import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzureadGroupsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Common display name prefix of the groups
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/groups#display_name_prefix DataAzureadGroups#display_name_prefix}
    */
    readonly displayNamePrefix?: string;
    /**
    * The display names of the groups
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/groups#display_names DataAzureadGroups#display_names}
    */
    readonly displayNames?: string[];
    /**
    * Whether the groups are mail-enabled
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/groups#mail_enabled DataAzureadGroups#mail_enabled}
    */
    readonly mailEnabled?: boolean | cdktf.IResolvable;
    /**
    * The object IDs of the groups
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/groups#object_ids DataAzureadGroups#object_ids}
    */
    readonly objectIds?: string[];
    /**
    * Retrieve all groups with no filter
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/groups#return_all DataAzureadGroups#return_all}
    */
    readonly returnAll?: boolean | cdktf.IResolvable;
    /**
    * Whether the groups are security-enabled
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/groups#security_enabled DataAzureadGroups#security_enabled}
    */
    readonly securityEnabled?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/groups#timeouts DataAzureadGroups#timeouts}
    */
    readonly timeouts?: DataAzureadGroupsTimeouts;
}
export interface DataAzureadGroupsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/groups#read DataAzureadGroups#read}
    */
    readonly read?: string;
}
export declare function dataAzureadGroupsTimeoutsToTerraform(struct?: DataAzureadGroupsTimeoutsOutputReference | DataAzureadGroupsTimeouts | cdktf.IResolvable): any;
export declare class DataAzureadGroupsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzureadGroupsTimeouts | undefined;
    set internalValue(value: DataAzureadGroupsTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/d/groups azuread_groups}
*/
export declare class DataAzureadGroups extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azuread_groups";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/d/groups azuread_groups} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzureadGroupsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAzureadGroupsConfig);
    private _displayNamePrefix?;
    get displayNamePrefix(): string;
    set displayNamePrefix(value: string);
    resetDisplayNamePrefix(): void;
    get displayNamePrefixInput(): string | undefined;
    private _displayNames?;
    get displayNames(): string[];
    set displayNames(value: string[]);
    resetDisplayNames(): void;
    get displayNamesInput(): string[] | undefined;
    get id(): string;
    private _mailEnabled?;
    get mailEnabled(): boolean | cdktf.IResolvable;
    set mailEnabled(value: boolean | cdktf.IResolvable);
    resetMailEnabled(): void;
    get mailEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _objectIds?;
    get objectIds(): string[];
    set objectIds(value: string[]);
    resetObjectIds(): void;
    get objectIdsInput(): string[] | undefined;
    private _returnAll?;
    get returnAll(): boolean | cdktf.IResolvable;
    set returnAll(value: boolean | cdktf.IResolvable);
    resetReturnAll(): void;
    get returnAllInput(): boolean | cdktf.IResolvable | undefined;
    private _securityEnabled?;
    get securityEnabled(): boolean | cdktf.IResolvable;
    set securityEnabled(value: boolean | cdktf.IResolvable);
    resetSecurityEnabled(): void;
    get securityEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    get timeouts(): DataAzureadGroupsTimeoutsOutputReference;
    putTimeouts(value: DataAzureadGroupsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzureadGroupsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
