import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzureadServicePrincipalConfig extends cdktf.TerraformMetaArguments {
    /**
    * The application ID (client ID) of the application associated with this service principal
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/service_principal#application_id DataAzureadServicePrincipal#application_id}
    */
    readonly applicationId?: string;
    /**
    * The display name of the application associated with this service principal
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/service_principal#display_name DataAzureadServicePrincipal#display_name}
    */
    readonly displayName?: string;
    /**
    * The object ID of the service principal
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/service_principal#object_id DataAzureadServicePrincipal#object_id}
    */
    readonly objectId?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/service_principal#timeouts DataAzureadServicePrincipal#timeouts}
    */
    readonly timeouts?: DataAzureadServicePrincipalTimeouts;
}
export interface DataAzureadServicePrincipalAppRoles {
}
export declare function dataAzureadServicePrincipalAppRolesToTerraform(struct?: DataAzureadServicePrincipalAppRoles): any;
export declare class DataAzureadServicePrincipalAppRolesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzureadServicePrincipalAppRoles | undefined;
    set internalValue(value: DataAzureadServicePrincipalAppRoles | undefined);
    get allowedMemberTypes(): string[];
    get description(): string;
    get displayName(): string;
    get enabled(): cdktf.IResolvable;
    get id(): string;
    get value(): string;
}
export declare class DataAzureadServicePrincipalAppRolesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzureadServicePrincipalAppRolesOutputReference;
}
export interface DataAzureadServicePrincipalFeatureTags {
}
export declare function dataAzureadServicePrincipalFeatureTagsToTerraform(struct?: DataAzureadServicePrincipalFeatureTags): any;
export declare class DataAzureadServicePrincipalFeatureTagsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzureadServicePrincipalFeatureTags | undefined;
    set internalValue(value: DataAzureadServicePrincipalFeatureTags | undefined);
    get customSingleSignOn(): cdktf.IResolvable;
    get enterprise(): cdktf.IResolvable;
    get gallery(): cdktf.IResolvable;
    get hide(): cdktf.IResolvable;
}
export declare class DataAzureadServicePrincipalFeatureTagsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzureadServicePrincipalFeatureTagsOutputReference;
}
export interface DataAzureadServicePrincipalFeatures {
}
export declare function dataAzureadServicePrincipalFeaturesToTerraform(struct?: DataAzureadServicePrincipalFeatures): any;
export declare class DataAzureadServicePrincipalFeaturesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzureadServicePrincipalFeatures | undefined;
    set internalValue(value: DataAzureadServicePrincipalFeatures | undefined);
    get customSingleSignOnApp(): cdktf.IResolvable;
    get enterpriseApplication(): cdktf.IResolvable;
    get galleryApplication(): cdktf.IResolvable;
    get visibleToUsers(): cdktf.IResolvable;
}
export declare class DataAzureadServicePrincipalFeaturesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzureadServicePrincipalFeaturesOutputReference;
}
export interface DataAzureadServicePrincipalOauth2PermissionScopes {
}
export declare function dataAzureadServicePrincipalOauth2PermissionScopesToTerraform(struct?: DataAzureadServicePrincipalOauth2PermissionScopes): any;
export declare class DataAzureadServicePrincipalOauth2PermissionScopesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzureadServicePrincipalOauth2PermissionScopes | undefined;
    set internalValue(value: DataAzureadServicePrincipalOauth2PermissionScopes | undefined);
    get adminConsentDescription(): string;
    get adminConsentDisplayName(): string;
    get enabled(): cdktf.IResolvable;
    get id(): string;
    get type(): string;
    get userConsentDescription(): string;
    get userConsentDisplayName(): string;
    get value(): string;
}
export declare class DataAzureadServicePrincipalOauth2PermissionScopesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzureadServicePrincipalOauth2PermissionScopesOutputReference;
}
export interface DataAzureadServicePrincipalSamlSingleSignOn {
}
export declare function dataAzureadServicePrincipalSamlSingleSignOnToTerraform(struct?: DataAzureadServicePrincipalSamlSingleSignOn): any;
export declare class DataAzureadServicePrincipalSamlSingleSignOnOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzureadServicePrincipalSamlSingleSignOn | undefined;
    set internalValue(value: DataAzureadServicePrincipalSamlSingleSignOn | undefined);
    get relayState(): string;
}
export declare class DataAzureadServicePrincipalSamlSingleSignOnList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzureadServicePrincipalSamlSingleSignOnOutputReference;
}
export interface DataAzureadServicePrincipalTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/service_principal#read DataAzureadServicePrincipal#read}
    */
    readonly read?: string;
}
export declare function dataAzureadServicePrincipalTimeoutsToTerraform(struct?: DataAzureadServicePrincipalTimeoutsOutputReference | DataAzureadServicePrincipalTimeouts | cdktf.IResolvable): any;
export declare class DataAzureadServicePrincipalTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzureadServicePrincipalTimeouts | undefined;
    set internalValue(value: DataAzureadServicePrincipalTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/d/service_principal azuread_service_principal}
*/
export declare class DataAzureadServicePrincipal extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azuread_service_principal";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/d/service_principal azuread_service_principal} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzureadServicePrincipalConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAzureadServicePrincipalConfig);
    get accountEnabled(): cdktf.IResolvable;
    get alternativeNames(): string[];
    get appRoleAssignmentRequired(): cdktf.IResolvable;
    appRoleIds(key: string): string | cdktf.IResolvable;
    private _appRoles;
    get appRoles(): DataAzureadServicePrincipalAppRolesList;
    private _applicationId?;
    get applicationId(): string;
    set applicationId(value: string);
    resetApplicationId(): void;
    get applicationIdInput(): string | undefined;
    get applicationTenantId(): string;
    get description(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _featureTags;
    get featureTags(): DataAzureadServicePrincipalFeatureTagsList;
    private _features;
    get features(): DataAzureadServicePrincipalFeaturesList;
    get homepageUrl(): string;
    get id(): string;
    get loginUrl(): string;
    get logoutUrl(): string;
    get notes(): string;
    get notificationEmailAddresses(): string[];
    oauth2PermissionScopeIds(key: string): string | cdktf.IResolvable;
    private _oauth2PermissionScopes;
    get oauth2PermissionScopes(): DataAzureadServicePrincipalOauth2PermissionScopesList;
    private _objectId?;
    get objectId(): string;
    set objectId(value: string);
    resetObjectId(): void;
    get objectIdInput(): string | undefined;
    get preferredSingleSignOnMode(): string;
    get redirectUris(): string[];
    get samlMetadataUrl(): string;
    private _samlSingleSignOn;
    get samlSingleSignOn(): DataAzureadServicePrincipalSamlSingleSignOnList;
    get servicePrincipalNames(): string[];
    get signInAudience(): string;
    get tags(): string[];
    get type(): string;
    private _timeouts;
    get timeouts(): DataAzureadServicePrincipalTimeoutsOutputReference;
    putTimeouts(value: DataAzureadServicePrincipalTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzureadServicePrincipalTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
