import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzureadServicePrincipalsConfig extends cdktf.TerraformMetaArguments {
    /**
    * The application IDs (client IDs) of the applications associated with the service principals
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/service_principals#application_ids DataAzureadServicePrincipals#application_ids}
    */
    readonly applicationIds?: string[];
    /**
    * The display names of the applications associated with the service principals
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/service_principals#display_names DataAzureadServicePrincipals#display_names}
    */
    readonly displayNames?: string[];
    /**
    * Ignore missing service principals and return the service principals that were found. The data source will still fail if no service principals are found
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/service_principals#ignore_missing DataAzureadServicePrincipals#ignore_missing}
    */
    readonly ignoreMissing?: boolean | cdktf.IResolvable;
    /**
    * The object IDs of the service principals
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/service_principals#object_ids DataAzureadServicePrincipals#object_ids}
    */
    readonly objectIds?: string[];
    /**
    * Fetch all service principals with no filter and return all that were found. The data source will still fail if no service principals are found.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/service_principals#return_all DataAzureadServicePrincipals#return_all}
    */
    readonly returnAll?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/service_principals#timeouts DataAzureadServicePrincipals#timeouts}
    */
    readonly timeouts?: DataAzureadServicePrincipalsTimeouts;
}
export interface DataAzureadServicePrincipalsServicePrincipals {
}
export declare function dataAzureadServicePrincipalsServicePrincipalsToTerraform(struct?: DataAzureadServicePrincipalsServicePrincipals): any;
export declare class DataAzureadServicePrincipalsServicePrincipalsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzureadServicePrincipalsServicePrincipals | undefined;
    set internalValue(value: DataAzureadServicePrincipalsServicePrincipals | undefined);
    get accountEnabled(): cdktf.IResolvable;
    get appRoleAssignmentRequired(): cdktf.IResolvable;
    get applicationId(): string;
    get applicationTenantId(): string;
    get displayName(): string;
    get objectId(): string;
    get preferredSingleSignOnMode(): string;
    get samlMetadataUrl(): string;
    get servicePrincipalNames(): string[];
    get signInAudience(): string;
    get tags(): string[];
    get type(): string;
}
export declare class DataAzureadServicePrincipalsServicePrincipalsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzureadServicePrincipalsServicePrincipalsOutputReference;
}
export interface DataAzureadServicePrincipalsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/service_principals#read DataAzureadServicePrincipals#read}
    */
    readonly read?: string;
}
export declare function dataAzureadServicePrincipalsTimeoutsToTerraform(struct?: DataAzureadServicePrincipalsTimeoutsOutputReference | DataAzureadServicePrincipalsTimeouts | cdktf.IResolvable): any;
export declare class DataAzureadServicePrincipalsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzureadServicePrincipalsTimeouts | undefined;
    set internalValue(value: DataAzureadServicePrincipalsTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/d/service_principals azuread_service_principals}
*/
export declare class DataAzureadServicePrincipals extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azuread_service_principals";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/d/service_principals azuread_service_principals} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzureadServicePrincipalsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAzureadServicePrincipalsConfig);
    private _applicationIds?;
    get applicationIds(): string[];
    set applicationIds(value: string[]);
    resetApplicationIds(): void;
    get applicationIdsInput(): string[] | undefined;
    private _displayNames?;
    get displayNames(): string[];
    set displayNames(value: string[]);
    resetDisplayNames(): void;
    get displayNamesInput(): string[] | undefined;
    get id(): string;
    private _ignoreMissing?;
    get ignoreMissing(): boolean | cdktf.IResolvable;
    set ignoreMissing(value: boolean | cdktf.IResolvable);
    resetIgnoreMissing(): void;
    get ignoreMissingInput(): boolean | cdktf.IResolvable | undefined;
    private _objectIds?;
    get objectIds(): string[];
    set objectIds(value: string[]);
    resetObjectIds(): void;
    get objectIdsInput(): string[] | undefined;
    private _returnAll?;
    get returnAll(): boolean | cdktf.IResolvable;
    set returnAll(value: boolean | cdktf.IResolvable);
    resetReturnAll(): void;
    get returnAllInput(): boolean | cdktf.IResolvable | undefined;
    private _servicePrincipals;
    get servicePrincipals(): DataAzureadServicePrincipalsServicePrincipalsList;
    private _timeouts;
    get timeouts(): DataAzureadServicePrincipalsTimeoutsOutputReference;
    putTimeouts(value: DataAzureadServicePrincipalsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzureadServicePrincipalsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
