import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzureadUsersConfig extends cdktf.TerraformMetaArguments {
    /**
    * Ignore missing users and return users that were found. The data source will still fail if no users are found
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/users#ignore_missing DataAzureadUsers#ignore_missing}
    */
    readonly ignoreMissing?: boolean | cdktf.IResolvable;
    /**
    * The email aliases of the users
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/users#mail_nicknames DataAzureadUsers#mail_nicknames}
    */
    readonly mailNicknames?: string[];
    /**
    * The object IDs of the users
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/users#object_ids DataAzureadUsers#object_ids}
    */
    readonly objectIds?: string[];
    /**
    * Fetch all users with no filter and return all that were found. The data source will still fail if no users are found.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/users#return_all DataAzureadUsers#return_all}
    */
    readonly returnAll?: boolean | cdktf.IResolvable;
    /**
    * The user principal names (UPNs) of the users
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/users#user_principal_names DataAzureadUsers#user_principal_names}
    */
    readonly userPrincipalNames?: string[];
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/users#timeouts DataAzureadUsers#timeouts}
    */
    readonly timeouts?: DataAzureadUsersTimeouts;
}
export interface DataAzureadUsersUsers {
}
export declare function dataAzureadUsersUsersToTerraform(struct?: DataAzureadUsersUsers): any;
export declare class DataAzureadUsersUsersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzureadUsersUsers | undefined;
    set internalValue(value: DataAzureadUsersUsers | undefined);
    get accountEnabled(): cdktf.IResolvable;
    get displayName(): string;
    get mail(): string;
    get mailNickname(): string;
    get objectId(): string;
    get onpremisesImmutableId(): string;
    get onpremisesSamAccountName(): string;
    get onpremisesUserPrincipalName(): string;
    get usageLocation(): string;
    get userPrincipalName(): string;
}
export declare class DataAzureadUsersUsersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzureadUsersUsersOutputReference;
}
export interface DataAzureadUsersTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/d/users#read DataAzureadUsers#read}
    */
    readonly read?: string;
}
export declare function dataAzureadUsersTimeoutsToTerraform(struct?: DataAzureadUsersTimeoutsOutputReference | DataAzureadUsersTimeouts | cdktf.IResolvable): any;
export declare class DataAzureadUsersTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzureadUsersTimeouts | undefined;
    set internalValue(value: DataAzureadUsersTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/d/users azuread_users}
*/
export declare class DataAzureadUsers extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azuread_users";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/d/users azuread_users} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzureadUsersConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAzureadUsersConfig);
    get id(): string;
    private _ignoreMissing?;
    get ignoreMissing(): boolean | cdktf.IResolvable;
    set ignoreMissing(value: boolean | cdktf.IResolvable);
    resetIgnoreMissing(): void;
    get ignoreMissingInput(): boolean | cdktf.IResolvable | undefined;
    private _mailNicknames?;
    get mailNicknames(): string[];
    set mailNicknames(value: string[]);
    resetMailNicknames(): void;
    get mailNicknamesInput(): string[] | undefined;
    private _objectIds?;
    get objectIds(): string[];
    set objectIds(value: string[]);
    resetObjectIds(): void;
    get objectIdsInput(): string[] | undefined;
    private _returnAll?;
    get returnAll(): boolean | cdktf.IResolvable;
    set returnAll(value: boolean | cdktf.IResolvable);
    resetReturnAll(): void;
    get returnAllInput(): boolean | cdktf.IResolvable | undefined;
    private _userPrincipalNames?;
    get userPrincipalNames(): string[];
    set userPrincipalNames(value: string[]);
    resetUserPrincipalNames(): void;
    get userPrincipalNamesInput(): string[] | undefined;
    private _users;
    get users(): DataAzureadUsersUsersList;
    private _timeouts;
    get timeouts(): DataAzureadUsersTimeoutsOutputReference;
    putTimeouts(value: DataAzureadUsersTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzureadUsersTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
