import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GroupMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * The object ID of the group you want to add the member to
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group_member#group_object_id GroupMember#group_object_id}
    */
    readonly groupObjectId: string;
    /**
    * The object ID of the principal you want to add as a member to the group. Supported object types are Users, Groups or Service Principals
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group_member#member_object_id GroupMember#member_object_id}
    */
    readonly memberObjectId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group_member#timeouts GroupMember#timeouts}
    */
    readonly timeouts?: GroupMemberTimeouts;
}
export interface GroupMemberTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group_member#create GroupMember#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group_member#delete GroupMember#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group_member#read GroupMember#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/group_member#update GroupMember#update}
    */
    readonly update?: string;
}
export declare function groupMemberTimeoutsToTerraform(struct?: GroupMemberTimeoutsOutputReference | GroupMemberTimeouts | cdktf.IResolvable): any;
export declare class GroupMemberTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GroupMemberTimeouts | undefined;
    set internalValue(value: GroupMemberTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/r/group_member azuread_group_member}
*/
export declare class GroupMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "azuread_group_member";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/group_member azuread_group_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GroupMemberConfig
    */
    constructor(scope: Construct, id: string, config: GroupMemberConfig);
    private _groupObjectId?;
    get groupObjectId(): string;
    set groupObjectId(value: string);
    get groupObjectIdInput(): string | undefined;
    get id(): string;
    private _memberObjectId?;
    get memberObjectId(): string;
    set memberObjectId(value: string);
    get memberObjectIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): GroupMemberTimeoutsOutputReference;
    putTimeouts(value: GroupMemberTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): GroupMemberTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
