import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface InvitationConfig extends cdktf.TerraformMetaArguments {
    /**
    * The URL that the user should be redirected to once the invitation is redeemed
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/invitation#redirect_url Invitation#redirect_url}
    */
    readonly redirectUrl: string;
    /**
    * The display name of the user being invited
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/invitation#user_display_name Invitation#user_display_name}
    */
    readonly userDisplayName?: string;
    /**
    * The email address of the user being invited
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/invitation#user_email_address Invitation#user_email_address}
    */
    readonly userEmailAddress: string;
    /**
    * The user type of the user being invited
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/invitation#user_type Invitation#user_type}
    */
    readonly userType?: string;
    /**
    * message block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/invitation#message Invitation#message}
    */
    readonly message?: InvitationMessage;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/invitation#timeouts Invitation#timeouts}
    */
    readonly timeouts?: InvitationTimeouts;
}
export interface InvitationMessage {
    /**
    * Email addresses of additional recipients the invitation message should be sent to
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/invitation#additional_recipients Invitation#additional_recipients}
    */
    readonly additionalRecipients?: string[];
    /**
    * Customized message body you want to send if you don't want to send the default message
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/invitation#body Invitation#body}
    */
    readonly body?: string;
    /**
    * The language you want to send the default message in
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/invitation#language Invitation#language}
    */
    readonly language?: string;
}
export declare function invitationMessageToTerraform(struct?: InvitationMessageOutputReference | InvitationMessage): any;
export declare class InvitationMessageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): InvitationMessage | undefined;
    set internalValue(value: InvitationMessage | undefined);
    private _additionalRecipients?;
    get additionalRecipients(): string[];
    set additionalRecipients(value: string[]);
    resetAdditionalRecipients(): void;
    get additionalRecipientsInput(): string[] | undefined;
    private _body?;
    get body(): string;
    set body(value: string);
    resetBody(): void;
    get bodyInput(): string | undefined;
    private _language?;
    get language(): string;
    set language(value: string);
    resetLanguage(): void;
    get languageInput(): string | undefined;
}
export interface InvitationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/invitation#create Invitation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/invitation#delete Invitation#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/invitation#read Invitation#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/invitation#update Invitation#update}
    */
    readonly update?: string;
}
export declare function invitationTimeoutsToTerraform(struct?: InvitationTimeoutsOutputReference | InvitationTimeouts | cdktf.IResolvable): any;
export declare class InvitationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): InvitationTimeouts | undefined;
    set internalValue(value: InvitationTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/r/invitation azuread_invitation}
*/
export declare class Invitation extends cdktf.TerraformResource {
    static readonly tfResourceType = "azuread_invitation";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/invitation azuread_invitation} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options InvitationConfig
    */
    constructor(scope: Construct, id: string, config: InvitationConfig);
    get id(): string;
    get redeemUrl(): string;
    private _redirectUrl?;
    get redirectUrl(): string;
    set redirectUrl(value: string);
    get redirectUrlInput(): string | undefined;
    private _userDisplayName?;
    get userDisplayName(): string;
    set userDisplayName(value: string);
    resetUserDisplayName(): void;
    get userDisplayNameInput(): string | undefined;
    private _userEmailAddress?;
    get userEmailAddress(): string;
    set userEmailAddress(value: string);
    get userEmailAddressInput(): string | undefined;
    get userId(): string;
    private _userType?;
    get userType(): string;
    set userType(value: string);
    resetUserType(): void;
    get userTypeInput(): string | undefined;
    private _message;
    get message(): InvitationMessageOutputReference;
    putMessage(value: InvitationMessage): void;
    resetMessage(): void;
    get messageInput(): InvitationMessage | undefined;
    private _timeouts;
    get timeouts(): InvitationTimeoutsOutputReference;
    putTimeouts(value: InvitationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): InvitationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
