import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServicePrincipalClaimsMappingPolicyAssignmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * ID of the claims mapping policy to assign
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_claims_mapping_policy_assignment#claims_mapping_policy_id ServicePrincipalClaimsMappingPolicyAssignment#claims_mapping_policy_id}
    */
    readonly claimsMappingPolicyId: string;
    /**
    * Object ID of the service principal for which to assign the policy
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_claims_mapping_policy_assignment#service_principal_id ServicePrincipalClaimsMappingPolicyAssignment#service_principal_id}
    */
    readonly servicePrincipalId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_claims_mapping_policy_assignment azuread_service_principal_claims_mapping_policy_assignment}
*/
export declare class ServicePrincipalClaimsMappingPolicyAssignment extends cdktf.TerraformResource {
    static readonly tfResourceType = "azuread_service_principal_claims_mapping_policy_assignment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/service_principal_claims_mapping_policy_assignment azuread_service_principal_claims_mapping_policy_assignment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServicePrincipalClaimsMappingPolicyAssignmentConfig
    */
    constructor(scope: Construct, id: string, config: ServicePrincipalClaimsMappingPolicyAssignmentConfig);
    private _claimsMappingPolicyId?;
    get claimsMappingPolicyId(): string;
    set claimsMappingPolicyId(value: string);
    get claimsMappingPolicyIdInput(): string | undefined;
    get id(): string;
    private _servicePrincipalId?;
    get servicePrincipalId(): string;
    set servicePrincipalId(value: string);
    get servicePrincipalIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
