import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServicePrincipalConfig extends cdktf.TerraformMetaArguments {
    /**
    * Whether or not the service principal account is enabled
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#account_enabled ServicePrincipal#account_enabled}
    */
    readonly accountEnabled?: boolean | cdktf.IResolvable;
    /**
    * A list of alternative names, used to retrieve service principals by subscription, identify resource group and full resource ids for managed identities
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#alternative_names ServicePrincipal#alternative_names}
    */
    readonly alternativeNames?: string[];
    /**
    * Whether this service principal requires an app role assignment to a user or group before Azure AD will issue a user or access token to the application
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#app_role_assignment_required ServicePrincipal#app_role_assignment_required}
    */
    readonly appRoleAssignmentRequired?: boolean | cdktf.IResolvable;
    /**
    * The application ID (client ID) of the application for which to create a service principal
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#application_id ServicePrincipal#application_id}
    */
    readonly applicationId: string;
    /**
    * Description of the service principal provided for internal end-users
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#description ServicePrincipal#description}
    */
    readonly description?: string;
    /**
    * The URL where the service provider redirects the user to Azure AD to authenticate. Azure AD uses the URL to launch the application from Microsoft 365 or the Azure AD My Apps. When blank, Azure AD performs IdP-initiated sign-on for applications configured with SAML-based single sign-on
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#login_url ServicePrincipal#login_url}
    */
    readonly loginUrl?: string;
    /**
    * Free text field to capture information about the service principal, typically used for operational purposes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#notes ServicePrincipal#notes}
    */
    readonly notes?: string;
    /**
    * List of email addresses where Azure AD sends a notification when the active certificate is near the expiration date. This is only for the certificates used to sign the SAML token issued for Azure AD Gallery applications
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#notification_email_addresses ServicePrincipal#notification_email_addresses}
    */
    readonly notificationEmailAddresses?: string[];
    /**
    * A list of object IDs of principals that will be granted ownership of the service principal
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#owners ServicePrincipal#owners}
    */
    readonly owners?: string[];
    /**
    * The single sign-on mode configured for this application. Azure AD uses the preferred single sign-on mode to launch the application from Microsoft 365 or the Azure AD My Apps
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#preferred_single_sign_on_mode ServicePrincipal#preferred_single_sign_on_mode}
    */
    readonly preferredSingleSignOnMode?: string;
    /**
    * A set of tags to apply to the service principal
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#tags ServicePrincipal#tags}
    */
    readonly tags?: string[];
    /**
    * When true, the resource will return an existing service principal instead of failing with an error
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#use_existing ServicePrincipal#use_existing}
    */
    readonly useExisting?: boolean | cdktf.IResolvable;
    /**
    * feature_tags block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#feature_tags ServicePrincipal#feature_tags}
    */
    readonly featureTags?: ServicePrincipalFeatureTags[] | cdktf.IResolvable;
    /**
    * features block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#features ServicePrincipal#features}
    */
    readonly features?: ServicePrincipalFeatures[] | cdktf.IResolvable;
    /**
    * saml_single_sign_on block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#saml_single_sign_on ServicePrincipal#saml_single_sign_on}
    */
    readonly samlSingleSignOn?: ServicePrincipalSamlSingleSignOn;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#timeouts ServicePrincipal#timeouts}
    */
    readonly timeouts?: ServicePrincipalTimeouts;
}
export interface ServicePrincipalAppRoles {
}
export declare function servicePrincipalAppRolesToTerraform(struct?: ServicePrincipalAppRoles): any;
export declare class ServicePrincipalAppRolesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServicePrincipalAppRoles | undefined;
    set internalValue(value: ServicePrincipalAppRoles | undefined);
    get allowedMemberTypes(): string[];
    get description(): string;
    get displayName(): string;
    get enabled(): cdktf.IResolvable;
    get id(): string;
    get value(): string;
}
export declare class ServicePrincipalAppRolesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServicePrincipalAppRolesOutputReference;
}
export interface ServicePrincipalOauth2PermissionScopes {
}
export declare function servicePrincipalOauth2PermissionScopesToTerraform(struct?: ServicePrincipalOauth2PermissionScopes): any;
export declare class ServicePrincipalOauth2PermissionScopesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServicePrincipalOauth2PermissionScopes | undefined;
    set internalValue(value: ServicePrincipalOauth2PermissionScopes | undefined);
    get adminConsentDescription(): string;
    get adminConsentDisplayName(): string;
    get enabled(): cdktf.IResolvable;
    get id(): string;
    get type(): string;
    get userConsentDescription(): string;
    get userConsentDisplayName(): string;
    get value(): string;
}
export declare class ServicePrincipalOauth2PermissionScopesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServicePrincipalOauth2PermissionScopesOutputReference;
}
export interface ServicePrincipalFeatureTags {
    /**
    * Whether this service principal represents a custom SAML application
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#custom_single_sign_on ServicePrincipal#custom_single_sign_on}
    */
    readonly customSingleSignOn?: boolean | cdktf.IResolvable;
    /**
    * Whether this service principal represents an Enterprise Application
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#enterprise ServicePrincipal#enterprise}
    */
    readonly enterprise?: boolean | cdktf.IResolvable;
    /**
    * Whether this service principal represents a gallery application
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#gallery ServicePrincipal#gallery}
    */
    readonly gallery?: boolean | cdktf.IResolvable;
    /**
    * Whether this app is invisible to users in My Apps and Office 365 Launcher
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#hide ServicePrincipal#hide}
    */
    readonly hide?: boolean | cdktf.IResolvable;
}
export declare function servicePrincipalFeatureTagsToTerraform(struct?: ServicePrincipalFeatureTags | cdktf.IResolvable): any;
export interface ServicePrincipalFeatures {
    /**
    * Whether this service principal represents a custom SAML application
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#custom_single_sign_on_app ServicePrincipal#custom_single_sign_on_app}
    */
    readonly customSingleSignOnApp?: boolean | cdktf.IResolvable;
    /**
    * Whether this service principal represents an Enterprise Application
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#enterprise_application ServicePrincipal#enterprise_application}
    */
    readonly enterpriseApplication?: boolean | cdktf.IResolvable;
    /**
    * Whether this service principal represents a gallery application
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#gallery_application ServicePrincipal#gallery_application}
    */
    readonly galleryApplication?: boolean | cdktf.IResolvable;
    /**
    * Whether this app is visible to users in My Apps and Office 365 Launcher
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#visible_to_users ServicePrincipal#visible_to_users}
    */
    readonly visibleToUsers?: boolean | cdktf.IResolvable;
}
export declare function servicePrincipalFeaturesToTerraform(struct?: ServicePrincipalFeatures | cdktf.IResolvable): any;
export interface ServicePrincipalSamlSingleSignOn {
    /**
    * The relative URI the service provider would redirect to after completion of the single sign-on flow
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#relay_state ServicePrincipal#relay_state}
    */
    readonly relayState?: string;
}
export declare function servicePrincipalSamlSingleSignOnToTerraform(struct?: ServicePrincipalSamlSingleSignOnOutputReference | ServicePrincipalSamlSingleSignOn): any;
export declare class ServicePrincipalSamlSingleSignOnOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServicePrincipalSamlSingleSignOn | undefined;
    set internalValue(value: ServicePrincipalSamlSingleSignOn | undefined);
    private _relayState?;
    get relayState(): string;
    set relayState(value: string);
    resetRelayState(): void;
    get relayStateInput(): string | undefined;
}
export interface ServicePrincipalTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#create ServicePrincipal#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#delete ServicePrincipal#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#read ServicePrincipal#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azuread/r/service_principal#update ServicePrincipal#update}
    */
    readonly update?: string;
}
export declare function servicePrincipalTimeoutsToTerraform(struct?: ServicePrincipalTimeoutsOutputReference | ServicePrincipalTimeouts | cdktf.IResolvable): any;
export declare class ServicePrincipalTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServicePrincipalTimeouts | undefined;
    set internalValue(value: ServicePrincipalTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/r/service_principal azuread_service_principal}
*/
export declare class ServicePrincipal extends cdktf.TerraformResource {
    static readonly tfResourceType = "azuread_service_principal";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/service_principal azuread_service_principal} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServicePrincipalConfig
    */
    constructor(scope: Construct, id: string, config: ServicePrincipalConfig);
    private _accountEnabled?;
    get accountEnabled(): boolean | cdktf.IResolvable;
    set accountEnabled(value: boolean | cdktf.IResolvable);
    resetAccountEnabled(): void;
    get accountEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _alternativeNames?;
    get alternativeNames(): string[];
    set alternativeNames(value: string[]);
    resetAlternativeNames(): void;
    get alternativeNamesInput(): string[] | undefined;
    private _appRoleAssignmentRequired?;
    get appRoleAssignmentRequired(): boolean | cdktf.IResolvable;
    set appRoleAssignmentRequired(value: boolean | cdktf.IResolvable);
    resetAppRoleAssignmentRequired(): void;
    get appRoleAssignmentRequiredInput(): boolean | cdktf.IResolvable | undefined;
    appRoleIds(key: string): string | cdktf.IResolvable;
    private _appRoles;
    get appRoles(): ServicePrincipalAppRolesList;
    private _applicationId?;
    get applicationId(): string;
    set applicationId(value: string);
    get applicationIdInput(): string | undefined;
    get applicationTenantId(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get displayName(): string;
    get homepageUrl(): string;
    get id(): string;
    private _loginUrl?;
    get loginUrl(): string;
    set loginUrl(value: string);
    resetLoginUrl(): void;
    get loginUrlInput(): string | undefined;
    get logoutUrl(): string;
    private _notes?;
    get notes(): string;
    set notes(value: string);
    resetNotes(): void;
    get notesInput(): string | undefined;
    private _notificationEmailAddresses?;
    get notificationEmailAddresses(): string[];
    set notificationEmailAddresses(value: string[]);
    resetNotificationEmailAddresses(): void;
    get notificationEmailAddressesInput(): string[] | undefined;
    oauth2PermissionScopeIds(key: string): string | cdktf.IResolvable;
    private _oauth2PermissionScopes;
    get oauth2PermissionScopes(): ServicePrincipalOauth2PermissionScopesList;
    get objectId(): string;
    private _owners?;
    get owners(): string[];
    set owners(value: string[]);
    resetOwners(): void;
    get ownersInput(): string[] | undefined;
    private _preferredSingleSignOnMode?;
    get preferredSingleSignOnMode(): string;
    set preferredSingleSignOnMode(value: string);
    resetPreferredSingleSignOnMode(): void;
    get preferredSingleSignOnModeInput(): string | undefined;
    get redirectUris(): string[];
    get samlMetadataUrl(): string;
    get servicePrincipalNames(): string[];
    get signInAudience(): string;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    get type(): string;
    private _useExisting?;
    get useExisting(): boolean | cdktf.IResolvable;
    set useExisting(value: boolean | cdktf.IResolvable);
    resetUseExisting(): void;
    get useExistingInput(): boolean | cdktf.IResolvable | undefined;
    private _featureTags?;
    get featureTags(): ServicePrincipalFeatureTags[] | cdktf.IResolvable;
    set featureTags(value: ServicePrincipalFeatureTags[] | cdktf.IResolvable);
    resetFeatureTags(): void;
    get featureTagsInput(): cdktf.IResolvable | ServicePrincipalFeatureTags[] | undefined;
    private _features?;
    get features(): ServicePrincipalFeatures[] | cdktf.IResolvable;
    set features(value: ServicePrincipalFeatures[] | cdktf.IResolvable);
    resetFeatures(): void;
    get featuresInput(): cdktf.IResolvable | ServicePrincipalFeatures[] | undefined;
    private _samlSingleSignOn;
    get samlSingleSignOn(): ServicePrincipalSamlSingleSignOnOutputReference;
    putSamlSingleSignOn(value: ServicePrincipalSamlSingleSignOn): void;
    resetSamlSingleSignOn(): void;
    get samlSingleSignOnInput(): ServicePrincipalSamlSingleSignOn | undefined;
    private _timeouts;
    get timeouts(): ServicePrincipalTimeoutsOutputReference;
    putTimeouts(value: ServicePrincipalTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ServicePrincipalTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
