"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.User = exports.UserTimeoutsOutputReference = exports.userTimeoutsToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function userTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        read: cdktf.stringToTerraform(struct.read),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.userTimeoutsToTerraform = userTimeoutsToTerraform;
class UserTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._read !== undefined) {
            hasAnyValues = true;
            internalValueResult.read = this._read;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._create = undefined;
            this._delete = undefined;
            this._read = undefined;
            this._update = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._create = value.create;
            this._delete = value.delete;
            this._read = value.read;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get read() {
        return this.getStringAttribute('read');
    }
    set read(value) {
        this._read = value;
    }
    resetRead() {
        this._read = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get readInput() {
        return this._read;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.UserTimeoutsOutputReference = UserTimeoutsOutputReference;
_a = JSII_RTTI_SYMBOL_1;
UserTimeoutsOutputReference[_a] = { fqn: "@cdktf/provider-azuread.UserTimeoutsOutputReference", version: "0.4.17" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/azuread/r/user azuread_user}
*/
class User extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azuread/r/user azuread_user} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options UserConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'azuread_user',
            terraformGeneratorMetadata: {
                providerName: 'azuread',
                providerVersion: '2.20.0',
                providerVersionConstraint: '~> 2.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new UserTimeoutsOutputReference(this, "timeouts");
        this._accountEnabled = config.accountEnabled;
        this._ageGroup = config.ageGroup;
        this._businessPhones = config.businessPhones;
        this._city = config.city;
        this._companyName = config.companyName;
        this._consentProvidedForMinor = config.consentProvidedForMinor;
        this._costCenter = config.costCenter;
        this._country = config.country;
        this._department = config.department;
        this._disablePasswordExpiration = config.disablePasswordExpiration;
        this._disableStrongPassword = config.disableStrongPassword;
        this._displayName = config.displayName;
        this._division = config.division;
        this._employeeId = config.employeeId;
        this._employeeType = config.employeeType;
        this._faxNumber = config.faxNumber;
        this._forcePasswordChange = config.forcePasswordChange;
        this._givenName = config.givenName;
        this._jobTitle = config.jobTitle;
        this._mail = config.mail;
        this._mailNickname = config.mailNickname;
        this._managerId = config.managerId;
        this._mobilePhone = config.mobilePhone;
        this._officeLocation = config.officeLocation;
        this._onpremisesImmutableId = config.onpremisesImmutableId;
        this._otherMails = config.otherMails;
        this._password = config.password;
        this._postalCode = config.postalCode;
        this._preferredLanguage = config.preferredLanguage;
        this._showInAddressList = config.showInAddressList;
        this._state = config.state;
        this._streetAddress = config.streetAddress;
        this._surname = config.surname;
        this._usageLocation = config.usageLocation;
        this._userPrincipalName = config.userPrincipalName;
        this._timeouts.internalValue = config.timeouts;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // about_me - computed: true, optional: false, required: false
    get aboutMe() {
        return this.getStringAttribute('about_me');
    }
    get accountEnabled() {
        return this.getBooleanAttribute('account_enabled');
    }
    set accountEnabled(value) {
        this._accountEnabled = value;
    }
    resetAccountEnabled() {
        this._accountEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get accountEnabledInput() {
        return this._accountEnabled;
    }
    get ageGroup() {
        return this.getStringAttribute('age_group');
    }
    set ageGroup(value) {
        this._ageGroup = value;
    }
    resetAgeGroup() {
        this._ageGroup = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ageGroupInput() {
        return this._ageGroup;
    }
    get businessPhones() {
        return this.getListAttribute('business_phones');
    }
    set businessPhones(value) {
        this._businessPhones = value;
    }
    resetBusinessPhones() {
        this._businessPhones = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get businessPhonesInput() {
        return this._businessPhones;
    }
    get city() {
        return this.getStringAttribute('city');
    }
    set city(value) {
        this._city = value;
    }
    resetCity() {
        this._city = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get cityInput() {
        return this._city;
    }
    get companyName() {
        return this.getStringAttribute('company_name');
    }
    set companyName(value) {
        this._companyName = value;
    }
    resetCompanyName() {
        this._companyName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get companyNameInput() {
        return this._companyName;
    }
    get consentProvidedForMinor() {
        return this.getStringAttribute('consent_provided_for_minor');
    }
    set consentProvidedForMinor(value) {
        this._consentProvidedForMinor = value;
    }
    resetConsentProvidedForMinor() {
        this._consentProvidedForMinor = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get consentProvidedForMinorInput() {
        return this._consentProvidedForMinor;
    }
    get costCenter() {
        return this.getStringAttribute('cost_center');
    }
    set costCenter(value) {
        this._costCenter = value;
    }
    resetCostCenter() {
        this._costCenter = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get costCenterInput() {
        return this._costCenter;
    }
    get country() {
        return this.getStringAttribute('country');
    }
    set country(value) {
        this._country = value;
    }
    resetCountry() {
        this._country = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get countryInput() {
        return this._country;
    }
    // creation_type - computed: true, optional: false, required: false
    get creationType() {
        return this.getStringAttribute('creation_type');
    }
    get department() {
        return this.getStringAttribute('department');
    }
    set department(value) {
        this._department = value;
    }
    resetDepartment() {
        this._department = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get departmentInput() {
        return this._department;
    }
    get disablePasswordExpiration() {
        return this.getBooleanAttribute('disable_password_expiration');
    }
    set disablePasswordExpiration(value) {
        this._disablePasswordExpiration = value;
    }
    resetDisablePasswordExpiration() {
        this._disablePasswordExpiration = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disablePasswordExpirationInput() {
        return this._disablePasswordExpiration;
    }
    get disableStrongPassword() {
        return this.getBooleanAttribute('disable_strong_password');
    }
    set disableStrongPassword(value) {
        this._disableStrongPassword = value;
    }
    resetDisableStrongPassword() {
        this._disableStrongPassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableStrongPasswordInput() {
        return this._disableStrongPassword;
    }
    get displayName() {
        return this.getStringAttribute('display_name');
    }
    set displayName(value) {
        this._displayName = value;
    }
    // Temporarily expose input value. Use with caution.
    get displayNameInput() {
        return this._displayName;
    }
    get division() {
        return this.getStringAttribute('division');
    }
    set division(value) {
        this._division = value;
    }
    resetDivision() {
        this._division = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get divisionInput() {
        return this._division;
    }
    get employeeId() {
        return this.getStringAttribute('employee_id');
    }
    set employeeId(value) {
        this._employeeId = value;
    }
    resetEmployeeId() {
        this._employeeId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get employeeIdInput() {
        return this._employeeId;
    }
    get employeeType() {
        return this.getStringAttribute('employee_type');
    }
    set employeeType(value) {
        this._employeeType = value;
    }
    resetEmployeeType() {
        this._employeeType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get employeeTypeInput() {
        return this._employeeType;
    }
    // external_user_state - computed: true, optional: false, required: false
    get externalUserState() {
        return this.getStringAttribute('external_user_state');
    }
    get faxNumber() {
        return this.getStringAttribute('fax_number');
    }
    set faxNumber(value) {
        this._faxNumber = value;
    }
    resetFaxNumber() {
        this._faxNumber = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get faxNumberInput() {
        return this._faxNumber;
    }
    get forcePasswordChange() {
        return this.getBooleanAttribute('force_password_change');
    }
    set forcePasswordChange(value) {
        this._forcePasswordChange = value;
    }
    resetForcePasswordChange() {
        this._forcePasswordChange = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get forcePasswordChangeInput() {
        return this._forcePasswordChange;
    }
    get givenName() {
        return this.getStringAttribute('given_name');
    }
    set givenName(value) {
        this._givenName = value;
    }
    resetGivenName() {
        this._givenName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get givenNameInput() {
        return this._givenName;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    // im_addresses - computed: true, optional: false, required: false
    get imAddresses() {
        return this.getListAttribute('im_addresses');
    }
    get jobTitle() {
        return this.getStringAttribute('job_title');
    }
    set jobTitle(value) {
        this._jobTitle = value;
    }
    resetJobTitle() {
        this._jobTitle = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get jobTitleInput() {
        return this._jobTitle;
    }
    get mail() {
        return this.getStringAttribute('mail');
    }
    set mail(value) {
        this._mail = value;
    }
    resetMail() {
        this._mail = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mailInput() {
        return this._mail;
    }
    get mailNickname() {
        return this.getStringAttribute('mail_nickname');
    }
    set mailNickname(value) {
        this._mailNickname = value;
    }
    resetMailNickname() {
        this._mailNickname = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mailNicknameInput() {
        return this._mailNickname;
    }
    get managerId() {
        return this.getStringAttribute('manager_id');
    }
    set managerId(value) {
        this._managerId = value;
    }
    resetManagerId() {
        this._managerId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get managerIdInput() {
        return this._managerId;
    }
    get mobilePhone() {
        return this.getStringAttribute('mobile_phone');
    }
    set mobilePhone(value) {
        this._mobilePhone = value;
    }
    resetMobilePhone() {
        this._mobilePhone = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get mobilePhoneInput() {
        return this._mobilePhone;
    }
    // object_id - computed: true, optional: false, required: false
    get objectId() {
        return this.getStringAttribute('object_id');
    }
    get officeLocation() {
        return this.getStringAttribute('office_location');
    }
    set officeLocation(value) {
        this._officeLocation = value;
    }
    resetOfficeLocation() {
        this._officeLocation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get officeLocationInput() {
        return this._officeLocation;
    }
    // onpremises_distinguished_name - computed: true, optional: false, required: false
    get onpremisesDistinguishedName() {
        return this.getStringAttribute('onpremises_distinguished_name');
    }
    // onpremises_domain_name - computed: true, optional: false, required: false
    get onpremisesDomainName() {
        return this.getStringAttribute('onpremises_domain_name');
    }
    get onpremisesImmutableId() {
        return this.getStringAttribute('onpremises_immutable_id');
    }
    set onpremisesImmutableId(value) {
        this._onpremisesImmutableId = value;
    }
    resetOnpremisesImmutableId() {
        this._onpremisesImmutableId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get onpremisesImmutableIdInput() {
        return this._onpremisesImmutableId;
    }
    // onpremises_sam_account_name - computed: true, optional: false, required: false
    get onpremisesSamAccountName() {
        return this.getStringAttribute('onpremises_sam_account_name');
    }
    // onpremises_security_identifier - computed: true, optional: false, required: false
    get onpremisesSecurityIdentifier() {
        return this.getStringAttribute('onpremises_security_identifier');
    }
    // onpremises_sync_enabled - computed: true, optional: false, required: false
    get onpremisesSyncEnabled() {
        return this.getBooleanAttribute('onpremises_sync_enabled');
    }
    // onpremises_user_principal_name - computed: true, optional: false, required: false
    get onpremisesUserPrincipalName() {
        return this.getStringAttribute('onpremises_user_principal_name');
    }
    get otherMails() {
        return cdktf.Fn.tolist(this.getListAttribute('other_mails'));
    }
    set otherMails(value) {
        this._otherMails = value;
    }
    resetOtherMails() {
        this._otherMails = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get otherMailsInput() {
        return this._otherMails;
    }
    get password() {
        return this.getStringAttribute('password');
    }
    set password(value) {
        this._password = value;
    }
    resetPassword() {
        this._password = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordInput() {
        return this._password;
    }
    get postalCode() {
        return this.getStringAttribute('postal_code');
    }
    set postalCode(value) {
        this._postalCode = value;
    }
    resetPostalCode() {
        this._postalCode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get postalCodeInput() {
        return this._postalCode;
    }
    get preferredLanguage() {
        return this.getStringAttribute('preferred_language');
    }
    set preferredLanguage(value) {
        this._preferredLanguage = value;
    }
    resetPreferredLanguage() {
        this._preferredLanguage = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get preferredLanguageInput() {
        return this._preferredLanguage;
    }
    // proxy_addresses - computed: true, optional: false, required: false
    get proxyAddresses() {
        return this.getListAttribute('proxy_addresses');
    }
    get showInAddressList() {
        return this.getBooleanAttribute('show_in_address_list');
    }
    set showInAddressList(value) {
        this._showInAddressList = value;
    }
    resetShowInAddressList() {
        this._showInAddressList = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get showInAddressListInput() {
        return this._showInAddressList;
    }
    get state() {
        return this.getStringAttribute('state');
    }
    set state(value) {
        this._state = value;
    }
    resetState() {
        this._state = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get stateInput() {
        return this._state;
    }
    get streetAddress() {
        return this.getStringAttribute('street_address');
    }
    set streetAddress(value) {
        this._streetAddress = value;
    }
    resetStreetAddress() {
        this._streetAddress = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get streetAddressInput() {
        return this._streetAddress;
    }
    get surname() {
        return this.getStringAttribute('surname');
    }
    set surname(value) {
        this._surname = value;
    }
    resetSurname() {
        this._surname = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get surnameInput() {
        return this._surname;
    }
    get usageLocation() {
        return this.getStringAttribute('usage_location');
    }
    set usageLocation(value) {
        this._usageLocation = value;
    }
    resetUsageLocation() {
        this._usageLocation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get usageLocationInput() {
        return this._usageLocation;
    }
    get userPrincipalName() {
        return this.getStringAttribute('user_principal_name');
    }
    set userPrincipalName(value) {
        this._userPrincipalName = value;
    }
    // Temporarily expose input value. Use with caution.
    get userPrincipalNameInput() {
        return this._userPrincipalName;
    }
    // user_type - computed: true, optional: false, required: false
    get userType() {
        return this.getStringAttribute('user_type');
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            account_enabled: cdktf.booleanToTerraform(this._accountEnabled),
            age_group: cdktf.stringToTerraform(this._ageGroup),
            business_phones: cdktf.listMapper(cdktf.stringToTerraform)(this._businessPhones),
            city: cdktf.stringToTerraform(this._city),
            company_name: cdktf.stringToTerraform(this._companyName),
            consent_provided_for_minor: cdktf.stringToTerraform(this._consentProvidedForMinor),
            cost_center: cdktf.stringToTerraform(this._costCenter),
            country: cdktf.stringToTerraform(this._country),
            department: cdktf.stringToTerraform(this._department),
            disable_password_expiration: cdktf.booleanToTerraform(this._disablePasswordExpiration),
            disable_strong_password: cdktf.booleanToTerraform(this._disableStrongPassword),
            display_name: cdktf.stringToTerraform(this._displayName),
            division: cdktf.stringToTerraform(this._division),
            employee_id: cdktf.stringToTerraform(this._employeeId),
            employee_type: cdktf.stringToTerraform(this._employeeType),
            fax_number: cdktf.stringToTerraform(this._faxNumber),
            force_password_change: cdktf.booleanToTerraform(this._forcePasswordChange),
            given_name: cdktf.stringToTerraform(this._givenName),
            job_title: cdktf.stringToTerraform(this._jobTitle),
            mail: cdktf.stringToTerraform(this._mail),
            mail_nickname: cdktf.stringToTerraform(this._mailNickname),
            manager_id: cdktf.stringToTerraform(this._managerId),
            mobile_phone: cdktf.stringToTerraform(this._mobilePhone),
            office_location: cdktf.stringToTerraform(this._officeLocation),
            onpremises_immutable_id: cdktf.stringToTerraform(this._onpremisesImmutableId),
            other_mails: cdktf.listMapper(cdktf.stringToTerraform)(this._otherMails),
            password: cdktf.stringToTerraform(this._password),
            postal_code: cdktf.stringToTerraform(this._postalCode),
            preferred_language: cdktf.stringToTerraform(this._preferredLanguage),
            show_in_address_list: cdktf.booleanToTerraform(this._showInAddressList),
            state: cdktf.stringToTerraform(this._state),
            street_address: cdktf.stringToTerraform(this._streetAddress),
            surname: cdktf.stringToTerraform(this._surname),
            usage_location: cdktf.stringToTerraform(this._usageLocation),
            user_principal_name: cdktf.stringToTerraform(this._userPrincipalName),
            timeouts: userTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.User = User;
_b = JSII_RTTI_SYMBOL_1;
User[_b] = { fqn: "@cdktf/provider-azuread.User", version: "0.4.17" };
// =================
// STATIC PROPERTIES
// =================
User.tfResourceType = "azuread_user";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXNlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy91c2VyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBSUEsK0JBQStCO0FBaVAvQixTQUFnQix1QkFBdUIsQ0FBQyxNQUF1RTtJQUM3RyxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsSUFBSSxLQUFLLENBQUMsWUFBWSxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUFFLE9BQU8sTUFBTSxDQUFDO0tBQUU7SUFDNUYsSUFBSSxLQUFLLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFDbEMsTUFBTSxJQUFJLEtBQUssQ0FBQyxvSEFBb0gsQ0FBQyxDQUFDO0tBQ3ZJO0lBQ0QsT0FBTztRQUNMLE1BQU0sRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLE1BQU0sQ0FBQztRQUMvQyxNQUFNLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxNQUFNLENBQUM7UUFDL0MsSUFBSSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsSUFBSSxDQUFDO1FBQzNDLE1BQU0sRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLE1BQU0sQ0FBQztLQUNoRCxDQUFBO0FBQ0gsQ0FBQztBQVhELDBEQVdDO0FBRUQsTUFBYSwyQkFBNEIsU0FBUSxLQUFLLENBQUMsYUFBYTtJQUdsRTs7O01BR0U7SUFDRixZQUFtQixpQkFBNkMsRUFBRSxrQkFBMEI7UUFDMUYsS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixFQUFFLEtBQUssRUFBRSxDQUFDLENBQUMsQ0FBQztRQVBqRCxrQkFBYSxHQUFHLEtBQUssQ0FBQztJQVE5QixDQUFDO0lBRUQsSUFBVyxhQUFhO1FBQ3RCLElBQUksWUFBWSxHQUFHLElBQUksQ0FBQyxhQUFhLENBQUM7UUFDdEMsTUFBTSxtQkFBbUIsR0FBUSxFQUFFLENBQUM7UUFDcEMsSUFBSSxJQUFJLENBQUMsT0FBTyxLQUFLLFNBQVMsRUFBRTtZQUM5QixZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDO1NBQzNDO1FBQ0QsSUFBSSxJQUFJLENBQUMsT0FBTyxLQUFLLFNBQVMsRUFBRTtZQUM5QixZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDO1NBQzNDO1FBQ0QsSUFBSSxJQUFJLENBQUMsS0FBSyxLQUFLLFNBQVMsRUFBRTtZQUM1QixZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLElBQUksR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDO1NBQ3ZDO1FBQ0QsSUFBSSxJQUFJLENBQUMsT0FBTyxLQUFLLFNBQVMsRUFBRTtZQUM5QixZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDO1NBQzNDO1FBQ0QsT0FBTyxZQUFZLENBQUMsQ0FBQyxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUM7SUFDeEQsQ0FBQztJQUVELElBQVcsYUFBYSxDQUFDLEtBQStCO1FBQ3RELElBQUksS0FBSyxLQUFLLFNBQVMsRUFBRTtZQUN2QixJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztZQUMzQixJQUFJLENBQUMsT0FBTyxHQUFHLFNBQVMsQ0FBQztZQUN6QixJQUFJLENBQUMsT0FBTyxHQUFHLFNBQVMsQ0FBQztZQUN6QixJQUFJLENBQUMsS0FBSyxHQUFHLFNBQVMsQ0FBQztZQUN2QixJQUFJLENBQUMsT0FBTyxHQUFHLFNBQVMsQ0FBQztTQUMxQjthQUNJO1lBQ0gsSUFBSSxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLE1BQU0sS0FBSyxDQUFDLENBQUM7WUFDckQsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDO1lBQzVCLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDLE1BQU0sQ0FBQztZQUM1QixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUM7WUFDeEIsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDO1NBQzdCO0lBQ0gsQ0FBQztJQUlELElBQVcsTUFBTTtRQUNmLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFFBQVEsQ0FBQyxDQUFDO0lBQzNDLENBQUM7SUFDRCxJQUFXLE1BQU0sQ0FBQyxLQUFhO1FBQzdCLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDO0lBQ3ZCLENBQUM7SUFDTSxXQUFXO1FBQ2hCLElBQUksQ0FBQyxPQUFPLEdBQUcsU0FBUyxDQUFDO0lBQzNCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxXQUFXO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQztJQUN0QixDQUFDO0lBSUQsSUFBVyxNQUFNO1FBQ2YsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLENBQUM7SUFDM0MsQ0FBQztJQUNELElBQVcsTUFBTSxDQUFDLEtBQWE7UUFDN0IsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUM7SUFDdkIsQ0FBQztJQUNNLFdBQVc7UUFDaEIsSUFBSSxDQUFDLE9BQU8sR0FBRyxTQUFTLENBQUM7SUFDM0IsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDO0lBQ3RCLENBQUM7SUFJRCxJQUFXLElBQUk7UUFDYixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUN6QyxDQUFDO0lBQ0QsSUFBVyxJQUFJLENBQUMsS0FBYTtRQUMzQixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztJQUNyQixDQUFDO0lBQ00sU0FBUztRQUNkLElBQUksQ0FBQyxLQUFLLEdBQUcsU0FBUyxDQUFDO0lBQ3pCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxTQUFTO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQztJQUNwQixDQUFDO0lBSUQsSUFBVyxNQUFNO1FBQ2YsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLENBQUM7SUFDM0MsQ0FBQztJQUNELElBQVcsTUFBTSxDQUFDLEtBQWE7UUFDN0IsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUM7SUFDdkIsQ0FBQztJQUNNLFdBQVc7UUFDaEIsSUFBSSxDQUFDLE9BQU8sR0FBRyxTQUFTLENBQUM7SUFDM0IsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDO0lBQ3RCLENBQUM7O0FBaEhILGtFQWlIQzs7O0FBRUQ7O0VBRUU7QUFDRixNQUFhLElBQUssU0FBUSxLQUFLLENBQUMsaUJBQWlCO0lBTy9DLGNBQWM7SUFDZCxjQUFjO0lBQ2QsY0FBYztJQUVkOzs7Ozs7TUFNRTtJQUNGLFlBQW1CLEtBQWdCLEVBQUUsRUFBVSxFQUFFLE1BQWtCO1FBQ2pFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2YscUJBQXFCLEVBQUUsY0FBYztZQUNyQywwQkFBMEIsRUFBRTtnQkFDMUIsWUFBWSxFQUFFLFNBQVM7Z0JBQ3ZCLGVBQWUsRUFBRSxRQUFRO2dCQUN6Qix5QkFBeUIsRUFBRSxRQUFRO2FBQ3BDO1lBQ0QsUUFBUSxFQUFFLE1BQU0sQ0FBQyxRQUFRO1lBQ3pCLFNBQVMsRUFBRSxNQUFNLENBQUMsU0FBUztZQUMzQixLQUFLLEVBQUUsTUFBTSxDQUFDLEtBQUs7WUFDbkIsU0FBUyxFQUFFLE1BQU0sQ0FBQyxTQUFTO1NBQzVCLENBQUMsQ0FBQztRQTJwQkwsOERBQThEO1FBQ3RELGNBQVMsR0FBRyxJQUFJLDJCQUEyQixDQUFDLElBQUksRUFBRSxVQUFVLENBQUMsQ0FBQztRQTNwQnBFLElBQUksQ0FBQyxlQUFlLEdBQUcsTUFBTSxDQUFDLGNBQWMsQ0FBQztRQUM3QyxJQUFJLENBQUMsU0FBUyxHQUFHLE1BQU0sQ0FBQyxRQUFRLENBQUM7UUFDakMsSUFBSSxDQUFDLGVBQWUsR0FBRyxNQUFNLENBQUMsY0FBYyxDQUFDO1FBQzdDLElBQUksQ0FBQyxLQUFLLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQztRQUN6QixJQUFJLENBQUMsWUFBWSxHQUFHLE1BQU0sQ0FBQyxXQUFXLENBQUM7UUFDdkMsSUFBSSxDQUFDLHdCQUF3QixHQUFHLE1BQU0sQ0FBQyx1QkFBdUIsQ0FBQztRQUMvRCxJQUFJLENBQUMsV0FBVyxHQUFHLE1BQU0sQ0FBQyxVQUFVLENBQUM7UUFDckMsSUFBSSxDQUFDLFFBQVEsR0FBRyxNQUFNLENBQUMsT0FBTyxDQUFDO1FBQy9CLElBQUksQ0FBQyxXQUFXLEdBQUcsTUFBTSxDQUFDLFVBQVUsQ0FBQztRQUNyQyxJQUFJLENBQUMsMEJBQTBCLEdBQUcsTUFBTSxDQUFDLHlCQUF5QixDQUFDO1FBQ25FLElBQUksQ0FBQyxzQkFBc0IsR0FBRyxNQUFNLENBQUMscUJBQXFCLENBQUM7UUFDM0QsSUFBSSxDQUFDLFlBQVksR0FBRyxNQUFNLENBQUMsV0FBVyxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxTQUFTLEdBQUcsTUFBTSxDQUFDLFFBQVEsQ0FBQztRQUNqQyxJQUFJLENBQUMsV0FBVyxHQUFHLE1BQU0sQ0FBQyxVQUFVLENBQUM7UUFDckMsSUFBSSxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsWUFBWSxDQUFDO1FBQ3pDLElBQUksQ0FBQyxVQUFVLEdBQUcsTUFBTSxDQUFDLFNBQVMsQ0FBQztRQUNuQyxJQUFJLENBQUMsb0JBQW9CLEdBQUcsTUFBTSxDQUFDLG1CQUFtQixDQUFDO1FBQ3ZELElBQUksQ0FBQyxVQUFVLEdBQUcsTUFBTSxDQUFDLFNBQVMsQ0FBQztRQUNuQyxJQUFJLENBQUMsU0FBUyxHQUFHLE1BQU0sQ0FBQyxRQUFRLENBQUM7UUFDakMsSUFBSSxDQUFDLEtBQUssR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDO1FBQ3pCLElBQUksQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFDLFlBQVksQ0FBQztRQUN6QyxJQUFJLENBQUMsVUFBVSxHQUFHLE1BQU0sQ0FBQyxTQUFTLENBQUM7UUFDbkMsSUFBSSxDQUFDLFlBQVksR0FBRyxNQUFNLENBQUMsV0FBVyxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxlQUFlLEdBQUcsTUFBTSxDQUFDLGNBQWMsQ0FBQztRQUM3QyxJQUFJLENBQUMsc0JBQXNCLEdBQUcsTUFBTSxDQUFDLHFCQUFxQixDQUFDO1FBQzNELElBQUksQ0FBQyxXQUFXLEdBQUcsTUFBTSxDQUFDLFVBQVUsQ0FBQztRQUNyQyxJQUFJLENBQUMsU0FBUyxHQUFHLE1BQU0sQ0FBQyxRQUFRLENBQUM7UUFDakMsSUFBSSxDQUFDLFdBQVcsR0FBRyxNQUFNLENBQUMsVUFBVSxDQUFDO1FBQ3JDLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxNQUFNLENBQUMsaUJBQWlCLENBQUM7UUFDbkQsSUFBSSxDQUFDLGtCQUFrQixHQUFHLE1BQU0sQ0FBQyxpQkFBaUIsQ0FBQztRQUNuRCxJQUFJLENBQUMsTUFBTSxHQUFHLE1BQU0sQ0FBQyxLQUFLLENBQUM7UUFDM0IsSUFBSSxDQUFDLGNBQWMsR0FBRyxNQUFNLENBQUMsYUFBYSxDQUFDO1FBQzNDLElBQUksQ0FBQyxRQUFRLEdBQUcsTUFBTSxDQUFDLE9BQU8sQ0FBQztRQUMvQixJQUFJLENBQUMsY0FBYyxHQUFHLE1BQU0sQ0FBQyxhQUFhLENBQUM7UUFDM0MsSUFBSSxDQUFDLGtCQUFrQixHQUFHLE1BQU0sQ0FBQyxpQkFBaUIsQ0FBQztRQUNuRCxJQUFJLENBQUMsU0FBUyxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsUUFBUSxDQUFDO0lBQ2pELENBQUM7SUFFRCxhQUFhO0lBQ2IsYUFBYTtJQUNiLGFBQWE7SUFFYiw4REFBOEQ7SUFDOUQsSUFBVyxPQUFPO1FBQ2hCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQzdDLENBQUM7SUFJRCxJQUFXLGNBQWM7UUFDdkIsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMsaUJBQWlCLENBQUMsQ0FBQztJQUNyRCxDQUFDO0lBQ0QsSUFBVyxjQUFjLENBQUMsS0FBa0M7UUFDMUQsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUM7SUFDL0IsQ0FBQztJQUNNLG1CQUFtQjtRQUN4QixJQUFJLENBQUMsZUFBZSxHQUFHLFNBQVMsQ0FBQztJQUNuQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsbUJBQW1CO1FBQzVCLE9BQU8sSUFBSSxDQUFDLGVBQWUsQ0FBQztJQUM5QixDQUFDO0lBSUQsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFdBQVcsQ0FBQyxDQUFDO0lBQzlDLENBQUM7SUFDRCxJQUFXLFFBQVEsQ0FBQyxLQUFhO1FBQy9CLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDO0lBQ3pCLENBQUM7SUFDTSxhQUFhO1FBQ2xCLElBQUksQ0FBQyxTQUFTLEdBQUcsU0FBUyxDQUFDO0lBQzdCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxhQUFhO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQztJQUN4QixDQUFDO0lBSUQsSUFBVyxjQUFjO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLGdCQUFnQixDQUFDLGlCQUFpQixDQUFDLENBQUM7SUFDbEQsQ0FBQztJQUNELElBQVcsY0FBYyxDQUFDLEtBQWU7UUFDdkMsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUM7SUFDL0IsQ0FBQztJQUNNLG1CQUFtQjtRQUN4QixJQUFJLENBQUMsZUFBZSxHQUFHLFNBQVMsQ0FBQztJQUNuQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsbUJBQW1CO1FBQzVCLE9BQU8sSUFBSSxDQUFDLGVBQWUsQ0FBQztJQUM5QixDQUFDO0lBSUQsSUFBVyxJQUFJO1FBQ2IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDekMsQ0FBQztJQUNELElBQVcsSUFBSSxDQUFDLEtBQWE7UUFDM0IsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7SUFDckIsQ0FBQztJQUNNLFNBQVM7UUFDZCxJQUFJLENBQUMsS0FBSyxHQUFHLFNBQVMsQ0FBQztJQUN6QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsU0FBUztRQUNsQixPQUFPLElBQUksQ0FBQyxLQUFLLENBQUM7SUFDcEIsQ0FBQztJQUlELElBQVcsV0FBVztRQUNwQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxjQUFjLENBQUMsQ0FBQztJQUNqRCxDQUFDO0lBQ0QsSUFBVyxXQUFXLENBQUMsS0FBYTtRQUNsQyxJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQztJQUM1QixDQUFDO0lBQ00sZ0JBQWdCO1FBQ3JCLElBQUksQ0FBQyxZQUFZLEdBQUcsU0FBUyxDQUFDO0lBQ2hDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxnQkFBZ0I7UUFDekIsT0FBTyxJQUFJLENBQUMsWUFBWSxDQUFDO0lBQzNCLENBQUM7SUFJRCxJQUFXLHVCQUF1QjtRQUNoQyxPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyw0QkFBNEIsQ0FBQyxDQUFDO0lBQy9ELENBQUM7SUFDRCxJQUFXLHVCQUF1QixDQUFDLEtBQWE7UUFDOUMsSUFBSSxDQUFDLHdCQUF3QixHQUFHLEtBQUssQ0FBQztJQUN4QyxDQUFDO0lBQ00sNEJBQTRCO1FBQ2pDLElBQUksQ0FBQyx3QkFBd0IsR0FBRyxTQUFTLENBQUM7SUFDNUMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLDRCQUE0QjtRQUNyQyxPQUFPLElBQUksQ0FBQyx3QkFBd0IsQ0FBQztJQUN2QyxDQUFDO0lBSUQsSUFBVyxVQUFVO1FBQ25CLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGFBQWEsQ0FBQyxDQUFDO0lBQ2hELENBQUM7SUFDRCxJQUFXLFVBQVUsQ0FBQyxLQUFhO1FBQ2pDLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDO0lBQzNCLENBQUM7SUFDTSxlQUFlO1FBQ3BCLElBQUksQ0FBQyxXQUFXLEdBQUcsU0FBUyxDQUFDO0lBQy9CLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxlQUFlO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLFdBQVcsQ0FBQztJQUMxQixDQUFDO0lBSUQsSUFBVyxPQUFPO1FBQ2hCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzVDLENBQUM7SUFDRCxJQUFXLE9BQU8sQ0FBQyxLQUFhO1FBQzlCLElBQUksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDO0lBQ3hCLENBQUM7SUFDTSxZQUFZO1FBQ2pCLElBQUksQ0FBQyxRQUFRLEdBQUcsU0FBUyxDQUFDO0lBQzVCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxZQUFZO1FBQ3JCLE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQztJQUN2QixDQUFDO0lBRUQsbUVBQW1FO0lBQ25FLElBQVcsWUFBWTtRQUNyQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxlQUFlLENBQUMsQ0FBQztJQUNsRCxDQUFDO0lBSUQsSUFBVyxVQUFVO1FBQ25CLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFlBQVksQ0FBQyxDQUFDO0lBQy9DLENBQUM7SUFDRCxJQUFXLFVBQVUsQ0FBQyxLQUFhO1FBQ2pDLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDO0lBQzNCLENBQUM7SUFDTSxlQUFlO1FBQ3BCLElBQUksQ0FBQyxXQUFXLEdBQUcsU0FBUyxDQUFDO0lBQy9CLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxlQUFlO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLFdBQVcsQ0FBQztJQUMxQixDQUFDO0lBSUQsSUFBVyx5QkFBeUI7UUFDbEMsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMsNkJBQTZCLENBQUMsQ0FBQztJQUNqRSxDQUFDO0lBQ0QsSUFBVyx5QkFBeUIsQ0FBQyxLQUFrQztRQUNyRSxJQUFJLENBQUMsMEJBQTBCLEdBQUcsS0FBSyxDQUFDO0lBQzFDLENBQUM7SUFDTSw4QkFBOEI7UUFDbkMsSUFBSSxDQUFDLDBCQUEwQixHQUFHLFNBQVMsQ0FBQztJQUM5QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsOEJBQThCO1FBQ3ZDLE9BQU8sSUFBSSxDQUFDLDBCQUEwQixDQUFDO0lBQ3pDLENBQUM7SUFJRCxJQUFXLHFCQUFxQjtRQUM5QixPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDO0lBQzdELENBQUM7SUFDRCxJQUFXLHFCQUFxQixDQUFDLEtBQWtDO1FBQ2pFLElBQUksQ0FBQyxzQkFBc0IsR0FBRyxLQUFLLENBQUM7SUFDdEMsQ0FBQztJQUNNLDBCQUEwQjtRQUMvQixJQUFJLENBQUMsc0JBQXNCLEdBQUcsU0FBUyxDQUFDO0lBQzFDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVywwQkFBMEI7UUFDbkMsT0FBTyxJQUFJLENBQUMsc0JBQXNCLENBQUM7SUFDckMsQ0FBQztJQUlELElBQVcsV0FBVztRQUNwQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxjQUFjLENBQUMsQ0FBQztJQUNqRCxDQUFDO0lBQ0QsSUFBVyxXQUFXLENBQUMsS0FBYTtRQUNsQyxJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQztJQUM1QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FBQztJQUMzQixDQUFDO0lBSUQsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQzdDLENBQUM7SUFDRCxJQUFXLFFBQVEsQ0FBQyxLQUFhO1FBQy9CLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDO0lBQ3pCLENBQUM7SUFDTSxhQUFhO1FBQ2xCLElBQUksQ0FBQyxTQUFTLEdBQUcsU0FBUyxDQUFDO0lBQzdCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxhQUFhO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQztJQUN4QixDQUFDO0lBSUQsSUFBVyxVQUFVO1FBQ25CLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGFBQWEsQ0FBQyxDQUFDO0lBQ2hELENBQUM7SUFDRCxJQUFXLFVBQVUsQ0FBQyxLQUFhO1FBQ2pDLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDO0lBQzNCLENBQUM7SUFDTSxlQUFlO1FBQ3BCLElBQUksQ0FBQyxXQUFXLEdBQUcsU0FBUyxDQUFDO0lBQy9CLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxlQUFlO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLFdBQVcsQ0FBQztJQUMxQixDQUFDO0lBSUQsSUFBVyxZQUFZO1FBQ3JCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGVBQWUsQ0FBQyxDQUFDO0lBQ2xELENBQUM7SUFDRCxJQUFXLFlBQVksQ0FBQyxLQUFhO1FBQ25DLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO0lBQzdCLENBQUM7SUFDTSxpQkFBaUI7UUFDdEIsSUFBSSxDQUFDLGFBQWEsR0FBRyxTQUFTLENBQUM7SUFDakMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGlCQUFpQjtRQUMxQixPQUFPLElBQUksQ0FBQyxhQUFhLENBQUM7SUFDNUIsQ0FBQztJQUVELHlFQUF5RTtJQUN6RSxJQUFXLGlCQUFpQjtRQUMxQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO0lBQ3hELENBQUM7SUFJRCxJQUFXLFNBQVM7UUFDbEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsWUFBWSxDQUFDLENBQUM7SUFDL0MsQ0FBQztJQUNELElBQVcsU0FBUyxDQUFDLEtBQWE7UUFDaEMsSUFBSSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUM7SUFDMUIsQ0FBQztJQUNNLGNBQWM7UUFDbkIsSUFBSSxDQUFDLFVBQVUsR0FBRyxTQUFTLENBQUM7SUFDOUIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGNBQWM7UUFDdkIsT0FBTyxJQUFJLENBQUMsVUFBVSxDQUFDO0lBQ3pCLENBQUM7SUFJRCxJQUFXLG1CQUFtQjtRQUM1QixPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDO0lBQzNELENBQUM7SUFDRCxJQUFXLG1CQUFtQixDQUFDLEtBQWtDO1FBQy9ELElBQUksQ0FBQyxvQkFBb0IsR0FBRyxLQUFLLENBQUM7SUFDcEMsQ0FBQztJQUNNLHdCQUF3QjtRQUM3QixJQUFJLENBQUMsb0JBQW9CLEdBQUcsU0FBUyxDQUFDO0lBQ3hDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyx3QkFBd0I7UUFDakMsT0FBTyxJQUFJLENBQUMsb0JBQW9CLENBQUM7SUFDbkMsQ0FBQztJQUlELElBQVcsU0FBUztRQUNsQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxZQUFZLENBQUMsQ0FBQztJQUMvQyxDQUFDO0lBQ0QsSUFBVyxTQUFTLENBQUMsS0FBYTtRQUNoQyxJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQztJQUMxQixDQUFDO0lBQ00sY0FBYztRQUNuQixJQUFJLENBQUMsVUFBVSxHQUFHLFNBQVMsQ0FBQztJQUM5QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsY0FBYztRQUN2QixPQUFPLElBQUksQ0FBQyxVQUFVLENBQUM7SUFDekIsQ0FBQztJQUVELHVEQUF1RDtJQUN2RCxJQUFXLEVBQUU7UUFDWCxPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUN2QyxDQUFDO0lBRUQsa0VBQWtFO0lBQ2xFLElBQVcsV0FBVztRQUNwQixPQUFPLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxjQUFjLENBQUMsQ0FBQztJQUMvQyxDQUFDO0lBSUQsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFdBQVcsQ0FBQyxDQUFDO0lBQzlDLENBQUM7SUFDRCxJQUFXLFFBQVEsQ0FBQyxLQUFhO1FBQy9CLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDO0lBQ3pCLENBQUM7SUFDTSxhQUFhO1FBQ2xCLElBQUksQ0FBQyxTQUFTLEdBQUcsU0FBUyxDQUFDO0lBQzdCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxhQUFhO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQztJQUN4QixDQUFDO0lBSUQsSUFBVyxJQUFJO1FBQ2IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDekMsQ0FBQztJQUNELElBQVcsSUFBSSxDQUFDLEtBQWE7UUFDM0IsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7SUFDckIsQ0FBQztJQUNNLFNBQVM7UUFDZCxJQUFJLENBQUMsS0FBSyxHQUFHLFNBQVMsQ0FBQztJQUN6QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsU0FBUztRQUNsQixPQUFPLElBQUksQ0FBQyxLQUFLLENBQUM7SUFDcEIsQ0FBQztJQUlELElBQVcsWUFBWTtRQUNyQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxlQUFlLENBQUMsQ0FBQztJQUNsRCxDQUFDO0lBQ0QsSUFBVyxZQUFZLENBQUMsS0FBYTtRQUNuQyxJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztJQUM3QixDQUFDO0lBQ00saUJBQWlCO1FBQ3RCLElBQUksQ0FBQyxhQUFhLEdBQUcsU0FBUyxDQUFDO0lBQ2pDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxpQkFBaUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDO0lBQzVCLENBQUM7SUFJRCxJQUFXLFNBQVM7UUFDbEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsWUFBWSxDQUFDLENBQUM7SUFDL0MsQ0FBQztJQUNELElBQVcsU0FBUyxDQUFDLEtBQWE7UUFDaEMsSUFBSSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUM7SUFDMUIsQ0FBQztJQUNNLGNBQWM7UUFDbkIsSUFBSSxDQUFDLFVBQVUsR0FBRyxTQUFTLENBQUM7SUFDOUIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGNBQWM7UUFDdkIsT0FBTyxJQUFJLENBQUMsVUFBVSxDQUFDO0lBQ3pCLENBQUM7SUFJRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsY0FBYyxDQUFDLENBQUM7SUFDakQsQ0FBQztJQUNELElBQVcsV0FBVyxDQUFDLEtBQWE7UUFDbEMsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUM7SUFDNUIsQ0FBQztJQUNNLGdCQUFnQjtRQUNyQixJQUFJLENBQUMsWUFBWSxHQUFHLFNBQVMsQ0FBQztJQUNoQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FBQztJQUMzQixDQUFDO0lBRUQsK0RBQStEO0lBQy9ELElBQVcsUUFBUTtRQUNqQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxXQUFXLENBQUMsQ0FBQztJQUM5QyxDQUFDO0lBSUQsSUFBVyxjQUFjO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGlCQUFpQixDQUFDLENBQUM7SUFDcEQsQ0FBQztJQUNELElBQVcsY0FBYyxDQUFDLEtBQWE7UUFDckMsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUM7SUFDL0IsQ0FBQztJQUNNLG1CQUFtQjtRQUN4QixJQUFJLENBQUMsZUFBZSxHQUFHLFNBQVMsQ0FBQztJQUNuQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsbUJBQW1CO1FBQzVCLE9BQU8sSUFBSSxDQUFDLGVBQWUsQ0FBQztJQUM5QixDQUFDO0lBRUQsbUZBQW1GO0lBQ25GLElBQVcsMkJBQTJCO1FBQ3BDLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLCtCQUErQixDQUFDLENBQUM7SUFDbEUsQ0FBQztJQUVELDRFQUE0RTtJQUM1RSxJQUFXLG9CQUFvQjtRQUM3QixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDO0lBQzNELENBQUM7SUFJRCxJQUFXLHFCQUFxQjtRQUM5QixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDO0lBQzVELENBQUM7SUFDRCxJQUFXLHFCQUFxQixDQUFDLEtBQWE7UUFDNUMsSUFBSSxDQUFDLHNCQUFzQixHQUFHLEtBQUssQ0FBQztJQUN0QyxDQUFDO0lBQ00sMEJBQTBCO1FBQy9CLElBQUksQ0FBQyxzQkFBc0IsR0FBRyxTQUFTLENBQUM7SUFDMUMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLDBCQUEwQjtRQUNuQyxPQUFPLElBQUksQ0FBQyxzQkFBc0IsQ0FBQztJQUNyQyxDQUFDO0lBRUQsaUZBQWlGO0lBQ2pGLElBQVcsd0JBQXdCO1FBQ2pDLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLDZCQUE2QixDQUFDLENBQUM7SUFDaEUsQ0FBQztJQUVELG9GQUFvRjtJQUNwRixJQUFXLDRCQUE0QjtRQUNyQyxPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO0lBQ25FLENBQUM7SUFFRCw2RUFBNkU7SUFDN0UsSUFBVyxxQkFBcUI7UUFDOUIsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMseUJBQXlCLENBQUMsQ0FBQztJQUM3RCxDQUFDO0lBRUQsb0ZBQW9GO0lBQ3BGLElBQVcsMkJBQTJCO1FBQ3BDLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGdDQUFnQyxDQUFDLENBQUM7SUFDbkUsQ0FBQztJQUlELElBQVcsVUFBVTtRQUNuQixPQUFPLEtBQUssQ0FBQyxFQUFFLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDO0lBQy9ELENBQUM7SUFDRCxJQUFXLFVBQVUsQ0FBQyxLQUFlO1FBQ25DLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDO0lBQzNCLENBQUM7SUFDTSxlQUFlO1FBQ3BCLElBQUksQ0FBQyxXQUFXLEdBQUcsU0FBUyxDQUFDO0lBQy9CLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxlQUFlO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLFdBQVcsQ0FBQztJQUMxQixDQUFDO0lBSUQsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQzdDLENBQUM7SUFDRCxJQUFXLFFBQVEsQ0FBQyxLQUFhO1FBQy9CLElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDO0lBQ3pCLENBQUM7SUFDTSxhQUFhO1FBQ2xCLElBQUksQ0FBQyxTQUFTLEdBQUcsU0FBUyxDQUFDO0lBQzdCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxhQUFhO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQztJQUN4QixDQUFDO0lBSUQsSUFBVyxVQUFVO1FBQ25CLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGFBQWEsQ0FBQyxDQUFDO0lBQ2hELENBQUM7SUFDRCxJQUFXLFVBQVUsQ0FBQyxLQUFhO1FBQ2pDLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDO0lBQzNCLENBQUM7SUFDTSxlQUFlO1FBQ3BCLElBQUksQ0FBQyxXQUFXLEdBQUcsU0FBUyxDQUFDO0lBQy9CLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxlQUFlO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLFdBQVcsQ0FBQztJQUMxQixDQUFDO0lBSUQsSUFBVyxpQkFBaUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsb0JBQW9CLENBQUMsQ0FBQztJQUN2RCxDQUFDO0lBQ0QsSUFBVyxpQkFBaUIsQ0FBQyxLQUFhO1FBQ3hDLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUM7SUFDbEMsQ0FBQztJQUNNLHNCQUFzQjtRQUMzQixJQUFJLENBQUMsa0JBQWtCLEdBQUcsU0FBUyxDQUFDO0lBQ3RDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxzQkFBc0I7UUFDL0IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUM7SUFDakMsQ0FBQztJQUVELHFFQUFxRTtJQUNyRSxJQUFXLGNBQWM7UUFDdkIsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsaUJBQWlCLENBQUMsQ0FBQztJQUNsRCxDQUFDO0lBSUQsSUFBVyxpQkFBaUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMsc0JBQXNCLENBQUMsQ0FBQztJQUMxRCxDQUFDO0lBQ0QsSUFBVyxpQkFBaUIsQ0FBQyxLQUFrQztRQUM3RCxJQUFJLENBQUMsa0JBQWtCLEdBQUcsS0FBSyxDQUFDO0lBQ2xDLENBQUM7SUFDTSxzQkFBc0I7UUFDM0IsSUFBSSxDQUFDLGtCQUFrQixHQUFHLFNBQVMsQ0FBQztJQUN0QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsc0JBQXNCO1FBQy9CLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDO0lBQ2pDLENBQUM7SUFJRCxJQUFXLEtBQUs7UUFDZCxPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxPQUFPLENBQUMsQ0FBQztJQUMxQyxDQUFDO0lBQ0QsSUFBVyxLQUFLLENBQUMsS0FBYTtRQUM1QixJQUFJLENBQUMsTUFBTSxHQUFHLEtBQUssQ0FBQztJQUN0QixDQUFDO0lBQ00sVUFBVTtRQUNmLElBQUksQ0FBQyxNQUFNLEdBQUcsU0FBUyxDQUFDO0lBQzFCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxVQUFVO1FBQ25CLE9BQU8sSUFBSSxDQUFDLE1BQU0sQ0FBQztJQUNyQixDQUFDO0lBSUQsSUFBVyxhQUFhO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGdCQUFnQixDQUFDLENBQUM7SUFDbkQsQ0FBQztJQUNELElBQVcsYUFBYSxDQUFDLEtBQWE7UUFDcEMsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUM7SUFDOUIsQ0FBQztJQUNNLGtCQUFrQjtRQUN2QixJQUFJLENBQUMsY0FBYyxHQUFHLFNBQVMsQ0FBQztJQUNsQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsa0JBQWtCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLGNBQWMsQ0FBQztJQUM3QixDQUFDO0lBSUQsSUFBVyxPQUFPO1FBQ2hCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzVDLENBQUM7SUFDRCxJQUFXLE9BQU8sQ0FBQyxLQUFhO1FBQzlCLElBQUksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDO0lBQ3hCLENBQUM7SUFDTSxZQUFZO1FBQ2pCLElBQUksQ0FBQyxRQUFRLEdBQUcsU0FBUyxDQUFDO0lBQzVCLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxZQUFZO1FBQ3JCLE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQztJQUN2QixDQUFDO0lBSUQsSUFBVyxhQUFhO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGdCQUFnQixDQUFDLENBQUM7SUFDbkQsQ0FBQztJQUNELElBQVcsYUFBYSxDQUFDLEtBQWE7UUFDcEMsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUM7SUFDOUIsQ0FBQztJQUNNLGtCQUFrQjtRQUN2QixJQUFJLENBQUMsY0FBYyxHQUFHLFNBQVMsQ0FBQztJQUNsQyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsa0JBQWtCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLGNBQWMsQ0FBQztJQUM3QixDQUFDO0lBSUQsSUFBVyxpQkFBaUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMscUJBQXFCLENBQUMsQ0FBQztJQUN4RCxDQUFDO0lBQ0QsSUFBVyxpQkFBaUIsQ0FBQyxLQUFhO1FBQ3hDLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxLQUFLLENBQUM7SUFDbEMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLHNCQUFzQjtRQUMvQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQztJQUNqQyxDQUFDO0lBRUQsK0RBQStEO0lBQy9ELElBQVcsUUFBUTtRQUNqQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxXQUFXLENBQUMsQ0FBQztJQUM5QyxDQUFDO0lBSUQsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQztJQUN4QixDQUFDO0lBQ00sV0FBVyxDQUFDLEtBQW1CO1FBQ3BDLElBQUksQ0FBQyxTQUFTLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztJQUN2QyxDQUFDO0lBQ00sYUFBYTtRQUNsQixJQUFJLENBQUMsU0FBUyxDQUFDLGFBQWEsR0FBRyxTQUFTLENBQUM7SUFDM0MsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLGFBQWE7UUFDdEIsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDLGFBQWEsQ0FBQztJQUN0QyxDQUFDO0lBRUQsWUFBWTtJQUNaLFlBQVk7SUFDWixZQUFZO0lBRUYsb0JBQW9CO1FBQzVCLE9BQU87WUFDTCxlQUFlLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxlQUFlLENBQUM7WUFDL0QsU0FBUyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDO1lBQ2xELGVBQWUsRUFBRSxLQUFLLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUM7WUFDaEYsSUFBSSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDO1lBQ3pDLFlBQVksRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQztZQUN4RCwwQkFBMEIsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLHdCQUF3QixDQUFDO1lBQ2xGLFdBQVcsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQztZQUN0RCxPQUFPLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxRQUFRLENBQUM7WUFDL0MsVUFBVSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDO1lBQ3JELDJCQUEyQixFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsMEJBQTBCLENBQUM7WUFDdEYsdUJBQXVCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxzQkFBc0IsQ0FBQztZQUM5RSxZQUFZLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxZQUFZLENBQUM7WUFDeEQsUUFBUSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDO1lBQ2pELFdBQVcsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQztZQUN0RCxhQUFhLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxhQUFhLENBQUM7WUFDMUQsVUFBVSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDO1lBQ3BELHFCQUFxQixFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsb0JBQW9CLENBQUM7WUFDMUUsVUFBVSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDO1lBQ3BELFNBQVMsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQztZQUNsRCxJQUFJLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxLQUFLLENBQUM7WUFDekMsYUFBYSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDO1lBQzFELFVBQVUsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQztZQUNwRCxZQUFZLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxZQUFZLENBQUM7WUFDeEQsZUFBZSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDO1lBQzlELHVCQUF1QixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsc0JBQXNCLENBQUM7WUFDN0UsV0FBVyxFQUFFLEtBQUssQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLGlCQUFpQixDQUFDLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQztZQUN4RSxRQUFRLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxTQUFTLENBQUM7WUFDakQsV0FBVyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDO1lBQ3RELGtCQUFrQixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsa0JBQWtCLENBQUM7WUFDcEUsb0JBQW9CLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxrQkFBa0IsQ0FBQztZQUN2RSxLQUFLLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxNQUFNLENBQUM7WUFDM0MsY0FBYyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDO1lBQzVELE9BQU8sRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQztZQUMvQyxjQUFjLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxjQUFjLENBQUM7WUFDNUQsbUJBQW1CLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxrQkFBa0IsQ0FBQztZQUNyRSxRQUFRLEVBQUUsdUJBQXVCLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxhQUFhLENBQUM7U0FDaEUsQ0FBQztJQUNKLENBQUM7O0FBcHZCSCxvQkFxdkJDOzs7QUFudkJDLG9CQUFvQjtBQUNwQixvQkFBb0I7QUFDcEIsb0JBQW9CO0FBQ0csbUJBQWMsR0FBRyxjQUFjLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVhZC9yL3VzZXJcbi8vIGdlbmVyYXRlZCBmcm9tIHRlcnJhZm9ybSByZXNvdXJjZSBzY2hlbWFcblxuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgKiBhcyBjZGt0ZiBmcm9tICdjZGt0Zic7XG5cbi8vIENvbmZpZ3VyYXRpb25cblxuZXhwb3J0IGludGVyZmFjZSBVc2VyQ29uZmlnIGV4dGVuZHMgY2RrdGYuVGVycmFmb3JtTWV0YUFyZ3VtZW50cyB7XG4gIC8qKlxuICAqIFdoZXRoZXIgb3Igbm90IHRoZSBhY2NvdW50IHNob3VsZCBiZSBlbmFibGVkXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVhZC9yL3VzZXIjYWNjb3VudF9lbmFibGVkIFVzZXIjYWNjb3VudF9lbmFibGVkfVxuICAqL1xuICByZWFkb25seSBhY2NvdW50RW5hYmxlZD86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogVGhlIGFnZSBncm91cCBvZiB0aGUgdXNlclxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F6dXJlYWQvci91c2VyI2FnZV9ncm91cCBVc2VyI2FnZV9ncm91cH1cbiAgKi9cbiAgcmVhZG9ubHkgYWdlR3JvdXA/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFRoZSB0ZWxlcGhvbmUgbnVtYmVycyBmb3IgdGhlIHVzZXIuIE9ubHkgb25lIG51bWJlciBjYW4gYmUgc2V0IGZvciB0aGlzIHByb3BlcnR5LiBSZWFkLW9ubHkgZm9yIHVzZXJzIHN5bmNlZCB3aXRoIEF6dXJlIEFEIENvbm5lY3RcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZWFkL3IvdXNlciNidXNpbmVzc19waG9uZXMgVXNlciNidXNpbmVzc19waG9uZXN9XG4gICovXG4gIHJlYWRvbmx5IGJ1c2luZXNzUGhvbmVzPzogc3RyaW5nW107XG4gIC8qKlxuICAqIFRoZSBjaXR5IGluIHdoaWNoIHRoZSB1c2VyIGlzIGxvY2F0ZWRcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZWFkL3IvdXNlciNjaXR5IFVzZXIjY2l0eX1cbiAgKi9cbiAgcmVhZG9ubHkgY2l0eT86IHN0cmluZztcbiAgLyoqXG4gICogVGhlIGNvbXBhbnkgbmFtZSB3aGljaCB0aGUgdXNlciBpcyBhc3NvY2lhdGVkLiBUaGlzIHByb3BlcnR5IGNhbiBiZSB1c2VmdWwgZm9yIGRlc2NyaWJpbmcgdGhlIGNvbXBhbnkgdGhhdCBhbiBleHRlcm5hbCB1c2VyIGNvbWVzIGZyb21cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZWFkL3IvdXNlciNjb21wYW55X25hbWUgVXNlciNjb21wYW55X25hbWV9XG4gICovXG4gIHJlYWRvbmx5IGNvbXBhbnlOYW1lPzogc3RyaW5nO1xuICAvKipcbiAgKiBXaGV0aGVyIGNvbnNlbnQgaGFzIGJlZW4gb2J0YWluZWQgZm9yIG1pbm9yc1xuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F6dXJlYWQvci91c2VyI2NvbnNlbnRfcHJvdmlkZWRfZm9yX21pbm9yIFVzZXIjY29uc2VudF9wcm92aWRlZF9mb3JfbWlub3J9XG4gICovXG4gIHJlYWRvbmx5IGNvbnNlbnRQcm92aWRlZEZvck1pbm9yPzogc3RyaW5nO1xuICAvKipcbiAgKiBUaGUgY29zdCBjZW50ZXIgYXNzb2NpYXRlZCB3aXRoIHRoZSB1c2VyLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F6dXJlYWQvci91c2VyI2Nvc3RfY2VudGVyIFVzZXIjY29zdF9jZW50ZXJ9XG4gICovXG4gIHJlYWRvbmx5IGNvc3RDZW50ZXI/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFRoZSBjb3VudHJ5L3JlZ2lvbiBpbiB3aGljaCB0aGUgdXNlciBpcyBsb2NhdGVkLCBlLmcuIGBVU2Agb3IgYFVLYFxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F6dXJlYWQvci91c2VyI2NvdW50cnkgVXNlciNjb3VudHJ5fVxuICAqL1xuICByZWFkb25seSBjb3VudHJ5Pzogc3RyaW5nO1xuICAvKipcbiAgKiBUaGUgbmFtZSBmb3IgdGhlIGRlcGFydG1lbnQgaW4gd2hpY2ggdGhlIHVzZXIgd29ya3NcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZWFkL3IvdXNlciNkZXBhcnRtZW50IFVzZXIjZGVwYXJ0bWVudH1cbiAgKi9cbiAgcmVhZG9ubHkgZGVwYXJ0bWVudD86IHN0cmluZztcbiAgLyoqXG4gICogV2hldGhlciB0aGUgdXNlcnMgcGFzc3dvcmQgaXMgZXhlbXB0IGZyb20gZXhwaXJpbmdcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZWFkL3IvdXNlciNkaXNhYmxlX3Bhc3N3b3JkX2V4cGlyYXRpb24gVXNlciNkaXNhYmxlX3Bhc3N3b3JkX2V4cGlyYXRpb259XG4gICovXG4gIHJlYWRvbmx5IGRpc2FibGVQYXNzd29yZEV4cGlyYXRpb24/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIFdoZXRoZXIgdGhlIHVzZXIgaXMgYWxsb3dlZCB3ZWFrZXIgcGFzc3dvcmRzIHRoYW4gdGhlIGRlZmF1bHQgcG9saWN5IHRvIGJlIHNwZWNpZmllZC5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZWFkL3IvdXNlciNkaXNhYmxlX3N0cm9uZ19wYXNzd29yZCBVc2VyI2Rpc2FibGVfc3Ryb25nX3Bhc3N3b3JkfVxuICAqL1xuICByZWFkb25seSBkaXNhYmxlU3Ryb25nUGFzc3dvcmQ/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIFRoZSBuYW1lIHRvIGRpc3BsYXkgaW4gdGhlIGFkZHJlc3MgYm9vayBmb3IgdGhlIHVzZXJcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZWFkL3IvdXNlciNkaXNwbGF5X25hbWUgVXNlciNkaXNwbGF5X25hbWV9XG4gICovXG4gIHJlYWRvbmx5IGRpc3BsYXlOYW1lOiBzdHJpbmc7XG4gIC8qKlxuICAqIFRoZSBuYW1lIG9mIHRoZSBkaXZpc2lvbiBpbiB3aGljaCB0aGUgdXNlciB3b3Jrcy5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZWFkL3IvdXNlciNkaXZpc2lvbiBVc2VyI2RpdmlzaW9ufVxuICAqL1xuICByZWFkb25seSBkaXZpc2lvbj86IHN0cmluZztcbiAgLyoqXG4gICogVGhlIGVtcGxveWVlIGlkZW50aWZpZXIgYXNzaWduZWQgdG8gdGhlIHVzZXIgYnkgdGhlIG9yZ2FuaXNhdGlvblxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F6dXJlYWQvci91c2VyI2VtcGxveWVlX2lkIFVzZXIjZW1wbG95ZWVfaWR9XG4gICovXG4gIHJlYWRvbmx5IGVtcGxveWVlSWQ/OiBzdHJpbmc7XG4gIC8qKlxuICAqIENhcHR1cmVzIGVudGVycHJpc2Ugd29ya2VyIHR5cGUuIEZvciBleGFtcGxlLCBFbXBsb3llZSwgQ29udHJhY3RvciwgQ29uc3VsdGFudCwgb3IgVmVuZG9yLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F6dXJlYWQvci91c2VyI2VtcGxveWVlX3R5cGUgVXNlciNlbXBsb3llZV90eXBlfVxuICAqL1xuICByZWFkb25seSBlbXBsb3llZVR5cGU/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFRoZSBmYXggbnVtYmVyIG9mIHRoZSB1c2VyXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVhZC9yL3VzZXIjZmF4X251bWJlciBVc2VyI2ZheF9udW1iZXJ9XG4gICovXG4gIHJlYWRvbmx5IGZheE51bWJlcj86IHN0cmluZztcbiAgLyoqXG4gICogV2hldGhlciB0aGUgdXNlciBpcyBmb3JjZWQgdG8gY2hhbmdlIHRoZSBwYXNzd29yZCBkdXJpbmcgdGhlIG5leHQgc2lnbi1pbi4gT25seSB0YWtlcyBlZmZlY3Qgd2hlbiBhbHNvIGNoYW5naW5nIHRoZSBwYXNzd29yZFxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F6dXJlYWQvci91c2VyI2ZvcmNlX3Bhc3N3b3JkX2NoYW5nZSBVc2VyI2ZvcmNlX3Bhc3N3b3JkX2NoYW5nZX1cbiAgKi9cbiAgcmVhZG9ubHkgZm9yY2VQYXNzd29yZENoYW5nZT86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogVGhlIGdpdmVuIG5hbWUgKGZpcnN0IG5hbWUpIG9mIHRoZSB1c2VyXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVhZC9yL3VzZXIjZ2l2ZW5fbmFtZSBVc2VyI2dpdmVuX25hbWV9XG4gICovXG4gIHJlYWRvbmx5IGdpdmVuTmFtZT86IHN0cmluZztcbiAgLyoqXG4gICogVGhlIHVzZXLigJlzIGpvYiB0aXRsZVxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F6dXJlYWQvci91c2VyI2pvYl90aXRsZSBVc2VyI2pvYl90aXRsZX1cbiAgKi9cbiAgcmVhZG9ubHkgam9iVGl0bGU/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFRoZSBTTVRQIGFkZHJlc3MgZm9yIHRoZSB1c2VyLiBDYW5ub3QgYmUgdW5zZXQuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVhZC9yL3VzZXIjbWFpbCBVc2VyI21haWx9XG4gICovXG4gIHJlYWRvbmx5IG1haWw/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFRoZSBtYWlsIGFsaWFzIGZvciB0aGUgdXNlci4gRGVmYXVsdHMgdG8gdGhlIHVzZXIgbmFtZSBwYXJ0IG9mIHRoZSB1c2VyIHByaW5jaXBhbCBuYW1lIChVUE4pXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVhZC9yL3VzZXIjbWFpbF9uaWNrbmFtZSBVc2VyI21haWxfbmlja25hbWV9XG4gICovXG4gIHJlYWRvbmx5IG1haWxOaWNrbmFtZT86IHN0cmluZztcbiAgLyoqXG4gICogVGhlIG9iamVjdCBJRCBvZiB0aGUgdXNlcidzIG1hbmFnZXJcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZWFkL3IvdXNlciNtYW5hZ2VyX2lkIFVzZXIjbWFuYWdlcl9pZH1cbiAgKi9cbiAgcmVhZG9ubHkgbWFuYWdlcklkPzogc3RyaW5nO1xuICAvKipcbiAgKiBUaGUgcHJpbWFyeSBjZWxsdWxhciB0ZWxlcGhvbmUgbnVtYmVyIGZvciB0aGUgdXNlclxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F6dXJlYWQvci91c2VyI21vYmlsZV9waG9uZSBVc2VyI21vYmlsZV9waG9uZX1cbiAgKi9cbiAgcmVhZG9ubHkgbW9iaWxlUGhvbmU/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFRoZSBvZmZpY2UgbG9jYXRpb24gaW4gdGhlIHVzZXIncyBwbGFjZSBvZiBidXNpbmVzc1xuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F6dXJlYWQvci91c2VyI29mZmljZV9sb2NhdGlvbiBVc2VyI29mZmljZV9sb2NhdGlvbn1cbiAgKi9cbiAgcmVhZG9ubHkgb2ZmaWNlTG9jYXRpb24/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFRoZSB2YWx1ZSB1c2VkIHRvIGFzc29jaWF0ZSBhbiBvbi1wcmVtaXNlIEFjdGl2ZSBEaXJlY3RvcnkgdXNlciBhY2NvdW50IHdpdGggdGhlaXIgQXp1cmUgQUQgdXNlciBvYmplY3QuIFRoaXMgbXVzdCBiZSBzcGVjaWZpZWQgaWYgeW91IGFyZSB1c2luZyBhIGZlZGVyYXRlZCBkb21haW4gZm9yIHRoZSB1c2VyJ3MgYHVzZXJfcHJpbmNpcGFsX25hbWVgIHByb3BlcnR5IHdoZW4gY3JlYXRpbmcgYSBuZXcgdXNlciBhY2NvdW50XG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVhZC9yL3VzZXIjb25wcmVtaXNlc19pbW11dGFibGVfaWQgVXNlciNvbnByZW1pc2VzX2ltbXV0YWJsZV9pZH1cbiAgKi9cbiAgcmVhZG9ubHkgb25wcmVtaXNlc0ltbXV0YWJsZUlkPzogc3RyaW5nO1xuICAvKipcbiAgKiBBZGRpdGlvbmFsIGVtYWlsIGFkZHJlc3NlcyBmb3IgdGhlIHVzZXJcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZWFkL3IvdXNlciNvdGhlcl9tYWlscyBVc2VyI290aGVyX21haWxzfVxuICAqL1xuICByZWFkb25seSBvdGhlck1haWxzPzogc3RyaW5nW107XG4gIC8qKlxuICAqIFRoZSBwYXNzd29yZCBmb3IgdGhlIHVzZXIuIFRoZSBwYXNzd29yZCBtdXN0IHNhdGlzZnkgbWluaW11bSByZXF1aXJlbWVudHMgYXMgc3BlY2lmaWVkIGJ5IHRoZSBwYXNzd29yZCBwb2xpY3kuIFRoZSBtYXhpbXVtIGxlbmd0aCBpcyAyNTYgY2hhcmFjdGVycy4gVGhpcyBwcm9wZXJ0eSBpcyByZXF1aXJlZCB3aGVuIGNyZWF0aW5nIGEgbmV3IHVzZXJcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZWFkL3IvdXNlciNwYXNzd29yZCBVc2VyI3Bhc3N3b3JkfVxuICAqL1xuICByZWFkb25seSBwYXNzd29yZD86IHN0cmluZztcbiAgLyoqXG4gICogVGhlIHBvc3RhbCBjb2RlIGZvciB0aGUgdXNlcidzIHBvc3RhbCBhZGRyZXNzLiBUaGUgcG9zdGFsIGNvZGUgaXMgc3BlY2lmaWMgdG8gdGhlIHVzZXIncyBjb3VudHJ5L3JlZ2lvbi4gSW4gdGhlIFVuaXRlZCBTdGF0ZXMgb2YgQW1lcmljYSwgdGhpcyBhdHRyaWJ1dGUgY29udGFpbnMgdGhlIFpJUCBjb2RlXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVhZC9yL3VzZXIjcG9zdGFsX2NvZGUgVXNlciNwb3N0YWxfY29kZX1cbiAgKi9cbiAgcmVhZG9ubHkgcG9zdGFsQ29kZT86IHN0cmluZztcbiAgLyoqXG4gICogVGhlIHVzZXIncyBwcmVmZXJyZWQgbGFuZ3VhZ2UsIGluIElTTyA2MzktMSBub3RhdGlvblxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F6dXJlYWQvci91c2VyI3ByZWZlcnJlZF9sYW5ndWFnZSBVc2VyI3ByZWZlcnJlZF9sYW5ndWFnZX1cbiAgKi9cbiAgcmVhZG9ubHkgcHJlZmVycmVkTGFuZ3VhZ2U/OiBzdHJpbmc7XG4gIC8qKlxuICAqIFdoZXRoZXIgb3Igbm90IHRoZSBPdXRsb29rIGdsb2JhbCBhZGRyZXNzIGxpc3Qgc2hvdWxkIGluY2x1ZGUgdGhpcyB1c2VyXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVhZC9yL3VzZXIjc2hvd19pbl9hZGRyZXNzX2xpc3QgVXNlciNzaG93X2luX2FkZHJlc3NfbGlzdH1cbiAgKi9cbiAgcmVhZG9ubHkgc2hvd0luQWRkcmVzc0xpc3Q/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIFRoZSBzdGF0ZSBvciBwcm92aW5jZSBpbiB0aGUgdXNlcidzIGFkZHJlc3NcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZWFkL3IvdXNlciNzdGF0ZSBVc2VyI3N0YXRlfVxuICAqL1xuICByZWFkb25seSBzdGF0ZT86IHN0cmluZztcbiAgLyoqXG4gICogVGhlIHN0cmVldCBhZGRyZXNzIG9mIHRoZSB1c2VyJ3MgcGxhY2Ugb2YgYnVzaW5lc3NcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZWFkL3IvdXNlciNzdHJlZXRfYWRkcmVzcyBVc2VyI3N0cmVldF9hZGRyZXNzfVxuICAqL1xuICByZWFkb25seSBzdHJlZXRBZGRyZXNzPzogc3RyaW5nO1xuICAvKipcbiAgKiBUaGUgdXNlcidzIHN1cm5hbWUgKGZhbWlseSBuYW1lIG9yIGxhc3QgbmFtZSlcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZWFkL3IvdXNlciNzdXJuYW1lIFVzZXIjc3VybmFtZX1cbiAgKi9cbiAgcmVhZG9ubHkgc3VybmFtZT86IHN0cmluZztcbiAgLyoqXG4gICogVGhlIHVzYWdlIGxvY2F0aW9uIG9mIHRoZSB1c2VyLiBSZXF1aXJlZCBmb3IgdXNlcnMgdGhhdCB3aWxsIGJlIGFzc2lnbmVkIGxpY2Vuc2VzIGR1ZSB0byBsZWdhbCByZXF1aXJlbWVudCB0byBjaGVjayBmb3IgYXZhaWxhYmlsaXR5IG9mIHNlcnZpY2VzIGluIGNvdW50cmllcy4gVGhlIHVzYWdlIGxvY2F0aW9uIGlzIGEgdHdvIGxldHRlciBjb3VudHJ5IGNvZGUgKElTTyBzdGFuZGFyZCAzMTY2KS4gRXhhbXBsZXMgaW5jbHVkZTogYE5PYCwgYEpQYCwgYW5kIGBHQmAuIENhbm5vdCBiZSByZXNldCB0byBudWxsIG9uY2Ugc2V0XG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVhZC9yL3VzZXIjdXNhZ2VfbG9jYXRpb24gVXNlciN1c2FnZV9sb2NhdGlvbn1cbiAgKi9cbiAgcmVhZG9ubHkgdXNhZ2VMb2NhdGlvbj86IHN0cmluZztcbiAgLyoqXG4gICogVGhlIHVzZXIgcHJpbmNpcGFsIG5hbWUgKFVQTikgb2YgdGhlIHVzZXJcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZWFkL3IvdXNlciN1c2VyX3ByaW5jaXBhbF9uYW1lIFVzZXIjdXNlcl9wcmluY2lwYWxfbmFtZX1cbiAgKi9cbiAgcmVhZG9ubHkgdXNlclByaW5jaXBhbE5hbWU6IHN0cmluZztcbiAgLyoqXG4gICogdGltZW91dHMgYmxvY2tcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZWFkL3IvdXNlciN0aW1lb3V0cyBVc2VyI3RpbWVvdXRzfVxuICAqL1xuICByZWFkb25seSB0aW1lb3V0cz86IFVzZXJUaW1lb3V0cztcbn1cbmV4cG9ydCBpbnRlcmZhY2UgVXNlclRpbWVvdXRzIHtcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVhZC9yL3VzZXIjY3JlYXRlIFVzZXIjY3JlYXRlfVxuICAqL1xuICByZWFkb25seSBjcmVhdGU/OiBzdHJpbmc7XG4gIC8qKlxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL2F6dXJlYWQvci91c2VyI2RlbGV0ZSBVc2VyI2RlbGV0ZX1cbiAgKi9cbiAgcmVhZG9ubHkgZGVsZXRlPzogc3RyaW5nO1xuICAvKipcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZWFkL3IvdXNlciNyZWFkIFVzZXIjcmVhZH1cbiAgKi9cbiAgcmVhZG9ubHkgcmVhZD86IHN0cmluZztcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVhZC9yL3VzZXIjdXBkYXRlIFVzZXIjdXBkYXRlfVxuICAqL1xuICByZWFkb25seSB1cGRhdGU/OiBzdHJpbmc7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiB1c2VyVGltZW91dHNUb1RlcnJhZm9ybShzdHJ1Y3Q/OiBVc2VyVGltZW91dHNPdXRwdXRSZWZlcmVuY2UgfCBVc2VyVGltZW91dHMgfCBjZGt0Zi5JUmVzb2x2YWJsZSk6IGFueSB7XG4gIGlmICghY2RrdGYuY2FuSW5zcGVjdChzdHJ1Y3QpIHx8IGNka3RmLlRva2VuaXphdGlvbi5pc1Jlc29sdmFibGUoc3RydWN0KSkgeyByZXR1cm4gc3RydWN0OyB9XG4gIGlmIChjZGt0Zi5pc0NvbXBsZXhFbGVtZW50KHN0cnVjdCkpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXCJBIGNvbXBsZXggZWxlbWVudCB3YXMgdXNlZCBhcyBjb25maWd1cmF0aW9uLCB0aGlzIGlzIG5vdCBzdXBwb3J0ZWQ6IGh0dHBzOi8vY2RrLnRmL2NvbXBsZXgtb2JqZWN0LWFzLWNvbmZpZ3VyYXRpb25cIik7XG4gIH1cbiAgcmV0dXJuIHtcbiAgICBjcmVhdGU6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEuY3JlYXRlKSxcbiAgICBkZWxldGU6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEuZGVsZXRlKSxcbiAgICByZWFkOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybShzdHJ1Y3QhLnJlYWQpLFxuICAgIHVwZGF0ZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS51cGRhdGUpLFxuICB9XG59XG5cbmV4cG9ydCBjbGFzcyBVc2VyVGltZW91dHNPdXRwdXRSZWZlcmVuY2UgZXh0ZW5kcyBjZGt0Zi5Db21wbGV4T2JqZWN0IHtcbiAgcHJpdmF0ZSBpc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG5cbiAgLyoqXG4gICogQHBhcmFtIHRlcnJhZm9ybVJlc291cmNlIFRoZSBwYXJlbnQgcmVzb3VyY2VcbiAgKiBAcGFyYW0gdGVycmFmb3JtQXR0cmlidXRlIFRoZSBhdHRyaWJ1dGUgb24gdGhlIHBhcmVudCByZXNvdXJjZSB0aGlzIGNsYXNzIGlzIHJlZmVyZW5jaW5nXG4gICovXG4gIHB1YmxpYyBjb25zdHJ1Y3Rvcih0ZXJyYWZvcm1SZXNvdXJjZTogY2RrdGYuSUludGVycG9sYXRpbmdQYXJlbnQsIHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSwgZmFsc2UsIDApO1xuICB9XG5cbiAgcHVibGljIGdldCBpbnRlcm5hbFZhbHVlKCk6IFVzZXJUaW1lb3V0cyB8IHVuZGVmaW5lZCB7XG4gICAgbGV0IGhhc0FueVZhbHVlcyA9IHRoaXMuaXNFbXB0eU9iamVjdDtcbiAgICBjb25zdCBpbnRlcm5hbFZhbHVlUmVzdWx0OiBhbnkgPSB7fTtcbiAgICBpZiAodGhpcy5fY3JlYXRlICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LmNyZWF0ZSA9IHRoaXMuX2NyZWF0ZTtcbiAgICB9XG4gICAgaWYgKHRoaXMuX2RlbGV0ZSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5kZWxldGUgPSB0aGlzLl9kZWxldGU7XG4gICAgfVxuICAgIGlmICh0aGlzLl9yZWFkICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LnJlYWQgPSB0aGlzLl9yZWFkO1xuICAgIH1cbiAgICBpZiAodGhpcy5fdXBkYXRlICE9PSB1bmRlZmluZWQpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LnVwZGF0ZSA9IHRoaXMuX3VwZGF0ZTtcbiAgICB9XG4gICAgcmV0dXJuIGhhc0FueVZhbHVlcyA/IGludGVybmFsVmFsdWVSZXN1bHQgOiB1bmRlZmluZWQ7XG4gIH1cblxuICBwdWJsaWMgc2V0IGludGVybmFsVmFsdWUodmFsdWU6IFVzZXJUaW1lb3V0cyB8IHVuZGVmaW5lZCkge1xuICAgIGlmICh2YWx1ZSA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICB0aGlzLmlzRW1wdHlPYmplY3QgPSBmYWxzZTtcbiAgICAgIHRoaXMuX2NyZWF0ZSA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX2RlbGV0ZSA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3JlYWQgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl91cGRhdGUgPSB1bmRlZmluZWQ7XG4gICAgfVxuICAgIGVsc2Uge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gT2JqZWN0LmtleXModmFsdWUpLmxlbmd0aCA9PT0gMDtcbiAgICAgIHRoaXMuX2NyZWF0ZSA9IHZhbHVlLmNyZWF0ZTtcbiAgICAgIHRoaXMuX2RlbGV0ZSA9IHZhbHVlLmRlbGV0ZTtcbiAgICAgIHRoaXMuX3JlYWQgPSB2YWx1ZS5yZWFkO1xuICAgICAgdGhpcy5fdXBkYXRlID0gdmFsdWUudXBkYXRlO1xuICAgIH1cbiAgfVxuXG4gIC8vIGNyZWF0ZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jcmVhdGU/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGNyZWF0ZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2NyZWF0ZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgY3JlYXRlKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9jcmVhdGUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRDcmVhdGUoKSB7XG4gICAgdGhpcy5fY3JlYXRlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBjcmVhdGVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fY3JlYXRlO1xuICB9XG5cbiAgLy8gZGVsZXRlIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2RlbGV0ZT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgZGVsZXRlKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnZGVsZXRlJyk7XG4gIH1cbiAgcHVibGljIHNldCBkZWxldGUodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2RlbGV0ZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldERlbGV0ZSgpIHtcbiAgICB0aGlzLl9kZWxldGUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGRlbGV0ZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9kZWxldGU7XG4gIH1cblxuICAvLyByZWFkIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3JlYWQ/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IHJlYWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdyZWFkJyk7XG4gIH1cbiAgcHVibGljIHNldCByZWFkKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9yZWFkID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UmVhZCgpIHtcbiAgICB0aGlzLl9yZWFkID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCByZWFkSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3JlYWQ7XG4gIH1cblxuICAvLyB1cGRhdGUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfdXBkYXRlPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCB1cGRhdGUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCd1cGRhdGUnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHVwZGF0ZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fdXBkYXRlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0VXBkYXRlKCkge1xuICAgIHRoaXMuX3VwZGF0ZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgdXBkYXRlSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3VwZGF0ZTtcbiAgfVxufVxuXG4vKipcbiogUmVwcmVzZW50cyBhIHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVhZC9yL3VzZXIgYXp1cmVhZF91c2VyfVxuKi9cbmV4cG9ydCBjbGFzcyBVc2VyIGV4dGVuZHMgY2RrdGYuVGVycmFmb3JtUmVzb3VyY2Uge1xuXG4gIC8vID09PT09PT09PT09PT09PT09XG4gIC8vIFNUQVRJQyBQUk9QRVJUSUVTXG4gIC8vID09PT09PT09PT09PT09PT09XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgdGZSZXNvdXJjZVR5cGUgPSBcImF6dXJlYWRfdXNlclwiO1xuXG4gIC8vID09PT09PT09PT09XG4gIC8vIElOSVRJQUxJWkVSXG4gIC8vID09PT09PT09PT09XG5cbiAgLyoqXG4gICogQ3JlYXRlIGEgbmV3IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvYXp1cmVhZC9yL3VzZXIgYXp1cmVhZF91c2VyfSBSZXNvdXJjZVxuICAqXG4gICogQHBhcmFtIHNjb3BlIFRoZSBzY29wZSBpbiB3aGljaCB0byBkZWZpbmUgdGhpcyBjb25zdHJ1Y3RcbiAgKiBAcGFyYW0gaWQgVGhlIHNjb3BlZCBjb25zdHJ1Y3QgSUQuIE11c3QgYmUgdW5pcXVlIGFtb25nc3Qgc2libGluZ3MgaW4gdGhlIHNhbWUgc2NvcGVcbiAgKiBAcGFyYW0gb3B0aW9ucyBVc2VyQ29uZmlnXG4gICovXG4gIHB1YmxpYyBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBjb25maWc6IFVzZXJDb25maWcpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHtcbiAgICAgIHRlcnJhZm9ybVJlc291cmNlVHlwZTogJ2F6dXJlYWRfdXNlcicsXG4gICAgICB0ZXJyYWZvcm1HZW5lcmF0b3JNZXRhZGF0YToge1xuICAgICAgICBwcm92aWRlck5hbWU6ICdhenVyZWFkJyxcbiAgICAgICAgcHJvdmlkZXJWZXJzaW9uOiAnMi4yMC4wJyxcbiAgICAgICAgcHJvdmlkZXJWZXJzaW9uQ29uc3RyYWludDogJ34+IDIuMCdcbiAgICAgIH0sXG4gICAgICBwcm92aWRlcjogY29uZmlnLnByb3ZpZGVyLFxuICAgICAgZGVwZW5kc09uOiBjb25maWcuZGVwZW5kc09uLFxuICAgICAgY291bnQ6IGNvbmZpZy5jb3VudCxcbiAgICAgIGxpZmVjeWNsZTogY29uZmlnLmxpZmVjeWNsZVxuICAgIH0pO1xuICAgIHRoaXMuX2FjY291bnRFbmFibGVkID0gY29uZmlnLmFjY291bnRFbmFibGVkO1xuICAgIHRoaXMuX2FnZUdyb3VwID0gY29uZmlnLmFnZUdyb3VwO1xuICAgIHRoaXMuX2J1c2luZXNzUGhvbmVzID0gY29uZmlnLmJ1c2luZXNzUGhvbmVzO1xuICAgIHRoaXMuX2NpdHkgPSBjb25maWcuY2l0eTtcbiAgICB0aGlzLl9jb21wYW55TmFtZSA9IGNvbmZpZy5jb21wYW55TmFtZTtcbiAgICB0aGlzLl9jb25zZW50UHJvdmlkZWRGb3JNaW5vciA9IGNvbmZpZy5jb25zZW50UHJvdmlkZWRGb3JNaW5vcjtcbiAgICB0aGlzLl9jb3N0Q2VudGVyID0gY29uZmlnLmNvc3RDZW50ZXI7XG4gICAgdGhpcy5fY291bnRyeSA9IGNvbmZpZy5jb3VudHJ5O1xuICAgIHRoaXMuX2RlcGFydG1lbnQgPSBjb25maWcuZGVwYXJ0bWVudDtcbiAgICB0aGlzLl9kaXNhYmxlUGFzc3dvcmRFeHBpcmF0aW9uID0gY29uZmlnLmRpc2FibGVQYXNzd29yZEV4cGlyYXRpb247XG4gICAgdGhpcy5fZGlzYWJsZVN0cm9uZ1Bhc3N3b3JkID0gY29uZmlnLmRpc2FibGVTdHJvbmdQYXNzd29yZDtcbiAgICB0aGlzLl9kaXNwbGF5TmFtZSA9IGNvbmZpZy5kaXNwbGF5TmFtZTtcbiAgICB0aGlzLl9kaXZpc2lvbiA9IGNvbmZpZy5kaXZpc2lvbjtcbiAgICB0aGlzLl9lbXBsb3llZUlkID0gY29uZmlnLmVtcGxveWVlSWQ7XG4gICAgdGhpcy5fZW1wbG95ZWVUeXBlID0gY29uZmlnLmVtcGxveWVlVHlwZTtcbiAgICB0aGlzLl9mYXhOdW1iZXIgPSBjb25maWcuZmF4TnVtYmVyO1xuICAgIHRoaXMuX2ZvcmNlUGFzc3dvcmRDaGFuZ2UgPSBjb25maWcuZm9yY2VQYXNzd29yZENoYW5nZTtcbiAgICB0aGlzLl9naXZlbk5hbWUgPSBjb25maWcuZ2l2ZW5OYW1lO1xuICAgIHRoaXMuX2pvYlRpdGxlID0gY29uZmlnLmpvYlRpdGxlO1xuICAgIHRoaXMuX21haWwgPSBjb25maWcubWFpbDtcbiAgICB0aGlzLl9tYWlsTmlja25hbWUgPSBjb25maWcubWFpbE5pY2tuYW1lO1xuICAgIHRoaXMuX21hbmFnZXJJZCA9IGNvbmZpZy5tYW5hZ2VySWQ7XG4gICAgdGhpcy5fbW9iaWxlUGhvbmUgPSBjb25maWcubW9iaWxlUGhvbmU7XG4gICAgdGhpcy5fb2ZmaWNlTG9jYXRpb24gPSBjb25maWcub2ZmaWNlTG9jYXRpb247XG4gICAgdGhpcy5fb25wcmVtaXNlc0ltbXV0YWJsZUlkID0gY29uZmlnLm9ucHJlbWlzZXNJbW11dGFibGVJZDtcbiAgICB0aGlzLl9vdGhlck1haWxzID0gY29uZmlnLm90aGVyTWFpbHM7XG4gICAgdGhpcy5fcGFzc3dvcmQgPSBjb25maWcucGFzc3dvcmQ7XG4gICAgdGhpcy5fcG9zdGFsQ29kZSA9IGNvbmZpZy5wb3N0YWxDb2RlO1xuICAgIHRoaXMuX3ByZWZlcnJlZExhbmd1YWdlID0gY29uZmlnLnByZWZlcnJlZExhbmd1YWdlO1xuICAgIHRoaXMuX3Nob3dJbkFkZHJlc3NMaXN0ID0gY29uZmlnLnNob3dJbkFkZHJlc3NMaXN0O1xuICAgIHRoaXMuX3N0YXRlID0gY29uZmlnLnN0YXRlO1xuICAgIHRoaXMuX3N0cmVldEFkZHJlc3MgPSBjb25maWcuc3RyZWV0QWRkcmVzcztcbiAgICB0aGlzLl9zdXJuYW1lID0gY29uZmlnLnN1cm5hbWU7XG4gICAgdGhpcy5fdXNhZ2VMb2NhdGlvbiA9IGNvbmZpZy51c2FnZUxvY2F0aW9uO1xuICAgIHRoaXMuX3VzZXJQcmluY2lwYWxOYW1lID0gY29uZmlnLnVzZXJQcmluY2lwYWxOYW1lO1xuICAgIHRoaXMuX3RpbWVvdXRzLmludGVybmFsVmFsdWUgPSBjb25maWcudGltZW91dHM7XG4gIH1cblxuICAvLyA9PT09PT09PT09XG4gIC8vIEFUVFJJQlVURVNcbiAgLy8gPT09PT09PT09PVxuXG4gIC8vIGFib3V0X21lIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHB1YmxpYyBnZXQgYWJvdXRNZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2Fib3V0X21lJyk7XG4gIH1cblxuICAvLyBhY2NvdW50X2VuYWJsZWQgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfYWNjb3VudEVuYWJsZWQ/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7IFxuICBwdWJsaWMgZ2V0IGFjY291bnRFbmFibGVkKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ2FjY291bnRfZW5hYmxlZCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgYWNjb3VudEVuYWJsZWQodmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX2FjY291bnRFbmFibGVkID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0QWNjb3VudEVuYWJsZWQoKSB7XG4gICAgdGhpcy5fYWNjb3VudEVuYWJsZWQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGFjY291bnRFbmFibGVkSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2FjY291bnRFbmFibGVkO1xuICB9XG5cbiAgLy8gYWdlX2dyb3VwIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2FnZUdyb3VwPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBhZ2VHcm91cCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2FnZV9ncm91cCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgYWdlR3JvdXAodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2FnZUdyb3VwID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0QWdlR3JvdXAoKSB7XG4gICAgdGhpcy5fYWdlR3JvdXAgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGFnZUdyb3VwSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2FnZUdyb3VwO1xuICB9XG5cbiAgLy8gYnVzaW5lc3NfcGhvbmVzIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfYnVzaW5lc3NQaG9uZXM/OiBzdHJpbmdbXTsgXG4gIHB1YmxpYyBnZXQgYnVzaW5lc3NQaG9uZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TGlzdEF0dHJpYnV0ZSgnYnVzaW5lc3NfcGhvbmVzJyk7XG4gIH1cbiAgcHVibGljIHNldCBidXNpbmVzc1Bob25lcyh2YWx1ZTogc3RyaW5nW10pIHtcbiAgICB0aGlzLl9idXNpbmVzc1Bob25lcyA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldEJ1c2luZXNzUGhvbmVzKCkge1xuICAgIHRoaXMuX2J1c2luZXNzUGhvbmVzID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBidXNpbmVzc1Bob25lc0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9idXNpbmVzc1Bob25lcztcbiAgfVxuXG4gIC8vIGNpdHkgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfY2l0eT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgY2l0eSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2NpdHknKTtcbiAgfVxuICBwdWJsaWMgc2V0IGNpdHkodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2NpdHkgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRDaXR5KCkge1xuICAgIHRoaXMuX2NpdHkgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGNpdHlJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fY2l0eTtcbiAgfVxuXG4gIC8vIGNvbXBhbnlfbmFtZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jb21wYW55TmFtZT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgY29tcGFueU5hbWUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdjb21wYW55X25hbWUnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGNvbXBhbnlOYW1lKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9jb21wYW55TmFtZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldENvbXBhbnlOYW1lKCkge1xuICAgIHRoaXMuX2NvbXBhbnlOYW1lID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBjb21wYW55TmFtZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9jb21wYW55TmFtZTtcbiAgfVxuXG4gIC8vIGNvbnNlbnRfcHJvdmlkZWRfZm9yX21pbm9yIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2NvbnNlbnRQcm92aWRlZEZvck1pbm9yPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBjb25zZW50UHJvdmlkZWRGb3JNaW5vcigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2NvbnNlbnRfcHJvdmlkZWRfZm9yX21pbm9yJyk7XG4gIH1cbiAgcHVibGljIHNldCBjb25zZW50UHJvdmlkZWRGb3JNaW5vcih2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fY29uc2VudFByb3ZpZGVkRm9yTWlub3IgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRDb25zZW50UHJvdmlkZWRGb3JNaW5vcigpIHtcbiAgICB0aGlzLl9jb25zZW50UHJvdmlkZWRGb3JNaW5vciA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgY29uc2VudFByb3ZpZGVkRm9yTWlub3JJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fY29uc2VudFByb3ZpZGVkRm9yTWlub3I7XG4gIH1cblxuICAvLyBjb3N0X2NlbnRlciAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jb3N0Q2VudGVyPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBjb3N0Q2VudGVyKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnY29zdF9jZW50ZXInKTtcbiAgfVxuICBwdWJsaWMgc2V0IGNvc3RDZW50ZXIodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2Nvc3RDZW50ZXIgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRDb3N0Q2VudGVyKCkge1xuICAgIHRoaXMuX2Nvc3RDZW50ZXIgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGNvc3RDZW50ZXJJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fY29zdENlbnRlcjtcbiAgfVxuXG4gIC8vIGNvdW50cnkgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfY291bnRyeT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgY291bnRyeSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2NvdW50cnknKTtcbiAgfVxuICBwdWJsaWMgc2V0IGNvdW50cnkodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2NvdW50cnkgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRDb3VudHJ5KCkge1xuICAgIHRoaXMuX2NvdW50cnkgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGNvdW50cnlJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fY291bnRyeTtcbiAgfVxuXG4gIC8vIGNyZWF0aW9uX3R5cGUgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogZmFsc2VcbiAgcHVibGljIGdldCBjcmVhdGlvblR5cGUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdjcmVhdGlvbl90eXBlJyk7XG4gIH1cblxuICAvLyBkZXBhcnRtZW50IC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2RlcGFydG1lbnQ/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGRlcGFydG1lbnQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdkZXBhcnRtZW50Jyk7XG4gIH1cbiAgcHVibGljIHNldCBkZXBhcnRtZW50KHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9kZXBhcnRtZW50ID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0RGVwYXJ0bWVudCgpIHtcbiAgICB0aGlzLl9kZXBhcnRtZW50ID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBkZXBhcnRtZW50SW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2RlcGFydG1lbnQ7XG4gIH1cblxuICAvLyBkaXNhYmxlX3Bhc3N3b3JkX2V4cGlyYXRpb24gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZGlzYWJsZVBhc3N3b3JkRXhwaXJhdGlvbj86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgZGlzYWJsZVBhc3N3b3JkRXhwaXJhdGlvbigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRCb29sZWFuQXR0cmlidXRlKCdkaXNhYmxlX3Bhc3N3b3JkX2V4cGlyYXRpb24nKTtcbiAgfVxuICBwdWJsaWMgc2V0IGRpc2FibGVQYXNzd29yZEV4cGlyYXRpb24odmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX2Rpc2FibGVQYXNzd29yZEV4cGlyYXRpb24gPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXREaXNhYmxlUGFzc3dvcmRFeHBpcmF0aW9uKCkge1xuICAgIHRoaXMuX2Rpc2FibGVQYXNzd29yZEV4cGlyYXRpb24gPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGRpc2FibGVQYXNzd29yZEV4cGlyYXRpb25JbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fZGlzYWJsZVBhc3N3b3JkRXhwaXJhdGlvbjtcbiAgfVxuXG4gIC8vIGRpc2FibGVfc3Ryb25nX3Bhc3N3b3JkIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2Rpc2FibGVTdHJvbmdQYXNzd29yZD86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgZGlzYWJsZVN0cm9uZ1Bhc3N3b3JkKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ2Rpc2FibGVfc3Ryb25nX3Bhc3N3b3JkJyk7XG4gIH1cbiAgcHVibGljIHNldCBkaXNhYmxlU3Ryb25nUGFzc3dvcmQodmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX2Rpc2FibGVTdHJvbmdQYXNzd29yZCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldERpc2FibGVTdHJvbmdQYXNzd29yZCgpIHtcbiAgICB0aGlzLl9kaXNhYmxlU3Ryb25nUGFzc3dvcmQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGRpc2FibGVTdHJvbmdQYXNzd29yZElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9kaXNhYmxlU3Ryb25nUGFzc3dvcmQ7XG4gIH1cblxuICAvLyBkaXNwbGF5X25hbWUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfZGlzcGxheU5hbWU/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGRpc3BsYXlOYW1lKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnZGlzcGxheV9uYW1lJyk7XG4gIH1cbiAgcHVibGljIHNldCBkaXNwbGF5TmFtZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fZGlzcGxheU5hbWUgPSB2YWx1ZTtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgZGlzcGxheU5hbWVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fZGlzcGxheU5hbWU7XG4gIH1cblxuICAvLyBkaXZpc2lvbiAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9kaXZpc2lvbj86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgZGl2aXNpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdkaXZpc2lvbicpO1xuICB9XG4gIHB1YmxpYyBzZXQgZGl2aXNpb24odmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2RpdmlzaW9uID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0RGl2aXNpb24oKSB7XG4gICAgdGhpcy5fZGl2aXNpb24gPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGRpdmlzaW9uSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2RpdmlzaW9uO1xuICB9XG5cbiAgLy8gZW1wbG95ZWVfaWQgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZW1wbG95ZWVJZD86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgZW1wbG95ZWVJZCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2VtcGxveWVlX2lkJyk7XG4gIH1cbiAgcHVibGljIHNldCBlbXBsb3llZUlkKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9lbXBsb3llZUlkID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0RW1wbG95ZWVJZCgpIHtcbiAgICB0aGlzLl9lbXBsb3llZUlkID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBlbXBsb3llZUlkSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2VtcGxveWVlSWQ7XG4gIH1cblxuICAvLyBlbXBsb3llZV90eXBlIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2VtcGxveWVlVHlwZT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgZW1wbG95ZWVUeXBlKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnZW1wbG95ZWVfdHlwZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgZW1wbG95ZWVUeXBlKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9lbXBsb3llZVR5cGUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRFbXBsb3llZVR5cGUoKSB7XG4gICAgdGhpcy5fZW1wbG95ZWVUeXBlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBlbXBsb3llZVR5cGVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fZW1wbG95ZWVUeXBlO1xuICB9XG5cbiAgLy8gZXh0ZXJuYWxfdXNlcl9zdGF0ZSAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiBmYWxzZVxuICBwdWJsaWMgZ2V0IGV4dGVybmFsVXNlclN0YXRlKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnZXh0ZXJuYWxfdXNlcl9zdGF0ZScpO1xuICB9XG5cbiAgLy8gZmF4X251bWJlciAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9mYXhOdW1iZXI/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGZheE51bWJlcigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2ZheF9udW1iZXInKTtcbiAgfVxuICBwdWJsaWMgc2V0IGZheE51bWJlcih2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fZmF4TnVtYmVyID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0RmF4TnVtYmVyKCkge1xuICAgIHRoaXMuX2ZheE51bWJlciA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgZmF4TnVtYmVySW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2ZheE51bWJlcjtcbiAgfVxuXG4gIC8vIGZvcmNlX3Bhc3N3b3JkX2NoYW5nZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9mb3JjZVBhc3N3b3JkQ2hhbmdlPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCBmb3JjZVBhc3N3b3JkQ2hhbmdlKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ2ZvcmNlX3Bhc3N3b3JkX2NoYW5nZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgZm9yY2VQYXNzd29yZENoYW5nZSh2YWx1ZTogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlKSB7XG4gICAgdGhpcy5fZm9yY2VQYXNzd29yZENoYW5nZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldEZvcmNlUGFzc3dvcmRDaGFuZ2UoKSB7XG4gICAgdGhpcy5fZm9yY2VQYXNzd29yZENoYW5nZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgZm9yY2VQYXNzd29yZENoYW5nZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9mb3JjZVBhc3N3b3JkQ2hhbmdlO1xuICB9XG5cbiAgLy8gZ2l2ZW5fbmFtZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9naXZlbk5hbWU/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGdpdmVuTmFtZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2dpdmVuX25hbWUnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGdpdmVuTmFtZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fZ2l2ZW5OYW1lID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0R2l2ZW5OYW1lKCkge1xuICAgIHRoaXMuX2dpdmVuTmFtZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgZ2l2ZW5OYW1lSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2dpdmVuTmFtZTtcbiAgfVxuXG4gIC8vIGlkIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHVibGljIGdldCBpZCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2lkJyk7XG4gIH1cblxuICAvLyBpbV9hZGRyZXNzZXMgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogZmFsc2VcbiAgcHVibGljIGdldCBpbUFkZHJlc3NlcygpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRMaXN0QXR0cmlidXRlKCdpbV9hZGRyZXNzZXMnKTtcbiAgfVxuXG4gIC8vIGpvYl90aXRsZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9qb2JUaXRsZT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgam9iVGl0bGUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdqb2JfdGl0bGUnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGpvYlRpdGxlKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9qb2JUaXRsZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldEpvYlRpdGxlKCkge1xuICAgIHRoaXMuX2pvYlRpdGxlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBqb2JUaXRsZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9qb2JUaXRsZTtcbiAgfVxuXG4gIC8vIG1haWwgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9tYWlsPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBtYWlsKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnbWFpbCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgbWFpbCh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fbWFpbCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldE1haWwoKSB7XG4gICAgdGhpcy5fbWFpbCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgbWFpbElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9tYWlsO1xuICB9XG5cbiAgLy8gbWFpbF9uaWNrbmFtZSAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX21haWxOaWNrbmFtZT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgbWFpbE5pY2tuYW1lKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnbWFpbF9uaWNrbmFtZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgbWFpbE5pY2tuYW1lKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9tYWlsTmlja25hbWUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRNYWlsTmlja25hbWUoKSB7XG4gICAgdGhpcy5fbWFpbE5pY2tuYW1lID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBtYWlsTmlja25hbWVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fbWFpbE5pY2tuYW1lO1xuICB9XG5cbiAgLy8gbWFuYWdlcl9pZCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9tYW5hZ2VySWQ/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IG1hbmFnZXJJZCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ21hbmFnZXJfaWQnKTtcbiAgfVxuICBwdWJsaWMgc2V0IG1hbmFnZXJJZCh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fbWFuYWdlcklkID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0TWFuYWdlcklkKCkge1xuICAgIHRoaXMuX21hbmFnZXJJZCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgbWFuYWdlcklkSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX21hbmFnZXJJZDtcbiAgfVxuXG4gIC8vIG1vYmlsZV9waG9uZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9tb2JpbGVQaG9uZT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgbW9iaWxlUGhvbmUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdtb2JpbGVfcGhvbmUnKTtcbiAgfVxuICBwdWJsaWMgc2V0IG1vYmlsZVBob25lKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9tb2JpbGVQaG9uZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldE1vYmlsZVBob25lKCkge1xuICAgIHRoaXMuX21vYmlsZVBob25lID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBtb2JpbGVQaG9uZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9tb2JpbGVQaG9uZTtcbiAgfVxuXG4gIC8vIG9iamVjdF9pZCAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiBmYWxzZVxuICBwdWJsaWMgZ2V0IG9iamVjdElkKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnb2JqZWN0X2lkJyk7XG4gIH1cblxuICAvLyBvZmZpY2VfbG9jYXRpb24gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfb2ZmaWNlTG9jYXRpb24/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IG9mZmljZUxvY2F0aW9uKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnb2ZmaWNlX2xvY2F0aW9uJyk7XG4gIH1cbiAgcHVibGljIHNldCBvZmZpY2VMb2NhdGlvbih2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fb2ZmaWNlTG9jYXRpb24gPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRPZmZpY2VMb2NhdGlvbigpIHtcbiAgICB0aGlzLl9vZmZpY2VMb2NhdGlvbiA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgb2ZmaWNlTG9jYXRpb25JbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fb2ZmaWNlTG9jYXRpb247XG4gIH1cblxuICAvLyBvbnByZW1pc2VzX2Rpc3Rpbmd1aXNoZWRfbmFtZSAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiBmYWxzZVxuICBwdWJsaWMgZ2V0IG9ucHJlbWlzZXNEaXN0aW5ndWlzaGVkTmFtZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ29ucHJlbWlzZXNfZGlzdGluZ3Vpc2hlZF9uYW1lJyk7XG4gIH1cblxuICAvLyBvbnByZW1pc2VzX2RvbWFpbl9uYW1lIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHB1YmxpYyBnZXQgb25wcmVtaXNlc0RvbWFpbk5hbWUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdvbnByZW1pc2VzX2RvbWFpbl9uYW1lJyk7XG4gIH1cblxuICAvLyBvbnByZW1pc2VzX2ltbXV0YWJsZV9pZCAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX29ucHJlbWlzZXNJbW11dGFibGVJZD86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgb25wcmVtaXNlc0ltbXV0YWJsZUlkKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnb25wcmVtaXNlc19pbW11dGFibGVfaWQnKTtcbiAgfVxuICBwdWJsaWMgc2V0IG9ucHJlbWlzZXNJbW11dGFibGVJZCh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fb25wcmVtaXNlc0ltbXV0YWJsZUlkID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0T25wcmVtaXNlc0ltbXV0YWJsZUlkKCkge1xuICAgIHRoaXMuX29ucHJlbWlzZXNJbW11dGFibGVJZCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgb25wcmVtaXNlc0ltbXV0YWJsZUlkSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX29ucHJlbWlzZXNJbW11dGFibGVJZDtcbiAgfVxuXG4gIC8vIG9ucHJlbWlzZXNfc2FtX2FjY291bnRfbmFtZSAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiBmYWxzZVxuICBwdWJsaWMgZ2V0IG9ucHJlbWlzZXNTYW1BY2NvdW50TmFtZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ29ucHJlbWlzZXNfc2FtX2FjY291bnRfbmFtZScpO1xuICB9XG5cbiAgLy8gb25wcmVtaXNlc19zZWN1cml0eV9pZGVudGlmaWVyIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHB1YmxpYyBnZXQgb25wcmVtaXNlc1NlY3VyaXR5SWRlbnRpZmllcigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ29ucHJlbWlzZXNfc2VjdXJpdHlfaWRlbnRpZmllcicpO1xuICB9XG5cbiAgLy8gb25wcmVtaXNlc19zeW5jX2VuYWJsZWQgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogZmFsc2VcbiAgcHVibGljIGdldCBvbnByZW1pc2VzU3luY0VuYWJsZWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgnb25wcmVtaXNlc19zeW5jX2VuYWJsZWQnKTtcbiAgfVxuXG4gIC8vIG9ucHJlbWlzZXNfdXNlcl9wcmluY2lwYWxfbmFtZSAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiBmYWxzZVxuICBwdWJsaWMgZ2V0IG9ucHJlbWlzZXNVc2VyUHJpbmNpcGFsTmFtZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ29ucHJlbWlzZXNfdXNlcl9wcmluY2lwYWxfbmFtZScpO1xuICB9XG5cbiAgLy8gb3RoZXJfbWFpbHMgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfb3RoZXJNYWlscz86IHN0cmluZ1tdOyBcbiAgcHVibGljIGdldCBvdGhlck1haWxzKCkge1xuICAgIHJldHVybiBjZGt0Zi5Gbi50b2xpc3QodGhpcy5nZXRMaXN0QXR0cmlidXRlKCdvdGhlcl9tYWlscycpKTtcbiAgfVxuICBwdWJsaWMgc2V0IG90aGVyTWFpbHModmFsdWU6IHN0cmluZ1tdKSB7XG4gICAgdGhpcy5fb3RoZXJNYWlscyA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldE90aGVyTWFpbHMoKSB7XG4gICAgdGhpcy5fb3RoZXJNYWlscyA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgb3RoZXJNYWlsc0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9vdGhlck1haWxzO1xuICB9XG5cbiAgLy8gcGFzc3dvcmQgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9wYXNzd29yZD86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgcGFzc3dvcmQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdwYXNzd29yZCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgcGFzc3dvcmQodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3Bhc3N3b3JkID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UGFzc3dvcmQoKSB7XG4gICAgdGhpcy5fcGFzc3dvcmQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHBhc3N3b3JkSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3Bhc3N3b3JkO1xuICB9XG5cbiAgLy8gcG9zdGFsX2NvZGUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcG9zdGFsQ29kZT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgcG9zdGFsQ29kZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3Bvc3RhbF9jb2RlJyk7XG4gIH1cbiAgcHVibGljIHNldCBwb3N0YWxDb2RlKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9wb3N0YWxDb2RlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0UG9zdGFsQ29kZSgpIHtcbiAgICB0aGlzLl9wb3N0YWxDb2RlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBwb3N0YWxDb2RlSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3Bvc3RhbENvZGU7XG4gIH1cblxuICAvLyBwcmVmZXJyZWRfbGFuZ3VhZ2UgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcHJlZmVycmVkTGFuZ3VhZ2U/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IHByZWZlcnJlZExhbmd1YWdlKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgncHJlZmVycmVkX2xhbmd1YWdlJyk7XG4gIH1cbiAgcHVibGljIHNldCBwcmVmZXJyZWRMYW5ndWFnZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fcHJlZmVycmVkTGFuZ3VhZ2UgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRQcmVmZXJyZWRMYW5ndWFnZSgpIHtcbiAgICB0aGlzLl9wcmVmZXJyZWRMYW5ndWFnZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcHJlZmVycmVkTGFuZ3VhZ2VJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fcHJlZmVycmVkTGFuZ3VhZ2U7XG4gIH1cblxuICAvLyBwcm94eV9hZGRyZXNzZXMgLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogZmFsc2VcbiAgcHVibGljIGdldCBwcm94eUFkZHJlc3NlcygpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRMaXN0QXR0cmlidXRlKCdwcm94eV9hZGRyZXNzZXMnKTtcbiAgfVxuXG4gIC8vIHNob3dfaW5fYWRkcmVzc19saXN0IC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3Nob3dJbkFkZHJlc3NMaXN0PzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCBzaG93SW5BZGRyZXNzTGlzdCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRCb29sZWFuQXR0cmlidXRlKCdzaG93X2luX2FkZHJlc3NfbGlzdCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgc2hvd0luQWRkcmVzc0xpc3QodmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX3Nob3dJbkFkZHJlc3NMaXN0ID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0U2hvd0luQWRkcmVzc0xpc3QoKSB7XG4gICAgdGhpcy5fc2hvd0luQWRkcmVzc0xpc3QgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHNob3dJbkFkZHJlc3NMaXN0SW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3Nob3dJbkFkZHJlc3NMaXN0O1xuICB9XG5cbiAgLy8gc3RhdGUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfc3RhdGU/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IHN0YXRlKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnc3RhdGUnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHN0YXRlKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9zdGF0ZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFN0YXRlKCkge1xuICAgIHRoaXMuX3N0YXRlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBzdGF0ZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9zdGF0ZTtcbiAgfVxuXG4gIC8vIHN0cmVldF9hZGRyZXNzIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3N0cmVldEFkZHJlc3M/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IHN0cmVldEFkZHJlc3MoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdzdHJlZXRfYWRkcmVzcycpO1xuICB9XG4gIHB1YmxpYyBzZXQgc3RyZWV0QWRkcmVzcyh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fc3RyZWV0QWRkcmVzcyA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFN0cmVldEFkZHJlc3MoKSB7XG4gICAgdGhpcy5fc3RyZWV0QWRkcmVzcyA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgc3RyZWV0QWRkcmVzc0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9zdHJlZXRBZGRyZXNzO1xuICB9XG5cbiAgLy8gc3VybmFtZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9zdXJuYW1lPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBzdXJuYW1lKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnc3VybmFtZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgc3VybmFtZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fc3VybmFtZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFN1cm5hbWUoKSB7XG4gICAgdGhpcy5fc3VybmFtZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgc3VybmFtZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9zdXJuYW1lO1xuICB9XG5cbiAgLy8gdXNhZ2VfbG9jYXRpb24gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfdXNhZ2VMb2NhdGlvbj86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgdXNhZ2VMb2NhdGlvbigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3VzYWdlX2xvY2F0aW9uJyk7XG4gIH1cbiAgcHVibGljIHNldCB1c2FnZUxvY2F0aW9uKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl91c2FnZUxvY2F0aW9uID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0VXNhZ2VMb2NhdGlvbigpIHtcbiAgICB0aGlzLl91c2FnZUxvY2F0aW9uID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB1c2FnZUxvY2F0aW9uSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3VzYWdlTG9jYXRpb247XG4gIH1cblxuICAvLyB1c2VyX3ByaW5jaXBhbF9uYW1lIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiB0cnVlXG4gIHByaXZhdGUgX3VzZXJQcmluY2lwYWxOYW1lPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCB1c2VyUHJpbmNpcGFsTmFtZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3VzZXJfcHJpbmNpcGFsX25hbWUnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHVzZXJQcmluY2lwYWxOYW1lKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl91c2VyUHJpbmNpcGFsTmFtZSA9IHZhbHVlO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB1c2VyUHJpbmNpcGFsTmFtZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl91c2VyUHJpbmNpcGFsTmFtZTtcbiAgfVxuXG4gIC8vIHVzZXJfdHlwZSAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiBmYWxzZVxuICBwdWJsaWMgZ2V0IHVzZXJUeXBlKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgndXNlcl90eXBlJyk7XG4gIH1cblxuICAvLyB0aW1lb3V0cyAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF90aW1lb3V0cyA9IG5ldyBVc2VyVGltZW91dHNPdXRwdXRSZWZlcmVuY2UodGhpcywgXCJ0aW1lb3V0c1wiKTtcbiAgcHVibGljIGdldCB0aW1lb3V0cygpIHtcbiAgICByZXR1cm4gdGhpcy5fdGltZW91dHM7XG4gIH1cbiAgcHVibGljIHB1dFRpbWVvdXRzKHZhbHVlOiBVc2VyVGltZW91dHMpIHtcbiAgICB0aGlzLl90aW1lb3V0cy5pbnRlcm5hbFZhbHVlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0VGltZW91dHMoKSB7XG4gICAgdGhpcy5fdGltZW91dHMuaW50ZXJuYWxWYWx1ZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgdGltZW91dHNJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdGltZW91dHMuaW50ZXJuYWxWYWx1ZTtcbiAgfVxuXG4gIC8vID09PT09PT09PVxuICAvLyBTWU5USEVTSVNcbiAgLy8gPT09PT09PT09XG5cbiAgcHJvdGVjdGVkIHN5bnRoZXNpemVBdHRyaWJ1dGVzKCk6IHsgW25hbWU6IHN0cmluZ106IGFueSB9IHtcbiAgICByZXR1cm4ge1xuICAgICAgYWNjb3VudF9lbmFibGVkOiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0odGhpcy5fYWNjb3VudEVuYWJsZWQpLFxuICAgICAgYWdlX2dyb3VwOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9hZ2VHcm91cCksXG4gICAgICBidXNpbmVzc19waG9uZXM6IGNka3RmLmxpc3RNYXBwZXIoY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0pKHRoaXMuX2J1c2luZXNzUGhvbmVzKSxcbiAgICAgIGNpdHk6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX2NpdHkpLFxuICAgICAgY29tcGFueV9uYW1lOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9jb21wYW55TmFtZSksXG4gICAgICBjb25zZW50X3Byb3ZpZGVkX2Zvcl9taW5vcjogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fY29uc2VudFByb3ZpZGVkRm9yTWlub3IpLFxuICAgICAgY29zdF9jZW50ZXI6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX2Nvc3RDZW50ZXIpLFxuICAgICAgY291bnRyeTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fY291bnRyeSksXG4gICAgICBkZXBhcnRtZW50OiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9kZXBhcnRtZW50KSxcbiAgICAgIGRpc2FibGVfcGFzc3dvcmRfZXhwaXJhdGlvbjogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHRoaXMuX2Rpc2FibGVQYXNzd29yZEV4cGlyYXRpb24pLFxuICAgICAgZGlzYWJsZV9zdHJvbmdfcGFzc3dvcmQ6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybSh0aGlzLl9kaXNhYmxlU3Ryb25nUGFzc3dvcmQpLFxuICAgICAgZGlzcGxheV9uYW1lOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9kaXNwbGF5TmFtZSksXG4gICAgICBkaXZpc2lvbjogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fZGl2aXNpb24pLFxuICAgICAgZW1wbG95ZWVfaWQ6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX2VtcGxveWVlSWQpLFxuICAgICAgZW1wbG95ZWVfdHlwZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fZW1wbG95ZWVUeXBlKSxcbiAgICAgIGZheF9udW1iZXI6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX2ZheE51bWJlciksXG4gICAgICBmb3JjZV9wYXNzd29yZF9jaGFuZ2U6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybSh0aGlzLl9mb3JjZVBhc3N3b3JkQ2hhbmdlKSxcbiAgICAgIGdpdmVuX25hbWU6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX2dpdmVuTmFtZSksXG4gICAgICBqb2JfdGl0bGU6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX2pvYlRpdGxlKSxcbiAgICAgIG1haWw6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX21haWwpLFxuICAgICAgbWFpbF9uaWNrbmFtZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fbWFpbE5pY2tuYW1lKSxcbiAgICAgIG1hbmFnZXJfaWQ6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX21hbmFnZXJJZCksXG4gICAgICBtb2JpbGVfcGhvbmU6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX21vYmlsZVBob25lKSxcbiAgICAgIG9mZmljZV9sb2NhdGlvbjogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fb2ZmaWNlTG9jYXRpb24pLFxuICAgICAgb25wcmVtaXNlc19pbW11dGFibGVfaWQ6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX29ucHJlbWlzZXNJbW11dGFibGVJZCksXG4gICAgICBvdGhlcl9tYWlsczogY2RrdGYubGlzdE1hcHBlcihjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSkodGhpcy5fb3RoZXJNYWlscyksXG4gICAgICBwYXNzd29yZDogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fcGFzc3dvcmQpLFxuICAgICAgcG9zdGFsX2NvZGU6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX3Bvc3RhbENvZGUpLFxuICAgICAgcHJlZmVycmVkX2xhbmd1YWdlOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9wcmVmZXJyZWRMYW5ndWFnZSksXG4gICAgICBzaG93X2luX2FkZHJlc3NfbGlzdDogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHRoaXMuX3Nob3dJbkFkZHJlc3NMaXN0KSxcbiAgICAgIHN0YXRlOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9zdGF0ZSksXG4gICAgICBzdHJlZXRfYWRkcmVzczogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fc3RyZWV0QWRkcmVzcyksXG4gICAgICBzdXJuYW1lOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl9zdXJuYW1lKSxcbiAgICAgIHVzYWdlX2xvY2F0aW9uOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl91c2FnZUxvY2F0aW9uKSxcbiAgICAgIHVzZXJfcHJpbmNpcGFsX25hbWU6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX3VzZXJQcmluY2lwYWxOYW1lKSxcbiAgICAgIHRpbWVvdXRzOiB1c2VyVGltZW91dHNUb1RlcnJhZm9ybSh0aGlzLl90aW1lb3V0cy5pbnRlcm5hbFZhbHVlKSxcbiAgICB9O1xuICB9XG59XG4iXX0=