"""

Revision ID: ea815a161929
Revises: 
Create Date: 2025-05-31 17:11:37.371121

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
import sqlmodel

# revision identifiers, used by Alembic.
revision: str = "ea815a161929"
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "subject",
        sa.Column("reason", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("high_price_target", sa.Float(), nullable=True),
        sa.Column("low_price_target", sa.Float(), nullable=True),
        sa.Column("fair_value", sa.Float(), nullable=True),
        sa.Column(
            "summary_price_target", sqlmodel.sql.sqltypes.AutoString(), nullable=True
        ),
        sa.Column("symbol", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("consensus", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("name", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("exchange", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("date", sa.DateTime(), nullable=False),
        sa.Column("news", sa.JSON(), nullable=True),
        sa.Column("news_summary", sa.JSON(), nullable=True),
        sa.Column("summary", sa.JSON(), nullable=True),
        sa.Column("price_target_news", sa.JSON(), nullable=True),
        sa.PrimaryKeyConstraint("symbol", "date"),
    )
    with op.batch_alter_table("subject", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_subject_consensus"), ["consensus"], unique=False
        )
        batch_op.create_index(batch_op.f("ix_subject_date"), ["date"], unique=False)
        batch_op.create_index(batch_op.f("ix_subject_symbol"), ["symbol"], unique=False)

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("subject", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_subject_symbol"))
        batch_op.drop_index(batch_op.f("ix_subject_date"))
        batch_op.drop_index(batch_op.f("ix_subject_consensus"))

    op.drop_table("subject")
    # ### end Alembic commands ###
