<!--
<div align="right">
[![CN](https://img.shields.io/badge/CN-🇨🇳-white?style=plastic)](https://github.com/eli64s/readme-ai/blob/main/docs/README-zh-CN.md)
[![DE](https://img.shields.io/badge/DE-🇩🇪-white?style=plastic)](https://github.com/eli64s/readme-ai/blob/main/docs/README-de.md)
[![FR](https://img.shields.io/badge/FR-🇫🇷-white?style=plastic)](https://github.com/eli64s/readme-ai/blob/main/docs/README-fr.md)
</div>
-->

<div align="center">
    <h1 align="center">
        <img src="https://img.icons8.com/?size=512&id=55494&format=png" width="80" />
        <img src="https://img.icons8.com/?size=512&id=kTuxVYRKeKEY&format=png" width="80" />
        <br>README-AI
    </h1>
    <h3>◦ Generate beautiful and informative <i>README</i> files</h3>
    <h3>◦ Powered by OpenAI's GPT language model APIs</h3>
    <br>
    <p align="center">
        <img src="https://img.shields.io/badge/Markdown-000000.svg?&logo=Markdown&logoColor=white" alt="Markdown" />
        <img src="https://img.shields.io/badge/OpenAI-412991.svg?&logo=OpenAI&logoColor=white" alt="OpenAI" />
        <img src="https://img.shields.io/badge/Python-3776AB.svg?&logo=Python&logoColor=white" alt="Python" />
        <img src="https://img.shields.io/badge/Pytest-0A9EDC.svg?&logo=Pytest&logoColor=white" alt="pytest" />
        <img src="https://img.shields.io/badge/Docker-2496ED.svg?style&logo=Docker&logoColor=white" alt="Docker" />
        <img src="https://img.shields.io/badge/GitHub%20Actions-2088FF.svg?style&logo=GitHub-Actions&logoColor=white" alt="actions" />
    </p>
    <a href="https://pypi.org/project/readmeai/">
    <img src="https://img.shields.io/pypi/v/readmeai?color=5D6D7E&logo=pypi"
    alt="pypi-version" /></a>
    <a href="https://pypi.org/project/readmeai/">
    <img src="https://img.shields.io/pypi/pyversions/readmeai?color=5D6D7E&logo=python" alt="pypi-python-version" /></a>
    <img src="https://img.shields.io/github/commit-activity/m/eli64s/readme-ai.svg?color=5D6D7E" alt="commits-month" />
    <img src="https://img.shields.io/github/license/eli64s/readme-ai?color=5D6D7E" alt="license" />
    <br>
    <!--
    <a href="https://pypi.org/project/readmeai/">
    <img src="https://img.shields.io/pypi/dm/readmeai?color=5D6D7E" alt="pypi-downloads" />
    </a>
    -->
</div>

---

## 📖 Table of Contents

- [📖 Table of Contents](#-table-of-contents)
- [🔭 Overview](#-overview)
- [🎈 Demo](#-demo)
- [🤖 Features](#-features)
- [👩‍💻 Usage](#-usage)
  - [📦 Installation](#-installation)
  - [⚙️ Configuration](#️-configuration)
  - [🚀 Running *README-AI*](#-running-readme-ai)
  - [🧪 Tests](#-tests)
- [🛠 Project Roadmap](#-project-roadmap)
- [📒 Changelog](#-changelog)
- [🤝 Contributing](#-contributing)
- [📄 License](#-license)
- [👏 Acknowledgments](#-acknowledgments)

---

## 🔭 Overview

<div align="center">
  <img src="https://github.com/eli64s/readme-ai/blob/main/examples/images/dalle-readmeai.png?raw=true" height="500" />
</div>
<br>

**🎯 Objective**

Dev tool that auto-generates detailed README.md files from the command-line using OpenAI's GPT models. Simply provide a repository URL or directory path, and *README-AI* builds a well-structured README.md for your project.

**💥 Motivation**

Streamlines documentation creation and maintenance, enhancing developer productivity. *README-AI* aims to improve the adoption of open-source software, enabling all skill levels and disciplines to understand, utilize, and contribute to projects more effectively.

**⚠️ Note**

This project is under development with an opinionated setup. It's vital to review the text generated by the OpenAI API to ensure it accurately represents your codebase.

---

## 🎈 Demo

***readmeai CLI***

- Run <i>readme-ai</i> in your terminal via PyPI, Docker, and more!

[cli-demo](https://github.com/eli64s/readme-ai/assets/43382407/645c2336-6ea7-444c-a927-5450930c5255)

<!--
- You can also run the CLI without an API key using the <code>--offline</code> option. This option can still generate most of the README file

[offline-demo](https://github.com/eli64s/readme-ai/assets/43382407/645c2336-6ea7-444c-a927-5450930c5255)

<br>

***Streamlit Community Cloud***

‣ Use *readme-ai* directly in your browser! Zero installation, zero code!

[streamlit-demo](https://github.com/eli64s/readme-ai/assets/43382407/e8260e78-b684-4e72-941c-b3046b90c452)

-->

---

## 🤖 Features

<br>
<div>
<details>
    <summary style="display: flex; align-items: center;">
        <span style="font-size: 2.0em;"> ❶ Badges</span>
    </summary>
    <table>
        <tr>
            <td>
                <h4><i>Project Slogan and Badges</i></h4>
                <p>
                    ‣ A slogan to highlight your poject is generated by <a href="https://github.com/eli64s/readme-ai/blob/main/readmeai/settings/config.toml#L33">prompting</a> OpenAI's GPT engine.
                    </p>
                <p>
                    ‣ Codebase dependencies and metadata are visualized using <a href="https://shields.io/">Shields.io</a> badges.
                </p>
            </td>
        </tr>
        <tr>
            <td>
                <img src="https://raw.githubusercontent.com/eli64s/readme-ai/main/examples/images/badges.png" alt="badges" />
            </td>
        </tr>
    </table>
    <table>
        <p>
            ‣ Use the CLI option <code>--badges</code> to select the style of badges for your README! <br>
            ‣ 6 options currently supported: <i>flat (default), flat-square, plastic, for-the-badge, social, square</i>. Find a few examples below.
        <tr>
            <td>
                <h4 style="text-align:left;">1. Shieldsio <em>flat</em> badge style</h4>
                <p style="text-align:left;">Command: none as its the default style for <em>readme-ai</em></p>
                <div style="text-align:center;">
                    <img src="https://raw.githubusercontent.com/eli64s/readme-ai/main/examples/images/badges-shieldsio-default.png" alt="badges-shieldsio-default" />
                </div>
            </td>
        </tr>
        <tr>
            <td>
                <h4 style="text-align:left;">2. Shieldsio <em>for-the-badge</em> style</h4>
                <p style="text-align:left;">Command: <code>--badges for-the-badge</code></p>
                <div style="text-align:center;">
                    <img src="https://raw.githubusercontent.com/eli64s/readme-ai/main/examples/images/badges-shieldsio-flat.png" alt="badges-shieldsio-flat" />
                </div>
            </td>
        </tr>
        <tr>
            <td>
                <h4 style="text-align:left;">3. Square <em>iOS style</em> badges</h4>
                <p style="text-align:left;">Command: <code>--badges square</code></p>
                <div style="text-align:center;">
                    <img src="https://raw.githubusercontent.com/eli64s/readme-ai/main/examples/images/badges-square.png" alt="badges-square" />
                </div>
            </td>
        </tr>
    </table>
</details>
</div>
<br>
<div>
    <details>
        <summary style="display: flex; align-items: center;">
            <span style="font-size: 2.0em;"> ❷ Codebase Documentation</span>
        </summary>
        <table>
            <tr>
                <td colspan="2">
                    <h4><i>Directory Tree and File Summaries</i></h4>
                </td>
            </tr>
            <tr>
                <td colspan="2">
                    <p>‣ Your project's directory structure is visualized using a custom tree function.</p>
                    <p>‣ Each file in the codebase is summarized by OpenAI's <i>GPT</i> model.</p>
                </td>
            </tr>
            <tr>
                <td align="center">
                    <img src="https://raw.githubusercontent.com/eli64s/readme-ai/main/examples/images/repository-tree.png" alt="repository-tree" />
                </td>
                <td align="center">
                    <img src="https://raw.githubusercontent.com/eli64s/readme-ai/main/examples/images/code-summaries.png" alt="code-summaries" />
                </td>
            </tr>
        </table>
    </details>
</div>
<br>
<div>
    <details>
        <summary style="display: flex; align-items: center;">
            <span style="font-size: 2.0em;"> ❸ Features Table</span>
        </summary>
        <table>
            <tr>
                <td>
                    <h4><i>Prompted Text Generation</i></h4>
                    <p>
                        ‣ An overview paragraph and features table are generated using <a href="https://github.com/eli64s/readme-ai/blob/main/readmeai/settings/config.toml#L28">detailed prompts</a>, embedded with project metadata.
                    </p>
                </td>
            </tr>
            <tr>
                <td>
                    <img src="https://raw.githubusercontent.com/eli64s/readme-ai/main/examples/images/feature-table.png" alt="feature-table" />
                </td>
            </tr>
        </table>
    </details>
</div>
<br>
<div>
    <details>
        <summary style="display: flex; align-items: center;">
            <span style="font-size: 2.0em;"> ❹ Dynamic Usage Guides</span><br>
        </summary>
        <table>
            <tr>
                <td>
                    <h4><i>Installation, Running, and Test</i></h4>
                    <p>
                        ‣ Generates instructions for installing, running, and testing your project. Instructions are created by identifying the codebase's top language and referring to our <a href="https://github.com/eli64s/readme-ai/blob/main/readmeai/settings/language_setup.toml">language_setup.toml</a> configuration file.
                    </p>
                </td>
            </tr>
            <tr>
                <td>
                    <img src="https://raw.githubusercontent.com/eli64s/readme-ai/main/examples/images/usage-instructions.png" alt="usage-instructions" />
                </td>
            </tr>
        </table>
    </details>
</div>
<br>
<div>
    <details>
        <summary style="display: flex; align-items: center;">
            <span style="font-size: 2.0em;"> ❺ Additional README Sections</span><br>
        </summary>
        <table>
            <tr>
                <td>
                    <img src="https://raw.githubusercontent.com/eli64s/readme-ai/main/examples/images/roadmap.png" alt="roadmap" />
                </td>
            </tr>
            <br>
            <tr>
                <td>
                    <img src="https://raw.githubusercontent.com/eli64s/readme-ai/main/examples/images/license.png" alt="license" />
                </td>
            </tr>
        </table>
    </details>
</div>
<br>
<div>
<details>
    <summary style="display: flex; align-items: center;">
        <span style="font-size: 2.0em;">❻ Templates (coming soon)</span><br>
    </summary>
    <table>
        <tr>
            <td>
                <p>‣ Developing CLI option letting users select from a variety of README styles</p>
                <p>‣ Templates for use-cases such as data, machine learning, web development, and more!</p>
            </td>
        </tr>
        <tr>
            <td>
                <h3>AI and ML README Template Concept</h3>
                <ul>
                    <li><strong><a href="#overview">Overview</a></strong>: Summary of the projects' objectives, scope, and expected outcomes.</li>
                    <li><strong><a href="#project-structure">Project Structure</a></strong>: Overview of the organization of the projects and their main components.</li>
                    <li><strong><a href="#data-collection-and-preprocessing">Data Preprocessing</a></strong>: Data sources, collection methods, and types of data</li>
                    <li><strong><a href="#feature-engineering">Feature Engineering</a></strong>: Importance of feature engineering and its impact on model performance.</li>
                    <li><strong><a href="#model-architecture-and-development">Model Architecture and Development</a></strong>: Model selection, dev strategies, and implemented algorithms.</li>
                    <li><strong><a href="#training-and-validation">Training and Validation</a></strong>: Info on model training procedures, hyperparameter tuning, and validation strategies.</li>
                    <li><strong><a href="#testing-and-evaluation">Testing and Evaluation</a></strong>: Model testing results, performance analysis, and comparison with benchmarks.</li>
                    <li><strong><a href="#deployment-and-integration">Deployment and Integration</a></strong>: Integration with other systems, APIs, and user interfaces</li>
                    <li><strong><a href="#usage-and-maintenance">Usage and Maintenance</a></strong>: User guide on how to use the deployed models and interfaces.</li>
                    <li><strong><a href="#results-and-discussion">Results and Discussion</a></strong>: Implications, limitations, and future work.</li>
                    <li><strong><a href="#ethical-considerations">Ethical Considerations</a></strong>: Ethical aspects, data privacy, and fairness in model predictions.</li>
                    <li><strong><a href="#contributing">Contributing</a></strong>: Procedures for submitting contributions, reporting issues, and proposing enhancements.</li>
                    <li><strong><a href="#acknowledgements">Acknowledgements</a></strong>: References to resources, libraries, and frameworks used.</li>
                    <li><strong><a href="#license">License</a></strong>: Explanation of usage rights, restrictions, and attribution requirements.</li>
                </ul>
            </td>
        </tr>
    </table>
</details>
</div>
<br>
<div>
    <details>
        <summary style="display: flex; align-items: center;">
            <span style="font-size: 2.0em;"> ❼ Example README Files</span><br>
        </summary>
        <table>
            <thead>
                <tr>
                    <th></th>
                    <th>Output File</th>
                    <th>Repository</th>
                    <th>Languages</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>1️⃣</td>
                    <td><a href="https://github.com/eli64s/readme-ai/blob/main/examples/markdown/readme-python.md">readme-python.md</a></td>
                    <td><a href="https://github.com/eli64s/readme-ai">readme-ai</a></td>
                    <td>Python</td>
                </tr>
                <tr>
                    <td>2️⃣</td>
                    <td><a href="https://github.com/eli64s/readme-ai/blob/main/examples/markdown/readme-typescript.md">readme-typescript.md</a></td>
                    <td><a href="https://github.com/Yuberley/ChatGPT-App-React-Native-TypeScript">chatgpt-app-react-typescript</a></td>
                    <td>TypeScript, React</td>
                </tr>
                <tr>
                    <td>3️⃣</td>
                    <td><a href="https://github.com/eli64s/readme-ai/blob/main/examples/markdown/readme-javascript.md">readme-javascript.md</a></td>
                    <td><a href="https://github.com/idosal/assistant-chat-gpt-javascript">assistant-chat-gpt-javascript</a></td>
                    <td>JavaScript, React</td>
                </tr>
                <tr>
                    <td>4️⃣</td>
                    <td><a href="https://github.com/eli64s/readme-ai/blob/main/examples/markdown/readme-kotlin.md">readme-kotlin.md</a></td>
                    <td><a href="https://github.com/rumaan/file.io-Android-Client">file.io-android-client</a></td>
                    <td>Kotlin, Java, Android</td>
                </tr>
                <tr>
                    <td>5️⃣</td>
                    <td><a href="https://github.com/eli64s/readme-ai/blob/main/examples/markdown/readme-rust-c.md">readme-rust-c.md</a></td>
                    <td><a href="https://github.com/DownWithUp/CallMon">rust-c-app</a></td>
                    <td>C, Rust</td>
                </tr>
                <tr>
                    <td>6️⃣</td>
                    <td><a href="https://github.com/eli64s/readme-ai/blob/main/examples/markdown/readme-go.md">readme-go.md</a></td>
                    <td><a href="https://github.com/olliefr/docker-gs-ping">go-docker-app</a></td>
                    <td>Go</td>
                </tr>
                <tr>
                    <td>7️⃣</td>
                    <td><a href="https://github.com/eli64s/readme-ai/blob/main/examples/markdown/readme-java.md">readme-java.md</a></td>
                    <td><a href="https://github.com/avjinder/Minimal-Todo">java-minimal-todo</a></td>
                    <td>Java</td>
                </tr>
                <tr>
                    <td>8️⃣</td>
                    <td><a href="https://github.com/eli64s/readme-ai/blob/main/examples/markdown/readme-fastapi-redis.md">readme-fastapi-redis.md</a></td>
                    <td><a href="https://github.com/FerrariDG/async-ml-inference">async-ml-inference</a></td>
                    <td>Python, FastAPI, Redis</td>
                </tr>
                <tr>
                    <td>9️⃣</td>
                    <td><a href="https://github.com/eli64s/readme-ai/blob/main/examples/markdown/readme-mlops.md">readme-mlops.md</a></td>
                    <td><a href="https://github.com/GokuMohandas/mlops-course">mlops-course</a></td>
                    <td>Python, Jupyter</td>
                </tr>
                <tr>
                    <td>🔟</td>
                    <td><a href="https://github.com/eli64s/readme-ai/blob/main/examples/markdown/readme-pyflink.md">readme-pyflink.md</a></td>
                    <td><a href="https://github.com/eli64s/flink-flow">flink-flow</a></td>
                    <td>PyFlink</td>
                </tr>
            </tbody>
        </table>
    </details>
</div>
<br>

<p align="right">
  <a href="#top"><b>Return </b></a>
</p>

---

## 👩‍💻 Usage

***Dependencies***

Please ensure you have the following dependencies installed on your system:

- *Python version 3.9 or higher*
- *Package manager (i.e. pip, conda, poetry) or Docker*
- *OpenAI API paid account and API key*

<br>

***Repository***

A remote repository URL or local directory path to your project is needed to use *readme-ai*. The following platforms are currently supported:
- *GitHub*
- *GitLab*
- *Bitbucket*
- *File System*

<br>

***OpenAI API***

An OpenAI API account and API key are needed to use *readme-ai*. The steps below outline this process:

<details closed><summary>🔐 OpenAI API - Setup Instructions</summary>

1. Go to the [OpenAI website](https://platform.openai.com/).
2. Click the "Sign up for free" button.
3. Fill out the registration form with your information and agree to the terms of service.
4. Once logged in, click on the "API" tab.
5. Follow the instructions to create a new API key.
6. Copy the API key and keep it in a secure place.

</details>

<details closed><summary>⚠️ OpenAI API - Cautionary Guidelines</summary>

1. **Review Sensitive Information**: Before running the application, ensure that all content in your repository is free of sensitive information. Please note that *readme-ai* does not filter out sensitive data from the README file, and it does not modify any files in your repository.

2. **API Usage Costs**: The OpenAI API is not free, and you will be charged for each request made. Costs can accumulate rapidly, so it's essential to be aware of your usage. You can monitor your API usage and associated costs by visiting the [OpenAI API Usage Dashboard](https://platform.openai.com/account/usage).

3. **Paid Account Recommended**: Setting up a paid account with OpenAI is highly recommended to avoid potential issues. Without a payment method on file, your API usage will be restricted to base GPT-3 models. This limitation can result in less accurate README file generation and may lead to API errors due to request limits.

4. **Runtime Considerations**: README file generation typically takes less than a minute. If the process exceeds a few minutes (e.g., 3 minutes), it's advisable to terminate *readme-ai* to prevent extended processing times.

</details>

---

### 📦 Installation

Using `pip`
```bash
pip install readmeai
```

<br>

Using `docker`
```bash
docker pull zeroxeli/readme-ai:latest
```

<br>

Alternatively, clone the readme-ai repository and build from source:
```bash
git clone https://github.com/eli64s/readme-ai
cd readme-ai
```

<br>

Using `bash`
```bash
bash setup/setup.sh
```

<br>

Using `conda`
```bash
conda create -n readmeai python=3.9 -y && \
conda activate readmeai && \
pip install -r requirements.txt
```

<br>

Using `poetry`
```bash
poetry shell && \
poetry install
```

---

### ⚙️ Configuration

To generate a *README.md* file, use the `readmeai` command in your terminal, along with the arguments below.

| Short Flag | Long Flag       | Description                                                    | Type        | Status       |
|------------|-----------------|----------------------------------------------------------------|-------------|--------------|
| `-k`       | `--api-key`     | Your language model API secret key.                            | String      | Optional     |
| `-b`       | `--badges`      | [Styles](https://shields.io/badges) - `flat (default), flat-square, plastic, for-the-badge, social, sqaure`      | String      | Optional     |
| `-e`       | `--emojis`      | Use ```false``` to remove emojis from README default template. | Boolean     | Optional     |
| `-f`       | `--offline`     | Use ```true``` to run README-AI without an API key.            | Boolean     | Optional     |
| `-m`       | `--model`       | Default large language model is the `gpt-3.5-turbo` engine.    | String      | Optional     |
| `-o`       | `--output`      | The output path for your README.md file.                       | Path/String | Optional     |
| `-r`       | `--repository`  | The URL or path to your code repository.                       | URL/String  | Required     |
| `-t`       | `--temperature` | The temperature (randomness) of the model responses.           | Float       | Optional     |
| `-l`       | `--language`    | The language of text to write README in.                       | String      | Coming Soon! |
| `-s`       | `--style`       | The README template style to build.                            | String      | Coming Soon! |

<br>
<h4 style="text-align:left">Badge Style CLI Options</h4>
<table border="1">
    <thead>
        <tr>
            <th>--badges</th>
            <th>svg icon</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td><code>flat-square</code></td>
            <td><img src="https://img.shields.io/badge/Python-3776AB.svg?&style=flat-square&logo=Python&logoColor=white" alt="Python flat-square" /></td>
        </tr>
        <tr>
            <td><code>plastic</code></td>
            <td><img src="https://img.shields.io/badge/Python-3776AB.svg?&style=plastic&logo=Python&logoColor=white" alt="Python plastic" /></td>
        </tr>
        <tr>
            <td><code>for-the-badge</code></td>
            <td><img src="https://img.shields.io/badge/Python-3776AB.svg?&style=for-the-badge&logo=Python&logoColor=white" alt="Python for-the-badge" /></td>
        </tr>
        <tr>
            <td><code>social</code></td>
            <td><img src="https://img.shields.io/badge/Python-3776AB.svg?&style=social&logo=Python&logoColor=white" alt="Python social" /></td>
        </tr>
        <tr>
            <td><code>flat</code></td>
            <td><img src="https://img.shields.io/badge/Python-3776AB.svg?&style=flat&logo=Python&logoColor=white" alt="Python flat" /></td>
        </tr>
        <tr>
          <td><code>apps</code></td>
          <td>
          <a href="https://skillicons.dev"><img src="https://skillicons.dev/icons?i=py" /></a>
          </td>
        </tr>
        <tr>
          <td><code>apps-light</code></td>
          <td>
          <a href="https://skillicons.dev"><img src="https://skillicons.dev/icons?i=py&theme=light" /></a>
            </td>
        </tr>
    </tbody>
</table>

***Custom Settings***

To customize the README file generation process, you can modify the project's [configuration file:](https://github.com/eli64s/readme-ai/blob/main/readmeai/settings/config.toml)

- **api**: OpenAI language model API configuration settings.
- **base_urls**: Base URLs for supported remote repository platforms.
- **cli**: CLI option settings used by the *readme-ai* application.
- **git**: Default git repository settings used if no repository is provided.
- **paths**: Directory paths and files used by the *readme-ai* application.
- **prompts**: Large language model prompts used to generate the README file.
- **md**: Dynamic Markdown section code templates used to build the README file.

---

### 🚀 Running *README-AI*

First, add your OpenAI API key to environment variables.

On `Linux/MacOS`
```bash
export OPENAI_API_KEY=YOUR_API_KEY
```

On `Windows`
```bash
set OPENAI_API_KEY=YOUR_API_KEY
```

Next, use one of the methods below to run the application.

Using `pip`
```bash
readmeai --output readme-ai.md --repository https://github.com/eli64s/readme-ai
```

You can also use the `short flags` for the CLI options above.

> In this example we also set set the badge style to `flat-square` and remove emojis from all README header section names.

```bash
readmeai -o readme-ai.md -r https://github.com/eli64s/readme-ai -b flat-square -e false
```

Additionally, you can run readme-ai in offline mode, or without an API key.

> Useful for quickly spinning up a baseline README.md file containing all your project's metadata.

```bash
readmeai -o readme-ai.md -r https://github.com/eli64s/readme-ai --offline true
```

> Offline mode example [README.md](https://github.com/eli64s/readme-ai/blob/main/examples/markdown/readme-offline.md)

<br>

Using `docker`
```bash
docker run -it \
-e OPENAI_API_KEY=$OPENAI_API_KEY \
-v "$(pwd)":/app zeroxeli/readme-ai:latest \
readmeai -o readme-ai.md -r https://github.com/eli64s/readme-ai
```

<br>

Using `Conda`
```bash
conda activate readmeai
python3 -m readmeai.cli.commands -o readme-ai.md -r https://github.com/eli64s/readme-ai
```

<br>

Using `Poetry`
```bash
poetry shell
poetry run python3 -m readmeai.cli.commands -o readme-ai.md -r https://github.com/eli64s/readme-ai
```

<br>

Using `Streamlit`

Generate a README files directly in your browser on Streamlit Cloud!

> 🎈 Navigate at [readmeai.streamlit.app](https://readmeai.streamlit.app/)

Application may be unavailable at times as it's hosted on a free tier.

---

### 🧪 Tests

Execute the test suite using the command below.

```bash
bash scripts/test.sh
```

---

## 🛠 Project Roadmap

- [X] Publish project as a Python library via PyPI for easy installation.
  - [*PyPI - readmeai*](https://pypi.org/project/readmeai/)
- [X] Make project available as a Docker image on Docker Hub.
  - [*Docker Hub - readme-ai*](https://hub.docker.com/repository/docker/zeroxeli/readme-ai/general)
- [X] Integrate and deploy app with Streamlit to make tool more widely accessible.
  - [*Streamlit Community Cloud - readmeai*](https://readmeai.streamlit.app/)
- [ ] Refactor our large language model engine to enable more robust README generation.
  - [ ] Explore [LangChain 🦜️🔗](https://python.langchain.com/docs/get_started/introduction) as an alternative to using the OpenAI API directly.
  - [ ] Explore [LlamaIndex 🦙](https://gpt-index.readthedocs.io/en/stable/index.html) framework and Retrieval Augmented Generation (RAG) paradigm.
- [ ] Building template system to create README files for specific use-cases (data, mobile, web, etc.)
- [ ] Add support for generating README files in any language (i.e. CN, ES, FR, JA, KO, RU).
- [ ] Develop GitHub Actions script to automatically update the README file when new code is pushed.

---

## 📒 Changelog

[Changelog](https://github.com/eli64s/readme-ai/blob/main/CHANGELOG.md)

---

## 🤝 Contributing

- [Discussions](https://github.com/eli64s/readme-ai/discussions)
- [Open an Issue](https://github.com/eli64s/readme-ai/issues)
- [Contributing Guidelines](https://github.com/eli64s/readme-ai/blob/main/CONTRIBUTING.md)

---

## 📄 License

[MIT](https://github.com/eli64s/readme-ai/blob/main/LICENSE)

---

## 👏 Acknowledgments

*Badges*
  - [Shields.io](https://shields.io/)
  - [Aveek-Saha/GitHub-Profile-Badges](https://github.com/Aveek-Saha/GitHub-Profile-Badges)
  - [Ileriayo/Markdown-Badges](https://github.com/Ileriayo/markdown-badges)
  - [tandpfun/skill-icons](https://github.com/tandpfun/skill-icons)


<p align="right">
  <a href="#top"><b>Return</b></a>
</p>

---
