# Installation Guide

## 🚀 ONE COMMAND INSTALLATION

```bash
pip3 install -r requirements.txt
```

That's it! This installs **everything** you need:
- ✅ Activity tracking (screenshots, OCR, window monitoring)
- ✅ Blockchain integration (Solana, smart contracts)
- ✅ Oracle service (Flask API with rate limiting)
- ✅ Liveness detection (OpenCV face detection)
- ✅ CLI tools
- ✅ All dependencies

---

## 📦 Installation Methods

### Method 1: From Source (Development)

```bash
# Clone the repository
git clone https://github.com/stElmitchay/loggerheads.git
cd loggerheads

# Install all dependencies
pip3 install -r requirements.txt

# Install in development mode
pip3 install -e .

# Test installation
./test_installation.sh
```

### Method 2: From PyPI (Production)

```bash
# Install from PyPI (when published)
pip3 install loggerheads

# Verify installation
loggerheads --version
```

### Method 3: Direct setup.py

```bash
# Install from setup.py
python3 setup.py install

# Or in development mode
python3 setup.py develop
```

---

## 🧪 Verify Installation

Run the test script to verify everything works:

```bash
./test_installation.sh
```

You should see:
```
✅ All dependencies installed correctly!
✅ All modules working correctly!
✅ Installation test complete!
```

---

## 📦 What Gets Installed

### Core Tracking
- `pygetwindow` - Window monitoring
- `pillow` - Image processing
- `pytesseract` - OCR text extraction
- `pynput` - Keyboard/mouse monitoring

### UI & Display
- `rich` - Beautiful terminal output
- `textual` - Interactive TUI

### Blockchain
- `solana` - Solana RPC client
- `solders` - Solana types and cryptography

### API & Networking
- `flask` - Oracle API server
- `flask-cors` - CORS support
- `flask-limiter` - Rate limiting
- `requests` - HTTP client

### Utilities
- `python-dotenv` - Environment variables
- `opencv-python` - Liveness detection (face recognition)

---

## 🔧 System Requirements

### macOS
```bash
# Install Tesseract OCR
brew install tesseract

# Python 3.8+
python3 --version
```

### Linux
```bash
# Ubuntu/Debian
sudo apt-get install tesseract-ocr python3-tk python3-dev

# Arch
sudo pacman -S tesseract python

# Fedora
sudo dnf install tesseract python3-devel
```

### Python Version
- **Required:** Python 3.8 or higher
- **Recommended:** Python 3.10+

---

## 🚢 Deploy Oracle Service

After installation, deploy the oracle service:

```bash
# Test locally
python3 oracle_service/app.py

# Deploy to Render
# 1. Push to GitHub
# 2. Connect to Render
# 3. Render will use oracle_service/requirements.txt automatically
```

---

## 🐛 Troubleshooting

### "opencv not found"
```bash
pip3 install opencv-python
```

### "tesseract not found"
```bash
# macOS
brew install tesseract

# Linux
sudo apt-get install tesseract-ocr
```

### "Permission denied" on scripts
```bash
chmod +x test_installation.sh
chmod +x deploy_to_pypi.sh
```

### Import errors
```bash
# Reinstall in development mode
pip3 uninstall loggerheads
pip3 install -e .
```

---

## 📚 Next Steps

After installation:

1. **Configure your wallet:**
   ```bash
   loggerheads
   ```

2. **Start tracking:**
   ```bash
   loggerheads start
   ```

3. **Check status:**
   ```bash
   loggerheads status
   ```

4. **Submit hours:**
   ```bash
   loggerheads submit
   ```

---

## 🔄 Updating

### From Source
```bash
git pull
pip3 install -r requirements.txt --upgrade
```

### From PyPI
```bash
pip3 install --upgrade loggerheads
```

---

## 📦 For Package Maintainers

### Build Package
```bash
./deploy_to_pypi.sh
```

### Manual Build
```bash
# Install build tools
pip3 install --upgrade pip setuptools wheel twine

# Clean previous builds
rm -rf build/ dist/ *.egg-info/

# Build
python3 setup.py sdist bdist_wheel

# Check
twine check dist/*

# Upload to TestPyPI (test first!)
twine upload --repository testpypi dist/*

# Upload to PyPI (production)
twine upload dist/*
```

---

## ✅ Installation Complete!

You're ready to track work and earn USDC automatically! 🚀

For more information, see:
- [README.md](README.md) - Main documentation
- [QUICKSTART.md](QUICKSTART_ORACLE.md) - Quick start guide
