# Oracle Setup for Kapture

## What is the Oracle?

The oracle is an **independent service** that verifies work and submits hours to the blockchain. It acts as a neutral third party between employers and employees.

## Initial Setup (One-Time for Deployment)

As the system operator, you need to generate the oracle keypair ONCE:

```bash
python3 -m loggerheads.oracle_secure --generate
```

This creates: `~/.loggerheads/oracle-keypair.json`

**IMPORTANT:**
- Keep this file secure and NEVER commit to git
- This keypair controls work verification for ALL vaults
- Losing this file means you can't verify work for any vault using this oracle

## Get Oracle Public Key

To see the oracle public key (needed for vault creation):

```bash
python3 -m loggerheads.oracle_secure --pubkey
```

Share this public key - it's safe to make public. Employers need it when creating vaults.

## Current Implementation (Devnet Testing)

For devnet testing with your 3 users:

### Setup (You - System Operator)
1. Generate oracle keypair on your machine
2. Note the oracle public key
3. This oracle will verify work for all test vaults

### Vault Creation (Employer)
- Oracle public key is automatically used from the system
- No need to specify manually (uses the oracle you generated)

### Work Submission (Employee)
Currently, submission happens client-side but requires oracle keypair:
- `loggerheads submit` needs access to oracle keypair
- For testing, all 3 users need oracle keypair file

## Migration Path to Production Oracle Service

For production deployment, the oracle should run as an API service:

### Oracle Service (Future)
```
POST /submit-hours
Body: {
  "employee_wallet": "...",
  "admin_wallet": "...",
  "hours": 8,
  "proof": {
    "screenshots": [...],
    "activity_logs": [...],
    "timestamp": "..."
  }
}

Service:
1. Verifies proof is legitimate
2. Signs transaction with oracle keypair
3. Submits to blockchain
4. Returns transaction signature
```

### Employee Flow (Future)
```bash
loggerheads submit
→ Packages work proof
→ Sends to oracle service API
→ Oracle verifies and submits
→ Employee receives confirmation
```

## Security Model

**Current (Devnet Testing):**
- Oracle keypair shared with users for testing
- Not secure, but acceptable for devnet
- Allows testing the full flow

**Production (Future):**
- Oracle keypair stays on secure server
- Never shared with employees or employers
- Only accessible via API with verification
- Can be rate-limited, monitored, audited

## For Your 3 Test Users

All 3 need:
1. The oracle keypair file (you send them `~/.loggerheads/oracle-keypair.json`)
2. They place it at `~/.loggerheads/oracle-keypair.json` on their machines
3. Now they can test vault creation and submissions

This is a temporary setup for testing. Production will use API-based oracle service.
