# Kapture
**Unlock Your Days**

Get paid your full salary upfront, then unlock it daily by proving you worked.

---

## Installation (2 Minutes)

### What You Need
- Python 3.8+
- Git
- Solana CLI - Install: `sh -c "$(curl -sSfL https://release.solana.com/stable/install)"`

### Install Kapture

```bash
git clone https://github.com/stElmitchay/kapture
cd kapture
pip3 install -e .
```

### Run It

```bash
loggerheads
```

That's it! The app will guide you through setup.

---

## For Employers

### Create a Vault (One Time)

```bash
loggerheads
# Choose: Employer
```

Follow the prompts to:
1. Enter employee's wallet address
2. Set total payment amount (e.g., $3000 for one month)
3. Set daily target (e.g., 8 hours)
4. Set daily unlock (e.g., $150 per day)

You'll get your admin wallet address to share with employees.

---

## For Employees

### Setup (One Time)

```bash
loggerheads
# Choose: Employee
```

Enter your employer's wallet address when prompted.

### Daily Use

```bash
loggerheads start
```

Work normally. Press Ctrl+C when done.

Your hours are automatically submitted at 6 PM daily. Payment unlocks if you hit your quota.

### Check Balance

```bash
loggerheads balance
```

### Withdraw

```bash
loggerheads withdraw
```

---

## How It Works

1. **Employer locks payment** (e.g., $3000 USDC) in a blockchain vault
2. **Employee tracks work** throughout the day (screenshots, activity logs)
3. **System submits hours** to blockchain (automatic or manual)
4. **Smart contract unlocks payment** if daily quota met (e.g., 8 hours → $150 unlocked)
5. **Employee withdraws** anytime

Everything is automatic, verified, and trustless.

---

## Commands

```bash
loggerheads              # Start here (first time setup)
loggerheads start        # Track work with live dashboard
loggerheads status       # Check today's hours
loggerheads balance      # See unlocked payments
loggerheads submit       # Submit hours (happens automatically)
loggerheads withdraw     # Get your money
loggerheads config       # View settings
```

---

## Troubleshooting

**"Command not found"**
```bash
python3 -m loggerheads
```

**"Solana not installed"**
```bash
sh -c "$(curl -sSfL https://release.solana.com/stable/install)"
```

**"Screenshot permission denied" (macOS)**
- System Preferences → Security & Privacy → Screen Recording
- Enable Terminal

---

## Support

- Issues: https://github.com/stElmitchay/kapture/issues
- Docs: See `docs/` folder

---

## What Makes This Different?

**Traditional:** Work → Wait → Get paid
**Kapture:** Get paid → Work → Unlock daily

- ✅ Instant access to full salary (locked in vault)
- ✅ Daily unlocks based on actual work
- ✅ Automatic verification (no timesheets)
- ✅ Blockchain-enforced (trustless)
- ✅ Works for remote teams, DAOs, freelancers

---

**That's it! Really.**

No complex setup, no services to run, no blockchain knowledge needed.

Install → Run → Start tracking.
