# Kapture Testing Guide

**Testing with 3 People: 1 Employer + 2 Employees**

This guide walks through a complete real-world test of Kapture with 3 people testing the system together.

---

## Overview

**What we're testing:**
- Employer creates a vault and funds it with USDC
- 2 employees connect to the vault
- Employees track work throughout the day
- System submits hours to blockchain
- Employees unlock and withdraw payments

**Time needed:**
- Setup: 30 minutes (one-time)
- Daily testing: 15 minutes per day

---

## Prerequisites (All 3 People Need This)

### 1. Install Kapture

Everyone runs these commands:

```bash
git clone https://github.com/stElmitchay/loggerheads
cd loggerheads
pip3 install -e .
```

### 2. Install Solana CLI

If you don't have it already:

```bash
sh -c "$(curl -sSfL https://release.solana.com/stable/install)"
```

Add to PATH (add to ~/.bashrc or ~/.zshrc to make permanent):
```bash
export PATH="$HOME/.local/share/solana/install/active_release/bin:$PATH"
```

Verify it worked:
```bash
solana --version
```

### 3. Create Solana Wallet if You don't already have any

Each person creates their own wallet:

```bash
solana-keygen new
```

**IMPORTANT:**
- Write down your seed phrase somewhere safe
- You can skip the passphrase for testing (just press Enter)
- For real money, always use a passphrase

Get your wallet address:
```bash
solana address
```

**Everyone should share their wallet address with the group** (you'll need these later).

### 4. Switch to Devnet (Test Network)

Everyone runs this:

```bash
solana config set --url devnet
```

### 5. Get Free Test SOL

Everyone needs some SOL for transaction fees:

```bash
solana airdrop 2
```

If that fails, try:
```bash
solana airdrop 1
solana airdrop 1
```

Check your balance:
```bash
solana balance
```

You should see ~2 SOL.

### 6. Oracle Service Setup (System Operator Only)

**IMPORTANT: Only ONE person needs to do this** (the system operator, likely you).

The oracle is an independent API service that verifies work. It runs as a server that all testers connect to.

#### Step 1: Install Oracle Dependencies

```bash
cd oracle_service
pip3 install -r requirements.txt
```

#### Step 2: Generate Oracle Keypair

```bash
python3 -m loggerheads.oracle_secure --generate
```

This creates: `~/.loggerheads/oracle-keypair.json`

**IMPORTANT:** Keep this file secure! It controls work verification.

#### Step 3: Start Oracle Service

```bash
python3 oracle_service/app.py
```

You should see:
```
🔮 KAPTURE ORACLE SERVICE
══════════════════════════════════════════════════════════════════════

✅ Oracle Public Key: 7xJ9XxQp...

📡 Starting API server...
   Employers: Use this oracle pubkey when creating vaults
   Employees: Submit hours to this service
```

#### Step 4: Keep Oracle Running

Leave this terminal open. The oracle must stay running for testing.

#### Step 5: Share Oracle URL with Testers

Tell all 3 testers the oracle URL:
- Local testing: `http://localhost:5000`
- Network testing: `http://<your-ip>:5000`

To find your IP:
```bash
# macOS
ipconfig getifaddr en0

# Linux
hostname -I
```

**What is this for?**
- The oracle verifies work hours are legitimate
- It acts as an independent API service
- Employees submit to oracle, oracle submits to blockchain
- This is the proper production architecture

---

## Part 1: Employer Setup (15 minutes)

**Only the employer does this part.**

### Step 1: Get Test USDC

You need USDC to fund the vault. On devnet, you'll need to:

1. Go to https://spl-token-faucet.com (or similar devnet faucet)
2. Enter your wallet address (from `solana address`)
3. Request USDC tokens
4. Wait for confirmation

**Alternative:** Use the Solana Token Program to mint test USDC if you know how. For testing, you need enough USDC to pay your 2 employees.

**Example calculation:**
- 2 employees × $150/day × 20 days = $6,000 USDC total
- For a shorter test: 2 employees × $150/day × 5 days = $1,500 USDC

### Step 2: Run Kapture Setup

```bash
loggerheads
```

**Follow these prompts:**

1. **Are you an employer or employee?** → Choose `Employer`
2. **Create new vault?** → `Yes`
3. **Enter employee wallet address** → Enter Employee 1's address (they gave you this)
4. **Daily target hours** → `8` (or whatever you agree on)
5. **Daily payment in USDC** → `150` (or whatever amount)
6. **Total vault amount** → `3000` (or 20 days × $150 = $3000 for one employee)

The app will create the vault and show you the vault address.

### Step 3: Repeat for Employee 2

You need to create a separate vault for each employee (or use one vault - check with the app).

**If you need separate vaults:**
```bash
loggerheads
```
And repeat the process for Employee 2's wallet address.

### Step 4: Share Information with Employees

Send each employee:
- Your wallet address (employer wallet)
- Their vault details (the app will show you the vault PDA)

---

## Part 2: Employee Setup (5 minutes each)

**Each employee does this independently.**

### Step 1: Run Kapture Setup

```bash
loggerheads
```

**Follow these prompts:**

1. **Are you an employer or employee?** → Choose `Employee`
2. **Enter employer wallet address** → Paste the employer's address
3. **Enter your role/position** → Type something like `UX Engineer` or `Developer`
4. **Enter your industry** → Type something like `Tech` or `Software Development`
5. **Enable auto-submit?** → Choose `Yes` (recommended for testing)
6. **Configure Discord notifications?** → Optional (say `No` for now unless you want to test this)

### Step 2: Verify Connection

Check that you're connected to the vault:

```bash
loggerheads config
```

You should see:
- Employer wallet address
- Your vault information
- Daily target hours
- Daily payment amount

---

## Part 3: Daily Testing Workflow

### Morning: Start Tracking (Employees)

Each employee starts their day:

```bash
loggerheads start
```

**What happens:**
- Kapture starts taking screenshots every few minutes
- OCR extracts text from screenshots
- AI analyzes what you're working on
- Hours are calculated automatically
- A live dashboard shows your progress

**Just work normally on your computer.** Open browsers, code editors, documents, whatever you normally do. The tracker will capture it all.

**To stop tracking:** Press `Ctrl+C`

### During the Day: Check Status (Employees)

Anytime during the day, employees can check their progress:

```bash
loggerheads status
```

This shows:
- Hours worked today
- Current activity
- Progress toward daily target

### End of Day: Submit Hours (Automatic or Manual)

**If you enabled auto-submit:**
Hours are automatically submitted at the end of the day. You don't need to do anything.

**To submit manually:**
```bash
loggerheads submit
```

**What happens:**
1. Your hours are calculated from the database
2. An oracle signs your work hours
3. Transaction is sent to Solana blockchain
4. Smart contract verifies the signature
5. If you hit your quota → That day's payment unlocks
6. If you didn't → Payment is forfeited

### Check Your Earnings (Employees)

See how much you've unlocked:

```bash
loggerheads balance
```

This shows:
- Total USDC unlocked
- Total available to withdraw
- Vault balance remaining

### Withdraw Funds (Employees)

When you want to withdraw your unlocked USDC:

```bash
loggerheads withdraw
```

Follow the prompts to withdraw funds to your wallet.

---

## Part 4: Employer Monitoring

### Check Vault Status

Employer can check the vault anytime:

```bash
loggerheads vault-info
```

This shows:
- Total USDC locked in vault
- Amount paid out so far
- Amount remaining
- Employee activity

### View All Configuration

```bash
loggerheads config
```

---

## What to Test & Verify

### Day 1: Full Quota (Both Employees)
- Both employees work 8+ hours
- Submit hours
- Verify payment unlocks ($150 each)
- Try withdrawing a small amount

**Expected result:** Both employees unlock $150, can withdraw successfully

### Day 2: One Misses Quota
- Employee 1 works 8+ hours
- Employee 2 works only 4 hours
- Submit hours

**Expected result:**
- Employee 1 unlocks $150
- Employee 2 unlocks nothing (payment forfeited)

### Day 3: Partial Work Day
- Both employees work exactly 8 hours
- Submit hours

**Expected result:** Both unlock $150 (meeting minimum)

### Day 4: Test Dashboard
- Employees use `loggerheads start` and watch the live dashboard
- Verify it shows accurate hour counts
- Check that activity is being captured

### Day 5: Test Withdrawal
- Accumulated balance from multiple days
- Withdraw larger amounts
- Verify USDC arrives in wallet

---

## Troubleshooting

### "Insufficient SOL"
You need SOL for transaction fees. Get more:
```bash
solana airdrop 1
```

### "Failed to submit hours"
- Check your internet connection
- Verify you're on devnet: `solana config get`
- Check if vault exists: `loggerheads config`

### "Command not found: loggerheads"
Try:
```bash
python3 -m loggerheads
```

### "Screenshot permission denied" (macOS)
Go to System Preferences → Security & Privacy → Privacy → Screen Recording
Enable Terminal or your terminal app

### "No hours recorded"
- Make sure you ran `loggerheads start`
- Check if screenshots are being saved
- Verify database exists: `ls ~/.loggerheads/`

### Vault Issues
If vault creation fails:
- Ensure you have enough SOL for rent (2 SOL minimum)
- Check you have USDC in your wallet
- Verify network is set to devnet

---

## Testing Checklist

**Employer:**
- [ ] Created wallet
- [ ] Got test SOL
- [ ] Got test USDC
- [ ] Created vault for Employee 1
- [ ] Created vault for Employee 2
- [ ] Funded both vaults
- [ ] Shared wallet address with employees

**Employee 1:**
- [ ] Created wallet
- [ ] Got test SOL
- [ ] Connected to employer's vault
- [ ] Can see vault info in config
- [ ] Tracked work for 8+ hours (Day 1)
- [ ] Submitted hours successfully
- [ ] Payment unlocked
- [ ] Withdrew USDC successfully

**Employee 2:**
- [ ] Created wallet
- [ ] Got test SOL
- [ ] Connected to employer's vault
- [ ] Can see vault info in config
- [ ] Tracked work for 8+ hours (Day 1)
- [ ] Submitted hours successfully
- [ ] Payment unlocked
- [ ] Withdrew USDC successfully

**System Tests:**
- [ ] Auto-submit works (if enabled)
- [ ] Manual submit works
- [ ] Quota enforcement works (miss quota = no payment)
- [ ] Dashboard shows accurate data
- [ ] Blockchain transactions confirmed
- [ ] Withdrawals process correctly
- [ ] Multiple employees can use same employer vault

---

## Expected Timeline

**Day 0 (Setup Day):**
- Everyone installs Kapture: 15 min
- Everyone sets up Solana wallet: 10 min
- Employer gets test USDC: 10 min
- Employer creates vaults: 10 min
- Employees connect: 5 min each
- **Total: ~1 hour for everyone**

**Day 1-5 (Testing Days):**
- Employees work and track: All day
- End of day submission: 2 min
- Check results: 5 min
- **Total: ~10 min overhead per day**

**After 5 Days:**
- Review all data
- Test withdrawals
- Verify blockchain records
- Document any issues

---

## What to Report After Testing

Please document:

**For Employees:**
1. Was setup clear and easy?
2. Did tracking feel intrusive or was it seamless?
3. How accurate were the hour calculations?
4. Did payments unlock as expected?
5. Any bugs or confusing error messages?
6. What would make this better?

**For Employer:**
1. Was vault creation straightforward?
2. Could you monitor employee activity easily?
3. Did the payment automation work correctly?
4. Any concerns about the system?
5. What features are missing?

**Technical Issues:**
1. Any commands that failed?
2. Error messages encountered?
3. Performance issues?
4. Blockchain transaction problems?

---

## Emergency Contacts

If something breaks:
- Check the main README troubleshooting section
- Look at error logs in `~/.loggerheads/`
- Open an issue on GitHub with error details

---

## After Testing

Once testing is complete:

1. **Don't lose your seed phrases** (even for test wallets)
2. **Save your test data** - It might be useful for debugging
3. **Document everything** - What worked, what didn't
4. **Share feedback** - This helps improve the product

**To start fresh:**
```bash
rm -rf ~/.loggerheads/
```

Then run `loggerheads` again to set up from scratch.
