class BriefExtractor:

  MARKDOWN = '''
    # HTML文档解析专家 - 新闻摘要列表提取

    ## 核心任务
    从新闻列表页HTML中精确提取新闻摘要列表，排除所有非文章内容。

    ## 提取要求
    - **只提取**新闻摘要相关内容
    - **彻底排除**：menu/header/footer/sidebar/广告/评论/推荐等
    - **移除所有**HTML标签和样式，只保留纯文本
    - **移除所有**广告条目

    ## 字段规范

    ### 标题 (mat_title)
    新闻标题

    ### 缩略图 (mat_thumb)  
    新闻缩略图链接，如果缺少协议，补全为`https://`，可以为空

    ### 详情链接 (mat_url)
    新闻详情页访问链接，如果缺少协议，补全为`https://`

    ## 输出格式
    **必须使用以下JSON格式：**

    ```json
    [
      {
        "mat_title": "标题",
        "mat_thumb": "缩略图链接", 
        "mat_url": "详情页链接",
      }
    ]
    ```

    ### 待改写原始文档
    （以下为需处理的原始素材）

    '''
