# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: bos/v1/actions.proto, bos/v1/authentication.proto, bos/v1/common.proto, bos/v1/configuration.proto, bos/v1/constraints.proto, bos/v1/cooling.proto, bos/v1/license.proto, bos/v1/miner.proto, bos/v1/network.proto, bos/v1/performance.proto, bos/v1/pool.proto, bos/v1/units.proto, bos/v1/work.proto
# plugin: python-betterproto
# This file has been @generated
import warnings
from dataclasses import dataclass
from datetime import datetime
from typing import TYPE_CHECKING, AsyncIterator, Dict, List, Optional

import betterproto
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


class SaveAction(betterproto.Enum):
    """Save action for different operations"""

    UNSPECIFIED = 0
    SAVE = 1
    SAVE_AND_APPLY = 2
    SAVE_AND_FORCE_APPLY = 3


class CoolingMode(betterproto.Enum):
    UNSPECIFIED = 0
    AUTO = 1
    MANUAL = 2
    DISABLED = 3


class SensorLocation(betterproto.Enum):
    UNSPECIFIED = 0
    CHIP = 1
    PCB = 2


class TunerMode(betterproto.Enum):
    UNSPECIFIED = 0
    POWER_TARGET = 1
    HASHRATE_TARGET = 2


class TunerState(betterproto.Enum):
    UNSPECIFIED = 0
    DISABLED = 1
    STABLE = 2
    TUNING = 3
    ERROR = 4


class LicenseType(betterproto.Enum):
    UNSPECIFIED = 0
    STANDARD = 1
    CUSTOM = 2


class Platform(betterproto.Enum):
    """Supported platforms"""

    UNSPECIFIED = 0
    AM1_S9 = 1
    AM2_S17 = 2
    AM3_BBB = 3
    AM3_AML = 4
    STM32MP157C_II1_AM2 = 5
    CVITEK_BM1_AM2 = 6
    ZYNQ_BM3_AM2 = 7
    STM32MP157C_II2_BMM1 = 8


class BosMode(betterproto.Enum):
    """BOS modes enumeration"""

    UNSPECIFIED = 0
    UPGRADE = 1
    RECOVERY = 2
    SD = 3
    NAND = 4
    EMMC = 5


class MinerBrand(betterproto.Enum):
    UNSPECIFIED = 0
    ANTMINER = 1
    WHATSMINER = 2


class MinerModel(betterproto.Enum):
    """Deprecated: This enumeration is not longer maintained"""

    UNSPECIFIED = 0
    ANTMINER_S9 = 1
    ANTMINER_X17 = 2
    ANTMINER_S17 = 3
    ANTMINER_S17_PLUS = 4
    ANTMINER_S17_PRO = 5
    ANTMINER_S17E = 6
    ANTMINER_T17 = 7
    ANTMINER_T17E = 8
    ANTMINER_T17_PLUS = 9
    ANTMINER_X19 = 10
    ANTMINER_S19 = 11
    ANTMINER_S19_PRO = 12
    ANTMINER_S19_PLUS = 13
    ANTMINER_S19J = 14
    ANTMINER_S19J_PRO = 15
    ANTMINER_S19A = 16
    ANTMINER_S19A_PRO = 17
    ANTMINER_S19XP = 18
    ANTMINER_T19 = 19
    ANTMINER_S19J_PRO_PLUS = 20


class MinerStatus(betterproto.Enum):
    UNSPECIFIED = 0
    NOT_STARTED = 1
    NORMAL = 2
    PAUSED = 3
    SUSPENDED = 4
    RESTRICTED = 5


class SupportArchiveFormat(betterproto.Enum):
    """Enumeration for support archive format"""

    UNSPECIFIED = 0
    ZIP = 1
    """Compressed zip format"""

    BOS = 2
    """BOS custom format"""

    ZIP_ENCRYPTED = 3
    """Compressed encrypted zip format"""


class NetworkProtocol(betterproto.Enum):
    UNSPECIFIED = 0
    DHCP = 1
    STATIC = 2


@dataclass(eq=False, repr=False)
class StartRequest(betterproto.Message):
    """Request for start bosminer action."""

    pass


@dataclass(eq=False, repr=False)
class StartResponse(betterproto.Message):
    """Response for start bosminer action."""

    already_running: bool = betterproto.bool_field(1)
    """Flag that bosminer was already running"""


@dataclass(eq=False, repr=False)
class RestartRequest(betterproto.Message):
    """Request for restart bosminer action."""

    pass


@dataclass(eq=False, repr=False)
class RestartResponse(betterproto.Message):
    """Response for restart bosminer action."""

    already_running: bool = betterproto.bool_field(1)
    """Flag that bosminer was already running"""


@dataclass(eq=False, repr=False)
class RebootRequest(betterproto.Message):
    """Request for reboot bosminer action."""

    pass


@dataclass(eq=False, repr=False)
class RebootResponse(betterproto.Message):
    """Response for reboot bosminer action."""

    pass


@dataclass(eq=False, repr=False)
class StopRequest(betterproto.Message):
    """Request for stop bosminer action."""

    pass


@dataclass(eq=False, repr=False)
class StopResponse(betterproto.Message):
    """Response for stop bosminer action."""

    already_stopped: bool = betterproto.bool_field(1)
    """Flag that bosminer was already stopped"""


@dataclass(eq=False, repr=False)
class PauseMiningRequest(betterproto.Message):
    """Request for pause mining action."""

    pass


@dataclass(eq=False, repr=False)
class PauseMiningResponse(betterproto.Message):
    """Response for pause mining action."""

    already_paused: bool = betterproto.bool_field(1)
    """Flag that miner mining was already paused"""


@dataclass(eq=False, repr=False)
class ResumeMiningRequest(betterproto.Message):
    """Response for resume mining action."""

    pass


@dataclass(eq=False, repr=False)
class ResumeMiningResponse(betterproto.Message):
    """Response for resume mining action."""

    already_mining: bool = betterproto.bool_field(1)
    """Flag that miner was already mining"""


@dataclass(eq=False, repr=False)
class SetLocateDeviceStatusRequest(betterproto.Message):
    """Request message to enable/disable locate device"""

    enable: bool = betterproto.bool_field(1)


@dataclass(eq=False, repr=False)
class LocateDeviceStatusResponse(betterproto.Message):
    """Response with locate device status"""

    enabled: bool = betterproto.bool_field(1)


@dataclass(eq=False, repr=False)
class GetLocateDeviceStatusRequest(betterproto.Message):
    """Request for locate device status action."""

    pass


@dataclass(eq=False, repr=False)
class LoginRequest(betterproto.Message):
    """Request for login action."""

    username: str = betterproto.string_field(1)
    password: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class LoginResponse(betterproto.Message):
    """Response for login action."""

    token: str = betterproto.string_field(1)
    """Token to be used for authentication"""

    timeout_s: int = betterproto.uint32_field(2)
    """
    Authentication token validity/timeout in seconds.
     Token validity refreshed to this value with each request.
    """


@dataclass(eq=False, repr=False)
class SetPasswordRequest(betterproto.Message):
    """Request for set password action."""

    password: Optional[str] = betterproto.string_field(1, optional=True)


@dataclass(eq=False, repr=False)
class SetPasswordResponse(betterproto.Message):
    """Response for set password action."""

    pass


@dataclass(eq=False, repr=False)
class MegaHashrate(betterproto.Message):
    megahash_per_second: float = betterproto.double_field(1)


@dataclass(eq=False, repr=False)
class GigaHashrate(betterproto.Message):
    gigahash_per_second: float = betterproto.double_field(1)


@dataclass(eq=False, repr=False)
class TeraHashrate(betterproto.Message):
    terahash_per_second: float = betterproto.double_field(1)


@dataclass(eq=False, repr=False)
class Frequency(betterproto.Message):
    hertz: float = betterproto.double_field(1)


@dataclass(eq=False, repr=False)
class Voltage(betterproto.Message):
    volt: float = betterproto.double_field(1)


@dataclass(eq=False, repr=False)
class Power(betterproto.Message):
    watt: int = betterproto.uint64_field(1)


@dataclass(eq=False, repr=False)
class PowerEfficiency(betterproto.Message):
    joule_per_terahash: float = betterproto.double_field(1)


@dataclass(eq=False, repr=False)
class Temperature(betterproto.Message):
    degree_c: float = betterproto.double_field(1)


@dataclass(eq=False, repr=False)
class BasesPoints(betterproto.Message):
    """Structure representing Basis Points"""

    bsp: int = betterproto.uint32_field(1)
    """
    A basis point is one hundredth of 1 percentage point.
     For example: 1bps = 0.01%, 250bps = 2.5%
    """


@dataclass(eq=False, repr=False)
class Hours(betterproto.Message):
    hours: int = betterproto.uint32_field(1)


@dataclass(eq=False, repr=False)
class UInt32Constraints(betterproto.Message):
    default: int = betterproto.uint32_field(1)
    min: int = betterproto.uint32_field(2)
    max: int = betterproto.uint32_field(3)


@dataclass(eq=False, repr=False)
class DoubleConstraints(betterproto.Message):
    default: float = betterproto.double_field(1)
    min: float = betterproto.double_field(2)
    max: float = betterproto.double_field(3)


@dataclass(eq=False, repr=False)
class PowerConstraints(betterproto.Message):
    default: "Power" = betterproto.message_field(1)
    min: "Power" = betterproto.message_field(2)
    max: "Power" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class HashrateConstraints(betterproto.Message):
    default: "TeraHashrate" = betterproto.message_field(1)
    min: "TeraHashrate" = betterproto.message_field(2)
    max: "TeraHashrate" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class TemperatureConstraints(betterproto.Message):
    default: "Temperature" = betterproto.message_field(1)
    min: "Temperature" = betterproto.message_field(2)
    max: "Temperature" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class BooleanConstraint(betterproto.Message):
    default: bool = betterproto.bool_field(1)


@dataclass(eq=False, repr=False)
class DurationConstraints(betterproto.Message):
    default: "Hours" = betterproto.message_field(1)
    min: "Hours" = betterproto.message_field(2)
    max: "Hours" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class FrequencyConstraints(betterproto.Message):
    default: "Frequency" = betterproto.message_field(1)
    min: "Frequency" = betterproto.message_field(2)
    max: "Frequency" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class VoltageConstraints(betterproto.Message):
    default: "Voltage" = betterproto.message_field(1)
    min: "Voltage" = betterproto.message_field(2)
    max: "Voltage" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class CoolingAutoMode(betterproto.Message):
    """
    The temperature control modes.
     Miner software tries to regulate the fan speed so that miner temperature is approximately at the target temperature.
     The allowed temperature range is 0-200 degree Celsius.
    """

    target_temperature: "Temperature" = betterproto.message_field(1)
    """Temperature that the miner will try to maintain"""

    hot_temperature: "Temperature" = betterproto.message_field(2)
    """Temperature threshold at which the fans start to run at 100%."""

    dangerous_temperature: "Temperature" = betterproto.message_field(3)
    """
    Temperature threshold at which BOSMiner shuts down in order to prevent overheating and damaging the miner.
    """


@dataclass(eq=False, repr=False)
class CoolingManualMode(betterproto.Message):
    """
    Fans are kept at a fixed, user-defined speed, no matter the temperature.
    """

    fan_speed_ratio: Optional[float] = betterproto.double_field(1, optional=True)
    """
    User defined fan speed expressed as a ratio between 0.0 and 1.0
     where 0.0 means completely turned off and
     1.0 means running at full speed possible
    """

    hot_temperature: "Temperature" = betterproto.message_field(2)
    """Temperature threshold at which the fans start to run at 100%."""

    dangerous_temperature: "Temperature" = betterproto.message_field(3)
    """
    Temperature threshold at which BOSMiner shuts down in order to prevent overheating and damaging the miner.
    """


@dataclass(eq=False, repr=False)
class CoolingDisabledMode(betterproto.Message):
    """Disable temperature control. May be dangerous."""

    fan_speed_ratio: Optional[float] = betterproto.double_field(1, optional=True)
    """
    User defined fan speed expressed as a ratio between 0.0 and 1.0
     where 0.0 means completely turned off and
     1.0 means running at full speed possible
    """


@dataclass(eq=False, repr=False)
class CoolingConfiguration(betterproto.Message):
    minimum_required_fans: Optional[int] = betterproto.uint32_field(1, optional=True)
    auto: "CoolingAutoMode" = betterproto.message_field(2, group="mode")
    manual: "CoolingManualMode" = betterproto.message_field(3, group="mode")
    disabled: "CoolingDisabledMode" = betterproto.message_field(4, group="mode")


@dataclass(eq=False, repr=False)
class CoolingConstraints(betterproto.Message):
    default_cooling_mode: "CoolingMode" = betterproto.enum_field(1)
    target_temperature: "TemperatureConstraints" = betterproto.message_field(2)
    hot_temperature: "TemperatureConstraints" = betterproto.message_field(3)
    dangerous_temperature: "TemperatureConstraints" = betterproto.message_field(4)
    fan_speed_ratio: "DoubleConstraints" = betterproto.message_field(5)
    minimum_required_fans: "UInt32Constraints" = betterproto.message_field(6)


@dataclass(eq=False, repr=False)
class FanState(betterproto.Message):
    """Structure which contain info about one specific miner fan."""

    position: Optional[int] = betterproto.uint32_field(1, optional=True)
    """Fan positions/ID"""

    rpm: int = betterproto.uint32_field(2)
    """Actual fan RPM (Revolutions/Rotation Per Minute)"""

    target_speed_ratio: Optional[float] = betterproto.double_field(3, optional=True)
    """Actual fan speed ratio(PWM) in range 0.0 - 1.0"""


@dataclass(eq=False, repr=False)
class TemperatureSensor(betterproto.Message):
    id: Optional[int] = betterproto.uint32_field(1, optional=True)
    """Sensor id"""

    location: "SensorLocation" = betterproto.enum_field(2)
    """Sensor location"""

    temperature: "Temperature" = betterproto.message_field(3)
    """Temperature"""


@dataclass(eq=False, repr=False)
class GetCoolingStateRequest(betterproto.Message):
    """Request to get current temperature and fans measurements"""

    pass


@dataclass(eq=False, repr=False)
class GetCoolingStateResponse(betterproto.Message):
    """
    Response to get current fan states and
     temperature measurements
    """

    fans: List["FanState"] = betterproto.message_field(1)
    """All Fans state"""

    highest_temperature: "TemperatureSensor" = betterproto.message_field(2)
    """Sensor with current highest temperature"""


@dataclass(eq=False, repr=False)
class SetImmersionModeRequest(betterproto.Message):
    """Request to set immersion mode"""

    save_action: "SaveAction" = betterproto.enum_field(1)
    enable_immersion_mode: bool = betterproto.bool_field(2)
    """Flag to enable or disable immersion mode"""


@dataclass(eq=False, repr=False)
class SetImmersionModeResponse(betterproto.Message):
    """Response for set immersion mode action."""

    immersion_mode: bool = betterproto.bool_field(1)
    """The resulting immersion mode"""


@dataclass(eq=False, repr=False)
class TunerConfiguration(betterproto.Message):
    enabled: Optional[bool] = betterproto.bool_field(1, optional=True)
    """Flag if tuner is enabled"""

    tuner_mode: Optional["TunerMode"] = betterproto.enum_field(2, optional=True)
    """Tuner mode"""

    power_target: "Power" = betterproto.message_field(3)
    """Tuner power target"""

    hashrate_target: "TeraHashrate" = betterproto.message_field(4)
    """Tuner hashrate target"""


@dataclass(eq=False, repr=False)
class TunerConstraints(betterproto.Message):
    power_target: "PowerConstraints" = betterproto.message_field(1)
    """Tuner power target mode constraints"""

    hashrate_target: "HashrateConstraints" = betterproto.message_field(2)
    """Tuner hashrate target mode constraints"""

    enabled: "BooleanConstraint" = betterproto.message_field(3)
    """Tuner enabled enabled default value"""

    default_mode: "TunerMode" = betterproto.enum_field(4)
    """Default tuner mode"""


@dataclass(eq=False, repr=False)
class DpsConfiguration(betterproto.Message):
    enabled: Optional[bool] = betterproto.bool_field(1, optional=True)
    """Flag if Dynamic Performance Scaling is enabled"""

    power_step: "Power" = betterproto.message_field(2)
    """Dynamic Performance Scaling power step"""

    hashrate_step: "TeraHashrate" = betterproto.message_field(3)
    """Dynamic Performance Scaling hashrate step"""

    min_power_target: "Power" = betterproto.message_field(4)
    """Dynamic Performance Scaling minimal power target"""

    min_hashrate_target: "TeraHashrate" = betterproto.message_field(5)
    """Dynamic Performance Scaling minimal hashrate target"""

    shutdown_enabled: Optional[bool] = betterproto.bool_field(6, optional=True)
    """Flag if shutdown for Dynamic Performance Scaling is enabled"""

    shutdown_duration: "Hours" = betterproto.message_field(7)
    """Dynamic Performance Scaling shutdown duration"""


@dataclass(eq=False, repr=False)
class HashboardPerformanceConfiguration(betterproto.Message):
    global_frequency: "Frequency" = betterproto.message_field(1)
    """Common frequency for all HB"""

    global_voltage: "Voltage" = betterproto.message_field(2)
    """Common voltage for all HB"""

    hashboards: List["HashboardConfig"] = betterproto.message_field(3)
    """
    Per hashboard frequency/voltage. It has higher priority than global one
    """


@dataclass(eq=False, repr=False)
class DpsConstraints(betterproto.Message):
    power_step: "PowerConstraints" = betterproto.message_field(1)
    """Dynamic Performance Scaling power step constraints"""

    hashrate_step: "HashrateConstraints" = betterproto.message_field(2)
    """Dynamic Performance Scaling hashrate step constraints"""

    min_power_target: "PowerConstraints" = betterproto.message_field(3)
    """Dynamic Performance Scaling minimal power target constraints"""

    min_hashrate_target: "HashrateConstraints" = betterproto.message_field(4)
    """Dynamic Performance Scaling minimal hashrate target constraints"""

    shutdown_enabled: "BooleanConstraint" = betterproto.message_field(5)
    """Dynamic Performance Scaling enabled shutdown default value"""

    shutdown_duration: "DurationConstraints" = betterproto.message_field(6)
    """Dynamic Performance Scaling shutdown duration constraints"""

    enabled: "BooleanConstraint" = betterproto.message_field(7)
    """Dynamic Performance Scaling enabled default value"""


@dataclass(eq=False, repr=False)
class HashboardConstraints(betterproto.Message):
    hashboard_ids: List[str] = betterproto.string_field(1)
    """List of possible HB indices"""

    enabled: "BooleanConstraint" = betterproto.message_field(2)
    """Default value for flag if hashboards are enabled"""

    frequency: "FrequencyConstraints" = betterproto.message_field(3)
    """HB frequency constraints"""

    voltage: "VoltageConstraints" = betterproto.message_field(4)
    """HB frequency constraints"""


@dataclass(eq=False, repr=False)
class PowerTargetProfile(betterproto.Message):
    """Structure to handle power target profile"""

    created: datetime = betterproto.message_field(1)
    """Creation timestamp"""

    target: "Power" = betterproto.message_field(2)
    """Tuned power target"""

    measured_hashrate: "GigaHashrate" = betterproto.message_field(3)
    """Measured hashrate"""

    estimated_power_consumption: "Power" = betterproto.message_field(4)
    """Estimated power consumption"""


@dataclass(eq=False, repr=False)
class HashrateTargetProfile(betterproto.Message):
    """Structure to handle hashrate target profile"""

    created: datetime = betterproto.message_field(1)
    """Creation timestamp"""

    target: "TeraHashrate" = betterproto.message_field(2)
    """Tuned hashrate target"""

    measured_hashrate: "GigaHashrate" = betterproto.message_field(3)
    """Measured hashrate"""

    estimated_power_consumption: "Power" = betterproto.message_field(4)
    """Estimated power consumption"""


@dataclass(eq=False, repr=False)
class GetTunerStateRequest(betterproto.Message):
    """Request for getting the current performance data"""

    pass


@dataclass(eq=False, repr=False)
class GetTunerStateResponse(betterproto.Message):
    """Response with the current tuner details"""

    overall_tuner_state: "TunerState" = betterproto.enum_field(1)
    """Tuner state"""

    power_target_mode_state: "PowerTargetModeState" = betterproto.message_field(
        2, group="mode_state"
    )
    hashrate_target_mode_state: "HashrateTargetModeState" = betterproto.message_field(
        3, group="mode_state"
    )


@dataclass(eq=False, repr=False)
class PowerTargetModeState(betterproto.Message):
    profile: "PowerTargetProfile" = betterproto.message_field(1)
    """current power target profile"""

    current_target: "Power" = betterproto.message_field(2)
    """Current power target"""


@dataclass(eq=False, repr=False)
class HashrateTargetModeState(betterproto.Message):
    profile: "HashrateTargetProfile" = betterproto.message_field(1)
    """Currently used profile"""

    current_target: "TeraHashrate" = betterproto.message_field(2)
    """Current hashrate target"""


@dataclass(eq=False, repr=False)
class ListTargetProfilesRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class ListTargetProfilesResponse(betterproto.Message):
    power_target_profiles: List["PowerTargetProfile"] = betterproto.message_field(1)
    """Tuner profiles for power target mode"""

    hashrate_target_profiles: List["HashrateTargetProfile"] = betterproto.message_field(
        2
    )


@dataclass(eq=False, repr=False)
class SetDefaultPowerTargetRequest(betterproto.Message):
    """Request for set default power target action."""

    save_action: "SaveAction" = betterproto.enum_field(1)
    """Save action"""


@dataclass(eq=False, repr=False)
class SetPowerTargetRequest(betterproto.Message):
    """Request for set absolute power target action."""

    save_action: "SaveAction" = betterproto.enum_field(1)
    """Save action"""

    power_target: "Power" = betterproto.message_field(2)
    """Absolute value of power target"""


@dataclass(eq=False, repr=False)
class IncrementPowerTargetRequest(betterproto.Message):
    """Request for increment power target action."""

    save_action: "SaveAction" = betterproto.enum_field(1)
    """Save action"""

    power_target_increment: "Power" = betterproto.message_field(2)
    """Incremental value of power target"""


@dataclass(eq=False, repr=False)
class DecrementPowerTargetRequest(betterproto.Message):
    """Request for decrement power target action."""

    save_action: "SaveAction" = betterproto.enum_field(1)
    """Save action"""

    power_target_decrement: "Power" = betterproto.message_field(2)
    """Decremental value of power target"""


@dataclass(eq=False, repr=False)
class SetPowerTargetResponse(betterproto.Message):
    """Response for set power target action."""

    power_target: "Power" = betterproto.message_field(1)
    """New value of power target"""


@dataclass(eq=False, repr=False)
class SetDefaultHashrateTargetRequest(betterproto.Message):
    """Request for set default hashrate target action."""

    save_action: "SaveAction" = betterproto.enum_field(1)
    """Save action"""


@dataclass(eq=False, repr=False)
class SetHashrateTargetRequest(betterproto.Message):
    """Request for set absolute hashrate target action."""

    save_action: "SaveAction" = betterproto.enum_field(1)
    """Save action"""

    hashrate_target: "TeraHashrate" = betterproto.message_field(2)
    """Absolute value of hashrate target"""


@dataclass(eq=False, repr=False)
class IncrementHashrateTargetRequest(betterproto.Message):
    """Request for increment hashrate target action."""

    save_action: "SaveAction" = betterproto.enum_field(1)
    """Save action"""

    hashrate_target_increment: "TeraHashrate" = betterproto.message_field(2)
    """Incremental value of hashrate target"""


@dataclass(eq=False, repr=False)
class DecrementHashrateTargetRequest(betterproto.Message):
    """Request for decrement hashrate target action."""

    save_action: "SaveAction" = betterproto.enum_field(1)
    """Save action"""

    hashrate_target_decrement: "TeraHashrate" = betterproto.message_field(2)
    """Decremental value of hashrate target"""


@dataclass(eq=False, repr=False)
class SetHashrateTargetResponse(betterproto.Message):
    """Response for set hashrate target action."""

    hashrate_target: "TeraHashrate" = betterproto.message_field(1)
    """New value of hashrate target"""


@dataclass(eq=False, repr=False)
class DpsPowerTarget(betterproto.Message):
    power_step: "Power" = betterproto.message_field(1)
    """Dynamic Performance Scaling power step"""

    min_power_target: "Power" = betterproto.message_field(2)
    """Dynamic Performance Scaling minimal power target"""


@dataclass(eq=False, repr=False)
class DpsHashrateTarget(betterproto.Message):
    hashrate_step: "TeraHashrate" = betterproto.message_field(1)
    """Dynamic Performance Scaling hashrate step"""

    min_hashrate_target: "TeraHashrate" = betterproto.message_field(2)
    """Dynamic Performance Scaling minimal hashrate target"""


@dataclass(eq=False, repr=False)
class DpsTarget(betterproto.Message):
    power_target: "DpsPowerTarget" = betterproto.message_field(1, group="target")
    """Power target settings for Dynamic Performance Scaling"""

    hashrate_target: "DpsHashrateTarget" = betterproto.message_field(2, group="target")
    """Hashrate target settings for Dynamic Performance Scaling"""


@dataclass(eq=False, repr=False)
class SetDpsRequest(betterproto.Message):
    save_action: "SaveAction" = betterproto.enum_field(1)
    """Save action"""

    enable: Optional[bool] = betterproto.bool_field(2, optional=True)
    """Flag if Dynamic Performance Scaling should be enabled"""

    enable_shutdown: Optional[bool] = betterproto.bool_field(3, optional=True)
    """Flag if shutdown for Dynamic Performance Scaling should be enabled"""

    shutdown_duration: Optional["Hours"] = betterproto.message_field(4, optional=True)
    """Dynamic Performance Scaling shutdown duration"""

    target: "DpsTarget" = betterproto.message_field(5)
    """Dynamic Performance Scaling target"""


@dataclass(eq=False, repr=False)
class SetDpsResponse(betterproto.Message):
    enabled: Optional[bool] = betterproto.bool_field(1, optional=True)
    """Flag if Dynamic Performance Scaling is enabled"""

    shutdown_enabled: Optional[bool] = betterproto.bool_field(2, optional=True)
    """Flag if shutdown for Dynamic Performance Scaling should be enabled"""

    shutdown_duration: Optional["Hours"] = betterproto.message_field(3, optional=True)
    """Dynamic Performance Scaling shutdown duration"""

    power_target: "DpsPowerTarget" = betterproto.message_field(4)
    """Dynamic Performance Scaling Power target"""

    hashrate_target: "DpsHashrateTarget" = betterproto.message_field(5)
    """Dynamic Performance Scaling hashrate target"""


@dataclass(eq=False, repr=False)
class HashboardPerformanceSettings(betterproto.Message):
    id: str = betterproto.string_field(1)
    """Hashboard id"""

    frequency: "Frequency" = betterproto.message_field(2)
    """Hashboard frequency"""

    voltage: "Voltage" = betterproto.message_field(3)
    """Hashboard voltage"""


@dataclass(eq=False, repr=False)
class HashboardConfig(betterproto.Message):
    id: str = betterproto.string_field(1)
    """Hashboard id"""

    enabled: Optional[bool] = betterproto.bool_field(2, optional=True)
    """Flag if HB si enabled"""

    frequency: "Frequency" = betterproto.message_field(3)
    """Hashboard frequency"""

    voltage: "Voltage" = betterproto.message_field(4)
    """Hashboard voltage"""


@dataclass(eq=False, repr=False)
class ManualPerformanceMode(betterproto.Message):
    global_frequency: "Frequency" = betterproto.message_field(1)
    """Global hashboard frequency"""

    global_voltage: "Voltage" = betterproto.message_field(2)
    """Global hashboard voltage"""

    hashboards: List["HashboardPerformanceSettings"] = betterproto.message_field(3)
    """
    Per hashboard frequency/voltage. It has higher priority than global one
    """


@dataclass(eq=False, repr=False)
class PowerTargetMode(betterproto.Message):
    power_target: "Power" = betterproto.message_field(1)
    """Power target"""


@dataclass(eq=False, repr=False)
class HashrateTargetMode(betterproto.Message):
    hashrate_target: "TeraHashrate" = betterproto.message_field(1)
    """Hashrate target"""


@dataclass(eq=False, repr=False)
class TunerPerformanceMode(betterproto.Message):
    power_target: "PowerTargetMode" = betterproto.message_field(1, group="target")
    """Tuner power target"""

    hashrate_target: "HashrateTargetMode" = betterproto.message_field(2, group="target")
    """Tuner hashrate target"""


@dataclass(eq=False, repr=False)
class SetPerformanceModeRequest(betterproto.Message):
    save_action: "SaveAction" = betterproto.enum_field(1)
    """Save action"""

    mode: "PerformanceMode" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class PerformanceMode(betterproto.Message):
    manual_mode: "ManualPerformanceMode" = betterproto.message_field(1, group="mode")
    tuner_mode: "TunerPerformanceMode" = betterproto.message_field(2, group="mode")


@dataclass(eq=False, repr=False)
class GetPerformanceModeRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class RemoveTunedProfilesRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class RemoveTunedProfilesResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class Quota(betterproto.Message):
    """Structure for quota load balance strategy"""

    value: int = betterproto.uint32_field(1)


@dataclass(eq=False, repr=False)
class FixedShareRatio(betterproto.Message):
    """
    Structure for fixed share ratio load balance strategy
     Fixed share ratio is value between 0.0 to 1.0 where 1.0 represents that all work is
     generated from the group
    """

    value: float = betterproto.double_field(1)


@dataclass(eq=False, repr=False)
class PoolGroupConfiguration(betterproto.Message):
    """Structure handle configured mining group"""

    uid: str = betterproto.string_field(1)
    """Group id"""

    name: str = betterproto.string_field(2)
    """Group name"""

    quota: "Quota" = betterproto.message_field(3, group="load_balance_strategy")
    fixed_share_ratio: "FixedShareRatio" = betterproto.message_field(
        4, group="load_balance_strategy"
    )
    pools: List["PoolConfiguration"] = betterproto.message_field(5)
    """Group pools"""


@dataclass(eq=False, repr=False)
class PoolConfiguration(betterproto.Message):
    """Structure handle information about configured pool"""

    uid: str = betterproto.string_field(1)
    """Pool connection id"""

    url: str = betterproto.string_field(2)
    """Pool connection URL"""

    user: str = betterproto.string_field(3)
    """Pool connection user"""

    password: Optional[str] = betterproto.string_field(4, optional=True)
    """Pool connection password if set"""

    enabled: Optional[bool] = betterproto.bool_field(5, optional=True)
    """Flag if pool connection is enabled"""


@dataclass(eq=False, repr=False)
class PoolGroup(betterproto.Message):
    """Structure handle all pool group details"""

    name: str = betterproto.string_field(1)
    """Group name"""

    quota: "Quota" = betterproto.message_field(2, group="strategy")
    fixed_share_ratio: "FixedShareRatio" = betterproto.message_field(
        3, group="strategy"
    )
    pools: List["Pool"] = betterproto.message_field(4)
    """Group pools"""


@dataclass(eq=False, repr=False)
class Pool(betterproto.Message):
    """Structure handle information about configured pool"""

    uid: str = betterproto.string_field(1)
    """Pool connection id"""

    url: str = betterproto.string_field(2)
    """Pool connection URL"""

    user: str = betterproto.string_field(3)
    """Pool connection user"""

    enabled: bool = betterproto.bool_field(4)
    """Flag if pool connection is enabled"""

    alive: bool = betterproto.bool_field(5)
    """Flag if pool is alive"""

    active: bool = betterproto.bool_field(6)
    """Flag if pool is active (running)"""

    stats: "PoolStats" = betterproto.message_field(7)
    """Pool stats"""


@dataclass(eq=False, repr=False)
class PoolStats(betterproto.Message):
    """Structure handle pool statistics"""

    accepted_shares: int = betterproto.uint64_field(1)
    """Accepted shares"""

    rejected_shares: int = betterproto.uint64_field(2)
    """Rejected shares"""

    stale_shares: int = betterproto.uint64_field(3)
    """Stale shares"""

    last_difficulty: int = betterproto.uint64_field(4)
    """Last difficulty"""

    best_share: int = betterproto.uint64_field(5)
    """Best share"""

    generated_work: int = betterproto.uint64_field(6)
    """Generated work"""

    last_share_time: Optional[datetime] = betterproto.message_field(7, optional=True)
    """Last share time"""


@dataclass(eq=False, repr=False)
class GetPoolGroupsRequest(betterproto.Message):
    """Request to get pool groups data"""

    pass


@dataclass(eq=False, repr=False)
class GetPoolGroupsResponse(betterproto.Message):
    """Response on getting pool group data"""

    pool_groups: List["PoolGroup"] = betterproto.message_field(1)
    """All pool groups details"""


@dataclass(eq=False, repr=False)
class CreatePoolGroupRequest(betterproto.Message):
    """
    Request for pool group create action
     group.uid must not be specified (it will be generated)
     group.pools[].uid must not be specified (it will be generated)
    """

    save_action: "SaveAction" = betterproto.enum_field(1)
    """Save action"""

    group: "PoolGroupConfiguration" = betterproto.message_field(2)
    """Group configuration"""


@dataclass(eq=False, repr=False)
class CreatePoolGroupResponse(betterproto.Message):
    """Response for pool group create action"""

    group: "PoolGroupConfiguration" = betterproto.message_field(1)
    """Group configuration"""


@dataclass(eq=False, repr=False)
class UpdatePoolGroupRequest(betterproto.Message):
    """
    Request for pool group update action
     group.uid must be specified and represents unique id of group which will be updated
     group.pools[].uid must not be specified (it will be generated)
    """

    save_action: "SaveAction" = betterproto.enum_field(1)
    """Save action"""

    group: "PoolGroupConfiguration" = betterproto.message_field(2)
    """New group configuration"""


@dataclass(eq=False, repr=False)
class UpdatePoolGroupResponse(betterproto.Message):
    """Response for pool group update action"""

    group: "PoolGroupConfiguration" = betterproto.message_field(1)
    """Group configuration"""


@dataclass(eq=False, repr=False)
class RemovePoolGroupRequest(betterproto.Message):
    """Request for pool group remove action"""

    save_action: "SaveAction" = betterproto.enum_field(1)
    """Save action"""

    uid: str = betterproto.string_field(2)
    """Group id"""


@dataclass(eq=False, repr=False)
class RemovePoolGroupResponse(betterproto.Message):
    """Response for pool group remove action"""

    pass


@dataclass(eq=False, repr=False)
class SetPoolGroupsRequest(betterproto.Message):
    """Request for setting pool groups"""

    save_action: "SaveAction" = betterproto.enum_field(1)
    """
    Save action
     SAVE just update config but changes will not be applied
     SAVE_AND_APPLY and SAVE_AND_FORCE_APPLY are equal for this method. Pools config will be updated and changes will be applied that will trigger restart.
    """

    pool_groups: List["PoolGroupConfiguration"] = betterproto.message_field(2)
    """
    Pool groups configuration
     `uid` must not be specified (it will be generated)
    """


@dataclass(eq=False, repr=False)
class SetPoolGroupsResponse(betterproto.Message):
    """Response on setting pool groups"""

    pool_groups: List["PoolGroupConfiguration"] = betterproto.message_field(1)
    """Configured pool groups"""


@dataclass(eq=False, repr=False)
class GetMinerConfigurationRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetMinerConfigurationResponse(betterproto.Message):
    """Structure to return miner configuration"""

    pool_groups: List["PoolGroupConfiguration"] = betterproto.message_field(1)
    """Pool groups configuration"""

    temperature: "CoolingConfiguration" = betterproto.message_field(2)
    """Cooling configuration"""

    tuner: "TunerConfiguration" = betterproto.message_field(3)
    """Tuner configuration"""

    dps: "DpsConfiguration" = betterproto.message_field(4)
    """DPS configuration"""

    hashboard_config: "HashboardPerformanceConfiguration" = betterproto.message_field(5)
    """Hashchain configuration"""


@dataclass(eq=False, repr=False)
class GetConstraintsRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetConstraintsResponse(betterproto.Message):
    tuner_constraints: "TunerConstraints" = betterproto.message_field(1)
    """Tuner constraints"""

    cooling_constraints: "CoolingConstraints" = betterproto.message_field(2)
    """Cooling constraints"""

    dps_constraints: "DpsConstraints" = betterproto.message_field(3)
    """Dynamic Performance scaling constraints"""

    hashboards_constraints: "HashboardConstraints" = betterproto.message_field(4)
    """Hashboard constraints"""


@dataclass(eq=False, repr=False)
class NoneLicense(betterproto.Message):
    time_to_restricted: int = betterproto.uint32_field(1)
    """
    BOS Initialization timeout - number of seconds elapsed since bosminer start
     i.e., number of seconds BOS will start mining in restricted mode burning 5% of hashrate
     For more, see Section 3.10 of https://braiins.com/os/plus/license
    """


@dataclass(eq=False, repr=False)
class LimitedLicense(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class ValidLicense(betterproto.Message):
    type: "LicenseType" = betterproto.enum_field(1)
    """License type"""

    contract_name: str = betterproto.string_field(2)
    """Contract name"""

    time_to_restricted: int = betterproto.uint32_field(3)
    """
    Current license expiration - number of seconds since the moment the license was received
     i.e., number of seconds BOS will start mining in restricted mode burning 15% of hashrate
    """

    dev_fee: "BasesPoints" = betterproto.message_field(4)
    """Defines how much DevFee should be generated by the device."""


@dataclass(eq=False, repr=False)
class ExpiredLicense(betterproto.Message):
    type: "LicenseType" = betterproto.enum_field(1)
    """License type"""

    contract_name: str = betterproto.string_field(2)
    """Contract name"""

    dev_fee: "BasesPoints" = betterproto.message_field(3)
    """Defines how much DevFee should be generated by the device."""


@dataclass(eq=False, repr=False)
class GetLicenseStateRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetLicenseStateResponse(betterproto.Message):
    none: "NoneLicense" = betterproto.message_field(1, group="state")
    limited: "LimitedLicense" = betterproto.message_field(2, group="state")
    valid: "ValidLicense" = betterproto.message_field(3, group="state")
    expired: "ExpiredLicense" = betterproto.message_field(4, group="state")


@dataclass(eq=False, repr=False)
class RealHashrate(betterproto.Message):
    """Structure which contains HB real hashrate stats."""

    last_5_s: "GigaHashrate" = betterproto.message_field(1)
    last_15_s: "GigaHashrate" = betterproto.message_field(2)
    last_30_s: "GigaHashrate" = betterproto.message_field(3)
    last_1_m: "GigaHashrate" = betterproto.message_field(4)
    last_5_m: "GigaHashrate" = betterproto.message_field(5)
    last_15_m: "GigaHashrate" = betterproto.message_field(6)
    last_30_m: "GigaHashrate" = betterproto.message_field(7)
    last_1_h: "GigaHashrate" = betterproto.message_field(8)
    last_24_h: "GigaHashrate" = betterproto.message_field(9)
    since_restart: "GigaHashrate" = betterproto.message_field(10)


@dataclass(eq=False, repr=False)
class WorkSolverStats(betterproto.Message):
    """Structure to handle HB state"""

    real_hashrate: "RealHashrate" = betterproto.message_field(1)
    """Real hashrate"""

    nominal_hashrate: "GigaHashrate" = betterproto.message_field(2)
    """Nominal hashrate"""

    error_hashrate: "MegaHashrate" = betterproto.message_field(3)
    """Error hashrate"""

    found_blocks: int = betterproto.uint32_field(4)
    """Found blocks"""

    best_share: int = betterproto.uint64_field(5)
    """Best share"""


@dataclass(eq=False, repr=False)
class MinerIdentity(betterproto.Message):
    brand: "MinerBrand" = betterproto.enum_field(1)
    model: "MinerModel" = betterproto.enum_field(2)
    """
    Deprecated: Use miner_model instead.
     This field is no longer supported.
    """

    name: str = betterproto.string_field(3)
    miner_model: str = betterproto.string_field(4)

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("model"):
            warnings.warn("MinerIdentity.model is deprecated", DeprecationWarning)


@dataclass(eq=False, repr=False)
class BosVersion(betterproto.Message):
    """Structure to handle BOS version"""

    current: str = betterproto.string_field(1)
    major: str = betterproto.string_field(2)
    bos_plus: bool = betterproto.bool_field(3)


@dataclass(eq=False, repr=False)
class ErrorCode(betterproto.Message):
    code: str = betterproto.string_field(1)
    reason: str = betterproto.string_field(2)
    hint: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class Component(betterproto.Message):
    name: str = betterproto.string_field(1)
    index: int = betterproto.uint32_field(2)


@dataclass(eq=False, repr=False)
class MinerError(betterproto.Message):
    timestamp: str = betterproto.string_field(1)
    message: str = betterproto.string_field(2)
    error_codes: List["ErrorCode"] = betterproto.message_field(3)
    components: List["Component"] = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class GetMinerStatusRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetMinerStatusResponse(betterproto.Message):
    status: "MinerStatus" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class GetMinerDetailsRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetMinerDetailsResponse(betterproto.Message):
    """Structure to handle system details"""

    uid: str = betterproto.string_field(1)
    """Miner ID"""

    miner_identity: "MinerIdentity" = betterproto.message_field(2)
    """Miner identity"""

    platform: "Platform" = betterproto.enum_field(3)
    """Miner platform"""

    bos_mode: "BosMode" = betterproto.enum_field(4)
    """BOS Mode"""

    bos_version: "BosVersion" = betterproto.message_field(5)
    """OS Version"""

    hostname: str = betterproto.string_field(6)
    """Hostname"""

    mac_address: str = betterproto.string_field(7)
    """MAC address"""

    system_uptime: int = betterproto.uint64_field(8)
    """Deprecated: Use system_uptime_s"""

    sticker_hashrate: "GigaHashrate" = betterproto.message_field(9)
    """Miner hashrate declared by manufacturer"""

    bosminer_uptime_s: int = betterproto.uint64_field(10)
    """Bosminer uptime. `0` means bosminer is not running"""

    system_uptime_s: int = betterproto.uint64_field(11)
    """System uptime"""

    status: "MinerStatus" = betterproto.enum_field(12)
    """Miner status"""

    kernel_version: str = betterproto.string_field(13)
    """Kernel version"""

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("system_uptime"):
            warnings.warn(
                "GetMinerDetailsResponse.system_uptime is deprecated",
                DeprecationWarning,
            )


@dataclass(eq=False, repr=False)
class MinerPowerStats(betterproto.Message):
    approximated_consumption: "Power" = betterproto.message_field(1)
    """Miner approximated power consumption."""

    efficiency: "PowerEfficiency" = betterproto.message_field(2)
    """Miner power efficiency"""


@dataclass(eq=False, repr=False)
class GetMinerStatsRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetMinerStatsResponse(betterproto.Message):
    pool_stats: "PoolStats" = betterproto.message_field(1)
    """Aggregate pool statistic"""

    miner_stats: "WorkSolverStats" = betterproto.message_field(2)
    """Miner hashrate statistics"""

    power_stats: "MinerPowerStats" = betterproto.message_field(3)
    """Miner power stats"""


@dataclass(eq=False, repr=False)
class GetErrorsRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetErrorsResponse(betterproto.Message):
    errors: List["MinerError"] = betterproto.message_field(1)
    """Array of errors"""


@dataclass(eq=False, repr=False)
class Hashboard(betterproto.Message):
    """Structure to handle HB details"""

    id: str = betterproto.string_field(1)
    """Hashboard ID"""

    enabled: bool = betterproto.bool_field(2)
    """Flag if HB is enabled"""

    chips_count: Optional[int] = betterproto.message_field(
        3, wraps=betterproto.TYPE_UINT32
    )
    """Number of chips"""

    current_voltage: "Voltage" = betterproto.message_field(4)
    """Current HB voltage in volts"""

    current_frequency: "Frequency" = betterproto.message_field(5)
    """Current HB frequency in Hz"""

    highest_chip_temp: "TemperatureSensor" = betterproto.message_field(6)
    """Highest chip temperature"""

    board_temp: "Temperature" = betterproto.message_field(7)
    """Board temperature"""

    stats: "WorkSolverStats" = betterproto.message_field(8)
    """Hashboard stats"""

    model: Optional[str] = betterproto.string_field(9, optional=True)
    """Hashboard model"""


@dataclass(eq=False, repr=False)
class GetSupportArchiveRequest(betterproto.Message):
    format: "SupportArchiveFormat" = betterproto.enum_field(1)
    """Support archive format."""


@dataclass(eq=False, repr=False)
class GetSupportArchiveResponse(betterproto.Message):
    chunk_data: bytes = betterproto.bytes_field(1)
    """Support archive data"""


@dataclass(eq=False, repr=False)
class GetHashboardsRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetHashboardsResponse(betterproto.Message):
    hashboards: List["Hashboard"] = betterproto.message_field(1)
    """All HB details"""


@dataclass(eq=False, repr=False)
class EnableHashboardsRequest(betterproto.Message):
    save_action: "SaveAction" = betterproto.enum_field(1)
    """Save action"""

    hashboard_ids: List[str] = betterproto.string_field(2)
    """IDs of HB that should be enabled"""


@dataclass(eq=False, repr=False)
class EnableHashboardsResponse(betterproto.Message):
    hashboards: List["HashboardEnableState"] = betterproto.message_field(1)
    """Hashboards enable state"""


@dataclass(eq=False, repr=False)
class DisableHashboardsRequest(betterproto.Message):
    save_action: "SaveAction" = betterproto.enum_field(1)
    """Save action"""

    hashboard_ids: List[str] = betterproto.string_field(2)
    """IDs of HB that should be disabled"""


@dataclass(eq=False, repr=False)
class DisableHashboardsResponse(betterproto.Message):
    hashboards: List["HashboardEnableState"] = betterproto.message_field(1)
    """Hashboards disable state"""


@dataclass(eq=False, repr=False)
class HashboardEnableState(betterproto.Message):
    id: str = betterproto.string_field(1)
    """Hashboard ID"""

    is_enabled: bool = betterproto.bool_field(2)
    """Flag if hashboard is enabled or not"""


@dataclass(eq=False, repr=False)
class GetNetworkConfigurationRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetNetworkConfigurationResponse(betterproto.Message):
    network: "NetworkConfiguration" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class SetNetworkConfigurationRequest(betterproto.Message):
    dhcp: "Dhcp" = betterproto.message_field(1, group="protocol")
    static: "Static" = betterproto.message_field(2, group="protocol")
    hostname: Optional[str] = betterproto.string_field(3, optional=True)
    """Hostname. Existing value will be preserved if this field is not set."""


@dataclass(eq=False, repr=False)
class SetNetworkConfigurationResponse(betterproto.Message):
    network: "NetworkConfiguration" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class NetworkConfiguration(betterproto.Message):
    dhcp: "Dhcp" = betterproto.message_field(1, group="protocol")
    static: "Static" = betterproto.message_field(2, group="protocol")
    hostname: str = betterproto.string_field(3)
    """Hostname"""


@dataclass(eq=False, repr=False)
class Dhcp(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class Static(betterproto.Message):
    address: str = betterproto.string_field(1)
    """IP address"""

    netmask: str = betterproto.string_field(2)
    """Netmask"""

    gateway: str = betterproto.string_field(3)
    """Gateway"""

    dns_servers: List[str] = betterproto.string_field(4)
    """DNS servers"""


@dataclass(eq=False, repr=False)
class GetNetworkInfoRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetNetworkInfoResponse(betterproto.Message):
    """
    Response message for GetCurrentNetworkConfiguration
     Represents the current network configuration for the default network interface.
     Only IPv4 is supported.
    """

    name: str = betterproto.string_field(1)
    """Name of the network interface"""

    mac_address: Optional[str] = betterproto.string_field(2, optional=True)
    """MAC address of the network interface"""

    hostname: Optional[str] = betterproto.string_field(3, optional=True)
    """Miner hostname"""

    protocol: Optional["NetworkProtocol"] = betterproto.enum_field(4, optional=True)
    """Network protocol"""

    dns_servers: List[str] = betterproto.string_field(5)
    """List of configured DNS servers"""

    networks: List["IpNetwork"] = betterproto.message_field(6)
    """List of assigned IP addresses"""

    default_gateway: Optional[str] = betterproto.string_field(7, optional=True)
    """Default gateway/route for the interface"""


@dataclass(eq=False, repr=False)
class IpNetwork(betterproto.Message):
    address: str = betterproto.string_field(1)
    netmask: str = betterproto.string_field(2)


class ActionsServiceStub(betterproto.ServiceStub):
    async def start(
        self,
        start_request: "StartRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "StartResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.ActionsService/Start",
            start_request,
            StartResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def stop(
        self,
        stop_request: "StopRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "StopResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.ActionsService/Stop",
            stop_request,
            StopResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def pause_mining(
        self,
        pause_mining_request: "PauseMiningRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "PauseMiningResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.ActionsService/PauseMining",
            pause_mining_request,
            PauseMiningResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def resume_mining(
        self,
        resume_mining_request: "ResumeMiningRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "ResumeMiningResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.ActionsService/ResumeMining",
            resume_mining_request,
            ResumeMiningResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def restart(
        self,
        restart_request: "RestartRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "RestartResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.ActionsService/Restart",
            restart_request,
            RestartResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def reboot(
        self,
        reboot_request: "RebootRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "RebootResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.ActionsService/Reboot",
            reboot_request,
            RebootResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def set_locate_device_status(
        self,
        set_locate_device_status_request: "SetLocateDeviceStatusRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "LocateDeviceStatusResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.ActionsService/SetLocateDeviceStatus",
            set_locate_device_status_request,
            LocateDeviceStatusResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_locate_device_status(
        self,
        get_locate_device_status_request: "GetLocateDeviceStatusRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "LocateDeviceStatusResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.ActionsService/GetLocateDeviceStatus",
            get_locate_device_status_request,
            LocateDeviceStatusResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class AuthenticationServiceStub(betterproto.ServiceStub):
    async def login(
        self,
        login_request: "LoginRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "LoginResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.AuthenticationService/Login",
            login_request,
            LoginResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def set_password(
        self,
        set_password_request: "SetPasswordRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "SetPasswordResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.AuthenticationService/SetPassword",
            set_password_request,
            SetPasswordResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class CoolingServiceStub(betterproto.ServiceStub):
    async def get_cooling_state(
        self,
        get_cooling_state_request: "GetCoolingStateRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "GetCoolingStateResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.CoolingService/GetCoolingState",
            get_cooling_state_request,
            GetCoolingStateResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def set_immersion_mode(
        self,
        set_immersion_mode_request: "SetImmersionModeRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "SetImmersionModeResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.CoolingService/SetImmersionMode",
            set_immersion_mode_request,
            SetImmersionModeResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class PerformanceServiceStub(betterproto.ServiceStub):
    async def get_tuner_state(
        self,
        get_tuner_state_request: "GetTunerStateRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "GetTunerStateResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.PerformanceService/GetTunerState",
            get_tuner_state_request,
            GetTunerStateResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def list_target_profiles(
        self,
        list_target_profiles_request: "ListTargetProfilesRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "ListTargetProfilesResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.PerformanceService/ListTargetProfiles",
            list_target_profiles_request,
            ListTargetProfilesResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def set_default_power_target(
        self,
        set_default_power_target_request: "SetDefaultPowerTargetRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "SetPowerTargetResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.PerformanceService/SetDefaultPowerTarget",
            set_default_power_target_request,
            SetPowerTargetResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def set_power_target(
        self,
        set_power_target_request: "SetPowerTargetRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "SetPowerTargetResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.PerformanceService/SetPowerTarget",
            set_power_target_request,
            SetPowerTargetResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def increment_power_target(
        self,
        increment_power_target_request: "IncrementPowerTargetRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "SetPowerTargetResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.PerformanceService/IncrementPowerTarget",
            increment_power_target_request,
            SetPowerTargetResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def decrement_power_target(
        self,
        decrement_power_target_request: "DecrementPowerTargetRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "SetPowerTargetResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.PerformanceService/DecrementPowerTarget",
            decrement_power_target_request,
            SetPowerTargetResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def set_default_hashrate_target(
        self,
        set_default_hashrate_target_request: "SetDefaultHashrateTargetRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "SetHashrateTargetResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.PerformanceService/SetDefaultHashrateTarget",
            set_default_hashrate_target_request,
            SetHashrateTargetResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def set_hashrate_target(
        self,
        set_hashrate_target_request: "SetHashrateTargetRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "SetHashrateTargetResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.PerformanceService/SetHashrateTarget",
            set_hashrate_target_request,
            SetHashrateTargetResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def increment_hashrate_target(
        self,
        increment_hashrate_target_request: "IncrementHashrateTargetRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "SetHashrateTargetResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.PerformanceService/IncrementHashrateTarget",
            increment_hashrate_target_request,
            SetHashrateTargetResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def decrement_hashrate_target(
        self,
        decrement_hashrate_target_request: "DecrementHashrateTargetRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "SetHashrateTargetResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.PerformanceService/DecrementHashrateTarget",
            decrement_hashrate_target_request,
            SetHashrateTargetResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def set_dps(
        self,
        set_dps_request: "SetDpsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "SetDpsResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.PerformanceService/SetDPS",
            set_dps_request,
            SetDpsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def set_performance_mode(
        self,
        set_performance_mode_request: "SetPerformanceModeRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "PerformanceMode":
        return await self._unary_unary(
            "/braiins.bos.v1.PerformanceService/SetPerformanceMode",
            set_performance_mode_request,
            PerformanceMode,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_active_performance_mode(
        self,
        get_performance_mode_request: "GetPerformanceModeRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "PerformanceMode":
        return await self._unary_unary(
            "/braiins.bos.v1.PerformanceService/GetActivePerformanceMode",
            get_performance_mode_request,
            PerformanceMode,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def remove_tuned_profiles(
        self,
        remove_tuned_profiles_request: "RemoveTunedProfilesRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "RemoveTunedProfilesResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.PerformanceService/RemoveTunedProfiles",
            remove_tuned_profiles_request,
            RemoveTunedProfilesResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class PoolServiceStub(betterproto.ServiceStub):
    async def get_pool_groups(
        self,
        get_pool_groups_request: "GetPoolGroupsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "GetPoolGroupsResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.PoolService/GetPoolGroups",
            get_pool_groups_request,
            GetPoolGroupsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def create_pool_group(
        self,
        create_pool_group_request: "CreatePoolGroupRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "CreatePoolGroupResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.PoolService/CreatePoolGroup",
            create_pool_group_request,
            CreatePoolGroupResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def update_pool_group(
        self,
        update_pool_group_request: "UpdatePoolGroupRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "UpdatePoolGroupResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.PoolService/UpdatePoolGroup",
            update_pool_group_request,
            UpdatePoolGroupResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def remove_pool_group(
        self,
        remove_pool_group_request: "RemovePoolGroupRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "RemovePoolGroupResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.PoolService/RemovePoolGroup",
            remove_pool_group_request,
            RemovePoolGroupResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def set_pool_groups(
        self,
        set_pool_groups_request: "SetPoolGroupsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "SetPoolGroupsResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.PoolService/SetPoolGroups",
            set_pool_groups_request,
            SetPoolGroupsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class ConfigurationServiceStub(betterproto.ServiceStub):
    async def get_miner_configuration(
        self,
        get_miner_configuration_request: "GetMinerConfigurationRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "GetMinerConfigurationResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.ConfigurationService/GetMinerConfiguration",
            get_miner_configuration_request,
            GetMinerConfigurationResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_constraints(
        self,
        get_constraints_request: "GetConstraintsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "GetConstraintsResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.ConfigurationService/GetConstraints",
            get_constraints_request,
            GetConstraintsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class LicenseServiceStub(betterproto.ServiceStub):
    async def get_license_state(
        self,
        get_license_state_request: "GetLicenseStateRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "GetLicenseStateResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.LicenseService/GetLicenseState",
            get_license_state_request,
            GetLicenseStateResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class MinerServiceStub(betterproto.ServiceStub):
    async def get_miner_status(
        self,
        get_miner_status_request: "GetMinerStatusRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> AsyncIterator[GetMinerStatusResponse]:
        async for response in self._unary_stream(
            "/braiins.bos.v1.MinerService/GetMinerStatus",
            get_miner_status_request,
            GetMinerStatusResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def get_miner_details(
        self,
        get_miner_details_request: "GetMinerDetailsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "GetMinerDetailsResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.MinerService/GetMinerDetails",
            get_miner_details_request,
            GetMinerDetailsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_miner_stats(
        self,
        get_miner_stats_request: "GetMinerStatsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "GetMinerStatsResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.MinerService/GetMinerStats",
            get_miner_stats_request,
            GetMinerStatsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_errors(
        self,
        get_errors_request: "GetErrorsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "GetErrorsResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.MinerService/GetErrors",
            get_errors_request,
            GetErrorsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_hashboards(
        self,
        get_hashboards_request: "GetHashboardsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "GetHashboardsResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.MinerService/GetHashboards",
            get_hashboards_request,
            GetHashboardsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_support_archive(
        self,
        get_support_archive_request: "GetSupportArchiveRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> AsyncIterator[GetSupportArchiveResponse]:
        async for response in self._unary_stream(
            "/braiins.bos.v1.MinerService/GetSupportArchive",
            get_support_archive_request,
            GetSupportArchiveResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def enable_hashboards(
        self,
        enable_hashboards_request: "EnableHashboardsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "EnableHashboardsResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.MinerService/EnableHashboards",
            enable_hashboards_request,
            EnableHashboardsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def disable_hashboards(
        self,
        disable_hashboards_request: "DisableHashboardsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "DisableHashboardsResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.MinerService/DisableHashboards",
            disable_hashboards_request,
            DisableHashboardsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class NetworkServiceStub(betterproto.ServiceStub):
    async def get_network_configuration(
        self,
        get_network_configuration_request: "GetNetworkConfigurationRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "GetNetworkConfigurationResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.NetworkService/GetNetworkConfiguration",
            get_network_configuration_request,
            GetNetworkConfigurationResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def set_network_configuration(
        self,
        set_network_configuration_request: "SetNetworkConfigurationRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "SetNetworkConfigurationResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.NetworkService/SetNetworkConfiguration",
            set_network_configuration_request,
            SetNetworkConfigurationResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_network_info(
        self,
        get_network_info_request: "GetNetworkInfoRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None,
    ) -> "GetNetworkInfoResponse":
        return await self._unary_unary(
            "/braiins.bos.v1.NetworkService/GetNetworkInfo",
            get_network_info_request,
            GetNetworkInfoResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class ActionsServiceBase(ServiceBase):
    async def start(self, start_request: "StartRequest") -> "StartResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def stop(self, stop_request: "StopRequest") -> "StopResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def pause_mining(
        self, pause_mining_request: "PauseMiningRequest"
    ) -> "PauseMiningResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def resume_mining(
        self, resume_mining_request: "ResumeMiningRequest"
    ) -> "ResumeMiningResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def restart(self, restart_request: "RestartRequest") -> "RestartResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def reboot(self, reboot_request: "RebootRequest") -> "RebootResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def set_locate_device_status(
        self, set_locate_device_status_request: "SetLocateDeviceStatusRequest"
    ) -> "LocateDeviceStatusResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_locate_device_status(
        self, get_locate_device_status_request: "GetLocateDeviceStatusRequest"
    ) -> "LocateDeviceStatusResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_start(
        self, stream: "grpclib.server.Stream[StartRequest, StartResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.start(request)
        await stream.send_message(response)

    async def __rpc_stop(
        self, stream: "grpclib.server.Stream[StopRequest, StopResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.stop(request)
        await stream.send_message(response)

    async def __rpc_pause_mining(
        self, stream: "grpclib.server.Stream[PauseMiningRequest, PauseMiningResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.pause_mining(request)
        await stream.send_message(response)

    async def __rpc_resume_mining(
        self, stream: "grpclib.server.Stream[ResumeMiningRequest, ResumeMiningResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.resume_mining(request)
        await stream.send_message(response)

    async def __rpc_restart(
        self, stream: "grpclib.server.Stream[RestartRequest, RestartResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.restart(request)
        await stream.send_message(response)

    async def __rpc_reboot(
        self, stream: "grpclib.server.Stream[RebootRequest, RebootResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.reboot(request)
        await stream.send_message(response)

    async def __rpc_set_locate_device_status(
        self,
        stream: "grpclib.server.Stream[SetLocateDeviceStatusRequest, LocateDeviceStatusResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.set_locate_device_status(request)
        await stream.send_message(response)

    async def __rpc_get_locate_device_status(
        self,
        stream: "grpclib.server.Stream[GetLocateDeviceStatusRequest, LocateDeviceStatusResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_locate_device_status(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/braiins.bos.v1.ActionsService/Start": grpclib.const.Handler(
                self.__rpc_start,
                grpclib.const.Cardinality.UNARY_UNARY,
                StartRequest,
                StartResponse,
            ),
            "/braiins.bos.v1.ActionsService/Stop": grpclib.const.Handler(
                self.__rpc_stop,
                grpclib.const.Cardinality.UNARY_UNARY,
                StopRequest,
                StopResponse,
            ),
            "/braiins.bos.v1.ActionsService/PauseMining": grpclib.const.Handler(
                self.__rpc_pause_mining,
                grpclib.const.Cardinality.UNARY_UNARY,
                PauseMiningRequest,
                PauseMiningResponse,
            ),
            "/braiins.bos.v1.ActionsService/ResumeMining": grpclib.const.Handler(
                self.__rpc_resume_mining,
                grpclib.const.Cardinality.UNARY_UNARY,
                ResumeMiningRequest,
                ResumeMiningResponse,
            ),
            "/braiins.bos.v1.ActionsService/Restart": grpclib.const.Handler(
                self.__rpc_restart,
                grpclib.const.Cardinality.UNARY_UNARY,
                RestartRequest,
                RestartResponse,
            ),
            "/braiins.bos.v1.ActionsService/Reboot": grpclib.const.Handler(
                self.__rpc_reboot,
                grpclib.const.Cardinality.UNARY_UNARY,
                RebootRequest,
                RebootResponse,
            ),
            "/braiins.bos.v1.ActionsService/SetLocateDeviceStatus": grpclib.const.Handler(
                self.__rpc_set_locate_device_status,
                grpclib.const.Cardinality.UNARY_UNARY,
                SetLocateDeviceStatusRequest,
                LocateDeviceStatusResponse,
            ),
            "/braiins.bos.v1.ActionsService/GetLocateDeviceStatus": grpclib.const.Handler(
                self.__rpc_get_locate_device_status,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetLocateDeviceStatusRequest,
                LocateDeviceStatusResponse,
            ),
        }


class AuthenticationServiceBase(ServiceBase):
    async def login(self, login_request: "LoginRequest") -> "LoginResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def set_password(
        self, set_password_request: "SetPasswordRequest"
    ) -> "SetPasswordResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_login(
        self, stream: "grpclib.server.Stream[LoginRequest, LoginResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.login(request)
        await stream.send_message(response)

    async def __rpc_set_password(
        self, stream: "grpclib.server.Stream[SetPasswordRequest, SetPasswordResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.set_password(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/braiins.bos.v1.AuthenticationService/Login": grpclib.const.Handler(
                self.__rpc_login,
                grpclib.const.Cardinality.UNARY_UNARY,
                LoginRequest,
                LoginResponse,
            ),
            "/braiins.bos.v1.AuthenticationService/SetPassword": grpclib.const.Handler(
                self.__rpc_set_password,
                grpclib.const.Cardinality.UNARY_UNARY,
                SetPasswordRequest,
                SetPasswordResponse,
            ),
        }


class CoolingServiceBase(ServiceBase):
    async def get_cooling_state(
        self, get_cooling_state_request: "GetCoolingStateRequest"
    ) -> "GetCoolingStateResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def set_immersion_mode(
        self, set_immersion_mode_request: "SetImmersionModeRequest"
    ) -> "SetImmersionModeResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_get_cooling_state(
        self,
        stream: "grpclib.server.Stream[GetCoolingStateRequest, GetCoolingStateResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_cooling_state(request)
        await stream.send_message(response)

    async def __rpc_set_immersion_mode(
        self,
        stream: "grpclib.server.Stream[SetImmersionModeRequest, SetImmersionModeResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.set_immersion_mode(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/braiins.bos.v1.CoolingService/GetCoolingState": grpclib.const.Handler(
                self.__rpc_get_cooling_state,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetCoolingStateRequest,
                GetCoolingStateResponse,
            ),
            "/braiins.bos.v1.CoolingService/SetImmersionMode": grpclib.const.Handler(
                self.__rpc_set_immersion_mode,
                grpclib.const.Cardinality.UNARY_UNARY,
                SetImmersionModeRequest,
                SetImmersionModeResponse,
            ),
        }


class PerformanceServiceBase(ServiceBase):
    async def get_tuner_state(
        self, get_tuner_state_request: "GetTunerStateRequest"
    ) -> "GetTunerStateResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def list_target_profiles(
        self, list_target_profiles_request: "ListTargetProfilesRequest"
    ) -> "ListTargetProfilesResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def set_default_power_target(
        self, set_default_power_target_request: "SetDefaultPowerTargetRequest"
    ) -> "SetPowerTargetResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def set_power_target(
        self, set_power_target_request: "SetPowerTargetRequest"
    ) -> "SetPowerTargetResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def increment_power_target(
        self, increment_power_target_request: "IncrementPowerTargetRequest"
    ) -> "SetPowerTargetResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def decrement_power_target(
        self, decrement_power_target_request: "DecrementPowerTargetRequest"
    ) -> "SetPowerTargetResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def set_default_hashrate_target(
        self, set_default_hashrate_target_request: "SetDefaultHashrateTargetRequest"
    ) -> "SetHashrateTargetResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def set_hashrate_target(
        self, set_hashrate_target_request: "SetHashrateTargetRequest"
    ) -> "SetHashrateTargetResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def increment_hashrate_target(
        self, increment_hashrate_target_request: "IncrementHashrateTargetRequest"
    ) -> "SetHashrateTargetResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def decrement_hashrate_target(
        self, decrement_hashrate_target_request: "DecrementHashrateTargetRequest"
    ) -> "SetHashrateTargetResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def set_dps(self, set_dps_request: "SetDpsRequest") -> "SetDpsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def set_performance_mode(
        self, set_performance_mode_request: "SetPerformanceModeRequest"
    ) -> "PerformanceMode":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_active_performance_mode(
        self, get_performance_mode_request: "GetPerformanceModeRequest"
    ) -> "PerformanceMode":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def remove_tuned_profiles(
        self, remove_tuned_profiles_request: "RemoveTunedProfilesRequest"
    ) -> "RemoveTunedProfilesResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_get_tuner_state(
        self,
        stream: "grpclib.server.Stream[GetTunerStateRequest, GetTunerStateResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_tuner_state(request)
        await stream.send_message(response)

    async def __rpc_list_target_profiles(
        self,
        stream: "grpclib.server.Stream[ListTargetProfilesRequest, ListTargetProfilesResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.list_target_profiles(request)
        await stream.send_message(response)

    async def __rpc_set_default_power_target(
        self,
        stream: "grpclib.server.Stream[SetDefaultPowerTargetRequest, SetPowerTargetResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.set_default_power_target(request)
        await stream.send_message(response)

    async def __rpc_set_power_target(
        self,
        stream: "grpclib.server.Stream[SetPowerTargetRequest, SetPowerTargetResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.set_power_target(request)
        await stream.send_message(response)

    async def __rpc_increment_power_target(
        self,
        stream: "grpclib.server.Stream[IncrementPowerTargetRequest, SetPowerTargetResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.increment_power_target(request)
        await stream.send_message(response)

    async def __rpc_decrement_power_target(
        self,
        stream: "grpclib.server.Stream[DecrementPowerTargetRequest, SetPowerTargetResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.decrement_power_target(request)
        await stream.send_message(response)

    async def __rpc_set_default_hashrate_target(
        self,
        stream: "grpclib.server.Stream[SetDefaultHashrateTargetRequest, SetHashrateTargetResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.set_default_hashrate_target(request)
        await stream.send_message(response)

    async def __rpc_set_hashrate_target(
        self,
        stream: "grpclib.server.Stream[SetHashrateTargetRequest, SetHashrateTargetResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.set_hashrate_target(request)
        await stream.send_message(response)

    async def __rpc_increment_hashrate_target(
        self,
        stream: "grpclib.server.Stream[IncrementHashrateTargetRequest, SetHashrateTargetResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.increment_hashrate_target(request)
        await stream.send_message(response)

    async def __rpc_decrement_hashrate_target(
        self,
        stream: "grpclib.server.Stream[DecrementHashrateTargetRequest, SetHashrateTargetResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.decrement_hashrate_target(request)
        await stream.send_message(response)

    async def __rpc_set_dps(
        self, stream: "grpclib.server.Stream[SetDpsRequest, SetDpsResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.set_dps(request)
        await stream.send_message(response)

    async def __rpc_set_performance_mode(
        self,
        stream: "grpclib.server.Stream[SetPerformanceModeRequest, PerformanceMode]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.set_performance_mode(request)
        await stream.send_message(response)

    async def __rpc_get_active_performance_mode(
        self,
        stream: "grpclib.server.Stream[GetPerformanceModeRequest, PerformanceMode]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_active_performance_mode(request)
        await stream.send_message(response)

    async def __rpc_remove_tuned_profiles(
        self,
        stream: "grpclib.server.Stream[RemoveTunedProfilesRequest, RemoveTunedProfilesResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.remove_tuned_profiles(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/braiins.bos.v1.PerformanceService/GetTunerState": grpclib.const.Handler(
                self.__rpc_get_tuner_state,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetTunerStateRequest,
                GetTunerStateResponse,
            ),
            "/braiins.bos.v1.PerformanceService/ListTargetProfiles": grpclib.const.Handler(
                self.__rpc_list_target_profiles,
                grpclib.const.Cardinality.UNARY_UNARY,
                ListTargetProfilesRequest,
                ListTargetProfilesResponse,
            ),
            "/braiins.bos.v1.PerformanceService/SetDefaultPowerTarget": grpclib.const.Handler(
                self.__rpc_set_default_power_target,
                grpclib.const.Cardinality.UNARY_UNARY,
                SetDefaultPowerTargetRequest,
                SetPowerTargetResponse,
            ),
            "/braiins.bos.v1.PerformanceService/SetPowerTarget": grpclib.const.Handler(
                self.__rpc_set_power_target,
                grpclib.const.Cardinality.UNARY_UNARY,
                SetPowerTargetRequest,
                SetPowerTargetResponse,
            ),
            "/braiins.bos.v1.PerformanceService/IncrementPowerTarget": grpclib.const.Handler(
                self.__rpc_increment_power_target,
                grpclib.const.Cardinality.UNARY_UNARY,
                IncrementPowerTargetRequest,
                SetPowerTargetResponse,
            ),
            "/braiins.bos.v1.PerformanceService/DecrementPowerTarget": grpclib.const.Handler(
                self.__rpc_decrement_power_target,
                grpclib.const.Cardinality.UNARY_UNARY,
                DecrementPowerTargetRequest,
                SetPowerTargetResponse,
            ),
            "/braiins.bos.v1.PerformanceService/SetDefaultHashrateTarget": grpclib.const.Handler(
                self.__rpc_set_default_hashrate_target,
                grpclib.const.Cardinality.UNARY_UNARY,
                SetDefaultHashrateTargetRequest,
                SetHashrateTargetResponse,
            ),
            "/braiins.bos.v1.PerformanceService/SetHashrateTarget": grpclib.const.Handler(
                self.__rpc_set_hashrate_target,
                grpclib.const.Cardinality.UNARY_UNARY,
                SetHashrateTargetRequest,
                SetHashrateTargetResponse,
            ),
            "/braiins.bos.v1.PerformanceService/IncrementHashrateTarget": grpclib.const.Handler(
                self.__rpc_increment_hashrate_target,
                grpclib.const.Cardinality.UNARY_UNARY,
                IncrementHashrateTargetRequest,
                SetHashrateTargetResponse,
            ),
            "/braiins.bos.v1.PerformanceService/DecrementHashrateTarget": grpclib.const.Handler(
                self.__rpc_decrement_hashrate_target,
                grpclib.const.Cardinality.UNARY_UNARY,
                DecrementHashrateTargetRequest,
                SetHashrateTargetResponse,
            ),
            "/braiins.bos.v1.PerformanceService/SetDPS": grpclib.const.Handler(
                self.__rpc_set_dps,
                grpclib.const.Cardinality.UNARY_UNARY,
                SetDpsRequest,
                SetDpsResponse,
            ),
            "/braiins.bos.v1.PerformanceService/SetPerformanceMode": grpclib.const.Handler(
                self.__rpc_set_performance_mode,
                grpclib.const.Cardinality.UNARY_UNARY,
                SetPerformanceModeRequest,
                PerformanceMode,
            ),
            "/braiins.bos.v1.PerformanceService/GetActivePerformanceMode": grpclib.const.Handler(
                self.__rpc_get_active_performance_mode,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetPerformanceModeRequest,
                PerformanceMode,
            ),
            "/braiins.bos.v1.PerformanceService/RemoveTunedProfiles": grpclib.const.Handler(
                self.__rpc_remove_tuned_profiles,
                grpclib.const.Cardinality.UNARY_UNARY,
                RemoveTunedProfilesRequest,
                RemoveTunedProfilesResponse,
            ),
        }


class PoolServiceBase(ServiceBase):
    async def get_pool_groups(
        self, get_pool_groups_request: "GetPoolGroupsRequest"
    ) -> "GetPoolGroupsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def create_pool_group(
        self, create_pool_group_request: "CreatePoolGroupRequest"
    ) -> "CreatePoolGroupResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def update_pool_group(
        self, update_pool_group_request: "UpdatePoolGroupRequest"
    ) -> "UpdatePoolGroupResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def remove_pool_group(
        self, remove_pool_group_request: "RemovePoolGroupRequest"
    ) -> "RemovePoolGroupResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def set_pool_groups(
        self, set_pool_groups_request: "SetPoolGroupsRequest"
    ) -> "SetPoolGroupsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_get_pool_groups(
        self,
        stream: "grpclib.server.Stream[GetPoolGroupsRequest, GetPoolGroupsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_pool_groups(request)
        await stream.send_message(response)

    async def __rpc_create_pool_group(
        self,
        stream: "grpclib.server.Stream[CreatePoolGroupRequest, CreatePoolGroupResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.create_pool_group(request)
        await stream.send_message(response)

    async def __rpc_update_pool_group(
        self,
        stream: "grpclib.server.Stream[UpdatePoolGroupRequest, UpdatePoolGroupResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.update_pool_group(request)
        await stream.send_message(response)

    async def __rpc_remove_pool_group(
        self,
        stream: "grpclib.server.Stream[RemovePoolGroupRequest, RemovePoolGroupResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.remove_pool_group(request)
        await stream.send_message(response)

    async def __rpc_set_pool_groups(
        self,
        stream: "grpclib.server.Stream[SetPoolGroupsRequest, SetPoolGroupsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.set_pool_groups(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/braiins.bos.v1.PoolService/GetPoolGroups": grpclib.const.Handler(
                self.__rpc_get_pool_groups,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetPoolGroupsRequest,
                GetPoolGroupsResponse,
            ),
            "/braiins.bos.v1.PoolService/CreatePoolGroup": grpclib.const.Handler(
                self.__rpc_create_pool_group,
                grpclib.const.Cardinality.UNARY_UNARY,
                CreatePoolGroupRequest,
                CreatePoolGroupResponse,
            ),
            "/braiins.bos.v1.PoolService/UpdatePoolGroup": grpclib.const.Handler(
                self.__rpc_update_pool_group,
                grpclib.const.Cardinality.UNARY_UNARY,
                UpdatePoolGroupRequest,
                UpdatePoolGroupResponse,
            ),
            "/braiins.bos.v1.PoolService/RemovePoolGroup": grpclib.const.Handler(
                self.__rpc_remove_pool_group,
                grpclib.const.Cardinality.UNARY_UNARY,
                RemovePoolGroupRequest,
                RemovePoolGroupResponse,
            ),
            "/braiins.bos.v1.PoolService/SetPoolGroups": grpclib.const.Handler(
                self.__rpc_set_pool_groups,
                grpclib.const.Cardinality.UNARY_UNARY,
                SetPoolGroupsRequest,
                SetPoolGroupsResponse,
            ),
        }


class ConfigurationServiceBase(ServiceBase):
    async def get_miner_configuration(
        self, get_miner_configuration_request: "GetMinerConfigurationRequest"
    ) -> "GetMinerConfigurationResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_constraints(
        self, get_constraints_request: "GetConstraintsRequest"
    ) -> "GetConstraintsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_get_miner_configuration(
        self,
        stream: "grpclib.server.Stream[GetMinerConfigurationRequest, GetMinerConfigurationResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_miner_configuration(request)
        await stream.send_message(response)

    async def __rpc_get_constraints(
        self,
        stream: "grpclib.server.Stream[GetConstraintsRequest, GetConstraintsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_constraints(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/braiins.bos.v1.ConfigurationService/GetMinerConfiguration": grpclib.const.Handler(
                self.__rpc_get_miner_configuration,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetMinerConfigurationRequest,
                GetMinerConfigurationResponse,
            ),
            "/braiins.bos.v1.ConfigurationService/GetConstraints": grpclib.const.Handler(
                self.__rpc_get_constraints,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetConstraintsRequest,
                GetConstraintsResponse,
            ),
        }


class LicenseServiceBase(ServiceBase):
    async def get_license_state(
        self, get_license_state_request: "GetLicenseStateRequest"
    ) -> "GetLicenseStateResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_get_license_state(
        self,
        stream: "grpclib.server.Stream[GetLicenseStateRequest, GetLicenseStateResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_license_state(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/braiins.bos.v1.LicenseService/GetLicenseState": grpclib.const.Handler(
                self.__rpc_get_license_state,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetLicenseStateRequest,
                GetLicenseStateResponse,
            ),
        }


class MinerServiceBase(ServiceBase):
    async def get_miner_status(
        self, get_miner_status_request: "GetMinerStatusRequest"
    ) -> AsyncIterator[GetMinerStatusResponse]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)
        yield GetMinerStatusResponse()

    async def get_miner_details(
        self, get_miner_details_request: "GetMinerDetailsRequest"
    ) -> "GetMinerDetailsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_miner_stats(
        self, get_miner_stats_request: "GetMinerStatsRequest"
    ) -> "GetMinerStatsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_errors(
        self, get_errors_request: "GetErrorsRequest"
    ) -> "GetErrorsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_hashboards(
        self, get_hashboards_request: "GetHashboardsRequest"
    ) -> "GetHashboardsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_support_archive(
        self, get_support_archive_request: "GetSupportArchiveRequest"
    ) -> AsyncIterator[GetSupportArchiveResponse]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)
        yield GetSupportArchiveResponse()

    async def enable_hashboards(
        self, enable_hashboards_request: "EnableHashboardsRequest"
    ) -> "EnableHashboardsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def disable_hashboards(
        self, disable_hashboards_request: "DisableHashboardsRequest"
    ) -> "DisableHashboardsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_get_miner_status(
        self,
        stream: "grpclib.server.Stream[GetMinerStatusRequest, GetMinerStatusResponse]",
    ) -> None:
        request = await stream.recv_message()
        await self._call_rpc_handler_server_stream(
            self.get_miner_status,
            stream,
            request,
        )

    async def __rpc_get_miner_details(
        self,
        stream: "grpclib.server.Stream[GetMinerDetailsRequest, GetMinerDetailsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_miner_details(request)
        await stream.send_message(response)

    async def __rpc_get_miner_stats(
        self,
        stream: "grpclib.server.Stream[GetMinerStatsRequest, GetMinerStatsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_miner_stats(request)
        await stream.send_message(response)

    async def __rpc_get_errors(
        self, stream: "grpclib.server.Stream[GetErrorsRequest, GetErrorsResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_errors(request)
        await stream.send_message(response)

    async def __rpc_get_hashboards(
        self,
        stream: "grpclib.server.Stream[GetHashboardsRequest, GetHashboardsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_hashboards(request)
        await stream.send_message(response)

    async def __rpc_get_support_archive(
        self,
        stream: "grpclib.server.Stream[GetSupportArchiveRequest, GetSupportArchiveResponse]",
    ) -> None:
        request = await stream.recv_message()
        await self._call_rpc_handler_server_stream(
            self.get_support_archive,
            stream,
            request,
        )

    async def __rpc_enable_hashboards(
        self,
        stream: "grpclib.server.Stream[EnableHashboardsRequest, EnableHashboardsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.enable_hashboards(request)
        await stream.send_message(response)

    async def __rpc_disable_hashboards(
        self,
        stream: "grpclib.server.Stream[DisableHashboardsRequest, DisableHashboardsResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.disable_hashboards(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/braiins.bos.v1.MinerService/GetMinerStatus": grpclib.const.Handler(
                self.__rpc_get_miner_status,
                grpclib.const.Cardinality.UNARY_STREAM,
                GetMinerStatusRequest,
                GetMinerStatusResponse,
            ),
            "/braiins.bos.v1.MinerService/GetMinerDetails": grpclib.const.Handler(
                self.__rpc_get_miner_details,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetMinerDetailsRequest,
                GetMinerDetailsResponse,
            ),
            "/braiins.bos.v1.MinerService/GetMinerStats": grpclib.const.Handler(
                self.__rpc_get_miner_stats,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetMinerStatsRequest,
                GetMinerStatsResponse,
            ),
            "/braiins.bos.v1.MinerService/GetErrors": grpclib.const.Handler(
                self.__rpc_get_errors,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetErrorsRequest,
                GetErrorsResponse,
            ),
            "/braiins.bos.v1.MinerService/GetHashboards": grpclib.const.Handler(
                self.__rpc_get_hashboards,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetHashboardsRequest,
                GetHashboardsResponse,
            ),
            "/braiins.bos.v1.MinerService/GetSupportArchive": grpclib.const.Handler(
                self.__rpc_get_support_archive,
                grpclib.const.Cardinality.UNARY_STREAM,
                GetSupportArchiveRequest,
                GetSupportArchiveResponse,
            ),
            "/braiins.bos.v1.MinerService/EnableHashboards": grpclib.const.Handler(
                self.__rpc_enable_hashboards,
                grpclib.const.Cardinality.UNARY_UNARY,
                EnableHashboardsRequest,
                EnableHashboardsResponse,
            ),
            "/braiins.bos.v1.MinerService/DisableHashboards": grpclib.const.Handler(
                self.__rpc_disable_hashboards,
                grpclib.const.Cardinality.UNARY_UNARY,
                DisableHashboardsRequest,
                DisableHashboardsResponse,
            ),
        }


class NetworkServiceBase(ServiceBase):
    async def get_network_configuration(
        self, get_network_configuration_request: "GetNetworkConfigurationRequest"
    ) -> "GetNetworkConfigurationResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def set_network_configuration(
        self, set_network_configuration_request: "SetNetworkConfigurationRequest"
    ) -> "SetNetworkConfigurationResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_network_info(
        self, get_network_info_request: "GetNetworkInfoRequest"
    ) -> "GetNetworkInfoResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_get_network_configuration(
        self,
        stream: "grpclib.server.Stream[GetNetworkConfigurationRequest, GetNetworkConfigurationResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_network_configuration(request)
        await stream.send_message(response)

    async def __rpc_set_network_configuration(
        self,
        stream: "grpclib.server.Stream[SetNetworkConfigurationRequest, SetNetworkConfigurationResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.set_network_configuration(request)
        await stream.send_message(response)

    async def __rpc_get_network_info(
        self,
        stream: "grpclib.server.Stream[GetNetworkInfoRequest, GetNetworkInfoResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_network_info(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/braiins.bos.v1.NetworkService/GetNetworkConfiguration": grpclib.const.Handler(
                self.__rpc_get_network_configuration,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetNetworkConfigurationRequest,
                GetNetworkConfigurationResponse,
            ),
            "/braiins.bos.v1.NetworkService/SetNetworkConfiguration": grpclib.const.Handler(
                self.__rpc_set_network_configuration,
                grpclib.const.Cardinality.UNARY_UNARY,
                SetNetworkConfigurationRequest,
                SetNetworkConfigurationResponse,
            ),
            "/braiins.bos.v1.NetworkService/GetNetworkInfo": grpclib.const.Handler(
                self.__rpc_get_network_info,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetNetworkInfoRequest,
                GetNetworkInfoResponse,
            ),
        }
