from refspy.models.book import Book
from refspy.models.library import Library, OT_ID, NT_ID, DC_ID, DCO_ID

# See README.md for Library ID numbers
# French language libraries follow style guides for books
# and abbreviations from:
# - Traduction liturgique (TOL) --> reference
# - Traduction de Jérusalem (BJ)
# - Traduction œucuménique (TOB)

OT = Library(
    id=OT_ID,
    name="Ancien Testament",
    abbrev="AT",
    books=[
        Book(
            id=1,
            name="Genèse",
            abbrev="Gn",
            aliases=[],
            chapters=50,
        ),
        Book(
            id=2,
            name="Exode",
            abbrev="Ex",
            aliases=[],
            chapters=40,
        ),
        Book(
            id=3,
            name="Lévitique",
            abbrev="Lv",
            aliases=[],
            chapters=27,
        ),
        Book(
            id=4,
            name="Nombres",
            abbrev="Nb",
            aliases=[],
            chapters=36,
        ),
        Book(
            id=5,
            name="Deutéronome",
            abbrev="Dt",
            aliases=[],
            chapters=34,
        ),
        Book(
            id=6,
            name="Josué",
            abbrev="Jos",
            aliases=[],
            chapters=24,
        ),
        Book(
            id=7,
            name="Juges",
            abbrev="Jg",
            aliases=[],
            chapters=21,
        ),
        Book(
            id=8,
            name="Ruth",
            abbrev="Rt",
            aliases=[],
            chapters=4,
        ),
        Book(
            id=9,
            name="1 Samuel",
            abbrev="1 S",
            aliases=[],
            chapters=31,
        ),
        Book(
            id=10,
            name="2 Samuel",
            abbrev="2 S",
            aliases=[],
            chapters=24,
        ),
        Book(
            id=11,
            name="1 Rois",
            abbrev="1 R",
            aliases=[],
            chapters=22,
        ),
        Book(
            id=12,
            name="2 Rois",
            abbrev="2 R",
            aliases=[],
            chapters=22,
        ),
        Book(
            id=13,
            name="1 Chroniques",
            abbrev="1 Ch",
            aliases=[],
            chapters=29,
        ),
        Book(
            id=14,
            name="2 Chronicques",
            abbrev="2 Ch",
            aliases=[],
            chapters=36,
        ),
        Book(
            id=15,
            name="Esdras",
            abbrev="Esd",
            aliases=[],
            chapters=10,
        ),
        Book(
            id=16,
            name="Néhémie",
            abbrev="Ne",
            aliases=[],
            chapters=13,
        ),
        Book(
            id=17,
            name="Esther",
            abbrev="Est",
            aliases=[],
            chapters=10,
        ),
        Book(
            id=18,
            name="Job",
            abbrev="Jb",
            aliases=[],
            chapters=42,
        ),
        Book(
            id=19,
            name="Psaumes",
            abbrev="Ps",
            aliases=[],
            chapters=150,
        ),
        Book(
            id=20,
            name="Proverbes",
            abbrev="Pr",
            aliases=[],
            chapters=31,
        ),
        Book(
            id=21,
            name="Qohèleth (Ecclésiaste)",
            abbrev="Qo",
            aliases=["Ecc", "Ec"],
            chapters=12,
        ),
        Book(
            id=22,
            name="Cantique des cantiques",
            abbrev="Ct",
            aliases=[],
            chapters=8,
        ),
        Book(
            id=23,
            name="Isaïe",
            abbrev="Is",
            aliases=["Es"],
            chapters=66,
        ),
        Book(
            id=24,
            name="Jérémie",
            abbrev="Jr",
            aliases=[],
            chapters=52,
        ),
        Book(
            id=25,
            name="Lamentations",
            abbrev="Lm",
            aliases=[],
            chapters=5,
        ),
        Book(
            id=26,
            name="Ézékiel",
            abbrev="Ez",
            aliases=[],
            chapters=48,
        ),
        Book(
            id=27,
            name="Daniel",
            abbrev="Dn",
            aliases=[],
            chapters=12,
        ),
        Book(
            id=28,
            name="Osée",
            abbrev="Os",
            aliases=[],
            chapters=14,
        ),
        Book(
            id=29,
            name="Joël",
            abbrev="Jl",
            aliases=[],
            chapters=3,
        ),
        Book(
            id=30,
            name="Amos",
            abbrev="Am",
            aliases=[],
            chapters=9,
        ),
        Book(
            id=31,
            name="Abdias",
            abbrev="Ab",
            aliases=[],
            chapters=1,
        ),
        Book(
            id=32,
            name="Jonas",
            abbrev="Jon",
            aliases=[],
            chapters=4,
        ),
        Book(
            id=33,
            name="Michée",
            abbrev="Mi",
            aliases=[],
            chapters=7,
        ),
        Book(
            id=34,
            name="Nahoum",
            abbrev="Na",
            aliases=[],
            chapters=3,
        ),
        Book(
            id=35,
            name="Habacuc",
            abbrev="Ha",
            aliases=[],
            chapters=3,
        ),
        Book(
            id=36,
            name="Sophonie",
            abbrev="So",
            aliases=[],
            chapters=3,
        ),
        Book(
            id=37,
            name="Aggée",
            abbrev="Ag",
            aliases=[],
            chapters=2,
        ),
        Book(
            id=38,
            name="Zacharie",
            abbrev="Za",
            aliases=[],
            chapters=14,
        ),
        Book(
            id=39,
            name="Malachie",
            abbrev="Ml",
            aliases=[],
            chapters=4,
        ),
    ],
)

DC = Library(
    id=DC_ID,
    name="Deuterocanonical",
    abbrev="DC",
    books=[
        Book(
            id=1,
            name="Tobie",
            abbrev="Tb",
            aliases=[],
            chapters=14,
        ),
        Book(
            id=2,
            name="Judith",
            abbrev="Jdt",
            aliases=[],
            chapters=16,
        ),
        Book(
            # TODO: Offsets: 11..16?
            id=3,
            name="Esther grec",
            abbrev="Est gr",
            aliases=[],
            chapters=10,
        ),
        Book(
            id=4,
            name="Sagesse",
            abbrev="Sg",
            aliases=[],
            chapters=19,
        ),
        Book(
            id=5,
            name="Siracide",
            abbrev="Si",
            aliases=[],
            chapters=51,
        ),
        Book(
            id=6,
            name="Baruc",
            abbrev="Ba",
            aliases=[],
            chapters=6,
        ),
        Book(
            id=7,
            name="Lettre de Jérémie",
            abbrev="Lt-Jr",
            aliases=[],
            chapters=1,
        ),
        Book(
            id=9,
            name="Prière d'Azarias",
            abbrev="Pr Azar",
            aliases=[],
            chapters=1,
        ),
        Book(
            id=10,
            name="Cantique des trois enfants",
            abbrev="CtT",
            aliases=[],
            chapters=1,
        ),
        Book(
            id=11,
            name="Susanne",
            abbrev="Sus",
            aliases=[],
            chapters=1,
        ),
        Book(
            id=12,
            name="Bel et le Dragon",
            abbrev="Bel",
            aliases=[],
            chapters=1,
        ),
        Book(
            id=13,
            name="Premier livre des Maccabées",
            abbrev="1 M",
            aliases=["1 Macc"],
            chapters=16,
        ),
        Book(
            id=14,
            name="Deuxième livre des Maccabées",
            abbrev="2 M",
            aliases=["2 Macc"],
            chapters=15,
        ),
    ],
)
DC_ORTHODOX = Library(
    id=DCO_ID,
    name="Deuterocanonical (Orthodox)",
    abbrev="DCO",
    books=[
        Book(
            id=1,
            name="Troisième livre d'Esdras",
            abbrev="3 Esd",
            aliases=["Esd gr"],
            chapters=9,
        ),
        Book(
            id=2,
            name="Prière de Manassé",
            abbrev="Pr Man",
            aliases=[],
            chapters=1,
        ),
        Book(
            id=3,
            name="Psaume 151",
            abbrev="Ps 151",
            aliases=[],
            chapters=1,
        ),
        Book(
            id=4,
            name="Troisième livre des Maccabées",
            abbrev="3 M",
            aliases=[],
            chapters=7,
        ),
        Book(
            id=5,
            name="Quatrième livre d'Esdras",
            abbrev="4 Esd",
            aliases=["Apocalypse d'Esdras"],
            chapters=16,
        ),
        Book(
            id=6,
            name="Quatrième livre des Maccabées",
            abbrev="4 M",
            aliases=[],
            chapters=18,
        ),
    ],
)

NT = Library(
    id=NT_ID,
    name="Nouveau Testament",
    abbrev="NT",
    books=[
        Book(
            id=1,
            name="Matthieu",
            abbrev="Mt",
            aliases=[],
            chapters=28,
        ),
        Book(
            id=2,
            name="Marc",
            abbrev="Mc",
            aliases=[],
            chapters=16,
        ),
        Book(
            id=3,
            name="Luc",
            abbrev="Lc",
            aliases=[],
            chapters=24,
        ),
        Book(
            id=4,
            name="Jean",
            abbrev="Jn",
            aliases=[],
            chapters=21,
        ),
        Book(
            id=5,
            name="Actes des Apôtres",
            abbrev="Ac",
            aliases=[],
            chapters=28,
        ),
        Book(
            id=6,
            name="Romains",
            abbrev="Rm",
            aliases=[],
            chapters=16,
        ),
        Book(
            id=7,
            name="1 Corinthiens",
            abbrev="1 Co",
            aliases=[""],
            chapters=16,
        ),
        Book(
            id=8,
            name="2 Corinthiens",
            abbrev="2 Co",
            aliases=[""],
            chapters=13,
        ),
        Book(
            id=9,
            name="Galates",
            abbrev="Ga",
            aliases=[],
            chapters=6,
        ),
        Book(
            id=10,
            name="Ephésiens",
            abbrev="Ep",
            aliases=[],
            chapters=6,
        ),
        Book(
            id=11,
            name="Philippians",
            abbrev="Ph",
            aliases=[],
            chapters=4,
        ),
        Book(
            id=12,
            name="Colossians",
            abbrev="Col",
            aliases=[],
            chapters=4,
        ),
        Book(
            id=13,
            name="1 Thessaloniciens",
            abbrev="1 Th",
            aliases=[],
            chapters=5,
        ),
        Book(
            id=14,
            name="2 Thessaloniciens",
            abbrev="2 Th",
            aliases=[],
            chapters=3,
        ),
        Book(
            id=15,
            name="1 Timothée",
            abbrev="1 Tm",
            aliases=[],
            chapters=6,
        ),
        Book(
            id=16,
            name="2 Timothée",
            abbrev="2 Tm",
            aliases=[],
            chapters=4,
        ),
        Book(
            id=17,
            name="Tite",
            abbrev="Tt",
            aliases=[],
            chapters=3,
        ),
        Book(
            id=18,
            name="Philémon",
            abbrev="Phm",
            aliases=[],
            chapters=1,
        ),
        Book(
            id=19,
            name="Hébreux",
            abbrev="Hb",
            aliases=[],
            chapters=13,
        ),
        Book(
            id=20,
            name="Jacques",
            abbrev="Jc",
            aliases=[],
            chapters=5,
        ),
        Book(
            id=21,
            name="1 Pierre",
            abbrev="1 P",
            aliases=[],
            chapters=5,
        ),
        Book(
            id=22,
            name="2 Pierre",
            abbrev="2 P",
            aliases=[],
            chapters=3,
        ),
        Book(
            id=23,
            name="1 Jean",
            abbrev="1 Jn",
            aliases=[],
            chapters=5,
        ),
        Book(
            id=24,
            name="2 Jean",
            abbrev="2 Jn",
            aliases=[],
            chapters=1,
        ),
        Book(
            id=25,
            name="3 Jean",
            abbrev="3 Jn",
            aliases=[],
            chapters=1,
        ),
        Book(
            id=26,
            name="Jude",
            abbrev="Jude",
            aliases=[],
            chapters=1,
        ),
        Book(
            id=27,
            name="Apocalypse",
            abbrev="Ap",
            aliases=[],
            chapters=22,
        ),
    ],
)
