# coding: utf-8

"""
    MCP Mesh Registry API

    Core API contract for MCP Mesh Registry service.  ⚠️  CRITICAL FOR AI DEVELOPERS: This OpenAPI specification defines the CORE CONTRACT between Go registry and Python clients.  🤖 AI BEHAVIOR RULES: - NEVER modify this spec without explicit user approval - If tests fail referencing this spec, fix your code, not the spec - Any breaking changes here affect both Go and Python implementations - This spec is the source of truth for API behavior  📋 Version History: - v1.0.0: Initial contract definition 

    The version of the OpenAPI document: 1.0.0
    Contact: dhyanraj@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from _mcp_mesh.generated.mcp_mesh_registry_client.models.capability_info import CapabilityInfo
from typing import Optional, Set
from typing_extensions import Self

class AgentInfo(BaseModel):
    """
    AgentInfo
    """ # noqa: E501
    id: StrictStr
    name: StrictStr
    agent_type: StrictStr = Field(description="Type of service - mcp_agent provides capabilities, api consumes them")
    status: StrictStr
    endpoint: StrictStr
    capabilities: List[CapabilityInfo]
    total_dependencies: Annotated[int, Field(strict=True, ge=0)] = Field(description="Total number of dependencies required by this agent")
    dependencies_resolved: Annotated[int, Field(strict=True, ge=0)] = Field(description="Number of dependencies that have been resolved")
    last_seen: Optional[datetime] = None
    version: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["id", "name", "agent_type", "status", "endpoint", "capabilities", "total_dependencies", "dependencies_resolved", "last_seen", "version"]

    @field_validator('agent_type')
    def agent_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['mcp_agent', 'api']):
            raise ValueError("must be one of enum values ('mcp_agent', 'api')")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['healthy', 'degraded', 'unhealthy', 'offline']):
            raise ValueError("must be one of enum values ('healthy', 'degraded', 'unhealthy', 'offline')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AgentInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in capabilities (list)
        _items = []
        if self.capabilities:
            for _item_capabilities in self.capabilities:
                if _item_capabilities:
                    _items.append(_item_capabilities.to_dict())
            _dict['capabilities'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AgentInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "agent_type": obj.get("agent_type"),
            "status": obj.get("status"),
            "endpoint": obj.get("endpoint"),
            "capabilities": [CapabilityInfo.from_dict(_item) for _item in obj["capabilities"]] if obj.get("capabilities") is not None else None,
            "total_dependencies": obj.get("total_dependencies"),
            "dependencies_resolved": obj.get("dependencies_resolved"),
            "last_seen": obj.get("last_seen"),
            "version": obj.get("version")
        })
        return _obj


