# coding: utf-8

"""
    MCP Mesh Registry API

    Core API contract for MCP Mesh Registry service.  ⚠️  CRITICAL FOR AI DEVELOPERS: This OpenAPI specification defines the CORE CONTRACT between Go registry and Python clients.  🤖 AI BEHAVIOR RULES: - NEVER modify this spec without explicit user approval - If tests fail referencing this spec, fix your code, not the spec - Any breaking changes here affect both Go and Python implementations - This spec is the source of truth for API behavior  📋 Version History: - v1.0.0: Initial contract definition 

    The version of the OpenAPI document: 1.0.0
    Contact: dhyanraj@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from _mcp_mesh.generated.mcp_mesh_registry_client.models.mesh_registration_response_dependencies_resolved_value_inner import MeshRegistrationResponseDependenciesResolvedValueInner
from typing import Optional, Set
from typing_extensions import Self

class MeshRegistrationResponse(BaseModel):
    """
    Response for both registration and heartbeat requests
    """ # noqa: E501
    status: StrictStr
    timestamp: datetime
    message: StrictStr
    agent_id: StrictStr = Field(description="Confirmed agent ID")
    dependencies_resolved: Optional[Dict[str, List[MeshRegistrationResponseDependenciesResolvedValueInner]]] = Field(default=None, description="Function name to array of resolved dependencies mapping. 🤖 AI NOTE: This enables immediate dependency injection setup. ")
    __properties: ClassVar[List[str]] = ["status", "timestamp", "message", "agent_id", "dependencies_resolved"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['success', 'error']):
            raise ValueError("must be one of enum values ('success', 'error')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MeshRegistrationResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in dependencies_resolved (dict of array)
        _field_dict_of_array = {}
        if self.dependencies_resolved:
            for _key_dependencies_resolved in self.dependencies_resolved:
                if self.dependencies_resolved[_key_dependencies_resolved] is not None:
                    _field_dict_of_array[_key_dependencies_resolved] = [
                        _item.to_dict() for _item in self.dependencies_resolved[_key_dependencies_resolved]
                    ]
            _dict['dependencies_resolved'] = _field_dict_of_array
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MeshRegistrationResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "status": obj.get("status"),
            "timestamp": obj.get("timestamp"),
            "message": obj.get("message"),
            "agent_id": obj.get("agent_id"),
            "dependencies_resolved": dict(
                (_k,
                        [MeshRegistrationResponseDependenciesResolvedValueInner.from_dict(_item) for _item in _v]
                        if _v is not None
                        else None
                )
                for _k, _v in obj.get("dependencies_resolved", {}).items()
            )
        })
        return _obj


