import * as ecs from 'aws-cdk-lib/aws-ecs';
import { Construct } from 'constructs';
import { ContainerMutatingHook, ServiceBuild, ServiceExtension } from './extension-interfaces';
import { Service } from '../service';
/**
 * AliasedPortProps defines the properties of an aliased port extension
 */
export interface AliasedPortProps {
    /**
     * The DNS alias to advertise for downstream clients.
     */
    readonly alias: string;
    /**
     * The protocol to use over the specified port.
     *
     * May be one of HTTP, HTTP2, or GRPC.
     *
     * @default - none
     */
    readonly appProtocol?: ecs.AppProtocol;
    /**
     * The traffic port for clients to use to connect to the DNS alias.
     *
     * @default - same as containerPort.
     */
    readonly aliasPort?: number;
}
export declare class AliasedPortExtension extends ServiceExtension {
    protected alias: string;
    protected aliasPort?: number;
    protected appProtocol?: ecs.AppProtocol;
    protected namespace?: string;
    constructor(props: AliasedPortProps);
    prehook(service: Service, scope: Construct): void;
    addHooks(): void;
    modifyServiceProps(props: ServiceBuild): ServiceBuild;
}
export interface AliasedPortMutatingHookProps {
    /**
     * The name by which to refer to this port mapping.
     */
    readonly portMappingName: string;
    /**
     * The port on the container which receives traffic. This is the same as the `containerPort` property of port mapping.
     */
    readonly aliasPort: number;
    /**
     * The protocol which this port mapping expects to receive.
     *
     * @default - none
     */
    readonly protocol?: ecs.AppProtocol;
}
/**
 * This hook modifies the application container's settings so that
 * its primary port mapping has a name.
 */
export declare class AliasedPortMutatingHook extends ContainerMutatingHook {
    private portMappingName;
    private portMappingProtocol?;
    private aliasPort;
    constructor(props: AliasedPortMutatingHookProps);
    mutateContainerDefinition(props: ecs.ContainerDefinitionOptions): ecs.ContainerDefinitionOptions;
}
