"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssignPublicIpExtension = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("aws-cdk-lib/aws-ec2");
const task_record_manager_1 = require("./task-record-manager");
const extension_interfaces_1 = require("../extension-interfaces");
/**
 * Modifies the service to assign a public ip to each task and optionally
 * exposes public IPs in a Route 53 record set.
 *
 * Note: If you want to change the DNS zone or record name, you will need to
 * remove this extension completely and then re-add it.
 */
class AssignPublicIpExtension extends extension_interfaces_1.ServiceExtension {
    constructor(options) {
        super('public-ip');
        this.dns = options?.dns;
    }
    hasDns() {
        return Boolean(this.dns);
    }
    prehook(service, _scope) {
        super.prehook(service, _scope);
        if (service.capacityType != extension_interfaces_1.EnvironmentCapacityType.FARGATE) {
            throw new Error('AssignPublicIp only supports Fargate tasks');
        }
    }
    modifyServiceProps(props) {
        return {
            ...props,
            assignPublicIp: true,
        };
    }
    useService(service) {
        if (this.hasDns()) {
            new task_record_manager_1.TaskRecordManager(service, 'TaskRecordManager', {
                service: service,
                dnsZone: this.dns.zone,
                dnsRecordName: this.dns.recordName,
            });
            const container = this.parentService.serviceDescription.get('service-container');
            service.connections.allowFromAnyIpv4(ec2.Port.tcp(container.trafficPort), 'Accept inbound traffic on traffic port from anywhere');
        }
    }
}
exports.AssignPublicIpExtension = AssignPublicIpExtension;
_a = JSII_RTTI_SYMBOL_1;
AssignPublicIpExtension[_a] = { fqn: "@aws-cdk-containers/ecs-service-extensions.AssignPublicIpExtension", version: "2.0.1-alpha.275" };
//# sourceMappingURL=data:application/json;base64,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