"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceDescription = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * A ServiceDescription is a wrapper for all of the extensions that a user wants
 * to add to an ECS Service. It collects all of the extensions that are added
 * to a service, allowing each extension to query the full list of extensions
 * added to a service to determine information about how to self-configure.
 */
class ServiceDescription {
    constructor() {
        /**
         * The list of extensions that have been registered to run when
         * preparing this service.
         */
        this.extensions = {};
    }
    /**
     * Adds a new extension to the service. The extensions mutate a service
     * to add resources to or configure properties for the service.
     *
     * @param extension - The extension that you wish to add
     */
    add(extension) {
        if (this.extensions[extension.name]) {
            throw new Error(`An extension called ${extension.name} has already been added`);
        }
        this.extensions[extension.name] = extension;
        return this;
    }
    /**
     * Get the extension with a specific name. This is generally used by
     * extensions in order to discover each other.
     *
     * @param name
     */
    get(name) {
        return this.extensions[name];
    }
}
exports.ServiceDescription = ServiceDescription;
_a = JSII_RTTI_SYMBOL_1;
ServiceDescription[_a] = { fqn: "@aws-cdk-containers/ecs-service-extensions.ServiceDescription", version: "2.0.1-alpha.275" };
;
//# sourceMappingURL=data:application/json;base64,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