
# Vespa CLI - distributed as python package

<picture>
  <source media="(prefers-color-scheme: dark)" srcset="https://assets.vespa.ai/logos/Vespa-logo-green-RGB.svg">
  <source media="(prefers-color-scheme: light)" srcset="https://assets.vespa.ai/logos/Vespa-logo-dark-RGB.svg">
  <img alt="#Vespa" width="200" src="https://assets.vespa.ai/logos/Vespa-logo-dark-RGB.svg" style="margin-bottom: 25px;">
</picture>

[![image](https://img.shields.io/pypi/v/vespacli.svg)](https://pypi.python.org/pypi/vespacli)
[![image](https://img.shields.io/pypi/l/vespacli.svg)](https://pypi.python.org/pypi/vespacli)
![CI/CD](https://github.com/thomasht86/vespacli/actions/workflows/cross_platform_tests.yml/badge.svg)

Vespa CLI binaries are distributed as part of the Vespa engine. Docs and installation instructions can be found in the [Vespa documentation](https://docs.vespa.ai/en/vespa-cli.html).

By providing the Vespa CLI as a Python package, it is even easier to use Vespa in Python environments.
It lets you add it to python dependencies, and it is installed in the same way as other python packages, and automatically added to the PATH.

- ❓ As a Python user, moving between different environments and handling dependencies, and PATHS can be cumbersome.

- 🚀 Installation is as simple as running `pip install vespacli`.

- 🔁 The Github Action perform a daily check for new releases of the Vespa CLI. If a new version is found, the python package is updated and a new release is made.

- 🖥️ Works on Windows, Linux and MacOS.

## Usage

For usage of the Vespa CLI, see the [Vespa documentation](https://docs.vespa.ai/en/vespa-cli.html).
