!!! warning
    This page is under construction. The content may be incomplete or incorrect. Submit an issue
    on [GitHub](https://github.com/QuEraComputing/kirin/issues/new) if you need help or want to
    contribute.


# Compiler 101 for scientists

In this section, we cover some common compiler concepts that are useful to know when working with Kirin.

## Computational Graph

For those familiar with automatic differentiation and neutral networks. Many may be also familiar with the concept of computational graph. In the context of automatic differentiation, a computational graph is a directed async graph (DAG) that represents the computation of a function. Each node in the graph represents an operation, and each edge represents the flow of data between operations. The graph is constructed by tracing the operations performed on the input data.

Due to the fact that every edge in computational graph represents a data dependency, the "variables" (a.k.a the edges) are assigned a value only once. This is also known as the Static Single Assignment (SSA) form.

Further readings:

- [PyTorch Computational Graph](https://pytorch.org/blog/computational-graphs-constructed-in-pytorch/)
- [A Gentle Introduction to Tensors and Computational Graphs](https://medium.com/@ofelipefernandez/gentle-introduction-to-tensors-and-computational-graphs-in-neural-networks-929b5b0ddc5f)

## Static Single Assignment (SSA) Form

Kirin IR is in Static Single Assignment (SSA) form. This means that each variable is assigned only once. This makes it easier to reason about the program and allows for more optimizations such as dead code elimination, control flow graph (CFG) simplification and constant propagation. More specifically when you see variables starting with `%`, you are looking at the SSA form of the program.

Further readings:

- [Understanding static single assignment forms](https://blog.yossarian.net/2020/10/23/Understanding-static-single-assignment-forms)
- [CS6120 Lecture 6: Static Single Assignment](https://www.cs.cornell.edu/courses/cs6120/2022sp/lesson/6/)

## What is purity?

A function is said to be pure if it has no side effects. In other word, a pure function is a function that only depends on its input arguments and produces a result. This means that the function does not modify any state outside of its scope. This is useful because it allows the compiler to optimize the function more aggressively.
