# This file is generated by gen.py
import math

from kirin.interp import Frame, MethodTable, impl
from kirin.dialects.math import stmts
from kirin.dialects.math.dialect import dialect


@dialect.register
class MathMethodTable(MethodTable):

    @impl(stmts.acos)
    def acos(self, interp, frame: Frame, stmt: stmts.acos):
        values = frame.get_values(stmt.args)
        return (math.acos(values[0]),)

    @impl(stmts.asin)
    def asin(self, interp, frame: Frame, stmt: stmts.asin):
        values = frame.get_values(stmt.args)
        return (math.asin(values[0]),)

    @impl(stmts.asinh)
    def asinh(self, interp, frame: Frame, stmt: stmts.asinh):
        values = frame.get_values(stmt.args)
        return (math.asinh(values[0]),)

    @impl(stmts.atan)
    def atan(self, interp, frame: Frame, stmt: stmts.atan):
        values = frame.get_values(stmt.args)
        return (math.atan(values[0]),)

    @impl(stmts.atan2)
    def atan2(self, interp, frame: Frame, stmt: stmts.atan2):
        values = frame.get_values(stmt.args)
        return (math.atan2(values[0], values[1]),)

    @impl(stmts.atanh)
    def atanh(self, interp, frame: Frame, stmt: stmts.atanh):
        values = frame.get_values(stmt.args)
        return (math.atanh(values[0]),)

    @impl(stmts.ceil)
    def ceil(self, interp, frame: Frame, stmt: stmts.ceil):
        values = frame.get_values(stmt.args)
        return (math.ceil(values[0]),)

    @impl(stmts.copysign)
    def copysign(self, interp, frame: Frame, stmt: stmts.copysign):
        values = frame.get_values(stmt.args)
        return (math.copysign(values[0], values[1]),)

    @impl(stmts.cos)
    def cos(self, interp, frame: Frame, stmt: stmts.cos):
        values = frame.get_values(stmt.args)
        return (math.cos(values[0]),)

    @impl(stmts.cosh)
    def cosh(self, interp, frame: Frame, stmt: stmts.cosh):
        values = frame.get_values(stmt.args)
        return (math.cosh(values[0]),)

    @impl(stmts.degrees)
    def degrees(self, interp, frame: Frame, stmt: stmts.degrees):
        values = frame.get_values(stmt.args)
        return (math.degrees(values[0]),)

    @impl(stmts.erf)
    def erf(self, interp, frame: Frame, stmt: stmts.erf):
        values = frame.get_values(stmt.args)
        return (math.erf(values[0]),)

    @impl(stmts.erfc)
    def erfc(self, interp, frame: Frame, stmt: stmts.erfc):
        values = frame.get_values(stmt.args)
        return (math.erfc(values[0]),)

    @impl(stmts.exp)
    def exp(self, interp, frame: Frame, stmt: stmts.exp):
        values = frame.get_values(stmt.args)
        return (math.exp(values[0]),)

    @impl(stmts.expm1)
    def expm1(self, interp, frame: Frame, stmt: stmts.expm1):
        values = frame.get_values(stmt.args)
        return (math.expm1(values[0]),)

    @impl(stmts.fabs)
    def fabs(self, interp, frame: Frame, stmt: stmts.fabs):
        values = frame.get_values(stmt.args)
        return (math.fabs(values[0]),)

    @impl(stmts.floor)
    def floor(self, interp, frame: Frame, stmt: stmts.floor):
        values = frame.get_values(stmt.args)
        return (math.floor(values[0]),)

    @impl(stmts.fmod)
    def fmod(self, interp, frame: Frame, stmt: stmts.fmod):
        values = frame.get_values(stmt.args)
        return (math.fmod(values[0], values[1]),)

    @impl(stmts.gamma)
    def gamma(self, interp, frame: Frame, stmt: stmts.gamma):
        values = frame.get_values(stmt.args)
        return (math.gamma(values[0]),)

    @impl(stmts.isfinite)
    def isfinite(self, interp, frame: Frame, stmt: stmts.isfinite):
        values = frame.get_values(stmt.args)
        return (math.isfinite(values[0]),)

    @impl(stmts.isinf)
    def isinf(self, interp, frame: Frame, stmt: stmts.isinf):
        values = frame.get_values(stmt.args)
        return (math.isinf(values[0]),)

    @impl(stmts.isnan)
    def isnan(self, interp, frame: Frame, stmt: stmts.isnan):
        values = frame.get_values(stmt.args)
        return (math.isnan(values[0]),)

    @impl(stmts.lgamma)
    def lgamma(self, interp, frame: Frame, stmt: stmts.lgamma):
        values = frame.get_values(stmt.args)
        return (math.lgamma(values[0]),)

    @impl(stmts.log10)
    def log10(self, interp, frame: Frame, stmt: stmts.log10):
        values = frame.get_values(stmt.args)
        return (math.log10(values[0]),)

    @impl(stmts.log1p)
    def log1p(self, interp, frame: Frame, stmt: stmts.log1p):
        values = frame.get_values(stmt.args)
        return (math.log1p(values[0]),)

    @impl(stmts.log2)
    def log2(self, interp, frame: Frame, stmt: stmts.log2):
        values = frame.get_values(stmt.args)
        return (math.log2(values[0]),)

    @impl(stmts.pow)
    def pow(self, interp, frame: Frame, stmt: stmts.pow):
        values = frame.get_values(stmt.args)
        return (math.pow(values[0], values[1]),)

    @impl(stmts.radians)
    def radians(self, interp, frame: Frame, stmt: stmts.radians):
        values = frame.get_values(stmt.args)
        return (math.radians(values[0]),)

    @impl(stmts.remainder)
    def remainder(self, interp, frame: Frame, stmt: stmts.remainder):
        values = frame.get_values(stmt.args)
        return (math.remainder(values[0], values[1]),)

    @impl(stmts.sin)
    def sin(self, interp, frame: Frame, stmt: stmts.sin):
        values = frame.get_values(stmt.args)
        return (math.sin(values[0]),)

    @impl(stmts.sinh)
    def sinh(self, interp, frame: Frame, stmt: stmts.sinh):
        values = frame.get_values(stmt.args)
        return (math.sinh(values[0]),)

    @impl(stmts.sqrt)
    def sqrt(self, interp, frame: Frame, stmt: stmts.sqrt):
        values = frame.get_values(stmt.args)
        return (math.sqrt(values[0]),)

    @impl(stmts.tan)
    def tan(self, interp, frame: Frame, stmt: stmts.tan):
        values = frame.get_values(stmt.args)
        return (math.tan(values[0]),)

    @impl(stmts.tanh)
    def tanh(self, interp, frame: Frame, stmt: stmts.tanh):
        values = frame.get_values(stmt.args)
        return (math.tanh(values[0]),)

    @impl(stmts.trunc)
    def trunc(self, interp, frame: Frame, stmt: stmts.trunc):
        values = frame.get_values(stmt.args)
        return (math.trunc(values[0]),)

    @impl(stmts.ulp)
    def ulp(self, interp, frame: Frame, stmt: stmts.ulp):
        values = frame.get_values(stmt.args)
        return (math.ulp(values[0]),)
