# This file was auto-generated by Fern from our API Definition.

import typing
import urllib.parse
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.jsonable_encoder import jsonable_encoder
from ...core.remove_none_from_dict import remove_none_from_dict
from ...errors.unprocessable_entity_error import UnprocessableEntityError
from ...types.classifier_rule import ClassifierRule
from ...types.classify_job import ClassifyJob
from ...types.classify_job_results import ClassifyJobResults
from ...types.classify_parsing_configuration import ClassifyParsingConfiguration
from ...types.http_validation_error import HttpValidationError
from ...types.paginated_response_classify_job import PaginatedResponseClassifyJob

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ClassifierClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list_classify_jobs(
        self,
        *,
        project_id: typing.Optional[str] = None,
        organization_id: typing.Optional[str] = None,
        page_size: typing.Optional[int] = None,
        page_token: typing.Optional[str] = None,
    ) -> PaginatedResponseClassifyJob:
        """
        List classify jobs.
        Experimental: This endpoint is not yet ready for production use and is subject to change at any time.

        Parameters:
            - project_id: typing.Optional[str].

            - organization_id: typing.Optional[str].

            - page_size: typing.Optional[int].

            - page_token: typing.Optional[str].
        ---
        from llama_cloud.client import LlamaCloud

        client = LlamaCloud(
            token="YOUR_TOKEN",
        )
        client.classifier.list_classify_jobs()
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "api/v1/classifier/jobs"),
            params=remove_none_from_dict(
                {
                    "project_id": project_id,
                    "organization_id": organization_id,
                    "page_size": page_size,
                    "page_token": page_token,
                }
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(PaginatedResponseClassifyJob, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_classify_job(
        self,
        *,
        project_id: typing.Optional[str] = None,
        organization_id: typing.Optional[str] = None,
        rules: typing.List[ClassifierRule],
        file_ids: typing.List[str],
        parsing_configuration: typing.Optional[ClassifyParsingConfiguration] = OMIT,
    ) -> ClassifyJob:
        """
        Create a classify job.
        Experimental: This endpoint is not yet ready for production use and is subject to change at any time.

        Parameters:
            - project_id: typing.Optional[str].

            - organization_id: typing.Optional[str].

            - rules: typing.List[ClassifierRule]. The rules to classify the files

            - file_ids: typing.List[str]. The IDs of the files to classify

            - parsing_configuration: typing.Optional[ClassifyParsingConfiguration]. The configuration for the parsing job
        ---
        from llama_cloud import ClassifyParsingConfiguration, ParserLanguages
        from llama_cloud.client import LlamaCloud

        client = LlamaCloud(
            token="YOUR_TOKEN",
        )
        client.classifier.create_classify_job(
            rules=[],
            file_ids=[],
            parsing_configuration=ClassifyParsingConfiguration(
                lang=ParserLanguages.AF,
            ),
        )
        """
        _request: typing.Dict[str, typing.Any] = {"rules": rules, "file_ids": file_ids}
        if parsing_configuration is not OMIT:
            _request["parsing_configuration"] = parsing_configuration
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "api/v1/classifier/jobs"),
            params=remove_none_from_dict({"project_id": project_id, "organization_id": organization_id}),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(ClassifyJob, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_classify_job(
        self,
        classify_job_id: str,
        *,
        project_id: typing.Optional[str] = None,
        organization_id: typing.Optional[str] = None,
    ) -> ClassifyJob:
        """
        Get a classify job.
        Experimental: This endpoint is not yet ready for production use and is subject to change at any time.

        Parameters:
            - classify_job_id: str.

            - project_id: typing.Optional[str].

            - organization_id: typing.Optional[str].
        ---
        from llama_cloud.client import LlamaCloud

        client = LlamaCloud(
            token="YOUR_TOKEN",
        )
        client.classifier.get_classify_job(
            classify_job_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"api/v1/classifier/jobs/{classify_job_id}"
            ),
            params=remove_none_from_dict({"project_id": project_id, "organization_id": organization_id}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(ClassifyJob, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_classification_job_results(
        self,
        classify_job_id: str,
        *,
        project_id: typing.Optional[str] = None,
        organization_id: typing.Optional[str] = None,
    ) -> ClassifyJobResults:
        """
        Get the results of a classify job.
        Experimental: This endpoint is not yet ready for production use and is subject to change at any time.

        Parameters:
            - classify_job_id: str.

            - project_id: typing.Optional[str].

            - organization_id: typing.Optional[str].
        ---
        from llama_cloud.client import LlamaCloud

        client = LlamaCloud(
            token="YOUR_TOKEN",
        )
        client.classifier.get_classification_job_results(
            classify_job_id="string",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"api/v1/classifier/jobs/{classify_job_id}/results"
            ),
            params=remove_none_from_dict({"project_id": project_id, "organization_id": organization_id}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(ClassifyJobResults, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncClassifierClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list_classify_jobs(
        self,
        *,
        project_id: typing.Optional[str] = None,
        organization_id: typing.Optional[str] = None,
        page_size: typing.Optional[int] = None,
        page_token: typing.Optional[str] = None,
    ) -> PaginatedResponseClassifyJob:
        """
        List classify jobs.
        Experimental: This endpoint is not yet ready for production use and is subject to change at any time.

        Parameters:
            - project_id: typing.Optional[str].

            - organization_id: typing.Optional[str].

            - page_size: typing.Optional[int].

            - page_token: typing.Optional[str].
        ---
        from llama_cloud.client import AsyncLlamaCloud

        client = AsyncLlamaCloud(
            token="YOUR_TOKEN",
        )
        await client.classifier.list_classify_jobs()
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "api/v1/classifier/jobs"),
            params=remove_none_from_dict(
                {
                    "project_id": project_id,
                    "organization_id": organization_id,
                    "page_size": page_size,
                    "page_token": page_token,
                }
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(PaginatedResponseClassifyJob, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_classify_job(
        self,
        *,
        project_id: typing.Optional[str] = None,
        organization_id: typing.Optional[str] = None,
        rules: typing.List[ClassifierRule],
        file_ids: typing.List[str],
        parsing_configuration: typing.Optional[ClassifyParsingConfiguration] = OMIT,
    ) -> ClassifyJob:
        """
        Create a classify job.
        Experimental: This endpoint is not yet ready for production use and is subject to change at any time.

        Parameters:
            - project_id: typing.Optional[str].

            - organization_id: typing.Optional[str].

            - rules: typing.List[ClassifierRule]. The rules to classify the files

            - file_ids: typing.List[str]. The IDs of the files to classify

            - parsing_configuration: typing.Optional[ClassifyParsingConfiguration]. The configuration for the parsing job
        ---
        from llama_cloud import ClassifyParsingConfiguration, ParserLanguages
        from llama_cloud.client import AsyncLlamaCloud

        client = AsyncLlamaCloud(
            token="YOUR_TOKEN",
        )
        await client.classifier.create_classify_job(
            rules=[],
            file_ids=[],
            parsing_configuration=ClassifyParsingConfiguration(
                lang=ParserLanguages.AF,
            ),
        )
        """
        _request: typing.Dict[str, typing.Any] = {"rules": rules, "file_ids": file_ids}
        if parsing_configuration is not OMIT:
            _request["parsing_configuration"] = parsing_configuration
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "api/v1/classifier/jobs"),
            params=remove_none_from_dict({"project_id": project_id, "organization_id": organization_id}),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(ClassifyJob, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_classify_job(
        self,
        classify_job_id: str,
        *,
        project_id: typing.Optional[str] = None,
        organization_id: typing.Optional[str] = None,
    ) -> ClassifyJob:
        """
        Get a classify job.
        Experimental: This endpoint is not yet ready for production use and is subject to change at any time.

        Parameters:
            - classify_job_id: str.

            - project_id: typing.Optional[str].

            - organization_id: typing.Optional[str].
        ---
        from llama_cloud.client import AsyncLlamaCloud

        client = AsyncLlamaCloud(
            token="YOUR_TOKEN",
        )
        await client.classifier.get_classify_job(
            classify_job_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"api/v1/classifier/jobs/{classify_job_id}"
            ),
            params=remove_none_from_dict({"project_id": project_id, "organization_id": organization_id}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(ClassifyJob, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_classification_job_results(
        self,
        classify_job_id: str,
        *,
        project_id: typing.Optional[str] = None,
        organization_id: typing.Optional[str] = None,
    ) -> ClassifyJobResults:
        """
        Get the results of a classify job.
        Experimental: This endpoint is not yet ready for production use and is subject to change at any time.

        Parameters:
            - classify_job_id: str.

            - project_id: typing.Optional[str].

            - organization_id: typing.Optional[str].
        ---
        from llama_cloud.client import AsyncLlamaCloud

        client = AsyncLlamaCloud(
            token="YOUR_TOKEN",
        )
        await client.classifier.get_classification_job_results(
            classify_job_id="string",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"api/v1/classifier/jobs/{classify_job_id}/results"
            ),
            params=remove_none_from_dict({"project_id": project_id, "organization_id": organization_id}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(ClassifyJobResults, _response.json())  # type: ignore
        if _response.status_code == 422:
            raise UnprocessableEntityError(pydantic.parse_obj_as(HttpValidationError, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
