# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class ClassifierRule(pydantic.BaseModel):
    """
    A rule for classifying documents - v0 simplified version.

    This represents a single classification rule that will be applied to documents.
    All rules are content-based and use natural language descriptions.
    """

    type: str = pydantic.Field(
        description="The document type to assign when this rule matches (e.g., 'invoice', 'receipt', 'contract')"
    )
    description: str = pydantic.Field(
        description="Natural language description of what to classify. Be specific about the content characteristics that identify this document type."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
