# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .classifier_rule import ClassifierRule
from .classify_parsing_configuration import ClassifyParsingConfiguration
from .status_enum import StatusEnum

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class ClassifyJob(pydantic.BaseModel):
    """
    A classify job.
    """

    id: str = pydantic.Field(description="Unique identifier")
    created_at: typing.Optional[dt.datetime]
    updated_at: typing.Optional[dt.datetime]
    rules: typing.List[ClassifierRule] = pydantic.Field(description="The rules to classify the files")
    user_id: str = pydantic.Field(description="The ID of the user")
    project_id: str = pydantic.Field(description="The ID of the project")
    status: StatusEnum = pydantic.Field(description="The status of the classify job")
    parsing_configuration: typing.Optional[ClassifyParsingConfiguration] = pydantic.Field(
        description="The configuration for the parsing job"
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
