# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class CloudAstraDbVectorStore(pydantic.BaseModel):
    """
    Cloud AstraDB Vector Store.

    This class is used to store the configuration for an AstraDB vector store, so that it can be
    created and used in LlamaCloud.

    Args:
    token (str): The Astra DB Application Token to use.
    api_endpoint (str): The Astra DB JSON API endpoint for your database.
    collection_name (str): Collection name to use. If not existing, it will be created.
    embedding_dimension (int): Length of the embedding vectors in use.
    keyspace (optional[str]): The keyspace to use. If not provided, 'default_keyspace'
    """

    supports_nested_metadata_filters: typing.Optional[bool]
    token: str = pydantic.Field(description="The Astra DB Application Token to use")
    api_endpoint: str = pydantic.Field(description="The Astra DB JSON API endpoint for your database")
    collection_name: str = pydantic.Field(description="Collection name to use. If not existing, it will be created")
    embedding_dimension: int = pydantic.Field(description="Length of the embedding vectors in use")
    keyspace: typing.Optional[str]
    class_name: typing.Optional[str]

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
