# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .cloud_jira_data_source_v_2_api_version import CloudJiraDataSourceV2ApiVersion

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class CloudJiraDataSourceV2(pydantic.BaseModel):
    """
    Cloud Jira Data Source integrating JiraReaderV2.
    """

    supports_access_control: typing.Optional[bool]
    email: typing.Optional[str]
    api_token: typing.Optional[str]
    server_url: str = pydantic.Field(description="The server url for Jira Cloud.")
    cloud_id: typing.Optional[str]
    authentication_mechanism: str = pydantic.Field(description="Type of Authentication for connecting to Jira APIs.")
    api_version: typing.Optional[CloudJiraDataSourceV2ApiVersion] = pydantic.Field(
        description="Jira REST API version to use (2 or 3). 3 supports Atlassian Document Format (ADF)."
    )
    query: str = pydantic.Field(description="JQL (Jira Query Language) query to search.")
    fields: typing.Optional[typing.List[str]]
    expand: typing.Optional[str]
    requests_per_minute: typing.Optional[int]
    get_permissions: typing.Optional[bool] = pydantic.Field(
        description="Whether to fetch project role permissions and issue-level security"
    )
    class_name: typing.Optional[str]

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
