# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class CloudMongoDbAtlasVectorSearch(pydantic.BaseModel):
    """
    Cloud MongoDB Atlas Vector Store.

    This class is used to store the configuration for a MongoDB Atlas vector store,
    so that it can be created and used in LlamaCloud.

    Args:
    mongodb_uri (str): URI for connecting to MongoDB Atlas
    db_name (str): name of the MongoDB database
    collection_name (str): name of the MongoDB collection
    vector_index_name (str): name of the MongoDB Atlas vector index
    fulltext_index_name (str): name of the MongoDB Atlas full-text index
    """

    supports_nested_metadata_filters: typing.Optional[bool]
    mongodb_uri: str
    db_name: str
    collection_name: str
    vector_index_name: typing.Optional[str]
    fulltext_index_name: typing.Optional[str]
    embedding_dimension: typing.Optional[int]
    class_name: typing.Optional[str]

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
