# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class CloudSlackDataSource(pydantic.BaseModel):
    supports_access_control: typing.Optional[bool]
    slack_token: str = pydantic.Field(description="Slack Bot Token.")
    channel_ids: typing.Optional[str]
    latest_date: typing.Optional[str]
    earliest_date: typing.Optional[str]
    earliest_date_timestamp: typing.Optional[float]
    latest_date_timestamp: typing.Optional[float]
    channel_patterns: typing.Optional[str]
    class_name: typing.Optional[str]

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
