# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .supported_llm_model_names import SupportedLlmModelNames

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class EvalExecutionParams(pydantic.BaseModel):
    """
    Schema for the params for an eval execution.
    """

    llm_model: typing.Optional[SupportedLlmModelNames] = pydantic.Field(
        description="The LLM model to use within eval execution."
    )
    qa_prompt_tmpl: typing.Optional[str] = pydantic.Field(
        description="The template to use for the question answering prompt."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
