# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .extract_agent import ExtractAgent
from .file import File
from .status_enum import StatusEnum

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class ExtractJob(pydantic.BaseModel):
    id: str = pydantic.Field(description="The id of the extraction job")
    extraction_agent: ExtractAgent = pydantic.Field(description="The agent that the job was run on.")
    status: StatusEnum = pydantic.Field(description="The status of the extraction job")
    error: typing.Optional[str]
    file: File = pydantic.Field(description="The file that the extract was extracted from")

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
