# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime
from .file_create_permission_info_value import FileCreatePermissionInfoValue
from .file_create_resource_info_value import FileCreateResourceInfoValue

try:
    import pydantic
    if pydantic.__version__.startswith("1."):
        raise ImportError
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class FileCreate(pydantic.BaseModel):
    name: str = pydantic.Field(
        description="Name that will be used for created file. If possible, always include the file extension in the name."
    )
    external_file_id: typing.Optional[str]
    file_size: typing.Optional[int]
    last_modified_at: typing.Optional[dt.datetime]
    resource_info: typing.Optional[typing.Dict[str, typing.Optional[FileCreateResourceInfoValue]]]
    permission_info: typing.Optional[typing.Dict[str, typing.Optional[FileCreatePermissionInfoValue]]]
    data_source_id: typing.Optional[str]

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}
