from __future__ import annotations

import ast
from typing import Final
from urllib.parse import urljoin

from requests import Response

from ..core.entry import SignInEntry
from ..base.request import check_network_state, NetworkState
from ..base.sign_in import check_final_state, SignState, Work
from ..schema.xbt import XBT


class MainClass(XBT):
    URL: Final = 'https://abtorrents.me/'
    USER_CLASSES: Final = {
        'uploaded': [536870912000],
        'share_ratio': [1.5],
        'days': [90],
    }

    def sign_in_build_login_workflow(self, entry, config: dict) -> list[Work]:
        return [
            Work(
                url='/login.php?returnto=%2F',
                method=self.sign_in_by_get,
                assert_state=(check_network_state, NetworkState.SUCCEED),
            ),
            Work(
                url='/simpleCaptcha.php',
                method=self.sign_in_by_get,
                assert_state=(check_network_state, NetworkState.SUCCEED),
            ),
            Work(
                url='/takelogin.php',
                method=self.sign_in_by_login,
                succeed_regex=['Logout'],
                assert_state=(check_final_state, SignState.SUCCEED),
                is_base_content=True,
                response_urls=['/']
            )
        ]

    def sign_in_by_login(self, entry: SignInEntry, config: dict, work: Work, last_content: str) -> Response | None:
        if not (login := entry['site_config'].get('login')):
            entry.fail_with_prefix('Login data not found!')
            return None
        last_content_json = ast.literal_eval(last_content)
        target = {
            'light bulb': b'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\x00\x00\x000\x08\x03\x00\x00\x00`\xdc\t\xb5\x00\x00\x00\x19tEXtSoftware\x00Adobe ImageReadyq\xc9e<\x00\x00\x00\x9cPLTEGpL\xd0z\x00\xd0z\x00\x99\x99\x99\xd1{\x00\xd0z\x00\xd0z\x00\x99\x99\x99\xd0z\x00\xd0z\x00\xd0z\x00\xf7\xa9%\xf8\xad*\x99\x99\x99\xcc\xcc\xcc\xf7\xa6"\xf6\x9c\x17\xfd\xd6]\xf7\xb2,\xf8\xb72\xf7\xa3\x1e\xfa\xc6D\xf7\xa0\x1d\xfe\xdbd\xfa\xbc7\xfb\xcdP\xf5\x97\x12\xfc\xd0W\xfc\xc4K\xfe\xdfl\xc2\xc2\xc2\xf8\xbf<\xf9\xb13\xfb\xb9?\xfb\xc4<\xec\xec\xec\xba\xba\xba\xe1\xe1\xe1\xd7\xd7\xd7\xae\xae\xae\xff\xff\xff\xff\xe5v\xdb\x83\x05\xfd\xebV\xff\xd5E\xdf\x9c\x18\xfb\xe2L\xf5\x8e\t\xdb\x8b\x0c\xea\x8e\x0c\xeb\x9d\x1c\xff\xfa]\x9d^\x95\xf1\x00\x00\x00\x0btRNS\x00?\x92@\xfef\xe4\x94\x83\xc9\x9c\xc0v{\x81\x00\x00\x02\x18IDATH\xc7\xcd\x96\xdb\x9a\x9a0\x14F\xd5A M\x90\xf3I\x98\t2mi9\xa3\xef\xffn\xdd;8\x0e\xfa\x05a\xae\xa6\xeb\xc3\x0b\xe0_\xec\x1db\xa2\x9b\xcdw\xb0\xd5\x89\xaa(*\xd1\xb7\xab\xe2\xba\xda\xf0\xb6\xba\\\xaa\xd6mT}1\xbe\'Nu\xa9B;\x89k\xb0\xaa\x86\xec\x17\x1e\xdf\xb7\x90\x06\x928\x8e}\xbf\xae\xda\xfei\x91]S\x85\x02a\xf8`\xd4m\xb3{\xf2|\xc8\xdb\xe1+\x00\x86\x10r\x1f\x8c\xd9\x1a\xfb\xbe\xb5\xc7<\x1a\t\x089P\xd7\xfd\xdc8Hn\' \xfc\x05>\x04\xcey^s2S\xa0\xa9\xe3{\x01\xf3h4\xf2\x12Jt\'\xc0\x188\x8f\x90\xdcU\xa4\xf3\xdb\xe7\xbe/\x8c\xd7[\x01\x8c\xbb`\xf4\xb29\xd7\xcf9\xf7\xd3D\x0c\x1b\xf3\xa9\xcf#w$:\xcb^\x14\xa1Q\x04\x06\xd4\x10\xf36\xc9\xbb\x11\x95\r[ep\x07\x8d8\x81I\x13y\xe7\x8a\xcbT\xd9\x98\xf1\x8e\xcb\xb9/\xc0\xc7;\x9f\xc8F\xad0\xc0\xc1*\'~\xc28\x9b \x13T\x93R\n\x8a\x93\xb9n\x86i\xca\xe8\xf5\xa0\xa6\xac%r\xa6#\xf8Dz\xcfY6\xe8\xdd`\xde\xc0\x909a\x90\xbd\xd6m\xe9}0\x1a\xf4v\xee\x95\xd2\xc5\xaaX\xc1\x88gR\xd1\x95\xe9]\xcf\xcfdf\xb5Y\x96\x15\xc0\xe1A>\xcb\x18\x03A\\\xb0\xca\x99\xef\xb7r\xb4\x10\x102\x84Q\x14\x80\x81\xcc-\xa0\xf2\x08X\x81\xc9\xb2\x13\x9013\xb0\xf0\x8a2\xbb\x11\xe8\xa5\x10(\xe4S4h\x80\xf9\xf2\xc96\xb0+Q\x80\x02)p\x15\xca\xdd\xb3m\x83\x0cG\xcbc\x90\x8fQ` \x0c\xca\xf3]R\xe9,\x0f\n$v\x92\xa4\'\xe6\x1d\xbbra\'\xfb1t\x01\n\xb0\x84@\x08\xba\xd974)\xd1\xd1Sj\x87!\x08A\xb7X`\xa3\x19\x0fh\x0b\x82\xf1\xfe\xe7\x8ewc\xb1B\xf16\xa1X\xac\x00\xc2aB\xb1\xa2\xa5\x07\xfe\x83\x96~=\xb0\xdc\x92Q\xfc\xbcQ,\xcf\x03(\xd0\xd3\xdba\xfc\x14\xda\x8a\x9f]\xe3\xf7\x04c\x85\xf0\xd9\xd4\xaa\x86\x04/\x1a\x941\xb4\x97/\xfc{0\x0e\x07c\xf3\x15\xb4\xd5\xdd,\xf2\x0f\xa8`W(\x90\xd4\rZ\x00\x00\x00\x00IEND\xaeB`\x82',
            'house': b'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\x00\x00\x000\x08\x03\x00\x00\x00`\xdc\t\xb5\x00\x00\x00\x19tEXtSoftware\x00Adobe ImageReadyq\xc9e<\x00\x00\x00\xc3PLTEGpL\n[u\x99\x99\x99\x89\x9d\xa4\n[u\n[u\x99\x99\x99\n[u\x1dbyOw\x85\n[u\n[u*i}5n\x805m\x80\n[u\xe5\xe5\xe5\xea\xea\xea\xe1\xe1\xe1\xde\xde\xde\x99\x99\x99\xdc\xdc\xdc\xe7\xe7\xe7\xd9\xda\xda\xed\xed\xed\x15v\x96\x1c\x8c\xaf\x0fe\x81\x13n\x8b\x0b^x\xb2o4\x9e\x87z&\xaf\xd8\x1d\x93\xb8\x1f\x98\xbf\x17~\x9f\x1a\x84\xa6!\x9e\xc6\xbf\x80?\xd0\x93K\xa5`*\xd9\x9eR\x9dW#"\xa3\xcc$\xa7\xd1\x98\x82u(\xb8\xe5/\xcf\xfc,\xc5\xee\xc8\x8aEzcV\xde\xa4W\xff\xd2p\x83\xa9\xb5a\x92\xa2\xbc\xb7\xb5o\x9c\xaa\xff\xff\xff\xce\xd3\xd4M~\x8d\x98\xb5\xbe\xb7\xca\xd0\x9a\x9a\x9a\xff\xc0f2m\x7f9\xaf5\xfb\x00\x00\x00\x10tRNS\x00t\xe9\xf3\xb0\xe9\x8f\x8bF\x1fc\x9c\xaa\xd7\xd6\xd2\xbe`\xb9\x07\x00\x00\x02+IDATH\xc7\xc5\x96\x8b\x92\x9a0\x14@\xd5Q\x81\xb5\x0f@\x16MB\x1a\x82\xd8\xda\x15\x81>\x04\xeacw\xff\xff\xabJ\x08$\xc8\xcb\x9di\xa7=\x81\x19r\xef=I`\xe2\xc4\xd1\xe8\xbf3\xb7\x18\xf3{e\xeab\xa1\xf2\'\xeb\x17\xc3\xbaS?\xc6\xae\x8b\xc7\\X3\xee\x08\x8a\x13GQ\xec(o\x14\xd4)\x8c\xa20\x8c"8\xcd\x97e\x19\x8c!a\x8c\xdc(\x0es\xe2\xc8E\xe3\x91e3\xfa\x05M\x01q\x1c\xba\x05a\x1c\x03\xc5\xd2\x19V\xffrhT\x96\x17JD_/f\x8e\xd5\xbf\x9c\xd8\rj\xe4]\x94-\x97\xcbnA[\x800\x0c\xf67\x04a\x08\x92\xd3c\xa7\xf0\x80i\xe8n[\xb8!\xc5\x97.\xe1\x1d\xda\xbb[\xaf\x84\x02\x87V\xcf[w\x8f\xce\xed\xb7}\x0f\xdc\xbdGK|\x94\x1d\xf1\xa6\xeay\xfb\x00|P\x9b\xcb\x81\x81\x07!\xa4\x90\x01\xf0e\xbd\xbe&N\xd5\xa7^\x00\xf1\xc3\xcd^@\xde\xb6H\xf9\xecF\x99Y\xec\x87\x0co`\x15\xddzH\xa9}|\xe0Q\xbf\xc2a\xc3s\xaegG\x84\xa9\x07\xa6j5<\xa4\xfe\xa6\x04\xa0l\xb56D\xcb0\xa82>\x85|\x921\x82\xfe\x06\x00\xc0n\xe0\xe0\xa3Qg}9#\xc0\x93\xb9\x02\x11{\x91\x19/\xe5\xe5\xc9\xc9h\xb0\xcc\xb0S\xe57\xe0c.`\xa7\x025\x86/9b$Jfu\x01\'W\xc3\xeeh\xc6*\xc1ua\x86\n0>\xe6\xd9\x0eX0\x9f\x84\xc3\x04\xa5\xe8\xe4\xc3\xdb\x03\\\x13^\xc5>\x93\x86\x19g\xbd\x1f[\xb7m\xfd\\\x94i\xfcG6\x9b\xaa\x96~\x07K\x9d\xce\x14Mn\x8e\xfbBc\xb7\xe6\x82Y^)\x11\xa42\xda\x12LS/.\xd3$/?K^H\x15\xd5\xcd\xb6PeL\xf2C@d\xb4c\x86\n\xf2U@d\xf4\xcf\x85\xa5\x80|\x11\x10\x19m\x0bf\xd9n\x05\x11\x1d\x9a\xe1\x9b`h\x86G\x01\xf9, 2\xfaW\x85O\x82\xb7\t\x07)\x1c\x06\x84\x95@\n;"\xa3C\xc2Np\xe8\x17&\xa7\xba\xf0\xb4\xe3\xb7\x14N\x93\xe6\xf9\x9dJ\xe1I \x85\xb4y\xb4k\xcf\xe9\xa9_8\xa5\xcfZ\xeb\xf8\x99O,\xce\xe1\xbb\xe0P\x86&s\xed\xdf\xfdY\xf9\r\xe0m\x99\xfb\xc4aP\x89\x00\x00\x00\x00IEND\xaeB`\x82',
            'musical note': b'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\x00\x00\x000\x08\x03\x00\x00\x00`\xdc\t\xb5\x00\x00\x00\x19tEXtSoftware\x00Adobe ImageReadyq\xc9e<\x00\x00\x00oPLTEGpL\n[u\n[u\n[u\n[u\n[u\n[u\n[u\n[u\n[u\n[u\n[u\x13n\x8c\x14r\x91\x10e\x80\x12j\x86\x16w\x97\x17}\x9d(\xb2\xde\x1c\x8c\xb1\x0ea{#\xa3\xcc%\xaa\xd3\x19\x86\xa8)\xb6\xe3\x1d\x93\xb9\x18\x81\xa2\'\xaf\xda!\x9c\xc4&\xad\xd7*\xbb\xe9\x1f\x98\xbf-\xc9\xf95\xea\xff\x1e\xa1\xb51\xdb\xfc,\xce\xe4)\xcb7\xf0\x00\x00\x00\x0btRNS\x00\xcc"Y\x0f\xb4:\xddy\x97\xee\x7f\xdbj\x8c\x00\x00\x01\x95IDATH\xc7\xd5\x95\x81N\x830\x10\x86\xc7V\xb8\xd6\x83\xd2JY\xd7\x8a"\xd3\xf7\x7fF\x8fM\x94\x96\xd9\x9ahb\xfc\xc2\xb2\xf5\xbf\xfb\x80[\x13\xd8\xed\xfe#{^ \xf0\xefvW\x1c\xda\xf3\xeb\xf4\n\xdf\xea>\x08T\xe7\x97\xe9\xe5\xf9\xe9!/0.\xd0\x9e\xa7\xb9\x9bx\x84\\w\x89\xe7\xe34=S\xf7i>\x92\xc2<$\xdd6\x9d\xfa\xf4\xc11!\x886\xee\xce\x08H\xf7q\xba\x8fH\n\xf77\xe8S\xc2C\x84\xa7ORx\\\xd1\xfb\x16\xe7 )\x1c\x17\x9c7\xc0\xabK0\xe4\x85\xcec\xc9\xd9\x12$\x85\x9ehP\\\xbb\xdf\x83\x9c0B*\xd8\x08C,\x0cia\x18\x06\x07\xa9\xe0\xc7\xc28\x8e\x1d\xa4\x82Xp\xce\x85B\x1c\xfcX\xe8\xba\xceB*\xf8M\xe1\xc09?d\x05k\xad\x9f\xebU\x89\x8a~kt\xefAB\xd0T\xe7\xd2\x1d{\xda\x82~t\xd7\xe0K\xc1{Ou.\xa9\xd1/$\x05\xad\xb5\x02fl\xe7\xf5\x07\n\xbex.r\xbe\xbf\n\xbc\xb6Z\xa7\x05\x9a\xb1\xa6\x92D\xaf\x94\x82\xa2\xd1j\xcdV\xe0\xc6\x8e\x8e\xfe@\xd7\x91\xd0\x004A\x7f]n\xfa\xa5\xf5\xaa\xb90\x7f\x91\x10\xd0\xc6\x02C\xa5\x97bM\x07\x14u H\xbe\xb9\x80\xaa\xd7\x80\x90\xc1\x1a\xf7\x91P\xb4\xcd\xba\xde\x16\x15\xae\xd7R\xc4#@\x1b \xcb\x9d0\x9fK#\xd8F\x90\xa1@g\x14x\xcd\xa4A\xb1\xdd\x04\x90\x01f\x9e\xb1\x128\x03\x9c\xdd\xd8\xe3\xd2\x04\x02\xb2\xec\xcb\x127\x17\xc8 \xcc\'(X^`\x02\x97\xf6[3\xde|)\x97\x97\x19\xef8\xdb\xfd-o\xc4\xdb8 \xfcR[\xf5\x00\x00\x00\x00IEND\xaeB`\x82',
            'key': b'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\x00\x00\x000\x08\x03\x00\x00\x00`\xdc\t\xb5\x00\x00\x00\x19tEXtSoftware\x00Adobe ImageReadyq\xc9e<\x00\x00\x00cPLTEGpLEi\x05Ei\x05k\x92.Ei\x05Ei\x05Ei\x05\x99\x99\x99Ei\x05Ei\x05Sy\x13b\x8a$Mr\x0c\x97\xc2`t\x9c9\x99\x99\x99\xdd\xdd\xdd\x86\xafL}\xa6C\xe6\xe6\xe6\\\x83\x1eX~\x19\x8d\xb9P\xed\xed\xed\x93\xbd[\xb9\xedx\x8f\xb9X\xf0\xf0\xf0\xfe\xfe\xfe\xa8\xd8j\xbb\xbb\xbb\xc0\xc0\xc0\xc3\xc3\xc3\xe9\xea\xbc\x88\x00\x00\x00\ntRNS\x00\xae\xff\xff\xaa\x17\x84\x96\xecBp@\r\xa8\x00\x00\x01(IDATH\xc7\xbd\x94\xd1r\x83 \x10E\x134F\xad\xc8\n-\xa6X\xd2\xfc\xffW\x16\xac\xc5\xc0\x84\xecZ\xa7=\xbe\xed\xdc#\x17F9\x1c\xfe\x8d\xa6\xacY\x96\xbal\xd2|\xd5i\xfb\x9e\xc5\xea\xb6J\xde\xdfZ\xcb\xf3Xk\xdbx\x8dR\xf2g\\8\x97\xc7H\xa8\r\xbf<\x85\x9b:\x12\x98\t\x14w\x9b-\xd6\xb1a\xb1\xa0\xcd\xf2hv\n\xd3\xd3:6:\x11\x86\x00{<\x1e\xf6\n2\x10U\x92w\xf3\x8c0D\x9b\x1e\xb2B\xff\x83\x1c\xf4\x8a\x94a\xde\xe7\x84\xbe\xe8\x1f\x93\x08\x05\xca^\xe1\x05e\xaf\xf0\x8a\x92\x08o(\xb1P\xb7(\xf1\xe7}\xec\xb0|\x17\xff@\r\xeb\x10Xr\rT\x88\xc1\xaa\xbd\xd7\xcc\x8a\x98<\xb7iA\xa07\x9a\x18=\xb7\xf1\x1bqF\x85\xb3\x10"\x08\x84\xfc\xac|,\x029\xbf\x08\xf4\xbcR\x9fJ)Z\xde\x9d\x92\xcb\x8fN\x18\x05\xed\xde\x17\xca3\xaf@\x13\xdc)m\x13\xdc\x16\xa6m\x82o\x04N\x00z%\x00u\x05\x80\r\x95\x00\xae@^\xc1\xbd\x1f\xbc\x00\x9b*\xc1/*\xc1\xdfW"~J\xbe\xd2\xe8\x8f\x95\x9a_*\xd1\xf3\xf3\x1f\xe7 \xe71\xbe\x00\xaaf:y~\xf1\xbf@\x00\x00\x00\x00IEND\xaeB`\x82',
            'bug': b'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\x00\x00\x000\x08\x03\x00\x00\x00`\xdc\t\xb5\x00\x00\x00\x19tEXtSoftware\x00Adobe ImageReadyq\xc9e<\x00\x00\x00\xb4PLTEGpL\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\x14\xbe>\x1a\x14\x14\x14+\x19\x14\x14\x14\x14\x14\x14\x14\xbe>\x1a\xbe>\x1a\xbd=\x1a\xbe>\x1a\xbe>\x1a\xbe>\x1a\xbe>\x1a\x14\x14\x14\x14\x14\x14s+\x17\x8b1\x18\x14\x14\x14z-\x18\xe7x\'\xdb_\x1c\xd7Y\x1a\xc0,\x06\xddd\x1e\xca@\x0e\xe0j \xc54\t\xe3r$\x17\x17\x17\xd3S\x18###\xd2O\x15\xbe=\x18\xd0J\x13\xea~)777\xe3m"\xceF\x11\xc7:\x0b\x1e\x1e\x1e,,,DDD\xf9\x86,\xe9q$\xc8I\x1b\xeb\x81+\xfd\x910\xed\x84+WWW\xee\x982\xff\xa9:\x997\x1c\xf2x\'c2$\xdaG\x0c\xac:\x1a:\xff\xca.\x00\x00\x00\x17tRNS\x00\xb8\x85>u\x89I\x15"_u6\xe2\xad\xc5Y\xcf\x08\xab\xc8\xb9\xe5\xd7\x83I\x8cy\x00\x00\x02\xaaIDATH\xc7\xddUks\xaa0\x10E\x04\r\x16\xb4\xb5\x0f@k\t1\x1aZ\x02\x89<D\xeb\xff\xff_w\xb1U\x032\xb5\xdf:s\x0f3&k\xf6\x10\x92=\xbb\xabi\xff\'\x86#\xe7\x9e\xd2{g4\xfc\x95\xfb\x9d)\x83\xb2\xdcn\xcb2\x90\xe6\xddm\xff\x11u\xb7\xdb,K\xd3,\xdbn]:\xba\xe9/\xc19\xcf7\xf0\xe49\x90\xe4\r\xc6D\xa6\xd9f}\xc6&K\xe5\xe4G\xc2X\xa4n\x03\xa9\x18\xff\xb8A\xb8\x13A\x03b\x17vm1\xe8\xe9\xa8\x1e\x1dO,Z\x10\x9eS\xaf \xbd7P\x08\xbd$\x89\r\x18mo1oa\xe1\xd9\xb0`\xc4I\xd2S\x08\x06g\x05\xeek\x1a\xf5;@5\xad\x8f\x0b\xc6\r\x85\x80b\xce\x12\xd2\xd7\xec0\\\xfa\xf5{=@=\xfa\xcb0\xb4\xb5>I\x18\x8f\x91z\x08\x84\t|\x15r\xa4\x0c\\\x11\xc1\xa7\xcf\x03\xf8\x89\x84\x1bI\xe9 \xf8\x1e\x82Q\xf3\xd8\x08\xb3\x84\x1b\x8e\xcc\xbf\xaf5\xd8|_k.\x1d\x83\'\xac\xed\xaf\rk\xc2K\x98e\xf9\xe6\x08\xb7\xfc\x1a7Y\x16\xbe\xd4\x84\xe15\x81\xede\x9a\x9eb,\xca\xd3,M\xe5\x9e]\x134\x9d\xb0j\x97\xaeO\x11\x8e\xca\xd3l\x9d\xee*F\xf4\xeb$\xc0\xfb\xf0\xe2\xef\xce\xcf\x04w\x97\x86{\xdc\x91\x1a\xd6A\xec.\x92\xf0\xca\xcb|\'\x0eVW\xe2H!\xa23\xfc\xf22\x17Bv%\x92\x19\xaa:\xf2KUO\xa1\xa98\xf6\xa7\xb8g!\xa4W~\xa4H(,\x15#\xf2+\x1d!\xab\x87\xa7 \x1fm\xca\x8a\x82\x10\xc2\xa97W\x9ee\xde0)\x07\x97\xa2`\xd3z\x07\x0c\xb2(\x8a\x82\xfa\x9e\xe7\x9f\x9f\xd5Z1<\x9f\x82\x03\xc8\xa3\x16(\\(\x08\x893\xd6T\xea\xbb\xdbT,c\x1c\xe4t\xba\xdc\xa1\x1es~\x08U\xbc\x06\xaa\xb5<p\x1e\xebJ,\x86\xc63\xaeVK\x05\xaf\x91j\xad*\xfcl\xb4cg\xca\x95\x82\x8f\x85jI\xb3+p\xf4]\xc1\xc7\\\xb5hg\x05\xb4_\x15\xbcy\xaaew\xf9\xa3G\xaa\xb8\xcc|\xc5\xa0\x8f\xa8\xa3dcV}\\0\xfbT\x8c\xaa#\x1d\x86\x10\xbd=};c\xf6y\x99\xd3=\xc4\xac\xcd\x18\x10(\x1bO\xb4\x8b@\x9f\xa0h\x90A;\x1b\x08c\xc40\xe9\xec\x84\xcf\xd3\x84\x9aF\xbd\xd6\xce\x08\xf8\x93\xc7\x96va\xbc}\x0f\xd4\xd4,\xa8Z\xc4h\x13b\xd0\nHk2\xa6*\x81\x8e\'\xb5<\t\x8f\xdb\x04P\x13\xc6\x0f\xc7\x96b\x9fw\xa1\xf6\xb1\x9d<`\x0cJj\x1d!\x8e\xe3/\xffc\x97\x1b\xd7Mq|\xeep\x0f\x18\x96\x1b\x87\x18\xe0\xd6\x1fW\x15\x02\xde\xd7(\xf7\x04[?\xf72\x0b\x93^\xa3\xa1\x0cnu\xcb_\xb8\xfc\x15\xfe\x01\xf2*\x8e\xfd\xc7WX\x18\x00\x00\x00\x00IEND\xaeB`\x82',
            'heart': b'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\x00\x00\x000\x08\x03\x00\x00\x00`\xdc\t\xb5\x00\x00\x00\x19tEXtSoftware\x00Adobe ImageReadyq\xc9e<\x00\x00\x00{PLTEGpL\xbe>\x1a\xbe>\x1a\xbe>\x1a\xbe>\x1a\xbe>\x1a\xbe>\x1a\xbe>\x1a\xbe>\x1a\xbe>\x1a\xbe>\x1a\xbe>\x1a\xdef\x1f\xe3p$\xd5T\x17\xccB\x0f\xeb\x7f*\xd9]\x1b\xdba\x1d\xe0l"\xe9|)\xd7Z\x1a\xbf>\x18\xe8y(\xd2O\x15\xe5v&\xee\x82,\xc66\n\xd0K\x13\xceH\x12\xc21\t\xfb\x8c/\xc9>\r\xc8:\x0c\xee\x88.\xfd\x994\xc5E\x1a\xc0+\x04\xff\xad;\xccR\x1e\xe2z,%\xf8v\x07\x00\x00\x00\x0ctRNS\x005\xd2P\x8df\x0b\x9b}!\xb8\xe96C\xc4\x16\x00\x00\x01\x96IDATH\xc7\xed\x95\xcdv\x83 \x10\x85\xa3\xa2\xa81\xa9Q3F\xdaH\x0bTy\xff\',\xf8o\xd4H\x16\xdd\xf4\xf4\x93\x8dw\xe6\xeap\x80\xe1p\xf8\xe7w\xb1\xb0\rp\x0c\xfd`\x94\x02\xa4$\xb0\x91\xb5\x92\xee\x845\xe3UU1)\xb05HRK\\\xd6xa\xf1\x05\xab8e\x8cr^I\x81\x94\xe2\xa1\xba\x95\x98\x92b\xe1?\xe4\xd7\xbc\x891F\xb4\'\xc1\x81\x85S\xceY\x87\x92\xe6\x0eWPJHLZT\\\x02HN\xbbw\x15`\x94\nwb\x00BI\x1c\xab\xd1B\x18g\x84\xb2xxW\x83\x12\xf0\xc6\x82.:?\xce\x86\x8c\x8cP:\xd8\xdb\x00\xa1\xc9X\x14d$\xd3\xc8fhrE6\x87\x8c\xbfpj\xa23d\xdeR\xe4\x13d\xf3h)#u?\x0bt\xc9\n\x03H\x14v\x860\xcaO\x9a\xa2\x1b\xc5\xe9\x91F\xc9\xd3cg\xb0\xa3i0=m\x02\x9d\xe1\x18\xa5f\xf4\xb3\xb6\x93\xc8\x8c\xbe\xa4\xf0j\x96\x9f\xd8\xc3FJ\x8c\xa8q\x7f\x10\xc4\xc5\x84D8\xfdJ\xdb\xe7\xab\t\xe3fr\xc5y\x97\xeb\xf9>\xd9\xe0p\xdbw\xdc`rv]\xb8\xed2?AH|\xec\xd0\x1c\xdb\x99\xe3\xfe\x14\x81\xbd\x87.\x80\xc5\xdb\x13\x04\x0e\x16}\x06\xc1v>\xac\xe4\xab\x05\x87\xcf\r\x00\xad\xb7>\x17\xe0k\rp\xb7\x9ae\x80\xe0}\xc1z9\xe3O\x16\xf9\xfe\xf3\x8e\x1c`(\'\x00\xb6v\x9b\xb8?q\xec}\xbe\xeb:P~7\x94\xdb\xb3},\xabq\x94\x06\xe5\x0c\xcb^\xea\xfc\xc0\xfc2\xf2\x94\x03\x82\x97\xae/\x00\xe7\xb5\x0b\xcf\xf3\xfe\xf0m\xfe\x03^\xe4Y\x86P\x01\xc3\xc8\x00\x00\x00\x00IEND\xaeB`\x82',
            'clock': b'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\x00\x00\x000\x08\x03\x00\x00\x00`\xdc\t\xb5\x00\x00\x00\x19tEXtSoftware\x00Adobe ImageReadyq\xc9e<\x00\x00\x00\xcfPLTEGpL\n[u\n[u\n[u\n[u\n[u\n[u\n[u\n[u\n[u\n[u\n[u\n[u\xdd\xde\xde\xe0\xe0\xe0\xeb\xeb\xeb\x0eb}\x0b\\v\xee\xee\xee\xda\xda\xda\x12f\x81\x11k\x88)\xb8\xe5\xe4\xe3\xe3\xe8\xe7\xe7\x19\x84\xa6\x15x\x97\x1d\x90\xb4\x12o\x8d\x17\x7f\xa1\x1f\x97\xbd\x16|\x9c\x14s\x92#\xa3\xcb%\xa9\xd3\xfe\xfe\xfe\x1a\x88\xab-\xc8\xf9\'\xb0\xdc(\xb4\xe1+\xbc\xea!\x9d\xc51\xdb\xf6\xc3\xcd\xd0Ex\x88p\x97\xa3\xf3\xf4\xf3\x1c\x8b\xaf\xb3\xbc\xbf\xce\xd4\xd7&\xb2\xd6`\x88\x95\xeb\x8a;\xa0\xb3\xb9 \xa5\xb9\xd6Y\x1a|||rrr\x87\x87\x877\xf3\xff[\x83\x90\xe2q\'\xe8\xc2\xa9\xe2\xa2~\xf0\xda\xca\xa9\xa9\xa9\xbahL\xbbU,\xceG\x11\xf9\x8c\xa4\x03\x00\x00\x00\x0ctRNS\x00\xaa\xd5\xfayC\x96\x85\x18(\xed\xce\x16\x99\xd2\xbe\x00\x00\x03DIDATH\xc7\xd5\x96iw\xa20\x14\x86\xebR\xb5\xed\x11\x13$`B\x82\xacVd\x11\x8a\xd8\xd6\xb1\xdb\xcc\xfc\xff\xdf47P\xea\xdav\xbe\xf6\x85#\xe1\xde\xe7=\xdc\x84\x90xq\xf1\x134\xe8\xb6n:\x18wnZ\xdd\xc1\x7f\xd0\xfd6Y\xdf-~\x81\x16wk\xd2\xee\x0f\xbe\xc1\xd1z\xf1k\x11\x04sP\x10@s\x8d\xbe\xb2t\x01_T\xf0|\xaeW\xbf\xc1\x02,\xddO\xf0\xab\x1e\x05\\?\x94\xb4\xd0\xde\xd59\xfe\x12;\'\xb8\xae\xdf\xeaz\xb0p\xf0\xe5\x19\x1e\xdd\x05\xf3[)\xd7\xa2\xb6\x86\xb1fS\xcb\xad\x02\xf3\xe0\x0e\x9d8\xae\xb0\x1b\xe82\xeb\xf8$N\xb2<M\xf3,\x89\x89\xef\xc8\x98\x1e\xb8\xf8\xb8\xaa\x9e\x15\xe83\x90I\x8a\xdc\xf3\xbc\xc9f3\x82K^\x10SF\xf5\xc0\xea\x1d\xf2}Q\xf1\xae\x88#\xcfKU5{|\xc8T5\xf5\xbc(\x16n\xe5\x10\xfd\x83\x82\xd0\xad\xee\xba\xae3-\xd2\x14pU\x1do6CyM\xbd\xb4\x98:\x90\xd2o\xd1~Q=S\xf2\xae(\xbc\xd7\xd5\xb3z \xcf+\x84\xcc\xcd\xcd\xbd\xa2\x06\x08\xaaq]?V\xbd\xe7\xa7\xd5\xeb\x91C\x8d}H\xcefh\xf7\xca\xfbt\xe68\x8eE"O\x1d\xbd<\xad\x8c\xd1\xbeT/"\x16\xa4gt\xd7\x0b\x1c\xba\x10\x81\x82\xd4\xd1h\xb2zZ\x8d\x8e\x1c\x85\x80\xb4\x1b\xe2\x8fwF\x1c\'\x0c--Je\xfe\xf5\xe9\xfe\xe5\xd0\x91F\x9a\x15\x86\x8eC\x9a\xb7\xd7\x9d\x02\x1f\xfaq:\x9aL\xe0|\xbe\xbf\x7f\x9e\xecKMc\x1f\x00g\xda\xcc\xc2\x16\r-\xcbb\x89\xfa\x0e\xbc\xfc\xfd\x93hZ\x92W\xf6\x91t$\x0c\x80\x90\xb6\xde\r\xed\xa54\x90\xb21\x18\xbf1L\xf35\xce?\x1eQ\x12iX\xb6\xdf\r\xd7&\xdcZ(\x1afc\x89O&\x89\t\x1fE`&5>\xce\x94\x08Y\x96i\x99\xd7\xef\x86\x8e)\x85\x87\x0f\x8f\x1b\xc30&\x86\xa1\xc9Q\x83QYI\x19\x10\x1e\xe2\n\xe94\x86\xe5\xbe\x01\xa4-M8\x96\xf8^jgX6\x86k\x7f\tB\xd18\x1b\xd7\x86\x84LA$\xa9\xef \x1c!I\xf8MIm\xe1\x83\xb4\xd2P\x14C1\xe0\xcc1"\x04\xe1\xc8P\xeaC)5I\x88\xa6\xd3-F)\xf5y"\xf9Z\x91\x1c\xd6H\xf9P\xc2}@X3\xac].\r,V>U\xcc\xa4\x81w?>g!\x04\xa5(\xfb\x8c\xcf\x10\xa5\x80\xec>l\xcc\xa0\x8f\x94\x17\xc3OTp\n\x00\xc3\xbb\xe9-GELQy\x16WJ\x04I\x18\xb5\xdd\xf4\x1e`\x06\x12v\x9c\x0f\xc7\xa7G\x1e\xdbB\xe6\xf1\xde\x9a\xd9#\xb6\xcd\x18\xe5\xdb\xf1\x19m9e\xb6m\x93\xde\xc1\xaa\xc4!\xc4\x04\xd9\xe65\x14=<Du+\xdf\x12!y~\xb82\xf5\x11\x071\xc1\xe3\xb2\xc2\xde\x1e\x1f\xdf\xaaF\x19s\xc1d\x0e\xf5\x8f\x162\x8dp\xc2ma\xa3m\xb6{B\xb6E\x10\x82\x04\xd1z\'K\xa5F@\x9cMm\x14\'e\x96\xe7Y\x99\xc4\xc8\x9e2.\xe3\xda\xc9R\t\x8bw\xe5\x00\x0b\x94\xa0!\x8c\x91V5%\r\xfc\xb9\xe5\x1b\x90J\x04z\x0f\x13\x81B_I\x1dA\xe7x\xb9\xa14\x96C!|~C\x91\xb3\x10\n9\x11\xc6\xdd\xaf6\xc5c\x0b\xc6\xdf\xee\xa3m\xdc\x98\xa0\xf1\xdd\xb6[\xf7\x056v`1l\xecW?\xe2\x9f\xc8?aq\x94:\x9e\xdde\x03\x00\x00\x00\x00IEND\xaeB`\x82',
            'world': b'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\x00\x00\x000\x08\x03\x00\x00\x00`\xdc\t\xb5\x00\x00\x00\x19tEXtSoftware\x00Adobe ImageReadyq\xc9e<\x00\x00\x00\xc3PLTEGpL\n[u\n[u+c6\n[s\n[u\n[u\n[u\x0b[s\n[u\x18_Y\n[u\x0f\\k"\x9f\xc7\x11g\x83\x19\x81\xa2\x91\xbcX\x88\xb2O\x16v\x95\x17{\x9b\x1b\x8a\xad\x14q\x8f\n\\v\x0fb}`\x87!Rx\x12Y\x7f\x1aKp\x0b\x1f\x96\xbb$\xa7\xd0e\x8c\'\x97\xc2_\x1b\x85\xa7Ej\x08k\x93-\x12k\x88\x1d\x8e\xb2q\x9b3\x8d\xb7T\x12m\x8a~\xa8A\x83\xacI\x9d\xcba\x1e\x91\xb6 \x9a\xc0:t44\x82_&\xaf\xdb0i8x\xa2;5yL>o \'iO+\x85~\xa8\xd9j\x1ahn0\x92\x840\x85n*\xbd\xea(\x8f\x9a x|)\xa1\xb8?\x83=\xb8\xebw=\x93Y\x80MUo\x00\x00\x00\rtRNS\x00I7\xbd\xd3\x95\xaa\x80\x1a*\xf1\xedM?>\x9d\xbc\x00\x00\x02\xfdIDATH\xc7\xdd\x95kw\xaa8\x14\x86{Q\xd1\xd3QQ\xa7\x90\x8b\x04\x13\x1a\x1a\xa9\xe1.\xe2\xa5=\xe7\xff\xff\xaa\t(\x05\n\xe72k\xcd\xa7y@\x17l\xde7\xd9\t\xac\xbd\xef\xee\xfe\x97\x8c\xb5\xd1\xc0P\x0cF\xda\xf8O\xd4\x83Y\x9e\xff\xf8H(\xa5\x1f2\xfd\xf6\x1b\xcfX;\xf8\x1f\x18p\xd7\xcb\xbe\x7f\xcft]\x00\x9a<\xfe\xc2\xa2\xa5\t\x12\x9e\xee)l\xdb\x8e\xa0\xb0\xed\xcc\x8b\x92\xc7\x9f\xc8\'\xc3#\xf6\xb2\xcc\xf3\x94N\xb8\xb6\xab\xdb\x02a\xa2\xec\xe8q\xd2\xa7\xbfO%\xd0\x8b\x91\xcb\xe1u\x9b1\xd7\xf3"\x88t/#\xe1}W\xffWH\xf4\xec*\xd5\xed-\xa4\x18E\xae\x1b1\xdf\xe7j\x08\x92v\x1c\x93\x90+\xb9\x12\x97\xa7\xb7\x88\xc0\x07Q\xe6\xacp\xb8\x82\xe4\xc6\xd7\xac\x1e\x81\xde@\r\x9a\xe9ni\x15\xd8\xc78?\xed\x86_\xf6\xe7\x02)\x17\xba\xee\xde\x0e}q\xb3.\xb6\xfchY\xc1\xe94\xd7Z\t\x99\xc1\xfb;F[\xf7\x93\xc5\xe2z\xc3\xf8\x16\xe4A`\x9d\x02\xb3\x99\xd4\xf0\xe5\x14X\xd3#[\xb8\xf5Q\x988\x038Q3X\xca\xf1\xd2Hjl\xaa1,KF\x8b6\x04\xfb\xf9\xd4\xba\x12\x04f\xfd\xca\xb5M\xa1\xb7\x8eD%R\x9d\xea\x8f\xc7\xefVM\xb0\xa9WaL\xad\xa9\xe2\x1d\xf3m\x03\x01\xcf\xd3\x06\xd6\xd4\xa8\xf4\x0f\x8eu\x8d\xe5\x92\x8b\x9b\x9a\x8b(9N[X\xceC\x95\xd1\xaa\x0c\xec\xa6\xbb\x1c\x89\x02\x86\xa9\xa4\x11\xc0\xeb\xa6\xfe\x1c_\xaa\x9cF\xf3|w#\x06@D\x02\xed\xcf\xbe\x0f\xa0\x7f\xde5\x88Y<\xba\x19\x06\x14\xed\xd7\x05\xbb\xf5\x8b\x8fA$H\x8c\x08$\x8c@y\x8d\x97$\x9c\x0en\x86\xa7=\xbc=x[\xaf\xcf\x98G\x11\x13\\\xc6\x141\x06k\x87d\xf0[\xb5Io\xfb\xb7\x1a?\x81\x80p\xc6\xf0\xf9(e\xe3\x01\xe5\xb5\xe1\xa5\xcd>\x96\x88p\xe8\xc7\x18&\xd2\xdf\xdc\xa2\x92\xe0\xca\xf0\xf4w\x87\xa3\x04\x00\x10!"N\xe4\xf1\x1a\xf2\x91\xffT-z\xde1l\xf6\x12"\xc6\x19\xe7\x11Cq\xf9|NW\xd5\xa2G\xcbM\x0f1d\n\xa2< .\x03\xf3e\xb5\xad\xda\xeb\xbc\x07\xaa\xf6\xb5Dm/\x95\x17\x15y\xad^\xdc\x83\xd9\xa3_bRQL"U\xc8|\xf8\xfc\xf8V].\x184IT\xc8\xa8?o\xa7\xc7\x11\xc2\x86\x1e\xa7\xab\x95S\x7f\xdecc\xd9\xe5\x82\xd1\'0Q\x01\xa3Q3\x87N\x8f#\x84J\n\xca\x1fN\x97K\xa7Y7&\xc6s\x97KJ\xab\tBu\xdb\xaeL\x9a\xd9\xe38PXB\xc3\xc3\xf3\xb3\xa9\xb5\x0b\xd3p\xf6\xda!\xc5\x10"e\x08\xd5\xf5l\xf8\xb5T\x1a3\xe7+!.\xc6\xc7\xe1\xc1qf\x9dRywo\xcc\xda8\xd7\x8cT>\xea\xc6\xe8)\xdf\xf7\x86\xd9v\xa8\x8c0\xa6\xa1\xba2\xfb\xf4ECiYL\x8a\x95\x9e\x1e\x94|8\xf9Y\xcb2\x0c\xf3\x93\x03-\xf5\xa6ah\xbfj\x8a\rKJU\xfeJ\xfe\xbb>Z\xf4\xe8\xd2P\xf6\xea?k\xd5\xff\xa6\xb1\xff\xf7\xfc\x03\xc8\xf8\x9d9\'\xf7\x868\x00\x00\x00\x00IEND\xaeB`\x82'
        }[last_content_json['text']]
        data = {
            'username': login['username'],
            'password': login['password'],
            'remember': 1,
            'captchaSelection': next(hash for hash in last_content_json['images'] if self.request(entry, 'get',
                                                                                                  urljoin(entry['url'],
                                                                                                          '/simpleCaptcha.php?hash=' + hash)).content == target),
            'submitme': 'X',
            'returnto': '/'
        }
        return self.request(entry, 'post', work.url, data=data)
