# mypy-boto3-neptune

[![PyPI - mypy-boto3-neptune](https://img.shields.io/pypi/v/mypy-boto3-neptune.svg?color=blue)](https://pypi.org/project/mypy-boto3-neptune)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-neptune.svg?color=blue)](https://pypi.org/project/mypy-boto3-neptune)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.Neptune 1.16.28](https://boto3.amazonaws.com/v1/documentation/api/1.16.28/reference/services/neptune.html#Neptune) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.0.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-neptune](#mypy-boto3-neptune)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `Neptune` service.

```bash
python -m pip install boto3-stubs[neptune]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[neptune]` in your environment: `python -m pip install 'boto3-stubs[neptune]'`

Both type checking and auto-complete should work for `Neptune` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[neptune]` in your environment: `python -m pip install 'boto3-stubs[neptune]'`

Both type checking and auto-complete should work for `Neptune` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[neptune]` in your environment: `python -m pip install 'boto3-stubs[neptune]'`
- Run `mypy` as usual

Type checking should work for `Neptune` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[neptune]` in your environment: `python -m pip install 'boto3-stubs[neptune]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `Neptune` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`NeptuneClient` provides annotations for `boto3.client("neptune")`.

```python
import boto3

from mypy_boto3_neptune import NeptuneClient

client: NeptuneClient = boto3.client("neptune")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: NeptuneClient = session.client("neptune")
```

### Paginators annotations

`mypy_boto3_neptune.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_neptune import NeptuneClient
from mypy_boto3_neptune.paginator import (
    DescribeDBClusterEndpointsPaginator,
    DescribeDBClusterParameterGroupsPaginator,
    DescribeDBClusterParametersPaginator,
    DescribeDBClusterSnapshotsPaginator,
    DescribeDBClustersPaginator,
    DescribeDBEngineVersionsPaginator,
    DescribeDBInstancesPaginator,
    DescribeDBParameterGroupsPaginator,
    DescribeDBParametersPaginator,
    DescribeDBSubnetGroupsPaginator,
    DescribeEngineDefaultParametersPaginator,
    DescribeEventsPaginator,
    DescribeEventSubscriptionsPaginator,
    DescribeOrderableDBInstanceOptionsPaginator,
    DescribePendingMaintenanceActionsPaginator,
)

client: NeptuneClient = boto3.client("neptune")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_db_cluster_endpoints_paginator: DescribeDBClusterEndpointsPaginator = client.get_paginator("describe_db_cluster_endpoints")
describe_db_cluster_parameter_groups_paginator: DescribeDBClusterParameterGroupsPaginator = client.get_paginator("describe_db_cluster_parameter_groups")
describe_db_cluster_parameters_paginator: DescribeDBClusterParametersPaginator = client.get_paginator("describe_db_cluster_parameters")
describe_db_cluster_snapshots_paginator: DescribeDBClusterSnapshotsPaginator = client.get_paginator("describe_db_cluster_snapshots")
describe_db_clusters_paginator: DescribeDBClustersPaginator = client.get_paginator("describe_db_clusters")
describe_db_engine_versions_paginator: DescribeDBEngineVersionsPaginator = client.get_paginator("describe_db_engine_versions")
describe_db_instances_paginator: DescribeDBInstancesPaginator = client.get_paginator("describe_db_instances")
describe_db_parameter_groups_paginator: DescribeDBParameterGroupsPaginator = client.get_paginator("describe_db_parameter_groups")
describe_db_parameters_paginator: DescribeDBParametersPaginator = client.get_paginator("describe_db_parameters")
describe_db_subnet_groups_paginator: DescribeDBSubnetGroupsPaginator = client.get_paginator("describe_db_subnet_groups")
describe_engine_default_parameters_paginator: DescribeEngineDefaultParametersPaginator = client.get_paginator("describe_engine_default_parameters")
describe_event_subscriptions_paginator: DescribeEventSubscriptionsPaginator = client.get_paginator("describe_event_subscriptions")
describe_events_paginator: DescribeEventsPaginator = client.get_paginator("describe_events")
describe_orderable_db_instance_options_paginator: DescribeOrderableDBInstanceOptionsPaginator = client.get_paginator("describe_orderable_db_instance_options")
describe_pending_maintenance_actions_paginator: DescribePendingMaintenanceActionsPaginator = client.get_paginator("describe_pending_maintenance_actions")
```


### Waiters annotations

`mypy_boto3_neptune.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_neptune import NeptuneClient
from mypy_boto3_neptune.waiter import DBInstanceAvailableWaiter, DBInstanceDeletedWaiter

client: NeptuneClient = boto3.client("neptune")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
db_instance_available_waiter: DBInstanceAvailableWaiter = client.get_waiter("db_instance_available")
db_instance_deleted_waiter: DBInstanceDeletedWaiter = client.get_waiter("db_instance_deleted")
```





### Typed dictionations

`mypy_boto3_neptune.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_neptune.type_defs import (
    AddSourceIdentifierToSubscriptionResultTypeDef,
    ApplyPendingMaintenanceActionResultTypeDef,
    AvailabilityZoneTypeDef,
    CharacterSetTypeDef,
    CloudwatchLogsExportConfigurationTypeDef,
    CopyDBClusterParameterGroupResultTypeDef,
    CopyDBClusterSnapshotResultTypeDef,
    CopyDBParameterGroupResultTypeDef,
    CreateDBClusterEndpointOutputTypeDef,
    CreateDBClusterParameterGroupResultTypeDef,
    CreateDBClusterResultTypeDef,
    CreateDBClusterSnapshotResultTypeDef,
    CreateDBInstanceResultTypeDef,
    CreateDBParameterGroupResultTypeDef,
    CreateDBSubnetGroupResultTypeDef,
    CreateEventSubscriptionResultTypeDef,
    DBClusterEndpointMessageTypeDef,
    DBClusterEndpointTypeDef,
    DBClusterMemberTypeDef,
    DBClusterMessageTypeDef,
    DBClusterOptionGroupStatusTypeDef,
    DBClusterParameterGroupDetailsTypeDef,
    DBClusterParameterGroupNameMessageTypeDef,
    DBClusterParameterGroupsMessageTypeDef,
    DBClusterParameterGroupTypeDef,
    DBClusterRoleTypeDef,
    DBClusterSnapshotAttributesResultTypeDef,
    DBClusterSnapshotAttributeTypeDef,
    DBClusterSnapshotMessageTypeDef,
    DBClusterSnapshotTypeDef,
    DBClusterTypeDef,
    DBEngineVersionMessageTypeDef,
    DBEngineVersionTypeDef,
    DBInstanceMessageTypeDef,
    DBInstanceStatusInfoTypeDef,
    DBInstanceTypeDef,
    DBParameterGroupDetailsTypeDef,
    DBParameterGroupNameMessageTypeDef,
    DBParameterGroupsMessageTypeDef,
    DBParameterGroupStatusTypeDef,
    DBParameterGroupTypeDef,
    DBSecurityGroupMembershipTypeDef,
    DBSubnetGroupMessageTypeDef,
    DBSubnetGroupTypeDef,
    DeleteDBClusterEndpointOutputTypeDef,
    DeleteDBClusterResultTypeDef,
    DeleteDBClusterSnapshotResultTypeDef,
    DeleteDBInstanceResultTypeDef,
    DeleteEventSubscriptionResultTypeDef,
    DescribeDBClusterSnapshotAttributesResultTypeDef,
    DescribeEngineDefaultClusterParametersResultTypeDef,
    DescribeEngineDefaultParametersResultTypeDef,
    DescribeValidDBInstanceModificationsResultTypeDef,
    DomainMembershipTypeDef,
    DoubleRangeTypeDef,
    EndpointTypeDef,
    EngineDefaultsTypeDef,
    EventCategoriesMapTypeDef,
    EventCategoriesMessageTypeDef,
    EventsMessageTypeDef,
    EventSubscriptionsMessageTypeDef,
    EventSubscriptionTypeDef,
    EventTypeDef,
    FailoverDBClusterResultTypeDef,
    FilterTypeDef,
    ModifyDBClusterEndpointOutputTypeDef,
    ModifyDBClusterResultTypeDef,
    ModifyDBClusterSnapshotAttributeResultTypeDef,
    ModifyDBInstanceResultTypeDef,
    ModifyDBSubnetGroupResultTypeDef,
    ModifyEventSubscriptionResultTypeDef,
    OptionGroupMembershipTypeDef,
    OrderableDBInstanceOptionsMessageTypeDef,
    OrderableDBInstanceOptionTypeDef,
    PaginatorConfigTypeDef,
    ParameterTypeDef,
    PendingCloudwatchLogsExportsTypeDef,
    PendingMaintenanceActionsMessageTypeDef,
    PendingMaintenanceActionTypeDef,
    PendingModifiedValuesTypeDef,
    PromoteReadReplicaDBClusterResultTypeDef,
    RangeTypeDef,
    RebootDBInstanceResultTypeDef,
    RemoveSourceIdentifierFromSubscriptionResultTypeDef,
    ResourcePendingMaintenanceActionsTypeDef,
    ResponseMetadata,
    RestoreDBClusterFromSnapshotResultTypeDef,
    RestoreDBClusterToPointInTimeResultTypeDef,
    StartDBClusterResultTypeDef,
    StopDBClusterResultTypeDef,
    SubnetTypeDef,
    TagListMessageTypeDef,
    TagTypeDef,
    TimezoneTypeDef,
    UpgradeTargetTypeDef,
    ValidDBInstanceModificationsMessageTypeDef,
    ValidStorageOptionsTypeDef,
    VpcSecurityGroupMembershipTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> AvailabilityZoneTypeDef:
    return {
      ...
    }
```
