# Copyright 2025 ByteDance and/or its affiliates.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from setuptools import find_packages, setup

with open("requirements.txt") as f:
    install_requires = f.read().splitlines()

setup(
    name="pxmeter",
    python_requires=">=3.11",
    version="0.1.1",
    description="PXMeter is a comprehensive toolkit for evaluating the quality of \
        structures generated by biomolecular structure prediction models.",
    author="Bytedance Inc.",
    author_email="ai4s-bio@bytedance.com",
    packages=find_packages(
        exclude=(
            "benchmark*",
            "tmp*",
            "inhouse_runner*",
            "examples",
            "ccd_cache",
            "test*",
            "*.egg-info",
        )
    ),
    include_package_data=True,
    install_requires=install_requires,
    license="Apache 2.0 License",
    platforms="manylinux1",
    entry_points={
        "console_scripts": [
            "pxm = pxmeter.cli:cli",
        ],
    },
)
