"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SuppressionIgnoreErrors = exports.SuppressionIgnoreNever = exports.SuppressionIgnoreAlways = exports.SuppressionIgnoreOr = exports.SuppressionIgnoreAnd = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const nag_rules_1 = require("./nag-rules");
/**
 * Ignore the suppression if all of the given INagSuppressionIgnore return a non-empty message
 */
class SuppressionIgnoreAnd {
    constructor(...SuppressionIgnoreAnds) {
        if (SuppressionIgnoreAnds.length === 0) {
            throw new Error('SuppressionIgnoreAnd needs at least one INagSuppressionIgnore');
        }
        this.andSuppressionIgnores = SuppressionIgnoreAnds;
    }
    createMessage(input) {
        let messages = [];
        for (const i of this.andSuppressionIgnores) {
            const m = i.createMessage(input);
            messages.push(m);
            if (!m) {
                return '';
            }
        }
        return messages.join('\n\t');
    }
}
exports.SuppressionIgnoreAnd = SuppressionIgnoreAnd;
_a = JSII_RTTI_SYMBOL_1;
SuppressionIgnoreAnd[_a] = { fqn: "cdk-nag.SuppressionIgnoreAnd", version: "2.37.19" };
/**
 * Ignore the suppression if any of the given INagSuppressionIgnore return a non-empty message
 */
class SuppressionIgnoreOr {
    constructor(...orSuppressionIgnores) {
        if (orSuppressionIgnores.length === 0) {
            throw new Error('SuppressionIgnoreOr needs at least one INagSuppressionIgnore');
        }
        this.SuppressionIgnoreOrs = orSuppressionIgnores;
    }
    createMessage(input) {
        let messages = [];
        for (const i of this.SuppressionIgnoreOrs) {
            const m = i.createMessage(input);
            if (m) {
                messages.push(m);
            }
        }
        return messages ? messages.join('\n\t') : '';
    }
}
exports.SuppressionIgnoreOr = SuppressionIgnoreOr;
_b = JSII_RTTI_SYMBOL_1;
SuppressionIgnoreOr[_b] = { fqn: "cdk-nag.SuppressionIgnoreOr", version: "2.37.19" };
/**
 * Always ignore the suppression
 */
class SuppressionIgnoreAlways {
    constructor(triggerMessage) {
        if (triggerMessage.length === 0) {
            throw new Error('provide a triggerMessage for the SuppressionIgnoreAlways');
        }
        this.triggerMessage = triggerMessage;
    }
    createMessage(_input) {
        return this.triggerMessage;
    }
}
exports.SuppressionIgnoreAlways = SuppressionIgnoreAlways;
_c = JSII_RTTI_SYMBOL_1;
SuppressionIgnoreAlways[_c] = { fqn: "cdk-nag.SuppressionIgnoreAlways", version: "2.37.19" };
/**
 * Don't ignore the suppression
 */
class SuppressionIgnoreNever {
    createMessage(_input) {
        return '';
    }
}
exports.SuppressionIgnoreNever = SuppressionIgnoreNever;
_d = JSII_RTTI_SYMBOL_1;
SuppressionIgnoreNever[_d] = { fqn: "cdk-nag.SuppressionIgnoreNever", version: "2.37.19" };
/**
 * Ignore Suppressions for Rules with a NagMessageLevel.ERROR
 */
class SuppressionIgnoreErrors {
    createMessage(input) {
        return input.ruleLevel == nag_rules_1.NagMessageLevel.ERROR
            ? `${input.ruleId} is categorized as an ERROR and may not be suppressed`
            : '';
    }
}
exports.SuppressionIgnoreErrors = SuppressionIgnoreErrors;
_e = JSII_RTTI_SYMBOL_1;
SuppressionIgnoreErrors[_e] = { fqn: "cdk-nag.SuppressionIgnoreErrors", version: "2.37.19" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaWdub3JlLXN1cHByZXNzaW9uLWNvbmRpdGlvbnMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvaWdub3JlLXN1cHByZXNzaW9uLWNvbmRpdGlvbnMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFLQSwyQ0FBOEM7QUF5QjlDOztHQUVHO0FBQ0gsTUFBYSxvQkFBb0I7SUFHL0IsWUFBWSxHQUFHLHFCQUE4QztRQUMzRCxJQUFJLHFCQUFxQixDQUFDLE1BQU0sS0FBSyxDQUFDLEVBQUUsQ0FBQztZQUN2QyxNQUFNLElBQUksS0FBSyxDQUNiLCtEQUErRCxDQUNoRSxDQUFDO1FBQ0osQ0FBQztRQUNELElBQUksQ0FBQyxxQkFBcUIsR0FBRyxxQkFBcUIsQ0FBQztJQUNyRCxDQUFDO0lBRUQsYUFBYSxDQUFDLEtBQTZCO1FBQ3pDLElBQUksUUFBUSxHQUFHLEVBQUUsQ0FBQztRQUNsQixLQUFLLE1BQU0sQ0FBQyxJQUFJLElBQUksQ0FBQyxxQkFBcUIsRUFBRSxDQUFDO1lBQzNDLE1BQU0sQ0FBQyxHQUFHLENBQUMsQ0FBQyxhQUFhLENBQUMsS0FBSyxDQUFDLENBQUM7WUFDakMsUUFBUSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQztZQUNqQixJQUFJLENBQUMsQ0FBQyxFQUFFLENBQUM7Z0JBQ1AsT0FBTyxFQUFFLENBQUM7WUFDWixDQUFDO1FBQ0gsQ0FBQztRQUNELE9BQU8sUUFBUSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUMvQixDQUFDOztBQXRCSCxvREF1QkM7OztBQUVEOztHQUVHO0FBQ0gsTUFBYSxtQkFBbUI7SUFHOUIsWUFBWSxHQUFHLG9CQUE2QztRQUMxRCxJQUFJLG9CQUFvQixDQUFDLE1BQU0sS0FBSyxDQUFDLEVBQUUsQ0FBQztZQUN0QyxNQUFNLElBQUksS0FBSyxDQUNiLDhEQUE4RCxDQUMvRCxDQUFDO1FBQ0osQ0FBQztRQUNELElBQUksQ0FBQyxvQkFBb0IsR0FBRyxvQkFBb0IsQ0FBQztJQUNuRCxDQUFDO0lBRUQsYUFBYSxDQUFDLEtBQTZCO1FBQ3pDLElBQUksUUFBUSxHQUFHLEVBQUUsQ0FBQztRQUNsQixLQUFLLE1BQU0sQ0FBQyxJQUFJLElBQUksQ0FBQyxvQkFBb0IsRUFBRSxDQUFDO1lBQzFDLE1BQU0sQ0FBQyxHQUFHLENBQUMsQ0FBQyxhQUFhLENBQUMsS0FBSyxDQUFDLENBQUM7WUFDakMsSUFBSSxDQUFDLEVBQUUsQ0FBQztnQkFDTixRQUFRLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDO1lBQ25CLENBQUM7UUFDSCxDQUFDO1FBQ0QsT0FBTyxRQUFRLENBQUMsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQztJQUMvQyxDQUFDOztBQXJCSCxrREFzQkM7OztBQUVEOztHQUVHO0FBQ0gsTUFBYSx1QkFBdUI7SUFFbEMsWUFBWSxjQUFzQjtRQUNoQyxJQUFJLGNBQWMsQ0FBQyxNQUFNLEtBQUssQ0FBQyxFQUFFLENBQUM7WUFDaEMsTUFBTSxJQUFJLEtBQUssQ0FDYiwwREFBMEQsQ0FDM0QsQ0FBQztRQUNKLENBQUM7UUFDRCxJQUFJLENBQUMsY0FBYyxHQUFHLGNBQWMsQ0FBQztJQUN2QyxDQUFDO0lBQ0QsYUFBYSxDQUFDLE1BQThCO1FBQzFDLE9BQU8sSUFBSSxDQUFDLGNBQWMsQ0FBQztJQUM3QixDQUFDOztBQVpILDBEQWFDOzs7QUFFRDs7R0FFRztBQUNILE1BQWEsc0JBQXNCO0lBQ2pDLGFBQWEsQ0FBQyxNQUE4QjtRQUMxQyxPQUFPLEVBQUUsQ0FBQztJQUNaLENBQUM7O0FBSEgsd0RBSUM7OztBQUVEOztHQUVHO0FBQ0gsTUFBYSx1QkFBdUI7SUFDbEMsYUFBYSxDQUFDLEtBQTZCO1FBQ3pDLE9BQU8sS0FBSyxDQUFDLFNBQVMsSUFBSSwyQkFBZSxDQUFDLEtBQUs7WUFDN0MsQ0FBQyxDQUFDLEdBQUcsS0FBSyxDQUFDLE1BQU0sdURBQXVEO1lBQ3hFLENBQUMsQ0FBQyxFQUFFLENBQUM7SUFDVCxDQUFDOztBQUxILDBEQU1DIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5pbXBvcnQgeyBDZm5SZXNvdXJjZSB9IGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7IE5hZ01lc3NhZ2VMZXZlbCB9IGZyb20gJy4vbmFnLXJ1bGVzJztcblxuLyoqXG4gKiBJbmZvcm1hdGlvbiBhYm91dCB0aGUgTmFnUnVsZSBhbmQgdGhlIHJlbGV2YW50IE5hZ1N1cHByZXNzaW9uIGZvciB0aGUgSU5hZ1N1cHByZXNzaW9uSWdub3JlXG4gKiBAcGFyYW0gcmVzb3VyY2UgVGhlIHJlc291cmNlIHRoZSBzdXBwcmVzc2lvbiBpcyBhcHBsaWVkIHRvLlxuICogQHBhcmFtIHJlYXNvbiBUaGUgcmVhc29uIGdpdmVuIGZvciB0aGUgc3VwcHJlc3Npb24uXG4gKiBAcGFyYW0gcnVsZUlkIFRoZSBpZCBvZiB0aGUgcnVsZSB0byBpZ25vcmUuXG4gKiBAcGFyYW0gZmluZGluZ0lkIFRoZSBpZCBvZiB0aGUgZmluZGluZyB0aGF0IGlzIGJlaW5nIGNoZWNrZWQuXG4gKiBAcGFyYW0gcnVsZUxldmVsIFRoZSBzZXZlcml0eSBsZXZlbCBvZiB0aGUgcnVsZS5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBTdXBwcmVzc2lvbklnbm9yZUlucHV0IHtcbiAgcmVhZG9ubHkgcmVzb3VyY2U6IENmblJlc291cmNlO1xuICByZWFkb25seSByZWFzb246IHN0cmluZztcbiAgcmVhZG9ubHkgcnVsZUlkOiBzdHJpbmc7XG4gIHJlYWRvbmx5IGZpbmRpbmdJZDogc3RyaW5nO1xuICByZWFkb25seSBydWxlTGV2ZWw6IE5hZ01lc3NhZ2VMZXZlbDtcbn1cblxuLyoqXG4gKiBJbnRlcmZhY2UgZm9yIGNyZWF0aW5nIE5hZ1N1cHByZXNzaW9uIElnbm9yZXNcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJTmFnU3VwcHJlc3Npb25JZ25vcmUge1xuICBjcmVhdGVNZXNzYWdlKGlucHV0OiBTdXBwcmVzc2lvbklnbm9yZUlucHV0KTogc3RyaW5nO1xufVxuXG4vKipcbiAqIElnbm9yZSB0aGUgc3VwcHJlc3Npb24gaWYgYWxsIG9mIHRoZSBnaXZlbiBJTmFnU3VwcHJlc3Npb25JZ25vcmUgcmV0dXJuIGEgbm9uLWVtcHR5IG1lc3NhZ2VcbiAqL1xuZXhwb3J0IGNsYXNzIFN1cHByZXNzaW9uSWdub3JlQW5kIGltcGxlbWVudHMgSU5hZ1N1cHByZXNzaW9uSWdub3JlIHtcbiAgcHJpdmF0ZSBhbmRTdXBwcmVzc2lvbklnbm9yZXM6IElOYWdTdXBwcmVzc2lvbklnbm9yZVtdO1xuXG4gIGNvbnN0cnVjdG9yKC4uLlN1cHByZXNzaW9uSWdub3JlQW5kczogSU5hZ1N1cHByZXNzaW9uSWdub3JlW10pIHtcbiAgICBpZiAoU3VwcHJlc3Npb25JZ25vcmVBbmRzLmxlbmd0aCA9PT0gMCkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKFxuICAgICAgICAnU3VwcHJlc3Npb25JZ25vcmVBbmQgbmVlZHMgYXQgbGVhc3Qgb25lIElOYWdTdXBwcmVzc2lvbklnbm9yZSdcbiAgICAgICk7XG4gICAgfVxuICAgIHRoaXMuYW5kU3VwcHJlc3Npb25JZ25vcmVzID0gU3VwcHJlc3Npb25JZ25vcmVBbmRzO1xuICB9XG5cbiAgY3JlYXRlTWVzc2FnZShpbnB1dDogU3VwcHJlc3Npb25JZ25vcmVJbnB1dCk6IHN0cmluZyB7XG4gICAgbGV0IG1lc3NhZ2VzID0gW107XG4gICAgZm9yIChjb25zdCBpIG9mIHRoaXMuYW5kU3VwcHJlc3Npb25JZ25vcmVzKSB7XG4gICAgICBjb25zdCBtID0gaS5jcmVhdGVNZXNzYWdlKGlucHV0KTtcbiAgICAgIG1lc3NhZ2VzLnB1c2gobSk7XG4gICAgICBpZiAoIW0pIHtcbiAgICAgICAgcmV0dXJuICcnO1xuICAgICAgfVxuICAgIH1cbiAgICByZXR1cm4gbWVzc2FnZXMuam9pbignXFxuXFx0Jyk7XG4gIH1cbn1cblxuLyoqXG4gKiBJZ25vcmUgdGhlIHN1cHByZXNzaW9uIGlmIGFueSBvZiB0aGUgZ2l2ZW4gSU5hZ1N1cHByZXNzaW9uSWdub3JlIHJldHVybiBhIG5vbi1lbXB0eSBtZXNzYWdlXG4gKi9cbmV4cG9ydCBjbGFzcyBTdXBwcmVzc2lvbklnbm9yZU9yIGltcGxlbWVudHMgSU5hZ1N1cHByZXNzaW9uSWdub3JlIHtcbiAgcHJpdmF0ZSBTdXBwcmVzc2lvbklnbm9yZU9yczogSU5hZ1N1cHByZXNzaW9uSWdub3JlW107XG5cbiAgY29uc3RydWN0b3IoLi4ub3JTdXBwcmVzc2lvbklnbm9yZXM6IElOYWdTdXBwcmVzc2lvbklnbm9yZVtdKSB7XG4gICAgaWYgKG9yU3VwcHJlc3Npb25JZ25vcmVzLmxlbmd0aCA9PT0gMCkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKFxuICAgICAgICAnU3VwcHJlc3Npb25JZ25vcmVPciBuZWVkcyBhdCBsZWFzdCBvbmUgSU5hZ1N1cHByZXNzaW9uSWdub3JlJ1xuICAgICAgKTtcbiAgICB9XG4gICAgdGhpcy5TdXBwcmVzc2lvbklnbm9yZU9ycyA9IG9yU3VwcHJlc3Npb25JZ25vcmVzO1xuICB9XG5cbiAgY3JlYXRlTWVzc2FnZShpbnB1dDogU3VwcHJlc3Npb25JZ25vcmVJbnB1dCk6IHN0cmluZyB7XG4gICAgbGV0IG1lc3NhZ2VzID0gW107XG4gICAgZm9yIChjb25zdCBpIG9mIHRoaXMuU3VwcHJlc3Npb25JZ25vcmVPcnMpIHtcbiAgICAgIGNvbnN0IG0gPSBpLmNyZWF0ZU1lc3NhZ2UoaW5wdXQpO1xuICAgICAgaWYgKG0pIHtcbiAgICAgICAgbWVzc2FnZXMucHVzaChtKTtcbiAgICAgIH1cbiAgICB9XG4gICAgcmV0dXJuIG1lc3NhZ2VzID8gbWVzc2FnZXMuam9pbignXFxuXFx0JykgOiAnJztcbiAgfVxufVxuXG4vKipcbiAqIEFsd2F5cyBpZ25vcmUgdGhlIHN1cHByZXNzaW9uXG4gKi9cbmV4cG9ydCBjbGFzcyBTdXBwcmVzc2lvbklnbm9yZUFsd2F5cyBpbXBsZW1lbnRzIElOYWdTdXBwcmVzc2lvbklnbm9yZSB7XG4gIHByaXZhdGUgdHJpZ2dlck1lc3NhZ2U6IHN0cmluZztcbiAgY29uc3RydWN0b3IodHJpZ2dlck1lc3NhZ2U6IHN0cmluZykge1xuICAgIGlmICh0cmlnZ2VyTWVzc2FnZS5sZW5ndGggPT09IDApIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihcbiAgICAgICAgJ3Byb3ZpZGUgYSB0cmlnZ2VyTWVzc2FnZSBmb3IgdGhlIFN1cHByZXNzaW9uSWdub3JlQWx3YXlzJ1xuICAgICAgKTtcbiAgICB9XG4gICAgdGhpcy50cmlnZ2VyTWVzc2FnZSA9IHRyaWdnZXJNZXNzYWdlO1xuICB9XG4gIGNyZWF0ZU1lc3NhZ2UoX2lucHV0OiBTdXBwcmVzc2lvbklnbm9yZUlucHV0KTogc3RyaW5nIHtcbiAgICByZXR1cm4gdGhpcy50cmlnZ2VyTWVzc2FnZTtcbiAgfVxufVxuXG4vKipcbiAqIERvbid0IGlnbm9yZSB0aGUgc3VwcHJlc3Npb25cbiAqL1xuZXhwb3J0IGNsYXNzIFN1cHByZXNzaW9uSWdub3JlTmV2ZXIgaW1wbGVtZW50cyBJTmFnU3VwcHJlc3Npb25JZ25vcmUge1xuICBjcmVhdGVNZXNzYWdlKF9pbnB1dDogU3VwcHJlc3Npb25JZ25vcmVJbnB1dCk6IHN0cmluZyB7XG4gICAgcmV0dXJuICcnO1xuICB9XG59XG5cbi8qKlxuICogSWdub3JlIFN1cHByZXNzaW9ucyBmb3IgUnVsZXMgd2l0aCBhIE5hZ01lc3NhZ2VMZXZlbC5FUlJPUlxuICovXG5leHBvcnQgY2xhc3MgU3VwcHJlc3Npb25JZ25vcmVFcnJvcnMgaW1wbGVtZW50cyBJTmFnU3VwcHJlc3Npb25JZ25vcmUge1xuICBjcmVhdGVNZXNzYWdlKGlucHV0OiBTdXBwcmVzc2lvbklnbm9yZUlucHV0KTogc3RyaW5nIHtcbiAgICByZXR1cm4gaW5wdXQucnVsZUxldmVsID09IE5hZ01lc3NhZ2VMZXZlbC5FUlJPUlxuICAgICAgPyBgJHtpbnB1dC5ydWxlSWR9IGlzIGNhdGVnb3JpemVkIGFzIGFuIEVSUk9SIGFuZCBtYXkgbm90IGJlIHN1cHByZXNzZWRgXG4gICAgICA6ICcnO1xuICB9XG59XG4iXX0=