# mypy-boto3-timestream-write

[![PyPI - mypy-boto3-timestream-write](https://img.shields.io/pypi/v/mypy-boto3-timestream-write.svg?color=blue)](https://pypi.org/project/mypy-boto3-timestream-write)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-timestream-write.svg?color=blue)](https://pypi.org/project/mypy-boto3-timestream-write)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-timestream-write?color=blue)](https://pypistats.org/packages/mypy-boto3-timestream-write)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.TimestreamWrite 1.17.63](https://boto3.amazonaws.com/v1/documentation/api/1.17.63/reference/services/timestream-write.html#TimestreamWrite)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.10.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-timestream-write docs](https://github.com/vemel/mypy_boto3_builder/service_docs/mypy_boto3_timestream_write/README.md)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-timestream-write](#mypy-boto3-timestream-write)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)

## How to install

Install `boto3-stubs` for `TimestreamWrite` service.

```bash
python -m pip install boto3-stubs[timestream-write]
```

## Usage

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[timestream-write]` in your environment:
  `python -m pip install 'boto3-stubs[timestream-write]'`

Both type checking and auto-complete should work for `TimestreamWrite` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[timestream-write]` in your environment:
  `python -m pip install 'boto3-stubs[timestream-write]'`

Both type checking and auto-complete should work for `TimestreamWrite` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[timestream-write]` in your environment:
  `python -m pip install 'boto3-stubs[timestream-write]'`
- Run `mypy` as usual

Type checking should work for `TimestreamWrite` service. No explicit type
annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[timestream-write]` in your environment:
  `python -m pip install 'boto3-stubs[timestream-write]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `TimestreamWrite` service. No explicit type
annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`TimestreamWriteClient` provides annotations for
`boto3.client("timestream-write")`.

```python
import boto3

from mypy_boto3_timestream_write import TimestreamWriteClient

client: TimestreamWriteClient = boto3.client("timestream-write")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: TimestreamWriteClient = session.client("timestream-write")
```

### Literals

`mypy_boto3_timestream_write.literals` module contains literals extracted from
shapes that can be used in user code for type checking.

```python
from mypy_boto3_timestream_write.literals import (
    DimensionValueType,
    MeasureValueType,
    TableStatus,
    TimeUnit,
)

def check_value(value: DimensionValueType) -> bool:
    ...
```

### Typed dictionaries

`mypy_boto3_timestream_write.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_timestream_write.type_defs import (
    CreateDatabaseResponseTypeDef,
    CreateTableResponseTypeDef,
    DatabaseTypeDef,
    DescribeDatabaseResponseTypeDef,
    DescribeEndpointsResponseTypeDef,
    DescribeTableResponseTypeDef,
    DimensionTypeDef,
    EndpointTypeDef,
    ListDatabasesResponseTypeDef,
    ListTablesResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    RecordTypeDef,
    RetentionPropertiesTypeDef,
    TableTypeDef,
    TagTypeDef,
    UpdateDatabaseResponseTypeDef,
    UpdateTableResponseTypeDef,
)

def get_structure() -> CreateDatabaseResponseTypeDef:
    return {
      ...
    }
```
