<figure markdown="span">
  ![Image title](assets/balatrobot.svg){ width="256" }
  <figcaption>A framework for developing Balatro bots</figcaption>
</figure>

---

BalatroBot is a Python framework designed to help developers create automated bots for the card game Balatro. The framework provides a comprehensive API for interacting with the game, handling game state, making strategic decisions, and executing actions. Whether you're building a simple bot or a sophisticated AI player, BalatroBot offers the tools and structure needed to get started quickly.

<div class="grid cards" markdown>

- :material-download:{ .lg .middle } __Installation__

    ---

    Setup guide covering prerequisites, Steamodded mod installation, and Python environment setup.

    [:octicons-arrow-right-24: Installation](installation.md)

- :material-robot:{ .lg .middle } __Developing Bots__

    ---

    Learn to develop bots with complete code examples, class structure, and game state handling.

    [:octicons-arrow-right-24: Developing Bots](developing-bots.md)

- :material-api:{ .lg .middle } __Protocol API__

    ---

    Technical reference for TCP socket communication, message formats, game states, and action types.

    [:octicons-arrow-right-24: Protocol API](protocol-api.md)

- :octicons-sparkle-fill-16:{ .lg .middle } __Documentation for LLM__

    ---

    Documentation in [llms.txt](https://llmstxt.org/) format. Just paste the following link (or its content) into the LLM chat.

    [:octicons-arrow-right-24: llms-full.txt](llms-full.txt)

</div>
