"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImportedEnvironment = exports.Environment = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("aws-cdk-lib/aws-ec2");
const ecs = require("aws-cdk-lib/aws-ecs");
const constructs_1 = require("constructs");
const extension_interfaces_1 = require("./extensions/extension-interfaces");
/**
 * An environment into which to deploy a service. This environment
 * can either be instantiated with a pre-existing AWS VPC and ECS cluster,
 * or it can create its own VPC and cluster. By default, it will create
 * a cluster with Fargate capacity.
 */
class Environment extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        if (props && props.vpc) {
            this.vpc = props.vpc;
        }
        else {
            this.vpc = new ec2.Vpc(this.scope, `${this.id}-environment-vpc`);
        }
        if (props && props.cluster) {
            this._cluster = props.cluster;
        }
        else {
            this._cluster = new ecs.Cluster(this.scope, `${this.id}-environment-cluster`, { vpc: this.vpc });
        }
        if (props && props.capacityType) {
            this.capacityType = props.capacityType;
        }
        else {
            this.capacityType = extension_interfaces_1.EnvironmentCapacityType.FARGATE;
        }
    }
    /**
     * Import an existing environment from its attributes.
     */
    static fromEnvironmentAttributes(scope, id, attrs) {
        return new ImportedEnvironment(scope, id, attrs);
    }
    /**
     * The cluster that is providing capacity for this service.
     */
    get cluster() {
        return this._cluster;
    }
    ;
    /**
     * Add a default cloudmap namespace to the environment's cluster.
     * The environment's cluster must not be imported.
     */
    addDefaultCloudMapNamespace(options) {
        this._cluster.addDefaultCloudMapNamespace(options);
    }
}
exports.Environment = Environment;
_a = JSII_RTTI_SYMBOL_1;
Environment[_a] = { fqn: "cdk-ecs-service-extensions.Environment", version: "0.0.2" };
class ImportedEnvironment extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.id = id;
        this.capacityType = props.capacityType;
        this.cluster = props.cluster;
        this.vpc = props.cluster.vpc;
    }
    /**
     * Adding a default cloudmap namespace to the cluster will throw an error, as we don't
     * own it.
     */
    addDefaultCloudMapNamespace(_options) {
        throw new Error('the cluster environment is immutable when imported');
    }
}
exports.ImportedEnvironment = ImportedEnvironment;
_b = JSII_RTTI_SYMBOL_1;
ImportedEnvironment[_b] = { fqn: "cdk-ecs-service-extensions.ImportedEnvironment", version: "0.0.2" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZW52aXJvbm1lbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvZW52aXJvbm1lbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSwyQ0FBMkM7QUFDM0MsMkNBQTJDO0FBQzNDLDJDQUF1QztBQUN2Qyw0RUFBNEU7QUEyRDVFOzs7OztHQUtHO0FBQ0gsTUFBYSxXQUFZLFNBQVEsc0JBQVM7SUFpQ3hDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBd0I7UUFDaEUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztRQUNuQixJQUFJLENBQUMsRUFBRSxHQUFHLEVBQUUsQ0FBQztRQUViLElBQUksS0FBSyxJQUFJLEtBQUssQ0FBQyxHQUFHLEVBQUU7WUFDdEIsSUFBSSxDQUFDLEdBQUcsR0FBRyxLQUFLLENBQUMsR0FBRyxDQUFDO1NBQ3RCO2FBQU07WUFDTCxJQUFJLENBQUMsR0FBRyxHQUFHLElBQUksR0FBRyxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFLEdBQUcsSUFBSSxDQUFDLEVBQUUsa0JBQWtCLENBQUMsQ0FBQztTQUNsRTtRQUVELElBQUksS0FBSyxJQUFJLEtBQUssQ0FBQyxPQUFPLEVBQUU7WUFDMUIsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDO1NBQy9CO2FBQU07WUFDTCxJQUFJLENBQUMsUUFBUSxHQUFHLElBQUksR0FBRyxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFLEdBQUcsSUFBSSxDQUFDLEVBQUUsc0JBQXNCLEVBQUUsRUFBRSxHQUFHLEVBQUUsSUFBSSxDQUFDLEdBQUcsRUFBRSxDQUFDLENBQUM7U0FDbEc7UUFFRCxJQUFJLEtBQUssSUFBSSxLQUFLLENBQUMsWUFBWSxFQUFFO1lBQy9CLElBQUksQ0FBQyxZQUFZLEdBQUcsS0FBSyxDQUFDLFlBQVksQ0FBQztTQUN4QzthQUFNO1lBQ0wsSUFBSSxDQUFDLFlBQVksR0FBRyw4Q0FBdUIsQ0FBQyxPQUFPLENBQUM7U0FDckQ7SUFDSCxDQUFDO0lBdkREOztPQUVHO0lBQ0ksTUFBTSxDQUFDLHlCQUF5QixDQUFDLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTRCO1FBQ2hHLE9BQU8sSUFBSSxtQkFBbUIsQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssQ0FBQyxDQUFDO0lBQ25ELENBQUM7SUFZRDs7T0FFRztJQUNILElBQVcsT0FBTztRQUNoQixPQUFPLElBQUksQ0FBQyxRQUFRLENBQUM7SUFDdkIsQ0FBQztJQUFBLENBQUM7SUFtQ0Y7OztPQUdHO0lBQ0ksMkJBQTJCLENBQUMsT0FBcUM7UUFDdEUsSUFBSSxDQUFDLFFBQVEsQ0FBQywyQkFBMkIsQ0FBQyxPQUFPLENBQUMsQ0FBQztJQUNyRCxDQUFDOztBQWhFSCxrQ0FpRUM7OztBQWNELE1BQWEsbUJBQW9CLFNBQVEsc0JBQVM7SUFNaEQsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUE0QjtRQUNwRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLElBQUksQ0FBQyxFQUFFLEdBQUcsRUFBRSxDQUFDO1FBQ2IsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUMsWUFBWSxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQztRQUM3QixJQUFJLENBQUMsR0FBRyxHQUFHLEtBQUssQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDO0lBQy9CLENBQUM7SUFFRDs7O09BR0c7SUFDSCwyQkFBMkIsQ0FBQyxRQUFzQztRQUNoRSxNQUFNLElBQUksS0FBSyxDQUFDLG9EQUFvRCxDQUFDLENBQUM7SUFDeEUsQ0FBQzs7QUFyQkgsa0RBc0JDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgZWMyIGZyb20gJ2F3cy1jZGstbGliL2F3cy1lYzInO1xuaW1wb3J0ICogYXMgZWNzIGZyb20gJ2F3cy1jZGstbGliL2F3cy1lY3MnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBFbnZpcm9ubWVudENhcGFjaXR5VHlwZSB9IGZyb20gJy4vZXh0ZW5zaW9ucy9leHRlbnNpb24taW50ZXJmYWNlcyc7XG5cbi8qKlxuICogU2V0dGluZ3MgZm9yIHRoZSBlbnZpcm9ubWVudCB3aGVyZSB5b3Ugd2FudCB0byBkZXBsb3kgeW91ciBzZXJ2aWNlcy5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBFbnZpcm9ubWVudFByb3BzIHtcbiAgLyoqXG4gICAqIFRoZSBWUEMgdXNlZCBieSB0aGUgc2VydmljZSBmb3IgbmV0d29ya2luZy5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBDcmVhdGUgYSBuZXcgVlBDXG4gICAqL1xuICByZWFkb25seSB2cGM/OiBlYzIuSVZwYztcblxuICAvKipcbiAgICogVGhlIEVDUyBjbHVzdGVyIHdoaWNoIHByb3ZpZGVzIGNvbXB1dGUgY2FwYWNpdHkgdG8gdGhpcyBzZXJ2aWNlLlxuICAgKlxuICAgKiBbZGlzYWJsZS1hd3NsaW50OnJlZi12aWEtaW50ZXJmYWNlXVxuICAgKiBAZGVmYXVsdCAtIENyZWF0ZSBhIG5ldyBjbHVzdGVyXG4gICAqL1xuICByZWFkb25seSBjbHVzdGVyPzogZWNzLkNsdXN0ZXI7XG5cbiAgLyoqXG4gICAqIFRoZSB0eXBlIG9mIGNhcGFjaXR5IHRvIHVzZSBmb3IgdGhpcyBlbnZpcm9ubWVudC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBFbnZpcm9ubWVudENhcGFjaXR5VHlwZS5GQVJHQVRFXG4gICAqL1xuICByZWFkb25seSBjYXBhY2l0eVR5cGU/OiBFbnZpcm9ubWVudENhcGFjaXR5VHlwZTtcbn1cblxuLyoqXG4gKiBBbiBlbnZpcm9ubWVudCBpbnRvIHdoaWNoIHRvIGRlcGxveSBhIHNlcnZpY2UuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSUVudmlyb25tZW50IHtcbiAgLyoqXG4gICAqIFRoZSBuYW1lIG9mIHRoaXMgZW52aXJvbm1lbnQuXG4gICAqL1xuICByZWFkb25seSBpZDogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgVlBDIGludG8gd2hpY2ggZW52aXJvbm1lbnQgc2VydmljZXMgc2hvdWxkIGJlIHBsYWNlZC5cbiAgICovXG4gIHJlYWRvbmx5IHZwYzogZWMyLklWcGM7XG5cbiAgLyoqXG4gICAqIFRoZSBjbHVzdGVyIHRoYXQgaXMgcHJvdmlkaW5nIGNhcGFjaXR5IGZvciB0aGlzIHNlcnZpY2UuXG4gICAqL1xuICByZWFkb25seSBjbHVzdGVyOiBlY3MuSUNsdXN0ZXI7XG5cbiAgLyoqXG4gICAqIFRoZSBjYXBhY2l0eSB0eXBlIHVzZWQgYnkgdGhlIHNlcnZpY2UncyBjbHVzdGVyLlxuICAgKi9cbiAgcmVhZG9ubHkgY2FwYWNpdHlUeXBlOiBFbnZpcm9ubWVudENhcGFjaXR5VHlwZTtcblxuICAvKipcbiAgICogQWRkIGEgZGVmYXVsdCBjbG91ZG1hcCBuYW1lc3BhY2UgdG8gdGhlIGVudmlyb25tZW50J3MgY2x1c3Rlci5cbiAgICovXG4gIGFkZERlZmF1bHRDbG91ZE1hcE5hbWVzcGFjZShvcHRpb25zOiBlY3MuQ2xvdWRNYXBOYW1lc3BhY2VPcHRpb25zKTogdm9pZDtcbn1cblxuLyoqXG4gKiBBbiBlbnZpcm9ubWVudCBpbnRvIHdoaWNoIHRvIGRlcGxveSBhIHNlcnZpY2UuIFRoaXMgZW52aXJvbm1lbnRcbiAqIGNhbiBlaXRoZXIgYmUgaW5zdGFudGlhdGVkIHdpdGggYSBwcmUtZXhpc3RpbmcgQVdTIFZQQyBhbmQgRUNTIGNsdXN0ZXIsXG4gKiBvciBpdCBjYW4gY3JlYXRlIGl0cyBvd24gVlBDIGFuZCBjbHVzdGVyLiBCeSBkZWZhdWx0LCBpdCB3aWxsIGNyZWF0ZVxuICogYSBjbHVzdGVyIHdpdGggRmFyZ2F0ZSBjYXBhY2l0eS5cbiAqL1xuZXhwb3J0IGNsYXNzIEVudmlyb25tZW50IGV4dGVuZHMgQ29uc3RydWN0IGltcGxlbWVudHMgSUVudmlyb25tZW50IHtcbiAgLyoqXG4gICAqIEltcG9ydCBhbiBleGlzdGluZyBlbnZpcm9ubWVudCBmcm9tIGl0cyBhdHRyaWJ1dGVzLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBmcm9tRW52aXJvbm1lbnRBdHRyaWJ1dGVzKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIGF0dHJzOiBFbnZpcm9ubWVudEF0dHJpYnV0ZXMpOiBJRW52aXJvbm1lbnQge1xuICAgIHJldHVybiBuZXcgSW1wb3J0ZWRFbnZpcm9ubWVudChzY29wZSwgaWQsIGF0dHJzKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBUaGUgbmFtZSBvZiB0aGlzIGVudmlyb25tZW50LlxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IGlkOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBWUEMgd2hlcmUgZW52aXJvbm1lbnQgc2VydmljZXMgc2hvdWxkIGJlIHBsYWNlZC5cbiAgICovXG4gIHB1YmxpYyByZWFkb25seSB2cGM6IGVjMi5JVnBjO1xuXG4gIC8qKlxuICAgKiBUaGUgY2x1c3RlciB0aGF0IGlzIHByb3ZpZGluZyBjYXBhY2l0eSBmb3IgdGhpcyBzZXJ2aWNlLlxuICAgKi9cbiAgcHVibGljIGdldCBjbHVzdGVyKCk6IGVjcy5JQ2x1c3RlciB7XG4gICAgcmV0dXJuIHRoaXMuX2NsdXN0ZXI7XG4gIH07XG5cbiAgLyoqXG4gICAqIFRoZSBjYXBhY2l0eSB0eXBlIHVzZWQgYnkgdGhlIHNlcnZpY2UncyBjbHVzdGVyLlxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IGNhcGFjaXR5VHlwZTogRW52aXJvbm1lbnRDYXBhY2l0eVR5cGU7XG5cbiAgcHJpdmF0ZSByZWFkb25seSBzY29wZTogQ29uc3RydWN0O1xuICBwcml2YXRlIHJlYWRvbmx5IF9jbHVzdGVyOiBlY3MuQ2x1c3RlcjtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wcz86IEVudmlyb25tZW50UHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgdGhpcy5zY29wZSA9IHNjb3BlO1xuICAgIHRoaXMuaWQgPSBpZDtcblxuICAgIGlmIChwcm9wcyAmJiBwcm9wcy52cGMpIHtcbiAgICAgIHRoaXMudnBjID0gcHJvcHMudnBjO1xuICAgIH0gZWxzZSB7XG4gICAgICB0aGlzLnZwYyA9IG5ldyBlYzIuVnBjKHRoaXMuc2NvcGUsIGAke3RoaXMuaWR9LWVudmlyb25tZW50LXZwY2ApO1xuICAgIH1cblxuICAgIGlmIChwcm9wcyAmJiBwcm9wcy5jbHVzdGVyKSB7XG4gICAgICB0aGlzLl9jbHVzdGVyID0gcHJvcHMuY2x1c3RlcjtcbiAgICB9IGVsc2Uge1xuICAgICAgdGhpcy5fY2x1c3RlciA9IG5ldyBlY3MuQ2x1c3Rlcih0aGlzLnNjb3BlLCBgJHt0aGlzLmlkfS1lbnZpcm9ubWVudC1jbHVzdGVyYCwgeyB2cGM6IHRoaXMudnBjIH0pO1xuICAgIH1cblxuICAgIGlmIChwcm9wcyAmJiBwcm9wcy5jYXBhY2l0eVR5cGUpIHtcbiAgICAgIHRoaXMuY2FwYWNpdHlUeXBlID0gcHJvcHMuY2FwYWNpdHlUeXBlO1xuICAgIH0gZWxzZSB7XG4gICAgICB0aGlzLmNhcGFjaXR5VHlwZSA9IEVudmlyb25tZW50Q2FwYWNpdHlUeXBlLkZBUkdBVEU7XG4gICAgfVxuICB9XG5cbiAgLyoqXG4gICAqIEFkZCBhIGRlZmF1bHQgY2xvdWRtYXAgbmFtZXNwYWNlIHRvIHRoZSBlbnZpcm9ubWVudCdzIGNsdXN0ZXIuXG4gICAqIFRoZSBlbnZpcm9ubWVudCdzIGNsdXN0ZXIgbXVzdCBub3QgYmUgaW1wb3J0ZWQuXG4gICAqL1xuICBwdWJsaWMgYWRkRGVmYXVsdENsb3VkTWFwTmFtZXNwYWNlKG9wdGlvbnM6IGVjcy5DbG91ZE1hcE5hbWVzcGFjZU9wdGlvbnMpIHtcbiAgICB0aGlzLl9jbHVzdGVyLmFkZERlZmF1bHRDbG91ZE1hcE5hbWVzcGFjZShvcHRpb25zKTtcbiAgfVxufVxuXG5leHBvcnQgaW50ZXJmYWNlIEVudmlyb25tZW50QXR0cmlidXRlcyB7XG4gIC8qKlxuICAgKiBUaGUgY2FwYWNpdHkgdHlwZSB1c2VkIGJ5IHRoZSBzZXJ2aWNlJ3MgY2x1c3Rlci5cbiAgICovXG4gIHJlYWRvbmx5IGNhcGFjaXR5VHlwZTogRW52aXJvbm1lbnRDYXBhY2l0eVR5cGU7XG5cbiAgLyoqXG4gICAqIFRoZSBjbHVzdGVyIHRoYXQgaXMgcHJvdmlkaW5nIGNhcGFjaXR5IGZvciB0aGlzIHNlcnZpY2UuXG4gICAqL1xuICByZWFkb25seSBjbHVzdGVyOiBlY3MuSUNsdXN0ZXI7XG59XG5cbmV4cG9ydCBjbGFzcyBJbXBvcnRlZEVudmlyb25tZW50IGV4dGVuZHMgQ29uc3RydWN0IGltcGxlbWVudHMgSUVudmlyb25tZW50IHtcbiAgcHVibGljIHJlYWRvbmx5IGNhcGFjaXR5VHlwZTogRW52aXJvbm1lbnRDYXBhY2l0eVR5cGU7XG4gIHB1YmxpYyByZWFkb25seSBjbHVzdGVyOiBlY3MuSUNsdXN0ZXI7XG4gIHB1YmxpYyByZWFkb25seSBpZDogc3RyaW5nO1xuICBwdWJsaWMgcmVhZG9ubHkgdnBjOiBlYzIuSVZwYztcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogRW52aXJvbm1lbnRBdHRyaWJ1dGVzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIHRoaXMuaWQgPSBpZDtcbiAgICB0aGlzLmNhcGFjaXR5VHlwZSA9IHByb3BzLmNhcGFjaXR5VHlwZTtcbiAgICB0aGlzLmNsdXN0ZXIgPSBwcm9wcy5jbHVzdGVyO1xuICAgIHRoaXMudnBjID0gcHJvcHMuY2x1c3Rlci52cGM7XG4gIH1cblxuICAvKipcbiAgICogQWRkaW5nIGEgZGVmYXVsdCBjbG91ZG1hcCBuYW1lc3BhY2UgdG8gdGhlIGNsdXN0ZXIgd2lsbCB0aHJvdyBhbiBlcnJvciwgYXMgd2UgZG9uJ3RcbiAgICogb3duIGl0LlxuICAgKi9cbiAgYWRkRGVmYXVsdENsb3VkTWFwTmFtZXNwYWNlKF9vcHRpb25zOiBlY3MuQ2xvdWRNYXBOYW1lc3BhY2VPcHRpb25zKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKCd0aGUgY2x1c3RlciBlbnZpcm9ubWVudCBpcyBpbW11dGFibGUgd2hlbiBpbXBvcnRlZCcpO1xuICB9XG59XG4iXX0=