"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.XRayExtension = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const ecs = require("aws-cdk-lib/aws-ecs");
const iam = require("aws-cdk-lib/aws-iam");
const extension_interfaces_1 = require("./extension-interfaces");
const XRAY_DAEMON_IMAGE = 'amazon/aws-xray-daemon:latest';
/**
 * This extension adds an X-Ray daemon inside the task definition for
 * capturing application trace spans and submitting them to the AWS
 * X-Ray service.
 */
class XRayExtension extends extension_interfaces_1.ServiceExtension {
    constructor() {
        super('xray');
    }
    // @ts-ignore - Ignore unused params that are required for abstract class extend
    prehook(service, scope) {
        this.parentService = service;
    }
    useTaskDefinition(taskDefinition) {
        // Add the XRay Daemon to the task
        this.container = taskDefinition.addContainer('xray', {
            image: ecs.ContainerImage.fromRegistry(XRAY_DAEMON_IMAGE),
            essential: true,
            memoryReservationMiB: 256,
            environment: {
                AWS_REGION: aws_cdk_lib_1.Stack.of(this.parentService).region,
            },
            healthCheck: {
                command: [
                    'CMD-SHELL',
                    'curl -s http://localhost:2000',
                ],
                startPeriod: aws_cdk_lib_1.Duration.seconds(10),
                interval: aws_cdk_lib_1.Duration.seconds(5),
                timeout: aws_cdk_lib_1.Duration.seconds(2),
                retries: 3,
            },
            logging: new ecs.AwsLogDriver({ streamPrefix: 'xray' }),
            user: '1337',
        });
        // Add permissions to this task to allow it to talk to X-Ray
        taskDefinition.taskRole.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('AWSXRayDaemonWriteAccess'));
    }
    resolveContainerDependencies() {
        if (!this.container) {
            throw new Error('The container dependency hook was called before the container was created');
        }
        const appmeshextension = this.parentService.serviceDescription.get('appmesh');
        if (appmeshextension && appmeshextension.container) {
            this.container.addContainerDependencies({
                container: appmeshextension.container,
                condition: ecs.ContainerDependencyCondition.HEALTHY,
            });
        }
    }
}
exports.XRayExtension = XRayExtension;
_a = JSII_RTTI_SYMBOL_1;
XRayExtension[_a] = { fqn: "cdk-ecs-service-extensions.XRayExtension", version: "0.0.2" };
//# sourceMappingURL=data:application/json;base64,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