

# Define basic properties of elements (symbol, atomic number, atomic mass, atomic radius)
elements = {
        'H': {'name': 'Hydrogen', 'number': 1, 'mass': 1.008, 'radius': 1.30, 'row': 1, 'column': 1,
              'group': 'Nonmetal'},
        'He': {'name': 'Helium', 'number': 2, 'mass': 4.003, 'radius': 1.40, 'row': 1, 'column': 18,
               'group': 'Noble Gas'},
        'Li': {'name': 'Lithium', 'number': 3, 'mass': 6.941, 'radius': 0.76, 'row': 2, 'column': 1,
               'group': 'Alkali Metal'},
        'Be': {'name': 'Beryllium', 'number': 4, 'mass': 9.012, 'radius': 0.45, 'row': 2, 'column': 2,
               'group': 'Alkaline Earth Metal'},
        'B': {'name': 'Boron', 'number': 5, 'mass': 10.811, 'radius': 1.92, 'row': 2, 'column': 13,
              'group': 'Metalloid'},
        'C': {'name': 'Carbon', 'number': 6, 'mass': 12.011, 'radius': 1.80, 'row': 2, 'column': 14,
              'group': 'Nonmetal'},
        'N': {'name': 'Nitrogen', 'number': 7, 'mass': 14.007, 'radius': 1.60, 'row': 2, 'column': 15,
              'group': 'Nonmetal'},
        'O': {'name': 'Oxygen', 'number': 8, 'mass': 15.999, 'radius': 1.50, 'row': 2, 'column': 16,
              'group': 'Nonmetal'},
        'F': {'name': 'Fluorine', 'number': 9, 'mass': 18.998, 'radius': 1.33, 'row': 2, 'column': 17,
              'group': 'Halogens'},
        'Ne': {'name': 'Neon', 'number': 10, 'mass': 20.180, 'radius': 1.54, 'row': 2, 'column': 18,
               'group': 'Noble Gas'},
        'Na': {'name': 'Sodium', 'number': 11, 'mass': 22.990, 'radius': 1.02, 'row': 3, 'column': 1,
               'group': 'Alkali Metal'},
        'Mg': {'name': 'Magnesium', 'number': 12, 'mass': 24.305, 'radius': 0.72, 'row': 3, 'column': 2,
               'group': 'Alkaline Earth Metal'},
        'Al': {'name': 'Aluminum', 'number': 13, 'mass': 26.982, 'radius': 0.60, 'row': 3, 'column': 13,
               'group': 'Post-transition Metal'},
        'Si': {'name': 'Silicon', 'number': 14, 'mass': 28.086, 'radius': 2.10, 'row': 3, 'column': 14,
               'group': 'Metalloid'},
        'P': {'name': 'Phosphorus', 'number': 15, 'mass': 30.974, 'radius': 1.90, 'row': 3, 'column': 15,
              'group': 'Nonmetal'},
        'S': {'name': 'Sulfur', 'number': 16, 'mass': 32.066, 'radius': 1.90, 'row': 3, 'column': 16,
              'group': 'Nonmetal'},
        'Cl': {'name': 'Chlorine', 'number': 17, 'mass': 35.453, 'radius': 1.81, 'row': 3, 'column': 17,
               'group': 'Halogens'},
        'Ar': {'name': 'Argon', 'number': 18, 'mass': 39.948, 'radius': 1.88, 'row': 3, 'column': 18,
               'group': 'Noble Gas'},
        'K': {'name': 'Potassium', 'number': 19, 'mass': 39.098, 'radius': 1.38, 'row': 4, 'column': 1,
              'group': 'Alkali Metal'},
        'Ca': {'name': 'Calcium', 'number': 20, 'mass': 40.078, 'radius': 1.00, 'row': 4, 'column': 2,
               'group': 'Alkaline Earth Metal'},
        'Ga': {'name': 'Gallium', 'number': 31, 'mass': 69.723, 'radius': 0.62, 'row': 4, 'column': 13,
               'group': 'Post-transition Metal'},
        'Ge': {'name': 'Germanium', 'number': 32, 'mass': 72.631, 'radius': 0.73, 'row': 4, 'column': 14,
               'group': 'Metalloid'},
        'As': {'name': 'Arsenic', 'number': 33, 'mass': 74.922, 'radius': 0.58, 'row': 4, 'column': 15,
               'group': 'Metalloid'},
        'Se': {'name': 'Selenium', 'number': 34, 'mass': 78.971, 'radius': 1.90, 'row': 4, 'column': 16,
               'group': 'Nonmetal'},
        'Br': {'name': 'Bromine', 'number': 35, 'mass': 79.904, 'radius': 1.83, 'row': 4, 'column': 17,
               'group': 'Halogens'},
        'Kr': {'name': 'Krypton', 'number': 36, 'mass': 83.798, 'radius': 2.02, 'row': 4, 'column': 18,
               'group': 'Noble Gas'},
        'Rb': {'name': 'Rubidium', 'number': 37, 'mass': 85.468, 'radius': 1.52, 'row': 5, 'column': 1,
               'group': 'Alkali Metal'},
        'Sr': {'name': 'Strontium', 'number': 38, 'mass': 87.62, 'radius': 1.18, 'row': 5, 'column': 2,
               'group': 'Alkaline Earth Metal'},
        'In': {'name': 'Indium', 'number': 49, 'mass': 114.818, 'radius': 1.93, 'row': 5, 'column': 13,
               'group': 'Post-transition Metal'},
        'Sn': {'name': 'Tin', 'number': 50, 'mass': 118.711, 'radius': 2.17, 'row': 5, 'column': 14,
               'group': 'Post-transition Metal'},
        'Sb': {'name': 'Antimony', 'number': 51, 'mass': 121.760, 'radius': 2.06, 'row': 5, 'column': 15,
               'group': 'Metalloid'},
        'Te': {'name': 'Tellurium', 'number': 52, 'mass': 127.6, 'radius': 2.06, 'row': 5, 'column': 16,
               'group': 'Metalloid'},
        'I': {'name': 'Iodine', 'number': 53, 'mass': 126.904, 'radius': 2.20, 'row': 5, 'column': 17,
              'group': 'Halogens'},
        'Xe': {'name': 'Xenon', 'number': 54, 'mass': 131.293, 'radius': 2.16, 'row': 5, 'column': 18,
               'group': 'Noble Gas'},
        'Cs': {'name': 'Cesium', 'number': 55, 'mass': 132.905, 'radius': 1.67, 'row': 6, 'column': 1,
               'group': 'Alkali Metal'},
        'Ba': {'name': 'Barium', 'number': 56, 'mass': 137.328, 'radius': 1.35, 'row': 6, 'column': 2,
               'group': 'Alkaline Earth Metal'},
        'Tl': {'name': 'Thallium', 'number': 81, 'mass': 204.383, 'radius': 1.96, 'row': 6, 'column': 13,
               'group': 'Post-transition Metal'},
        'Pb': {'name': 'Lead', 'number': 82, 'mass': 207.2, 'radius': 2.02, 'row': 6, 'column': 14,
               'group': 'Post-transition Metal'},
        'Bi': {'name': 'Bismuth', 'number': 83, 'mass': 208.980, 'radius': 2.07, 'row': 6, 'column': 15,
               'group': 'Post-transition Metal'},
        'Po': {'name': 'Polonium', 'number': 84, 'mass': 208.982, 'radius': 1.97, 'row': 6, 'column': 16,
               'group': 'Metalloid'},
        'At': {'name': 'Astatine', 'number': 85, 'mass': 209.987, 'radius': 2.02, 'row': 6, 'column': 17,
               'group': 'Halogens'},
        'Rn': {'name': 'Radon', 'number': 86, 'mass': 222.018, 'radius': 2.20, 'row': 6, 'column': 18,
               'group': 'Noble Gas'},
        'Fr': {'name': 'Francium', 'number': 87, 'mass': 223.020, 'radius': 3.48, 'row': 7, 'column': 1,
               'group': 'Alkali Metal'},
        'Ra': {'name': 'Radium', 'number': 88, 'mass': 226.025, 'radius': 2.83, 'row': 7, 'column': 2,
               'group': 'Alkaline Earth Metal'},
        'Zn': {'name': 'Zinc', 'number': 30, 'mass': 65.38, 'radius': 1.39, 'row': 4, 'column': 12,
               'group': 'Transition Metal'}
    }


special_radii = {
    'ALA': {
        'C': {'radius': 1.75, 'mass': 12.011}, 'CA': {'radius': 1.9, 'mass': 12.011}, 'CB': {'radius': 1.92, 'mass': 12.011}, 
        'H': {'radius': 1.3, 'mass': 1.008}, 'HA': {'radius': 1.3, 'mass': 1.008}, 'HB1': {'radius': 1.3, 'mass': 1.008}, 
        'HB2': {'radius': 1.3, 'mass': 1.008}, 'HB3': {'radius': 1.3, 'mass': 1.008}, 'N': {'radius': 1.7, 'mass': 14.007}, 
        'O': {'radius': 1.49, 'mass': 15.999}, 'OC1': {'radius': 1.5, 'mass': 15.999}, 'OC2': {'radius': 1.5, 'mass': 15.999}
    },
    'ARG': {
        'C': {'radius': 1.75, 'mass': 12.011}, 'CA': {'radius': 1.9, 'mass': 12.011}, 'CB': {'radius': 1.91, 'mass': 12.011}, 
        'CD': {'radius': 1.88, 'mass': 12.011}, 'CG': {'radius': 1.92, 'mass': 12.011}, 'CZ': {'radius': 1.8, 'mass': 12.011}, 
        'H': {'radius': 1.3, 'mass': 1.008}, 'HA': {'radius': 1.3, 'mass': 1.008}, 'HB1': {'radius': 1.3, 'mass': 1.008}, 
        'HB2': {'radius': 1.3, 'mass': 1.008}, 'HB3': {'radius': 1.3, 'mass': 1.008}, 'HD1': {'radius': 1.3, 'mass': 1.008}, 
        'HD2': {'radius': 1.3, 'mass': 1.008}, 'HD3': {'radius': 1.3, 'mass': 1.008}, 'HE': {'radius': 1.3, 'mass': 1.008}, 
        'HG1': {'radius': 1.3, 'mass': 1.008}, 'HG2': {'radius': 1.3, 'mass': 1.008}, 'HH11': {'radius': 1.3, 'mass': 1.008}, 
        'HH12': {'radius': 1.3, 'mass': 1.008}, 'HH21': {'radius': 1.3, 'mass': 1.008}, 'HH22': {'radius': 1.3, 'mass': 1.008}, 
        'N': {'radius': 1.7, 'mass': 14.007}, 'NE': {'radius': 1.62, 'mass': 14.007}, 'NH1': {'radius': 1.62, 'mass': 14.007}, 
        'NH2': {'radius': 1.67, 'mass': 14.007}, 'O': {'radius': 1.49, 'mass': 15.999}
    },
    'ASN': {
        'C': {'radius': 1.75, 'mass': 12.011}, 'CA': {'radius': 1.9, 'mass': 12.011}, 'CB': {'radius': 1.91, 'mass': 12.011}, 
        'CG': {'radius': 1.81, 'mass': 12.011}, 'H': {'radius': 1.3, 'mass': 1.008}, 'HA': {'radius': 1.3, 'mass': 1.008}, 
        'HB1': {'radius': 1.3, 'mass': 1.008}, 'HB2': {'radius': 1.3, 'mass': 1.008}, 'HD21': {'radius': 1.3, 'mass': 1.008},
        'HD22': {'radius': 1.3, 'mass': 1.008}, 'N': {'radius': 1.7, 'mass': 14.007}, 'ND2': {'radius': 1.62, 'mass': 14.007}, 
        'O': {'radius': 1.49, 'mass': 15.999}, 'OD1': {'radius': 1.52, 'mass': 15.999}
    },
    'ASP': {
        'C': {'radius': 1.75, 'mass': 12.011}, 'CA': {'radius': 1.9, 'mass': 12.011}, 'CB': {'radius': 1.91, 'mass': 12.011}, 
        'CG': {'radius': 1.76, 'mass': 12.011}, 'H': {'radius': 1.3, 'mass': 1.008}, 'HA': {'radius': 1.3, 'mass': 1.008}, 
        'HB1': {'radius': 1.3, 'mass': 1.008}, 'HB2': {'radius': 1.3, 'mass': 1.008}, 'N': {'radius': 1.7, 'mass': 14.007}, 
        'O': {'radius': 1.49, 'mass': 15.999}, 'OD1': {'radius': 1.49, 'mass': 15.999}, 'OD2': {'radius': 1.49, 'mass': 15.999}
    },
    'CYS': {
        'C': {'radius': 1.75, 'mass': 12.011}, 'CA': {'radius': 1.9, 'mass': 12.011}, 'CB': {'radius': 1.91, 'mass': 12.011}, 
        'H': {'radius': 1.3, 'mass': 1.008}, 'HA': {'radius': 1.3, 'mass': 1.008}, 'HB1': {'radius': 1.3, 'mass': 1.008}, 
        'HB2': {'radius': 1.3, 'mass': 1.008}, 'HG': {'radius': 1.3, 'mass': 1.008}, 'N': {'radius': 1.7, 'mass': 14.007}, 
        'O': {'radius': 1.49, 'mass': 15.999}, 'S': {'radius': 1.88, 'mass': 32.06}, 'SG': {'radius': 1.88, 'mass': 32.06}
    },
    'GLN': {
        'C': {'radius': 1.75, 'mass': 12.011}, 'CA': {'radius': 1.9, 'mass': 12.011}, 'CB': {'radius': 1.91, 'mass': 12.011}, 
        'CD': {'radius': 1.81, 'mass': 12.011}, 'CG': {'radius': 1.8, 'mass': 12.011}, 'H': {'radius': 1.3, 'mass': 1.008}, 
        'HA': {'radius': 1.3, 'mass': 1.008}, 'HB1': {'radius': 1.3, 'mass': 1.008}, 'HB2': {'radius': 1.3, 'mass': 1.008},
        'HE21': {'radius': 1.3, 'mass': 1.008}, 'HE22': {'radius': 1.3, 'mass': 1.008}, 'HG1': {'radius': 1.3, 'mass': 1.008}, 
        'HG2': {'radius': 1.3, 'mass': 1.008}, 'N': {'radius': 1.7, 'mass': 14.007}, 'NE2': {'radius': 1.62, 'mass': 14.007}, 
        'O': {'radius': 1.49, 'mass': 15.999}, 'OE1': {'radius': 1.52, 'mass': 15.999}
    },
    'GLU': {
        'C': {'radius': 1.75, 'mass': 12.011}, 'CA': {'radius': 1.9, 'mass': 12.011}, 'CB': {'radius': 1.91, 'mass': 12.011}, 
        'CD': {'radius': 1.76, 'mass': 12.011}, 'CG': {'radius': 1.88, 'mass': 12.011}, 'H': {'radius': 1.3, 'mass': 1.008}, 
        'HA': {'radius': 1.3, 'mass': 1.008}, 'HB1': {'radius': 1.3, 'mass': 1.008}, 'HB2': {'radius': 1.3, 'mass': 1.008},
        'HG1': {'radius': 1.3, 'mass': 1.008}, 'HG2': {'radius': 1.3, 'mass': 1.008}, 'N': {'radius': 1.7, 'mass': 14.007}, 
        'O': {'radius': 1.49, 'mass': 15.999}, 'OE1': {'radius': 1.49, 'mass': 15.999}, 'OE2': {'radius': 1.49, 'mass': 15.999}
    },
    'GLY': {
        'C': {'radius': 1.75, 'mass': 12.011}, 'CA': {'radius': 1.9, 'mass': 12.011}, 
        'H': {'radius': 1.3, 'mass': 1.008}, 'HA1': {'radius': 1.3, 'mass': 1.008}, 
        'HA2': {'radius': 1.3, 'mass': 1.008}, 'N': {'radius': 1.7, 'mass': 14.007}, 
        'O': {'radius': 1.49, 'mass': 15.999}, 'OC1': {'radius': 1.5, 'mass': 15.999}, 
        'OC2': {'radius': 1.5, 'mass': 15.999}
    },
    'HIS': {
        'C': {'radius': 1.75, 'mass': 12.011}, 'CA': {'radius': 1.9, 'mass': 12.011}, 'CB': {'radius': 1.91, 'mass': 12.011}, 
        'CD': {'radius': 1.74, 'mass': 12.011}, 'CE': {'radius': 1.74, 'mass': 12.011}, 'CD2': {'radius': 1.74, 'mass': 12.011}, 
        'CE1': {'radius': 1.74, 'mass': 12.011}, 'CG': {'radius': 1.8, 'mass': 12.011}, 'H': {'radius': 1.3, 'mass': 1.008}, 
        'HA': {'radius': 1.3, 'mass': 1.008}, 'HB1': {'radius': 1.3, 'mass': 1.008}, 'HB2': {'radius': 1.3, 'mass': 1.008}, 
        'HD2': {'radius': 1.3, 'mass': 1.008}, 'HE1': {'radius': 1.3, 'mass': 1.008}, 'HE2': {'radius': 1.3, 'mass': 1.008}, 
        'N': {'radius': 1.7, 'mass': 14.007}, 'ND1': {'radius': 1.6, 'mass': 14.007}, 'ND2': {'radius': 1.6, 'mass': 14.007}, 
        'NE2': {'radius': 1.6, 'mass': 14.007}, 'O': {'radius': 1.49, 'mass': 15.999}
    },
    'ILE': {
        'C': {'radius': 1.75, 'mass': 12.011}, 'CA': {'radius': 1.9, 'mass': 12.011}, 'CB': {'radius': 2.01, 'mass': 12.011}, 
        'CD': {'radius': 1.92, 'mass': 12.011}, 'CD1': {'radius': 1.92, 'mass': 12.011}, 'CG1': {'radius': 1.92, 'mass': 12.011}, 
        'CG2': {'radius': 1.92, 'mass': 12.011}, 'H': {'radius': 1.3, 'mass': 1.008}, 'HA': {'radius': 1.3, 'mass': 1.008},
        'HB': {'radius': 1.3, 'mass': 1.008}, 'HD1': {'radius': 1.3, 'mass': 1.008}, 'HD2': {'radius': 1.3, 'mass': 1.008}, 
        'HD3': {'radius': 1.3, 'mass': 1.008}, 'HD11': {'radius': 1.3, 'mass': 1.008}, 'HD12': {'radius': 1.3, 'mass': 1.008}, 
        'HD13': {'radius': 1.3, 'mass': 1.008}, 'HG12': {'radius': 1.3, 'mass': 1.008}, 'HG13': {'radius': 1.3, 'mass': 1.008},
        'HG21': {'radius': 1.3, 'mass': 1.008}, 'HG22': {'radius': 1.3, 'mass': 1.008}, 'HG23': {'radius': 1.3, 'mass': 1.008}, 
        'N': {'radius': 1.7, 'mass': 14.007}, 'O': {'radius': 1.49, 'mass': 15.999}
    },
    'LEU': {
        'C': {'radius': 1.75, 'mass': 12.011}, 'CA': {'radius': 1.9, 'mass': 12.011}, 'CB': {'radius': 1.91, 'mass': 12.011}, 
        'CD1': {'radius': 1.92, 'mass': 12.011}, 'CD2': {'radius': 1.92, 'mass': 12.011}, 'CG': {'radius': 2.01, 'mass': 12.011}, 
        'H': {'radius': 1.3, 'mass': 1.008}, 'HA': {'radius': 1.3, 'mass': 1.008}, 'HB1': {'radius': 1.3, 'mass': 1.008},
        'HB2': {'radius': 1.3, 'mass': 1.008}, 'HD11': {'radius': 1.3, 'mass': 1.008}, 'HD12': {'radius': 1.3, 'mass': 1.008}, 
        'HD13': {'radius': 1.3, 'mass': 1.008}, 'HD21': {'radius': 1.3, 'mass': 1.008}, 'HD22': {'radius': 1.3, 'mass': 1.008}, 
        'HD23': {'radius': 1.3, 'mass': 1.008}, 'HG': {'radius': 1.3, 'mass': 1.008}, 'N': {'radius': 1.7, 'mass': 14.007},
        'O': {'radius': 1.49, 'mass': 15.999}
    },
    'LYS': {
        'C': {'radius': 1.75, 'mass': 12.011}, 'CA': {'radius': 1.9, 'mass': 12.011}, 'CB': {'radius': 1.91, 'mass': 12.011}, 
        'CD': {'radius': 1.92, 'mass': 12.011}, 'CE': {'radius': 1.88, 'mass': 12.011}, 'CG': {'radius': 1.92, 'mass': 12.011}, 
        'H': {'radius': 1.3, 'mass': 1.008}, 'HA': {'radius': 1.3, 'mass': 1.008}, 'HB1': {'radius': 1.3, 'mass': 1.008},
        'HB2': {'radius': 1.3, 'mass': 1.008}, 'HD1': {'radius': 1.3, 'mass': 1.008}, 'HD2': {'radius': 1.3, 'mass': 1.008}, 
        'HE1': {'radius': 1.3, 'mass': 1.008}, 'HE2': {'radius': 1.3, 'mass': 1.008}, 'HG1': {'radius': 1.3, 'mass': 1.008}, 
        'HG2': {'radius': 1.3, 'mass': 1.008}, 'HZ1': {'radius': 1.3, 'mass': 1.008}, 'HZ2': {'radius': 1.3, 'mass': 1.008},
        'HZ3': {'radius': 1.3, 'mass': 1.008}, 'N': {'radius': 1.7, 'mass': 14.007}, 'NZ': {'radius': 1.67, 'mass': 14.007}, 
        'O': {'radius': 1.49, 'mass': 15.999}
    },
    'MET': {
        'C': {'radius': 1.75, 'mass': 12.011}, 'CA': {'radius': 1.9, 'mass': 12.011}, 'CB': {'radius': 1.91, 'mass': 12.011}, 
        'CE': {'radius': 1.8, 'mass': 12.011}, 'CG': {'radius': 1.92, 'mass': 12.011}, 'H': {'radius': 1.3, 'mass': 1.008}, 
        'HA': {'radius': 1.3, 'mass': 1.008}, 'HB1': {'radius': 1.3, 'mass': 1.008}, 'HB2': {'radius': 1.3, 'mass': 1.008},
        'HE1': {'radius': 1.3, 'mass': 1.008}, 'HE2': {'radius': 1.3, 'mass': 1.008}, 'HE3': {'radius': 1.3, 'mass': 1.008}, 
        'HG1': {'radius': 1.3, 'mass': 1.008}, 'HG2': {'radius': 1.3, 'mass': 1.008}, 'N': {'radius': 1.7, 'mass': 14.007}, 
        'O': {'radius': 1.49, 'mass': 15.999}, 'SD': {'radius': 1.94, 'mass': 32.06}, 'S': {'radius': 1.94, 'mass': 32.06}
    },
    'PHE': {
        'C': {'radius': 1.75, 'mass': 12.011}, 'CA': {'radius': 1.9, 'mass': 12.011}, 'CB': {'radius': 1.91, 'mass': 12.011}, 
        'CD1': {'radius': 1.82, 'mass': 12.011}, 'CD2': {'radius': 1.82, 'mass': 12.011}, 'CD': {'radius': 1.82, 'mass': 12.011}, 
        'CE1': {'radius': 1.82, 'mass': 12.011}, 'CE2': {'radius': 1.82, 'mass': 12.011}, 'CG': {'radius': 1.74, 'mass': 12.011},
        'CZ': {'radius': 1.82, 'mass': 12.011}, 'H': {'radius': 1.3, 'mass': 1.008}, 'HA': {'radius': 1.3, 'mass': 1.008}, 
        'HB1': {'radius': 1.3, 'mass': 1.008}, 'HB2': {'radius': 1.3, 'mass': 1.008}, 'HD1': {'radius': 1.3, 'mass': 1.008}, 
        'HD2': {'radius': 1.3, 'mass': 1.008}, 'HE1': {'radius': 1.3, 'mass': 1.008}, 'HE2': {'radius': 1.3, 'mass': 1.008},
        'HZ': {'radius': 1.3, 'mass': 1.008}, 'N': {'radius': 1.7, 'mass': 14.007}, 'O': {'radius': 1.49, 'mass': 15.999}
    },
    'PRO': {
        'C': {'radius': 1.75, 'mass': 12.011}, 'CA': {'radius': 1.9, 'mass': 12.011}, 'CB': {'radius': 1.91, 'mass': 12.011}, 
        'CD': {'radius': 1.92, 'mass': 12.011}, 'CG': {'radius': 1.92, 'mass': 12.011}, 'H': {'radius': 1.3, 'mass': 1.008}, 
        'HA': {'radius': 1.3, 'mass': 1.008}, 'HB1': {'radius': 1.3, 'mass': 1.008}, 'HB2': {'radius': 1.3, 'mass': 1.008},
        'HD1': {'radius': 1.3, 'mass': 1.008}, 'HD2': {'radius': 1.3, 'mass': 1.008}, 'HG1': {'radius': 1.3, 'mass': 1.008}, 
        'HG2': {'radius': 1.3, 'mass': 1.008}, 'N': {'radius': 1.7, 'mass': 14.007}, 'O': {'radius': 1.49, 'mass': 15.999}
    },
    'SER': {
        'C': {'radius': 1.75, 'mass': 12.011}, 'CA': {'radius': 1.9, 'mass': 12.011}, 'CB': {'radius': 1.91, 'mass': 12.011}, 
        'H1': {'radius': 1.3, 'mass': 1.008}, 'H2': {'radius': 1.3, 'mass': 1.008}, 'H3': {'radius': 1.3, 'mass': 1.008}, 
        'H': {'radius': 1.3, 'mass': 1.008}, 'HA': {'radius': 1.3, 'mass': 1.008}, 'HB1': {'radius': 1.3, 'mass': 1.008}, 
        'HB2': {'radius': 1.3, 'mass': 1.008}, 'HG': {'radius': 1.3, 'mass': 1.008}, 'N': {'radius': 1.7, 'mass': 14.007}, 
        'O': {'radius': 1.49, 'mass': 15.999}, 'OG': {'radius': 1.54, 'mass': 15.999}
    },
    'THR': {
        'C': {'radius': 1.75, 'mass': 12.011}, 'CA': {'radius': 1.9, 'mass': 12.011}, 'CB': {'radius': 2.01, 'mass': 12.011}, 
        'CG2': {'radius': 1.92, 'mass': 12.011}, 'H': {'radius': 1.3, 'mass': 1.008}, 'HA': {'radius': 1.3, 'mass': 1.008}, 
        'HB': {'radius': 1.3, 'mass': 1.008}, 'HG1': {'radius': 1.3, 'mass': 1.008}, 'HG21': {'radius': 1.3, 'mass': 1.008},
        'HG22': {'radius': 1.3, 'mass': 1.008}, 'HG23': {'radius': 1.3, 'mass': 1.008}, 'N': {'radius': 1.7, 'mass': 14.007}, 
        'O': {'radius': 1.49, 'mass': 15.999}, 'OG1': {'radius': 1.54, 'mass': 15.999}, 'OG': {'radius': 1.54, 'mass': 15.999}
    },
    'TRP': {
        'C': {'radius': 1.75, 'mass': 12.011}, 'CA': {'radius': 1.9, 'mass': 12.011}, 'CB': {'radius': 1.91, 'mass': 12.011}, 
        'CD1': {'radius': 1.82, 'mass': 12.011}, 'CD2': {'radius': 1.82, 'mass': 12.011}, 'CD': {'radius': 1.82, 'mass': 12.011}, 
        'CE': {'radius': 1.82, 'mass': 12.011}, 'CE2': {'radius': 1.74, 'mass': 12.011}, 'CE3': {'radius': 1.82, 'mass': 12.011},
        'CG': {'radius': 1.74, 'mass': 12.011}, 'CH': {'radius': 1.82, 'mass': 12.011}, 'CH2': {'radius': 1.82, 'mass': 12.011}, 
        'CZ': {'radius': 1.82, 'mass': 12.011}, 'CZ1': {'radius': 1.82, 'mass': 12.011}, 'CZ2': {'radius': 1.82, 'mass': 12.011}, 
        'H': {'radius': 1.3, 'mass': 1.008}, 'HA': {'radius': 1.3, 'mass': 1.008}, 'HB1': {'radius': 1.3, 'mass': 1.008},
        'HB2': {'radius': 1.3, 'mass': 1.008}, 'HD1': {'radius': 1.3, 'mass': 1.008}, 'HE1': {'radius': 1.3, 'mass': 1.008}, 
        'HE3': {'radius': 1.3, 'mass': 1.008}, 'HZ1': {'radius': 1.3, 'mass': 1.008}, 'HZ2': {'radius': 1.3, 'mass': 1.008}, 
        'HH2': {'radius': 1.3, 'mass': 1.008}, 'N': {'radius': 1.7, 'mass': 14.007}, 'NE1': {'radius': 1.66, 'mass': 14.007}, 
        'O': {'radius': 1.49, 'mass': 15.999}
    },
    'TYR': {
        'C': {'radius': 1.75, 'mass': 12.011}, 'CA': {'radius': 1.9, 'mass': 12.011}, 'CB': {'radius': 1.91, 'mass': 12.011}, 
        'CD': {'radius': 1.82, 'mass': 12.011}, 'CD1': {'radius': 1.82, 'mass': 12.011}, 'CD2': {'radius': 1.82, 'mass': 12.011}, 
        'CE': {'radius': 1.82, 'mass': 12.011}, 'CE1': {'radius': 1.82, 'mass': 12.011}, 'CE2': {'radius': 1.82, 'mass': 12.011},
        'CG': {'radius': 1.74, 'mass': 12.011}, 'CZ': {'radius': 1.8, 'mass': 12.011}, 'H': {'radius': 1.3, 'mass': 1.008}, 
        'HA': {'radius': 1.3, 'mass': 1.008}, 'HB1': {'radius': 1.3, 'mass': 1.008}, 'HB2': {'radius': 1.3, 'mass': 1.008}, 
        'HD1': {'radius': 1.3, 'mass': 1.008}, 'HD2': {'radius': 1.3, 'mass': 1.008}, 'HE1': {'radius': 1.3, 'mass': 1.008}, 
        'HE2': {'radius': 1.3, 'mass': 1.008}, 'HH': {'radius': 1.3, 'mass': 1.008}, 'N': {'radius': 1.7, 'mass': 14.007}, 
        'O': {'radius': 1.49, 'mass': 15.999}, 'OH': {'radius': 1.54, 'mass': 15.999}
    },
    'VAL': {
        'C': {'radius': 1.75, 'mass': 12.011}, 'CA': {'radius': 1.9, 'mass': 12.011}, 'CB': {'radius': 2.01, 'mass': 12.011}, 
        'CG1': {'radius': 1.92, 'mass': 12.011}, 'CG2': {'radius': 1.92, 'mass': 12.011}, 'H': {'radius': 1.3, 'mass': 1.008}, 
        'HA': {'radius': 1.3, 'mass': 1.008}, 'HB': {'radius': 1.3, 'mass': 1.008}, 'HG11': {'radius': 1.3, 'mass': 1.008},
        'HG12': {'radius': 1.3, 'mass': 1.008}, 'HG13': {'radius': 1.3, 'mass': 1.008}, 'HG21': {'radius': 1.3, 'mass': 1.008}, 
        'HG22': {'radius': 1.3, 'mass': 1.008}, 'HG23': {'radius': 1.3, 'mass': 1.008}, 'N': {'radius': 1.7, 'mass': 14.007}, 
        'O': {'radius': 1.49, 'mass': 15.999}
    },
        'DA': {  # Adenine
            'C1\'': {'radius': 1.75, 'mass': 12.011},
            'C2': {'radius': 1.75, 'mass': 12.011},
            'C2\'': {'radius': 1.75, 'mass': 12.011},
            'C3\'': {'radius': 1.75, 'mass': 12.011},
            'C4': {'radius': 1.75, 'mass': 12.011},
            'C4\'': {'radius': 1.75, 'mass': 12.011},
            'C5': {'radius': 1.75, 'mass': 12.011},
            'C5\'': {'radius': 1.75, 'mass': 12.011},
            'C6': {'radius': 1.75, 'mass': 12.011},
            'C8': {'radius': 1.75, 'mass': 12.011},
            'H1\'': {'radius': 1.3, 'mass': 1.008},
            'H2': {'radius': 1.3, 'mass': 1.008},
            'H2\'1': {'radius': 1.3, 'mass': 1.008},
            'H2\'2': {'radius': 1.3, 'mass': 1.008},
            'H3\'': {'radius': 1.3, 'mass': 1.008},
            'H4\'': {'radius': 1.3, 'mass': 1.008},
            'H5\'1': {'radius': 1.3, 'mass': 1.008},
            'H5\'2': {'radius': 1.3, 'mass': 1.008},
            'H5T': {'radius': 1.3, 'mass': 1.008},
            'H61': {'radius': 1.3, 'mass': 1.008},
            'H62': {'radius': 1.3, 'mass': 1.008},
            'H8': {'radius': 1.3, 'mass': 1.008},
            'N1': {'radius': 1.7, 'mass': 14.007},
            'N3': {'radius': 1.7, 'mass': 14.007},
            'N6': {'radius': 1.7, 'mass': 14.007},
            'N7': {'radius': 1.7, 'mass': 14.007},
            'N9': {'radius': 1.7, 'mass': 14.007},
            'O1P': {'radius': 1.49, 'mass': 15.999},
            'O2P': {'radius': 1.49, 'mass': 15.999},
            'O3\'': {'radius': 1.49, 'mass': 15.999},
            'O4\'': {'radius': 1.49, 'mass': 15.999},
            'O5\'': {'radius': 1.49, 'mass': 15.999},
            'P': {'radius': 1.8, 'mass': 30.974}
    },
    'DC': {  # Cytosine
        'C1\'': {'radius': 1.75, 'mass': 12.011},
        'C2': {'radius': 1.75, 'mass': 12.011},
        'C2\'': {'radius': 1.75, 'mass': 12.011},
        'C3\'': {'radius': 1.75, 'mass': 12.011},
        'C4': {'radius': 1.75, 'mass': 12.011},
        'C4\'': {'radius': 1.75, 'mass': 12.011},
        'C5': {'radius': 1.75, 'mass': 12.011},
        'C5\'': {'radius': 1.75, 'mass': 12.011},
        'C6': {'radius': 1.75, 'mass': 12.011},
        'H1\'': {'radius': 1.3, 'mass': 1.008},
        'H2\'1': {'radius': 1.3, 'mass': 1.008},
        'H2\'2': {'radius': 1.3, 'mass': 1.008},
        'H3\'': {'radius': 1.3, 'mass': 1.008},
        'H4\'': {'radius': 1.3, 'mass': 1.008},
        'H41': {'radius': 1.3, 'mass': 1.008},
        'H42': {'radius': 1.3, 'mass': 1.008},
        'H5': {'radius': 1.3, 'mass': 1.008},
        'H5\'1': {'radius': 1.3, 'mass': 1.008},
        'H5\'2': {'radius': 1.3, 'mass': 1.008},
        'H6': {'radius': 1.3, 'mass': 1.008},
        'N1': {'radius': 1.7, 'mass': 14.007},
        'N3': {'radius': 1.7, 'mass': 14.007},
        'N4': {'radius': 1.7, 'mass': 14.007},
        'O1P': {'radius': 1.49, 'mass': 15.999},
        'O2': {'radius': 1.49, 'mass': 15.999},
        'O2P': {'radius': 1.49, 'mass': 15.999},
        'O3\'': {'radius': 1.49, 'mass': 15.999},
        'O4\'': {'radius': 1.49, 'mass': 15.999},
        'O5\'': {'radius': 1.49, 'mass': 15.999},
        'P': {'radius': 1.8, 'mass': 30.974}
    },
    'DT': {  # Thymine
        'C1\'': {'radius': 1.75, 'mass': 12.011},
        'C2': {'radius': 1.75, 'mass': 12.011},
        'C2\'': {'radius': 1.75, 'mass': 12.011},
        'C3\'': {'radius': 1.75, 'mass': 12.011},
        'C4': {'radius': 1.75, 'mass': 12.011},
        'C4\'': {'radius': 1.75, 'mass': 12.011},
        'C5': {'radius': 1.75, 'mass': 12.011},
        'C5\'': {'radius': 1.75, 'mass': 12.011},
        'C6': {'radius': 1.75, 'mass': 12.011},
        'C7': {'radius': 1.75, 'mass': 12.011},
        'H1\'': {'radius': 1.3, 'mass': 1.008},
        'H2\'1': {'radius': 1.3, 'mass': 1.008},
        'H2\'2': {'radius': 1.3, 'mass': 1.008},
        'H3': {'radius': 1.3, 'mass': 1.008},
        'H3\'': {'radius': 1.3, 'mass': 1.008},
        'H3T': {'radius': 1.3, 'mass': 1.008},
        'H4\'': {'radius': 1.3, 'mass': 1.008},
        'H5\'1': {'radius': 1.3, 'mass': 1.008},
        'H5\'2': {'radius': 1.3, 'mass': 1.008},
        'H6': {'radius': 1.3, 'mass': 1.008},
        'H71': {'radius': 1.3, 'mass': 1.008},
        'H72': {'radius': 1.3, 'mass': 1.008},
        'H73': {'radius': 1.3, 'mass': 1.008},
        'N1': {'radius': 1.7, 'mass': 14.007},
        'N3': {'radius': 1.7, 'mass': 14.007},
        'O1P': {'radius': 1.49, 'mass': 15.999},
        'O2': {'radius': 1.49, 'mass': 15.999},
        'O2P': {'radius': 1.49, 'mass': 15.999},
        'O3\'': {'radius': 1.49, 'mass': 15.999},
        'O4': {'radius': 1.49, 'mass': 15.999},
        'O4\'': {'radius': 1.49, 'mass': 15.999},
        'O5\'': {'radius': 1.49, 'mass': 15.999},
        'P': {'radius': 1.8, 'mass': 30.974}
    },
    'DG': {  # Guanine
        'C1\'': {'radius': 1.75, 'mass': 12.011},
        'C2': {'radius': 1.75, 'mass': 12.011},
        'C2\'': {'radius': 1.75, 'mass': 12.011},
        'C3\'': {'radius': 1.75, 'mass': 12.011},
        'C4': {'radius': 1.75, 'mass': 12.011},
        'C4\'': {'radius': 1.75, 'mass': 12.011},
        'C5': {'radius': 1.75, 'mass': 12.011},
        'C5\'': {'radius': 1.75, 'mass': 12.011},
        'C6': {'radius': 1.75, 'mass': 12.011},
        'C8': {'radius': 1.75, 'mass': 12.011},
        'H1\'': {'radius': 1.3, 'mass': 1.008},
        'H2\'1': {'radius': 1.3, 'mass': 1.008},
        'H2\'2': {'radius': 1.3, 'mass': 1.008},
        'H3\'': {'radius': 1.3, 'mass': 1.008},
        'H4\'': {'radius': 1.3, 'mass': 1.008},
        'H5\'1': {'radius': 1.3, 'mass': 1.008},
        'H5\'2': {'radius': 1.3, 'mass': 1.008},
        'H8': {'radius': 1.3, 'mass': 1.008},
        'N1': {'radius': 1.7, 'mass': 14.007},
        'N2': {'radius': 1.7, 'mass': 14.007},
        'N3': {'radius': 1.7, 'mass': 14.007},
        'N7': {'radius': 1.7, 'mass': 14.007},
        'N9': {'radius': 1.7, 'mass': 14.007},
        'O1P': {'radius': 1.49, 'mass': 15.999},
        'O2P': {'radius': 1.49, 'mass': 15.999},
        'O3\'': {'radius': 1.49, 'mass': 15.999},
        'O4\'': {'radius': 1.49, 'mass': 15.999},
        'O5\'': {'radius': 1.49, 'mass': 15.999},
        'O6': {'radius': 1.49, 'mass': 15.999},
        'P': {'radius': 1.8, 'mass': 30.974}
    },
    'U': {   # Uracil
        'C1\'': {'radius': 1.75, 'mass': 12.011},
        'C2': {'radius': 1.75, 'mass': 12.011},
        'C2\'': {'radius': 1.75, 'mass': 12.011},
        'C3\'': {'radius': 1.75, 'mass': 12.011},
        'C4': {'radius': 1.75, 'mass': 12.011},
        'C4\'': {'radius': 1.75, 'mass': 12.011},
        'C5': {'radius': 1.75, 'mass': 12.011},
        'C5\'': {'radius': 1.75, 'mass': 12.011},
        'C6': {'radius': 1.75, 'mass': 12.011},
        'H1\'': {'radius': 1.3, 'mass': 1.008},
        'H2\'': {'radius': 1.3, 'mass': 1.008},
        'H2\'\'': {'radius': 1.3, 'mass': 1.008},
        'H3': {'radius': 1.3, 'mass': 1.008},
        'H3\'': {'radius': 1.3, 'mass': 1.008},
        'H4\'': {'radius': 1.3, 'mass': 1.008},
        'H5': {'radius': 1.3, 'mass': 1.008},
        'H5\'': {'radius': 1.3, 'mass': 1.008},
        'H5\'\'': {'radius': 1.3, 'mass': 1.008},
        'H6': {'radius': 1.3, 'mass': 1.008},
        'N1': {'radius': 1.7, 'mass': 14.007},
        'N3': {'radius': 1.7, 'mass': 14.007},
        'O1P': {'radius': 1.49, 'mass': 15.999},
        'O2': {'radius': 1.49, 'mass': 15.999},
        'O2\'': {'radius': 1.49, 'mass': 15.999},
        'O2P': {'radius': 1.49, 'mass': 15.999},
        'O3\'': {'radius': 1.49, 'mass': 15.999},
        'O4': {'radius': 1.49, 'mass': 15.999},
        'O4\'': {'radius': 1.49, 'mass': 15.999},
        'O5\'': {'radius': 1.49, 'mass': 15.999},
        'P': {'radius': 1.8, 'mass': 30.974}
    }
}
