import csv
import os
import tkinter as tk
from tkinter import filedialog
import matplotlib.pyplot as plt
import numpy as np
from vorpy.src.system.system import System
from Data.Analyze.tools.batch.get_files import get_files
from Data.Analyze.tools.compare.read_logs2 import read_logs2
from System.sys_funcs.calcs.calcs import calc_dist


def num_olaps_folder(folder=None):
    # If the folder option isnt chosen prompt the user to choose a folder
    if folder is None:
        # Get the folder with all the logs
        root = tk.Tk()
        root.withdraw()
        root.wm_attributes()
        folder = filedialog.askdirectory(title="Choose a data folder")
    print(folder)
    # Create the densities data
    den_data = {}
    num_folders = len(os.listdir(folder))
    # Loop through the folders
    for k, subfolder in enumerate(os.listdir(folder)):
        # Get the cv and density values
        split_subfolder = subfolder.split("_")
        try:
            sf_cv, sf_den = float(split_subfolder[1]), float(split_subfolder[3])
        except:
            continue
        # Get the pdb, aw, and pow
        pdb, aw, pow = get_files(folder + '/' + subfolder)
        # Get the logs and make a system
        try:
            my_sys = System(pdb, simple=True)
            my_aw = read_logs2(aw)
        except TypeError:
            print(pdb, aw, pow)
        # Create a list of overlap indices
        olap_ndxs = []
        # Loop through the balls
        for i, ball in my_aw['atoms'].iterrows():
            # Check if the ball is already accounted for
            if ball['Index'] in olap_ndxs:
                continue
            # Make sure the ball is complete
            if not ball['Complete Cell?']:
                continue
            # Get the ball location
            bloc = [ball['X'], ball['Y'], ball['Z']]
            brad = ball['Radius']
            # Go through the balls neighbors
            for neighbor in ball['Neighbors']:
                # No need to check if we know it overlaps
                if neighbor in olap_ndxs:
                    continue
                # Get the neighbors location
                nloc = my_sys.balls['loc'][neighbor]
                nrad = my_sys.balls['rad'][neighbor]
                # Calculate the distance
                if calc_dist(bloc, nloc) < nrad + brad:
                    # Add the ball and the neighbor and exit
                    olap_ndxs += [neighbor, ball['Index']]
                    break
        print(f"\rFolder {k}/{num_folders} - {100 * (k/num_folders)}%", end="")
        # Add the overlap indexes to the density dictionary
        if (sf_cv, sf_den) in den_data:
            den_data[(sf_cv, sf_den)].append((len(set(olap_ndxs)) / len(my_aw['atoms']['Index'])))
        else:
            den_data[(sf_cv, sf_den)] = [(len(set(olap_ndxs)) / len(my_aw['atoms']['Index']))]
    print(folder)
    return den_data


def parse_data(file=None):
    # If the folder option isnt chosen prompt the user to choose a folder
    if file is None:
        # Get the folder with all the logs
        root = tk.Tk()
        root.withdraw()
        root.wm_attributes()
        file = filedialog.askopenfilename(title="Choose a data file")
    # Dictionary to hold the parsed data
    data_dict = {}

    # Open and read the file
    with open(file, 'r') as file1:
        file_csv = csv.reader(file1)
        for line in file_csv:

            # Extract the filename from the path
            try:
                path_parts = line[0].split('/')
            except IndexError:
                continue
            filename = path_parts[-1]

            # Extract details from the filename
            try:
                details = filename.split('_')

                mean = float(details[0])
                cv = float(details[1])
                num_balls = int(details[2])
                density = float(details[3].replace('_', '.'))
            except IndexError:
                continue
            except ValueError:
                continue
            try:
                file_number = int(details[-1])
            except ValueError:
                file_number = 0


            # Key for the main dictionary
            key = (cv, density, file_number)

            # Second column as key for the subdictionary
            sub_key = int(line[1])

            # Remaining columns as list of values
            values = [float(col) if col.isdigit() or '.' in col else int(col) for col in line[2:]]

            # Insert data into the dictionary
            if key not in data_dict:
                data_dict[key] = {}
            data_dict[key][sub_key] = values

    return data_dict


def distribution_of_overlaps(data=None, olap_value=0.5, bins=10):

    perdic, cv_vals, density_vals = {}, [], []
    for cv, density, file_number in data:
        curdic = data[(cv, density, file_number)]
        percent = 100 * len([_ for _ in curdic if sum(curdic[_]) != 0]) / len(curdic)
        if (cv, density) in perdic:
            perdic[(cv, density)].append(percent)
        else:
            perdic[(cv, density)] = [percent]
        if cv not in cv_vals:
            cv_vals.append(cv)
        if density not in density_vals:
            density_vals.append(density)
    density_vals.sort(reverse=True)
    cv_vals.sort()

    fig, axes = plt.subplots(10, 11, figsize=(20, 18), sharex='all', sharey='all')

    def format_ticks(val, pos):
        """Format tick labels as powers of ten."""
        if val == 0:
            return "$10^0$"
        else:
            exponent = int(np.log10(val))
            return f"$10^{{{exponent}}}$"

    for i, density in enumerate(density_vals):
        for j, cv in enumerate(cv_vals):
            ax = axes[i, j]
            try:
                percent_olap = np.mean(perdic[(cv, density)])
            except KeyError:
                percent_olap = 0
            ax.pie([min(percent_olap, 100), max(100 - percent_olap, 0.0)])
            # ax.pie([0, 100])

    for ax, col in zip(axes[-1], cv_vals):
        ax.set_xlabel("")  # Remove direct subplot labels, handled below

    for ax, row in zip(axes[:, 0], density_vals):
        ax.set_ylabel("")  # Remove direct subplot labels, handled below

    # Add CV values to the bottom of the figure
    for i, col in enumerate(cv_vals):
        fig.text(0.13 + i * (0.815 / len(cv_vals)), 0.05, col, ha='center', fontsize=20)

    for i, row in enumerate(density_vals[::-1]):
        fig.text(0.05, 0.125 + i * (0.825 / len(density_vals)), row, va='center', rotation='horizontal', fontsize=20)

    fig.text(0.5, 0.02, 'CV Values', ha='center', fontsize=25)  # X-axis label for the figure
    fig.text(0.02, 0.5, 'Density Values', va='center', rotation='vertical', fontsize=25)  # Y-axis label for the figure

    # Add a main title for the entire figure
    fig.suptitle("Percentage of Overlapping Balls", fontsize=30)

    # Adjust layout to prevent overlapping labels
    plt.subplots_adjust(left=0.1, bottom=0.1, top=0.9)
    # plt.tight_layout()

    plt.show()


if __name__ == '__main__':
    # Run the code
    os.chdir('../../../..')
    dicty = parse_data()
    # dicty = {(0.4, 0.15): [0.306, 0.294, 0.298, 0.314, 0.32, 0.3, 0.32, 0.324, 0.32, 0.316, 0.3, 0.296, 0.296, 0.306, 0.318, 0.318, 0.33, 0.306, 0.29, 0.304], (0.3, 0.3): [0.544, 0.564, 0.54, 0.554, 0.548, 0.516, 0.522, 0.528, 0.544, 0.548, 0.5, 0.514, 0.53, 0.536, 0.53, 0.482, 0.536, 0.518, 0.562, 0.528], (0.7, 0.25): [0.298, 0.286, 0.012, 0.304, 0.298, 0.298, 0.02, 0.284, 0.258, 0.264, 0.262, 0.3, 0.286, 0.278, 0.284, 0.284, 0.274, 0.286, 0.294, 0.306], (1.0, 0.25): [0.216, 0.2, 0.178, 0.204, 0.21, 0.214, 0.222, 0.21, 0.194, 0.198, 0.192, 0.232, 0.214, 0.18, 0.224, 0.2, 0.22, 0.212, 0.2], (0.4, 0.3): [0.462, 0.472, 0.484, 0.478, 0.432, 0.466, 0.476, 0.49, 0.486, 0.458, 0.484, 0.462, 0.446, 0.476, 0.484, 0.456, 0.462, 0.462, 0.478, 0.48], (0.05, 0.45): [0.732, 0.74, 0.728, 0.736, 0.754, 0.746, 0.744, 0.756, 0.738, 0.744, 0.756, 0.746, 0.738, 0.736, 0.742, 0.742, 0.73, 0.742, 0.734, 0.756], (0.9, 0.05): [0.07, 0.08, 0.072, 0.088, 0.076, 0.08, 0.082, 0.072, 0.07, 0.012, 0.096, 0.076, 0.088, 0.07, 0.014, 0.08, 0.078, 0.086, 0.09, 0.088], (0.1, 0.25): [0.596, 0.594, 0.564, 0.588, 0.58, 0.588, 0.576, 0.6, 0.584, 0.596, 0.586, 0.604, 0.564, 0.572, 0.588, 0.608, 0.596, 0.62, 0.586, 0.6], (0.5, 0.5): [0.506, 0.532, 0.504, 0.512, 0.526, 0.53, 0.52, 0.522, 0.518, 0.544, 0.514, 0.542, 0.544, 0.052, 0.518, 0.524, 0.508, 0.53, 0.53, 0.52], (0.6, 0.2): [0.296, 0.288, 0.25, 0.26, 0.272, 0.29, 0.018, 0.3, 0.296, 0.282, 0.268, 0.284, 0.272, 0.288, 0.274, 0.29, 0.286, 0.262, 0.272, 0.292], (0.2, 0.15): [0.406, 0.394, 0.388, 0.408, 0.408, 0.398, 0.39, 0.408, 0.386, 0.39, 0.388, 0.394, 0.386, 0.38, 0.394, 0.42, 0.4, 0.348, 0.398, 0.41], (0.7, 0.2): [0.28, 0.014, 0.25, 0.268, 0.234, 0.276, 0.254, 0.248, 0.25, 0.226, 0.23, 0.246, 0.276, 0.248, 0.226, 0.234, 0.23, 0.252, 0.234, 0.258], (0.6, 0.15): [0.228, 0.23, 0.224, 0.002, 0.204, 0.23, 0.016, 0.246, 0.256, 0.222, 0.226, 0.248, 0.246, 0.252, 0.214, 0.244, 0.232, 0.24, 0.21, 0.228], (0.05, 0.25): [0.614, 0.63, 0.59, 0.594, 0.618, 0.612, 0.598, 0.584, 0.598, 0.612, 0.618, 0.63, 0.636, 0.592, 0.594, 0.62, 0.594, 0.592, 0.582, 0.612], (1.0, 0.4): [0.266, 0.274, 0.278, 0.25, 0.272, 0.034, 0.272, 0.276, 0.288, 0.276, 0.274, 0.25, 0.266, 0.282, 0.288, 0.244, 0.27, 0.288, 0.284, 0.266], (0.8, 0.25): [0.262, 0.268, 0.26, 0.262, 0.24, 0.026, 0.234, 0.284, 0.26, 0.268, 0.236, 0.238, 0.024, 0.25, 0.244, 0.256, 0.244, 0.258, 0.016, 0.26], (0.05, 0.35): [0.72, 0.708, 0.704, 0.698, 0.708, 0.688, 0.706, 0.706, 0.696, 0.68, 0.684, 0.708, 0.696, 0.696, 0.708, 0.688, 0.686, 0.714, 0.708, 0.692], (0.3, 0.35): [0.58, 0.552, 0.568, 0.58, 0.554, 0.566, 0.598, 0.582, 0.6, 0.58, 0.558, 0.55, 0.566, 0.566, 0.566, 0.548, 0.578, 0.586, 0.564, 0.538], (0.4, 0.2): [0.368, 0.372, 0.366, 0.374, 0.402, 0.386, 0.024, 0.382, 0.36, 0.362, 0.358, 0.352, 0.374, 0.384, 0.372, 0.37, 0.394, 0.37, 0.38, 0.364], (0.05, 0.2): [0.528, 0.54, 0.536, 0.52, 0.546, 0.566, 0.532, 0.568, 0.524, 0.514, 0.528, 0.534, 0.568, 0.524, 0.562, 0.56, 0.522, 0.538, 0.552, 0.548], (0.1, 0.35): [0.682, 0.672, 0.684, 0.684, 0.68, 0.694, 0.67, 0.668, 0.702, 0.688, 0.66, 0.672, 0.682, 0.694, 0.67, 0.698, 0.672, 0.686, 0.7, 0.67], (0.2, 0.45): [0.688, 0.672, 0.692, 0.674, 0.678, 0.694, 0.662, 0.672, 0.664, 0.656, 0.69, 0.656, 0.656, 0.666, 0.686, 0.69, 0.7, 0.696, 0.668, 0.656], (0.9, 0.1): [0.136, 0.122, 0.146, 0.132, 0.158, 0.144, 0.144, 0.132, 0.12, 0.118, 0.15, 0.128, 0.126, 0.114, 0.008, 0.132, 0.138, 0.114, 0.128, 0.116], (0.8, 0.1): [0.146, 0.132, 0.142, 0.146, 0.118, 0.012, 0.122, 0.136, 0.146, 0.14, 0.138, 0.166, 0.144, 0.146, 0.152, 0.142, 0.154, 0.134, 0.122, 0.004], (0.05, 0.1): [0.352, 0.318, 0.342, 0.338, 0.34, 0.36, 0.332, 0.342, 0.376, 0.358, 0.354, 0.346, 0.348, 0.362, 0.344, 0.368, 0.374, 0.35, 0.35, 0.368], (0.8, 0.3): [0.25, 0.276, 0.288, 0.284, 0.286, 0.288, 0.302, 0.288, 0.288, 0.284, 0.284, 0.288, 0.28, 0.306, 0.274, 0.306, 0.294, 0.268, 0.292, 0.03], (0.5, 0.2): [0.318, 0.326, 0.332, 0.316, 0.334, 0.33, 0.282, 0.308, 0.336, 0.308, 0.34, 0.35, 0.332, 0.352, 0.314, 0.33, 0.344, 0.314, 0.008, 0.326], (0.1, 0.3): [0.638, 0.644, 0.618, 0.654, 0.65, 0.622, 0.656, 0.626, 0.626, 0.642, 0.67, 0.656, 0.65, 0.622, 0.644, 0.636, 0.642, 0.65, 0.64, 0.628], (0.4, 0.4): [0.5, 0.536, 0.51, 0.532, 0.518, 0.524, 0.54, 0.572, 0.546, 0.554, 0.55, 0.536, 0.538, 0.546, 0.544, 0.548, 0.53, 0.55, 0.548, 0.544], (0.9, 0.15): [0.164, 0.17, 0.156, 0.162, 0.17, 0.17, 0.17, 0.002, 0.162, 0.186, 0.006, 0.178, 0.168, 0.156, 0.158, 0.172, 0.174, 0.176, 0.152, 0.176], (0.7, 0.5): [0.412, 0.414, 0.416, 0.4, 0.406, 0.402, 0.404, 0.024, 0.418, 0.418, 0.426, 0.422, 0.392, 0.418, 0.434, 0.398, 0.444, 0.402, 0.052, 0.4], (1.0, 0.35): [0.264, 0.232, 0.254, 0.24, 0.26, 0.238, 0.244, 0.256, 0.294, 0.244, 0.252, 0.01, 0.254, 0.264, 0.252, 0.274, 0.248, 0.248, 0.22, 0.218], (0.5, 0.05): [0.124, 0.128, 0.122, 0.12, 0.124, 0.116, 0.102, 0.1, 0.116, 0.112, 0.148, 0.142, 0.106, 0.11, 0.124, 0.106, 0.136, 0.132, 0.108, 0.108], (0.5, 0.1): [0.19, 0.214, 0.208, 0.19, 0.168, 0.21, 0.204, 0.21, 0.184, 0.186, 0.192, 0.21, 0.17, 0.204, 0.186, 0.0, 0.206, 0.202, 0.212, 0.194], (0.8, 0.5): [0.362, 0.384, 0.388, 0.384, 0.368, 0.03, 0.364, 0.372, 0.366, 0.348, 0.376, 0.368, 0.346, 0.38, 0.364, 0.384, 0.382, 0.364, 0.364, 0.012], (1.0, 0.15): [0.158, 0.158, 0.144, 0.164, 0.134, 0.152, 0.14, 0.17, 0.156, 0.138, 0.176, 0.17, 0.132, 0.166, 0.01, 0.14, 0.178, 0.128, 0.006, 0.158], (0.5, 0.4): [0.442, 0.508, 0.488, 0.482, 0.468, 0.502, 0.484, 0.484, 0.482, 0.474, 0.496, 0.502, 0.5, 0.006, 0.492, 0.466, 0.454, 0.49, 0.476, 0.478], (0.2, 0.4): [0.648, 0.67, 0.66, 0.642, 0.66, 0.67, 0.664, 0.67, 0.66, 0.654, 0.656, 0.646, 0.66, 0.656, 0.654, 0.65, 0.664, 0.674, 0.658, 0.65], (0.3, 0.15): [0.36, 0.35, 0.35, 0.386, 0.372, 0.336, 0.362, 0.358, 0.39, 0.372, 0.36, 0.378, 0.346, 0.32, 0.376, 0.35, 0.364, 0.362, 0.332, 0.344], (1.0, 0.5): [0.308, 0.304, 0.312, 0.298, 0.306, 0.318, 0.316, 0.306, 0.302, 0.318, 0.316, 0.292, 0.302, 0.304, 0.288, 0.326, 0.312, 0.278, 0.302, 0.306], (0.2, 0.35): [0.638, 0.634, 0.606, 0.604, 0.63, 0.634, 0.612, 0.63, 0.632, 0.63, 0.63, 0.634, 0.608, 0.638, 0.632, 0.616, 0.606, 0.618, 0.622, 0.634], (0.05, 0.5): [0.768, 0.748, 0.776, 0.764, 0.772, 0.73, 0.744, 0.766, 0.762, 0.73, 0.77, 0.758, 0.752, 0.75, 0.768, 0.766, 0.766, 0.758, 0.774, 0.772], (0.7, 0.4): [0.346, 0.37, 0.38, 0.37, 0.04, 0.382, 0.378, 0.362, 0.374, 0.358, 0.376, 0.374, 0.386, 0.35, 0.338, 0.382, 0.022, 0.372, 0.352, 0.394], (0.05, 0.15): [0.45, 0.426, 0.422, 0.454, 0.446, 0.424, 0.45, 0.454, 0.428, 0.45, 0.434, 0.442, 0.44, 0.45, 0.456, 0.436, 0.502, 0.448, 0.43, 0.446], (0.6, 0.45): [0.43, 0.45, 0.424, 0.446, 0.418, 0.478, 0.424, 0.46, 0.46, 0.42, 0.428, 0.434, 0.444, 0.456, 0.456, 0.44, 0.418, 0.444, 0.422, 0.048], (0.5, 0.25): [0.358, 0.394, 0.388, 0.38, 0.364, 0.37, 0.404, 0.406, 0.34, 0.388, 0.398, 0.404, 0.39, 0.364, 0.344, 0.368, 0.366, 0.358, 0.362, 0.006], (0.8, 0.4): [0.328, 0.356, 0.3, 0.304, 0.328, 0.35, 0.318, 0.35, 0.352, 0.354, 0.352, 0.338, 0.35, 0.318, 0.328, 0.022, 0.33, 0.314, 0.31, 0.338], (0.8, 0.2): [0.21, 0.016, 0.242, 0.228, 0.228, 0.23, 0.2, 0.222, 0.238, 0.206, 0.028, 0.238, 0.2, 0.224, 0.22, 0.206, 0.214, 0.22, 0.234, 0.208], (0.2, 0.3): [0.572, 0.606, 0.594, 0.616, 0.608, 0.596, 0.602, 0.6, 0.588, 0.612, 0.568, 0.58, 0.598, 0.582, 0.59, 0.582, 0.588, 0.606, 0.574, 0.594], (0.4, 0.1): [0.222, 0.248, 0.202, 0.22, 0.236, 0.232, 0.23, 0.248, 0.23, 0.226, 0.236, 0.232, 0.22, 0.244, 0.234, 0.248, 0.204, 0.208, 0.258, 0.202], (0.1, 0.1): [0.346, 0.32, 0.302, 0.344, 0.322, 0.314, 0.31, 0.328, 0.332, 0.33, 0.324, 0.314, 0.314, 0.346, 0.336, 0.318, 0.34, 0.346, 0.32, 0.314], (0.1, 0.4): [0.706, 0.702, 0.71, 0.706, 0.68, 0.702, 0.716, 0.718, 0.706, 0.71, 0.698, 0.69, 0.71, 0.72, 0.71, 0.692, 0.724, 0.71, 0.69, 0.716], (0.5, 0.3): [0.392, 0.406, 0.428, 0.404, 0.402, 0.438, 0.402, 0.412, 0.424, 0.432, 0.402, 0.406, 0.384, 0.036, 0.416, 0.404, 0.422, 0.408, 0.39, 0.398], (0.7, 0.3): [0.284, 0.338, 0.304, 0.316, 0.006, 0.328, 0.35, 0.334, 0.296, 0.326, 0.298, 0.314, 0.024, 0.336, 0.316, 0.32, 0.342, 0.326, 0.344, 0.346], (0.4, 0.05): [0.126, 0.144, 0.132, 0.136, 0.134, 0.144, 0.142, 0.128, 0.142, 0.138, 0.154, 0.134, 0.13, 0.144, 0.118, 0.152, 0.12, 0.128, 0.122, 0.14], (0.6, 0.35): [0.392, 0.408, 0.348, 0.37, 0.382, 0.38, 0.392, 0.4, 0.398, 0.376, 0.382, 0.362, 0.408, 0.402, 0.404, 0.418, 0.006, 0.386, 0.378, 0.38], (0.1, 0.5): [0.738, 0.736, 0.764, 0.746, 0.742, 0.738, 0.734, 0.77, 0.732, 0.742, 0.744, 0.726, 0.708, 0.712, 0.764, 0.724, 0.738, 0.722, 0.714, 0.738], (0.3, 0.45): [0.634, 0.646, 0.618, 0.624, 0.624, 0.636, 0.644, 0.64, 0.622, 0.632, 0.632, 0.61, 0.618, 0.64, 0.616, 0.612, 0.618, 0.636, 0.604, 0.658], (0.1, 0.2): [0.546, 0.514, 0.558, 0.528, 0.54, 0.478, 0.5, 0.518, 0.528, 0.518, 0.542, 0.514, 0.504, 0.54, 0.498, 0.512, 0.538, 0.534, 0.526, 0.51], (1.0, 0.3): [0.212, 0.242, 0.228, 0.246, 0.226, 0.232, 0.254, 0.24, 0.24, 0.22, 0.254, 0.212, 0.23, 0.23, 0.224, 0.22, 0.226, 0.244, 0.228, 0.22], (0.8, 0.45): [0.324, 0.368, 0.342, 0.308, 0.354, 0.356, 0.348, 0.354, 0.336, 0.33, 0.028, 0.366, 0.366, 0.362, 0.35, 0.338, 0.324, 0.326, 0.362, 0.324], (0.05, 0.3): [0.666, 0.66, 0.678, 0.668, 0.656, 0.64, 0.666, 0.674, 0.652, 0.68, 0.636, 0.65, 0.642, 0.65, 0.66, 0.638, 0.676, 0.64, 0.666, 0.684], (0.4, 0.35): [0.536, 0.502, 0.508, 0.512, 0.476, 0.496, 0.502, 0.512, 0.51, 0.524, 0.518, 0.528, 0.49, 0.534, 0.522, 0.488, 0.508, 0.504, 0.522, 0.494], (0.3, 0.4): [0.604, 0.602, 0.592, 0.556, 0.592, 0.622, 0.6, 0.612, 0.604, 0.592, 0.608, 0.592, 0.608, 0.6, 0.61, 0.612, 0.608, 0.59, 0.592, 0.592], (0.2, 0.25): [0.552, 0.558, 0.548, 0.528, 0.552, 0.54, 0.556, 0.564, 0.536, 0.518, 0.554, 0.54, 0.532, 0.54, 0.556, 0.51, 0.542, 0.516, 0.542, 0.556], (0.9, 0.3): [0.238, 0.242, 0.252, 0.256, 0.24, 0.236, 0.252, 0.242, 0.262, 0.252, 0.258, 0.286, 0.03, 0.228, 0.246, 0.246, 0.28, 0.286, 0.262, 0.244], (0.5, 0.15): [0.276, 0.266, 0.29, 0.276, 0.254, 0.31, 0.262, 0.272, 0.274, 0.274, 0.282, 0.256, 0.268, 0.238, 0.276, 0.284, 0.278, 0.278, 0.266, 0.252], (0.6, 0.05): [0.082, 0.11, 0.084, 0.082, 0.118, 0.11, 0.088, 0.082, 0.096, 0.118, 0.106, 0.12, 0.14, 0.088, 0.092, 0.108, 0.114, 0.09, 0.106, 0.12], (0.9, 0.25): [0.236, 0.238, 0.238, 0.012, 0.256, 0.236, 0.18, 0.212, 0.24, 0.026, 0.216, 0.222, 0.218, 0.186, 0.21, 0.234, 0.23, 0.214, 0.228, 0.212], (1.0, 0.45): [0.256, 0.322, 0.27, 0.29, 0.31, 0.274, 0.28, 0.28, 0.306, 0.292, 0.268, 0.286, 0.29, 0.29, 0.294, 0.284, 0.304, 0.286, 0.284, 0.278], (0.7, 0.35): [0.334, 0.348, 0.352, 0.342, 0.362, 0.33, 0.322, 0.01, 0.374, 0.37, 0.324, 0.35, 0.374, 0.328, 0.326, 0.31, 0.04, 0.35, 0.336, 0.374], (0.2, 0.05): [0.172, 0.164, 0.132, 0.152, 0.174, 0.152, 0.156, 0.176, 0.168, 0.172, 0.162, 0.192, 0.176, 0.162, 0.17, 0.176, 0.18, 0.182, 0.16, 0.178], (0.1, 0.45): [0.726, 0.73, 0.71, 0.732, 0.728, 0.736, 0.716, 0.724, 0.718, 0.746, 0.706, 0.734, 0.744, 0.728, 0.718, 0.71, 0.712, 0.738, 0.726, 0.694], (0.4, 0.45): [0.554, 0.572, 0.556, 0.612, 0.56, 0.57, 0.572, 0.576, 0.56, 0.574, 0.568, 0.544, 0.57, 0.562, 0.58, 0.574, 0.568, 0.558, 0.59, 0.562], (0.7, 0.15): [0.016, 0.2, 0.21, 0.208, 0.2, 0.2, 0.194, 0.222, 0.204, 0.196, 0.224, 0.218, 0.184, 0.204, 0.216, 0.212, 0.184, 0.212, 0.014, 0.212], (0.8, 0.15): [0.18, 0.2, 0.19, 0.164, 0.162, 0.168, 0.166, 0.164, 0.172, 0.18, 0.176, 0.178, 0.174, 0.21, 0.188, 0.194, 0.174, 0.17, 0.192, 0.21], (0.5, 0.45): [0.528, 0.486, 0.028, 0.474, 0.504, 0.516, 0.502, 0.51, 0.508, 0.512, 0.518, 0.506, 0.478, 0.494, 0.504, 0.47, 0.522, 0.524, 0.476, 0.486], (0.5, 0.35): [0.452, 0.464, 0.462, 0.434, 0.434, 0.468, 0.448, 0.436, 0.444, 0.442, 0.428, 0.446, 0.446, 0.458, 0.44, 0.446, 0.452, 0.446, 0.446, 0.446], (1.0, 0.2): [0.188, 0.164, 0.178, 0.188, 0.188, 0.174, 0.164, 0.2, 0.174, 0.188, 0.174, 0.182, 0.152, 0.174, 0.18, 0.2, 0.174, 0.18, 0.184, 0.208], (0.6, 0.1): [0.154, 0.162, 0.174, 0.194, 0.18, 0.168, 0.184, 0.012, 0.184, 0.18, 0.158, 0.172, 0.176, 0.188, 0.162, 0.168, 0.16, 0.166, 0.164, 0.198], (0.3, 0.05): [0.158, 0.146, 0.146, 0.144, 0.15, 0.152, 0.146, 0.152, 0.15, 0.174, 0.162, 0.162, 0.17, 0.146, 0.124, 0.144, 0.174, 0.146, 0.122, 0.174], (0.9, 0.4): [0.284, 0.294, 0.264, 0.302, 0.292, 0.29, 0.316, 0.292, 0.286, 0.29, 0.298, 0.298, 0.308, 0.29, 0.286, 0.012, 0.29, 0.322, 0.3, 0.3], (0.2, 0.2): [0.46, 0.488, 0.468, 0.49, 0.504, 0.474, 0.484, 0.47, 0.506, 0.488, 0.466, 0.48, 0.468, 0.478, 0.48, 0.488, 0.508, 0.46, 0.476, 0.488], (0.8, 0.35): [0.284, 0.318, 0.322, 0.316, 0.314, 0.304, 0.314, 0.32, 0.306, 0.302, 0.302, 0.308, 0.298, 0.036, 0.352, 0.31, 0.3, 0.322, 0.31, 0.296], (0.7, 0.05): [0.09, 0.08, 0.104, 0.114, 0.108, 0.096, 0.092, 0.084, 0.108, 0.078, 0.0, 0.08, 0.086, 0.092, 0.074, 0.096, 0.094, 0.096, 0.096, 0.082], (0.1, 0.05): [0.202, 0.206, 0.186, 0.168, 0.194, 0.196, 0.162, 0.214, 0.178, 0.214, 0.176, 0.184, 0.206, 0.182, 0.188, 0.198, 0.186, 0.206, 0.168, 0.184], (0.6, 0.25): [0.014, 0.322, 0.314, 0.324, 0.314, 0.328, 0.328, 0.304, 0.33, 0.292, 0.336, 0.306, 0.35, 0.312, 0.356, 0.32, 0.018, 0.32, 0.334, 0.332], (0.6, 0.5): [0.026, 0.482, 0.458, 0.462, 0.038, 0.028, 0.472, 0.01, 0.482, 0.452, 0.442, 0.464, 0.48, 0.484, 0.49, 0.436, 0.428, 0.454, 0.468, 0.48], (1.0, 0.1): [0.102, 0.134, 0.106, 0.118, 0.116, 0.11, 0.12, 0.126, 0.128, 0.108, 0.108, 0.116, 0.13, 0.114, 0.126, 0.11, 0.134, 0.13, 0.12, 0.112], (0.9, 0.2): [0.012, 0.198, 0.194, 0.182, 0.22, 0.218, 0.2, 0.184, 0.212, 0.192, 0.196, 0.19, 0.212, 0.202, 0.208, 0.19, 0.18, 0.21, 0.184, 0.192], (0.4, 0.5): [0.572, 0.592, 0.58, 0.592, 0.572, 0.574, 0.602, 0.568, 0.588, 0.572, 0.588, 0.614, 0.598, 0.572, 0.586, 0.588, 0.592, 0.57, 0.58, 0.584], (0.9, 0.5): [0.338, 0.33, 0.354, 0.338, 0.03, 0.324, 0.338, 0.312, 0.33, 0.338, 0.34, 0.332, 0.346, 0.358, 0.35, 0.36, 0.364, 0.32, 0.33, 0.016], (0.4, 0.25): [0.454, 0.422, 0.422, 0.464, 0.42, 0.416, 0.454, 0.428, 0.42, 0.442, 0.424, 0.468, 0.43, 0.466, 0.43, 0.406, 0.442, 0.424, 0.418, 0.458], (0.8, 0.05): [0.076, 0.108, 0.074, 0.106, 0.086, 0.09, 0.068, 0.09, 0.104, 0.098, 0.086, 0.002, 0.09, 0.078, 0.088, 0.084, 0.07, 0.092, 0.098, 0.092], (0.05, 0.05): [0.178, 0.198, 0.182, 0.186, 0.196, 0.196, 0.178, 0.2, 0.214, 0.21, 0.192, 0.214, 0.188, 0.204, 0.212, 0.194, 0.22, 0.18, 0.214, 0.178], (0.6, 0.4): [0.428, 0.404, 0.396, 0.45, 0.448, 0.412, 0.414, 0.42, 0.428, 0.46, 0.46, 0.396, 0.436, 0.418, 0.012, 0.432, 0.394, 0.432, 0.438, 0.402], (0.3, 0.2): [0.434, 0.442, 0.442, 0.442, 0.44, 0.408, 0.438, 0.446, 0.414, 0.426, 0.436, 0.434, 0.424, 0.438, 0.44, 0.438, 0.436, 0.422, 0.432, 0.414], (0.2, 0.1): [0.298, 0.298, 0.278, 0.294, 0.284, 0.26, 0.276, 0.28, 0.314, 0.296, 0.312, 0.27, 0.276, 0.292, 0.294, 0.276, 0.296, 0.272, 0.29, 0.276], (0.05, 0.4): [0.736, 0.716, 0.716, 0.734, 0.72, 0.746, 0.746, 0.722, 0.736, 0.732, 0.718, 0.732, 0.734, 0.714, 0.736, 0.72, 0.736, 0.744, 0.714, 0.716], (0.6, 0.3): [0.356, 0.376, 0.372, 0.37, 0.382, 0.39, 0.346, 0.382, 0.328, 0.386, 0.364, 0.328, 0.384, 0.364, 0.02, 0.344, 0.346, 0.352, 0.022, 0.014], (0.2, 0.5): [0.702, 0.692, 0.676, 0.684, 0.676, 0.662, 0.686, 0.7, 0.694, 0.68, 0.688, 0.69, 0.686, 0.688, 0.71, 0.69, 0.688, 0.678, 0.692, 0.7], (0.1, 0.15): [0.42, 0.436, 0.452, 0.436, 0.452, 0.42, 0.452, 0.438, 0.426, 0.454, 0.436, 0.452, 0.444, 0.444, 0.44, 0.436, 0.418, 0.46, 0.412, 0.424], (0.3, 0.25): [0.492, 0.482, 0.462, 0.49, 0.492, 0.492, 0.498, 0.502, 0.478, 0.502, 0.484, 0.488, 0.508, 0.472, 0.496, 0.498, 0.478, 0.478, 0.444, 0.512], (0.9, 0.45): [0.326, 0.334, 0.314, 0.32, 0.014, 0.308, 0.33, 0.288, 0.336, 0.306, 0.304, 0.304, 0.336, 0.32, 0.316, 0.332, 0.304, 0.28, 0.35, 0.318], (0.7, 0.1): [0.148, 0.15, 0.16, 0.154, 0.15, 0.17, 0.154, 0.162, 0.01, 0.142, 0.146, 0.138, 0.16, 0.15, 0.16, 0.136, 0.126, 0.144, 0.142, 0.158], (0.9, 0.35): [0.292, 0.28, 0.278, 0.292, 0.302, 0.288, 0.266, 0.022, 0.278, 0.278, 0.272, 0.276, 0.3, 0.018, 0.266, 0.29, 0.28, 0.266, 0.264, 0.278], (0.3, 0.5): [0.632, 0.622, 0.654, 0.63, 0.614, 0.65, 0.636, 0.626, 0.654, 0.652, 0.642, 0.634, 0.66, 0.622, 0.626, 0.63, 0.646, 0.642, 0.622, 0.618], (0.3, 0.1): [0.264, 0.266, 0.23, 0.26, 0.258, 0.276, 0.234, 0.28, 0.268, 0.298, 0.26, 0.27, 0.274, 0.254, 0.262, 0.256, 0.284, 0.266, 0.278, 0.256], (0.7, 0.45): [0.384, 0.392, 0.432, 0.39, 0.036, 0.342, 0.402, 0.394, 0.418, 0.406, 0.396, 0.376, 0.41, 0.4, 0.04, 0.406, 0.408, 0.412, 0.368, 0.38], (1.0, 0.05): [0.09, 0.062, 0.092, 0.084, 0.074, 0.076, 0.062, 0.104, 0.08, 0.092, 0.076, 0.068, 0.084, 0.066, 0.076, 0.07, 0.012, 0.074, 0.082, 0.064]}
    distribution_of_overlaps(dicty)