# coding: utf-8

"""
    authentik

    Making authentication simple.

    The version of the OpenAPI document: 2025.4.1
    Contact: hello@goauthentik.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from authentik_client.models.device_challenge_request import DeviceChallengeRequest
from typing import Optional, Set
from typing_extensions import Self

class AuthenticatorValidationChallengeResponseRequest(BaseModel):
    """
    Challenge used for Code-based and WebAuthn authenticators
    """ # noqa: E501
    component: Optional[Annotated[str, Field(min_length=1, strict=True)]] = 'ak-stage-authenticator-validate'
    selected_challenge: Optional[DeviceChallengeRequest] = None
    selected_stage: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None
    code: Optional[Annotated[str, Field(min_length=1, strict=True)]] = None
    webauthn: Optional[Dict[str, Any]] = None
    duo: Optional[StrictInt] = None
    __properties: ClassVar[List[str]] = ["component", "selected_challenge", "selected_stage", "code", "webauthn", "duo"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AuthenticatorValidationChallengeResponseRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of selected_challenge
        if self.selected_challenge:
            _dict['selected_challenge'] = self.selected_challenge.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AuthenticatorValidationChallengeResponseRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "component": obj.get("component") if obj.get("component") is not None else 'ak-stage-authenticator-validate',
            "selected_challenge": DeviceChallengeRequest.from_dict(obj["selected_challenge"]) if obj.get("selected_challenge") is not None else None,
            "selected_stage": obj.get("selected_stage"),
            "code": obj.get("code"),
            "webauthn": obj.get("webauthn"),
            "duo": obj.get("duo")
        })
        return _obj


