# coding: utf-8

"""
    authentik

    Making authentication simple.

    The version of the OpenAPI document: 2025.4.1
    Contact: hello@goauthentik.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from authentik_client.models.country_code_enum import CountryCodeEnum
from typing import Optional, Set
from typing_extensions import Self

class GeoIPPolicyRequest(BaseModel):
    """
    GeoIP Policy Serializer
    """ # noqa: E501
    name: Annotated[str, Field(min_length=1, strict=True)]
    execution_logging: Optional[StrictBool] = Field(default=None, description="When this option is enabled, all executions of this policy will be logged. By default, only execution errors are logged.")
    asns: Optional[List[Annotated[int, Field(le=2147483647, strict=True, ge=-2147483648)]]] = None
    countries: Annotated[List[CountryCodeEnum], Field(max_length=249)]
    check_history_distance: Optional[StrictBool] = None
    history_max_distance_km: Optional[Annotated[int, Field(le=9223372036854775807, strict=True, ge=0)]] = None
    distance_tolerance_km: Optional[Annotated[int, Field(le=2147483647, strict=True, ge=0)]] = None
    history_login_count: Optional[Annotated[int, Field(le=2147483647, strict=True, ge=0)]] = None
    check_impossible_travel: Optional[StrictBool] = None
    impossible_tolerance_km: Optional[Annotated[int, Field(le=2147483647, strict=True, ge=0)]] = None
    __properties: ClassVar[List[str]] = ["name", "execution_logging", "asns", "countries", "check_history_distance", "history_max_distance_km", "distance_tolerance_km", "history_login_count", "check_impossible_travel", "impossible_tolerance_km"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GeoIPPolicyRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GeoIPPolicyRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "execution_logging": obj.get("execution_logging"),
            "asns": obj.get("asns"),
            "countries": obj.get("countries"),
            "check_history_distance": obj.get("check_history_distance"),
            "history_max_distance_km": obj.get("history_max_distance_km"),
            "distance_tolerance_km": obj.get("distance_tolerance_km"),
            "history_login_count": obj.get("history_login_count"),
            "check_impossible_travel": obj.get("check_impossible_travel"),
            "impossible_tolerance_km": obj.get("impossible_tolerance_km")
        })
        return _obj


