# coding: utf-8

"""
    authentik

    Making authentication simple.

    The version of the OpenAPI document: 2025.4.1
    Contact: hello@goauthentik.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from uuid import UUID
from typing import Optional, Set
from typing_extensions import Self

class Reputation(BaseModel):
    """
    Reputation Serializer
    """ # noqa: E501
    pk: Optional[UUID] = None
    identifier: StrictStr
    ip: StrictStr
    ip_geo_data: Optional[Any] = None
    ip_asn_data: Optional[Any] = None
    score: Optional[Annotated[int, Field(le=9223372036854775807, strict=True, ge=-9223372036854775808)]] = None
    updated: datetime
    __properties: ClassVar[List[str]] = ["pk", "identifier", "ip", "ip_geo_data", "ip_asn_data", "score", "updated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Reputation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "updated",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if ip_geo_data (nullable) is None
        # and model_fields_set contains the field
        if self.ip_geo_data is None and "ip_geo_data" in self.model_fields_set:
            _dict['ip_geo_data'] = None

        # set to None if ip_asn_data (nullable) is None
        # and model_fields_set contains the field
        if self.ip_asn_data is None and "ip_asn_data" in self.model_fields_set:
            _dict['ip_asn_data'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Reputation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pk": obj.get("pk"),
            "identifier": obj.get("identifier"),
            "ip": obj.get("ip"),
            "ip_geo_data": obj.get("ip_geo_data"),
            "ip_asn_data": obj.get("ip_asn_data"),
            "score": obj.get("score"),
            "updated": obj.get("updated")
        })
        return _obj


