# coding: utf-8

"""
    authentik

    Making authentication simple.

    The version of the OpenAPI document: 2025.4.1
    Contact: hello@goauthentik.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from authentik_client.models.application_request import ApplicationRequest
from authentik_client.models.model_request import ModelRequest
from authentik_client.models.provider_model_enum import ProviderModelEnum
from authentik_client.models.transaction_policy_binding_request import TransactionPolicyBindingRequest
from typing import Optional, Set
from typing_extensions import Self

class TransactionApplicationRequest(BaseModel):
    """
    Serializer for creating a provider and an application in one transaction
    """ # noqa: E501
    app: ApplicationRequest
    provider_model: ProviderModelEnum
    provider: ModelRequest
    policy_bindings: Optional[List[TransactionPolicyBindingRequest]] = None
    __properties: ClassVar[List[str]] = ["app", "provider_model", "provider", "policy_bindings"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TransactionApplicationRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of app
        if self.app:
            _dict['app'] = self.app.to_dict()
        # override the default output from pydantic by calling `to_dict()` of provider
        if self.provider:
            _dict['provider'] = self.provider.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in policy_bindings (list)
        _items = []
        if self.policy_bindings:
            for _item_policy_bindings in self.policy_bindings:
                if _item_policy_bindings:
                    _items.append(_item_policy_bindings.to_dict())
            _dict['policy_bindings'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TransactionApplicationRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "app": ApplicationRequest.from_dict(obj["app"]) if obj.get("app") is not None else None,
            "provider_model": obj.get("provider_model"),
            "provider": ModelRequest.from_dict(obj["provider"]) if obj.get("provider") is not None else None,
            "policy_bindings": [TransactionPolicyBindingRequest.from_dict(_item) for _item in obj["policy_bindings"]] if obj.get("policy_bindings") is not None else None
        })
        return _obj


